<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.ibsofts.com
 * @since      2.1.0
 *
 * @package    Ghl_Gf_Extension
 * @subpackage Ghl_Gf_Extension/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Ghl_Gf_Extension
 * @subpackage Ghl_Gf_Extension/admin
 * @author     iB Softs <https://www.ibsofts.com>
 */

class Ghl_Gf_Extension_Admin
{

	/**
	 * The ID of this plugin.
	 *
	 * @since    2.1.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    2.1.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    2.1.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct($plugin_name, $version)
	{
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    2.1.0
	 */
	public function enqueue_styles()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ghl_Gf_Extension_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ghl_Gf_Extension_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/ghl-gf-extension-admin.css', array(), $this->version, 'all');
	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    2.1.0
	 */
	public function enqueue_scripts()
	{

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ghl_Gf_Extension_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ghl_Gf_Extension_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		// wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/ghl-gf-extension-admin.js', array('jquery'), $this->version, false);
		wp_register_script( $this->plugin_name, plugins_url('js/ghl-gf-extension-admin.js', __FILE__), array(), false, true );
	}

	// Adding option in Setting 
	function ibs_ghlgfe_menu_item($menu_items)
	{

		$menu_items[] = array(
			'name' => 'my_custom_form_settings_page',
			'label' => __('Go High Level')
		);

		return $menu_items;
	}

	function ibs_ghlgfe_display()
	{
		if (class_exists('GFFormSettings')) {
			GFFormSettings::page_header();
			if (file_exists(plugin_dir_path(__FILE__) . 'partials/ghl-gf-extension-admin-display.php')) {
				require plugin_dir_path(__FILE__) . 'partials/ghl-gf-extension-admin-display.php';
			}
			GFFormSettings::page_footer();
		}
	}

	// GHL global tag callback

	function create_menu( $menus ){
	    $menus[] = array( 'name' => 'ghl_global_tag', 'label' => __( 'GHL Global Tag' ), 'callback' =>  array($this, 'ghl_global_tag') );
        return $menus;
	}
	
	function ghl_global_tag(){
	    if(file_exists(plugin_dir_path(__FILE__) . 'partials/ghl-gf-extension-global-tag.php')){
			require plugin_dir_path(__FILE__) . 'partials/ghl-gf-extension-global-tag.php';
		}
	}

	function ibs_ghlgfe_send_to_gohighlevel($entry, $form)
	{
		$field_ids = array();
		$required_types = array("name", "email", "phone");
		foreach ($required_types as $type) {
			$field_exists = false;
			foreach ($form['fields'] as $field) {
				if ($field["type"] == $type) {
					$field_exists = true;
					$field_ids[$type] = $field["id"];
					break;
				}
			}
			if (!$field_exists) {
				break;
			}
		}
		if (count($field_ids) >= count($required_types)) {
			$api_key_option_name = 'gf_ghl_api_key_' . $form['id'];
        	$api_key = get_option($api_key_option_name);
			if ($api_key) {
				$endpoint = 'https://rest.gohighlevel.com/v1/contacts/';

				// Get the data from the Gravity Forms entry
				$name_field_id = $field_ids['name'];
				if (class_exists('GFAPI')) {
					$name_subfields = GFAPI::get_field($form, $name_field_id)->inputs;
				}
				if (count($name_subfields) >= 2) {
					$prefix_name = rgar($entry, $name_field_id . '.' . '2');
					$first_name = rgar($entry, $name_field_id . '.' . '3');
					$middle_name = rgar($entry, $name_field_id . '.' . '4');
					$last_name = rgar($entry, $name_field_id . '.' . '6');
					$prefix_name = rgar($entry, $name_field_id . '.' . '8');
					$name_value = trim($prefix_name . ' ' . $first_name . ' ' . $middle_name . ' ' . $last_name . ' ' . $prefix_name);
				} else {
					$name_value = rgar($entry, $name_field_id);
				}
				$email = rgar($entry, $field_ids['email']);
				$phone = rgar($entry, $field_ids['phone']);
				$tags_option_name = 'gf_ghl_tags_' . $form['id'];
                $tags = (!empty(get_option($tags_option_name)) && get_option($tags_option_name) !== false) ? get_option($tags_option_name) : ((get_option("ghl_global_tag") !== false) ? get_option("ghl_global_tag") : "");
                
				$contact_data = array(
					'name' => $name_value,
					'email' => $email,
					'phone' => $phone,
					'tags' => $tags,
				);
				// var_dump($contact_data);
				// die("Hello..");
				// Send the data to GoHighLevel using WordPress HTTP API
				$response = wp_remote_post( $endpoint, array(
					'method'      => 'POST',
					'timeout'     => 45,
					'redirection' => 5,
					'httpversion' => '1.0',
					'blocking'    => true,
					'headers'     => array(
						'Content-Type' => 'application/json',
						'Accept' => 'application/json',
						'Authorization' => 'Bearer ' . $api_key
					),
					'body'        => json_encode($contact_data),
					'cookies'     => array()
				) );
			}
		}
	}
}