<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://www.ibsofts.com
 * @since      2.1.0
 *
 * @package    Ghl_Gf_Extension
 * @subpackage Ghl_Gf_Extension/admin/partials
 */

// Get the form ID from the URL parameter
$form_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

// Use the form ID to retrieve the API key from the options table
$api_key = '';
$tag = "";
if ($form_id > 0) {
  $api_key = get_option('gf_ghl_api_key_' . $form_id);
  $tags = get_option('gf_ghl_tags_' . $form_id);
  
}
if (isset($_POST['submit-btn'])) {
  // Get the API key from the form input
  $new_api_key = sanitize_text_field($_POST['apikey']);
  $new_tag = sanitize_text_field($_POST['tags']);
  
  // Update the API key in the options table
  update_option('gf_ghl_api_key_' . $form_id, $new_api_key);
  update_option('gf_ghl_tags_' . $form_id, $new_tag);

  // Redirect to the same page with the updated API key
  wp_redirect(admin_url('admin.php?page=gf_edit_forms&view=settings&id=' . $form_id));
  exit();
}
?>

<div class="container">
  <h3>Go High Level</h3>
  <form method="post" id="ghl-ext-form" class="ghl_carls_frm">
    <label for="apikey">Enter API Key:</label>
    <input type="text" id="apikey" name="apikey" value="<?php echo esc_attr($api_key); ?>">
    <label for="tags">Enter Tags to Send:</label>
    <input type="varchar" id="tags" name="tags" class="ghl_frm_inp" placeholder="tagA, tagB" value="<?php echo esc_attr($tags); ?>">
    <button type="submit" name="submit-btn" value="submit">Submit</button>
  </form>
  <p>Note: To send gravity form data to Go high Level, form must have name, email and phone type set.</p>
</div>