// ACTIVE CAMPAIGN SCRIPTS
(function( $ ){
	if ( $("body").hasClass("logged-in") ) { // check if a user is logged in
    	// HEADER BOOK A CALL BUTTON ADD "Clicked Booked A Call" TAG
        // CONTACT US PAGE BOOK A CALL BUTTON
		$("body").find(".cstm-header-menu .schedule-button > a, .contact-us-book-a-call > a").on("click", function(){
			activeCampaignBookCallAjax();
		})
        // CONTACT US SITE AUDIT BUTTON
        $("body").find(".site-audit-button > a").on("click", function(){
            activeCampaignSiteAuditAjax();
        })
	} else {
        // CONTACT US PAGE BOOK A CALL BUTTON
        $("body").find(".contact-us-book-a-call > a").on("click", function(){
            // check if theres an email parameter
            if ( getUrlParams().email ) {
                activeCampaignBookCallAjax( getUrlParams().email );
            }
        })
        // CONTACT US SITE AUDIT BUTTON
        $("body").find(".site-audit-button > a").on("click", function(){
            if ( getUrlParams().email ) {
                activeCampaignSiteAuditAjax( getUrlParams().email );
            }
        })
    }

    function activeCampaignBookCallAjax(email){
        $.ajax({
            type: "post",
            url: wp_ajax.ajax_url,
            data:{
                action: "_activeCampaignBookACall",
                email: email
            },
            beforeSend: function(){},
            success: function( response ){
                console.log("success");
            }
        })
    }
    function activeCampaignSiteAuditAjax(email){
        $.ajax({
            type: "post",
            url: wp_ajax.ajax_url,
            data:{
                action: "_activeCampaignSiteAudit",
                email: email
            },
            beforeSend: function(){},
            success: function( response ){
                console.log("success");
            }
        })
    }

    function getUrlParams() {
        var result = {};
        var params = (window.location.search.split('?')[1] || '').split('&');
        for(var param in params) {
            if (params.hasOwnProperty(param)) {
                var paramParts = params[param].split('=');
                result[paramParts[0]] = decodeURIComponent(paramParts[1] || "");
            }
        }
        return result;
    }
})( jQuery );

