/*
 *   SINGLE PRODUCT PAGE ORDER FORM
 *
 */

// get form by id
var order_form = document.getElementById("new-product-order-form");

// single product order form events
if(order_form){

    // order form on submit
    order_form.addEventListener("submit", (e) => {

        // prevent form from submitting
        e.preventDefault();

        // data object
        var data = {};

        // get form entries
        const form_data = Object.fromEntries(new FormData(e.target).entries());

        // get form action
        const form_action = order_form.getAttribute("action");

        // get local storage value
        var cart_items = JSON.parse(localStorage.getItem("cart_items"));

        // get page id
        var page_id = form_data.page_id;
        // var page_id = 2117;

        console.log(cart_items);

        // check if local storage has value
        if(cart_items){ // if there's a value

            // check if the page_id exists in the object
            if(page_id in cart_items){ // if it exists

                // delete from local storage object
                delete cart_items[page_id];
            }

            // push data into cart items object
            cart_items[page_id] = form_data;

            // set local storage value
            localStorage.setItem("cart_items", JSON.stringify(cart_items));
        } else { // if no value

            // push data into object
            data[page_id] = form_data;

            // set local storage value
            localStorage.setItem("cart_items", JSON.stringify(data));
        }

        // redirect to cart after setting local storage cart data
        window.location.href = form_action;
    })

    // content writing service and blog writing service
    var budget_count_field  = order_form.querySelector("input[name=budget_count]");
    var page_count_field    = order_form.querySelector("input[name=page_count]");
    var word_count_field    = order_form.querySelector("input[name=word_count]");
    var page_count_strong   = order_form.querySelector(".calculation-page-count");
    var word_count_strong   = order_form.querySelector(".calculation-word-count");
    var calculation_total   = order_form.querySelector(".calculation-total");

    if(page_count_field){

        page_count_field.addEventListener("change", (e) => {
    
            // get values
            var page_count = e.target.value;
            var word_count = word_count_field.value;
    
            // append values to its respective fields
            word_count_strong.querySelector("strong").innerHTML = word_count;
            page_count_strong.querySelector("strong").innerHTML = page_count;
            calculation_total.querySelector("strong").innerHTML = content_price_computation(page_count, word_count);
        })
    }
    if(word_count_field){

        word_count_field.addEventListener("change", (e) => {
    
            // get values
            var page_count = page_count_field.value;
            var word_count = e.target.value;
    
            // append values to its respective fields
            word_count_strong.querySelector("strong").innerHTML = word_count;
            page_count_strong.querySelector("strong").innerHTML = page_count;
            calculation_total.querySelector("strong").innerHTML = content_price_computation(page_count, word_count);
        })
    }
    if(budget_count_field){

        budget_count_field.addEventListener("change", (e) => {
    
            // get values
            var budget_count = e.target.value;
            
            // append values to its respective fields
            calculation_total.querySelector("strong").innerHTML = "£" + add_commas(budget_count);
        })
    }

    // create a function that converts numbers and adds commas
    function add_commas(nStr) {
        nStr += '';
        var x = nStr.split('.');
        var x1 = x[0];
        var x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + ',' + '$2');
        }
        return x1 + x2;
    }

    // for products like content writing service and blog writing service
    function content_price_computation(pages, words){

        // calculate total price
        // 12p per word

        var total_price = ( ( 12 * words ) * pages ) / 100;

        return "£" + total_price;
    }
}
/* !== SINGLE PRODUCT PAGE ORDER FORM */


/*
 *   CART PAGE
 *   -- display the form after page loads
 *
 */

// get body element
var body = document.getElementsByTagName("body");
var cart_order_form = document.getElementById("cart-order-form");

// when page loads
document.addEventListener("DOMContentLoaded", function(){

    // load the cart page content
    cart_contents();
});

// cart page contents
function cart_contents(){

    // check if we're on the cart page
    if(body[0].classList.contains("woocommerce-cart")){

        // get local storage cart items value
        var cart_items = localStorage.getItem("cart_items");

        // check if cart items exists
        if(cart_items){

            // ajax call
            var xhttp = new XMLHttpRequest();
            xhttp.open("POST", wp_ajax.ajax_url, true); // type, wp action url, async true (optional)
            xhttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8"); // request header
            xhttp.send("action=_cart_view_ajax&cart_items="+cart_items); // action and data
            xhttp.onerror = function(){

                // if error
                console.log("error");
            }
            xhttp.onload = function(){

                // check if the response is an error
                if (this.status >= 200 && this.status < 400) {

                    // get data
                    var response = this.response;
                    var response = JSON.parse(response); // parse response

                    // append cart order form contents
                    cart_order_form.innerHTML = response.content;

                    // remove loader to form
                    cart_order_form.classList.remove("loading");

                    // cart remove
                    remove_cart();

                    // update page count
                    update_cart_page_count();
                } else {

                    // if error
                    console.log("error");
                }
            }
        } else {
            cart_order_form.innerHTML = "<a href='https://seoi.io/'>Back to Home</a>";
        }
    }
}
/* !== CART PAGE */

/*
 *   ADD PRODUCT TO CART
 *
 */

// check if we're on the cart page and if the cart order form exists
if(cart_order_form && body[0].classList.contains("woocommerce-cart")){
    cart_order_form.addEventListener("submit", (e) => {

        // prevent form from submitting
        e.preventDefault();

        // add loader to form
        cart_order_form.classList.add("loading");

        // get form action
        const form_action = cart_order_form.getAttribute("action");

        // get form entries
        // const form_data = Object.fromEntries(new FormData(e.target).entries());
        var form_data = {};

        // get cart all cart items
        const cart_items = document.querySelectorAll('.cart-item[data-page-id]');

        // 
        var new_files = {};
        var new_data = new FormData();

        // check if cart items exists
        if(cart_items){

            // loop through the cart items
            [...cart_items].forEach(function(element){

                // get needed values
                var page_id = element.getAttribute('data-page-id');
                var elements = element.querySelectorAll('input[type="text"], input[type="number"], input[type="radio"]:checked, select');

                // empty object to be used to push the data below
                var valuestopush = {};

                // console.log(elements);
                
                // loop through the input elements inside the cart items
                [...elements].forEach(function(childElement){

                    //
                    var value     = childElement.value;
                    var type      = childElement.getAttribute('type');
                    var key       = childElement.getAttribute('name');
                    var newKey    = key.replace("cart_info["+page_id+"]", ""); // remove cart_info
                    const allKeys = newKey.match(/\[(.+?)\]/g);

                   /*  console.log(newKey);
                    console.log(allKeys); */

                    // build the data object structure
                    if(allKeys.length == 1){
                        var finalKey = newKey.replace("[", "").replace("]", "");
                        valuestopush[finalKey] = value; // populate the value
                    } else if (allKeys.length == 3){

                        // check allKeys[0]
                        var firstKey  = allKeys[0].replace("[", "").replace("]", "");
                        var secondKey = allKeys[1].replace("[", "").replace("]", "");
                        var thirdKey  = allKeys[2].replace("[", "").replace("]", "");

                        // check if the first key exists
                        if(Object.keys(valuestopush).includes(firstKey)){
                            // check if the second key exists
                            if(Object.keys(valuestopush[firstKey]).includes(secondKey)){
                                valuestopush[firstKey][secondKey][thirdKey] = value; // populate the value
                            } else { // if second key doesnt exist create the key
                                valuestopush[firstKey][secondKey] = {}; // create the second key
                                valuestopush[firstKey][secondKey][thirdKey] = value; // populate the value
                            }
                        } else { // if it doesnt exist create the key
                            valuestopush[firstKey] = {}; // create the object if it doesnt exist
                            valuestopush[firstKey][secondKey] = {}; // create the second key
                            valuestopush[firstKey][secondKey][thirdKey] = value; // populate the value
                        }

                        // attachments
                        // if input type is file
                        if(type == "file"){

                            // 
                            var file = childElement.files ? childElement.files[0] : "";

                            // if the file input has an attachement
                            if(file){
        
                                // create the key for the $_FILE call in php
                                var file_key = page_id+"_"+secondKey; 
                                new_data.append(file_key, file);
                            }
                        }
                    }
                })

                // insert the data into the form_data variable
                form_data[page_id] = valuestopush;
            });
        }

        console.log(form_data);

        // ajax call
        var xhttp = new XMLHttpRequest();
        xhttp.open("POST", wp_ajax.ajax_url, true); // type, wp action url, async true (optional)
        // append additional data to the form data
        new_data.append('action', '_add_product_to_cart');
        new_data.append('form_data', JSON.stringify(form_data));
        // initialize ajax
        xhttp.send(new_data);
        xhttp.onerror = function(){

            // if error
            console.log("error");
        }
        xhttp.onload = function(){

            // check if the response is an error
            if (this.status >= 200 && this.status < 400) {

                // check the response
                // var response = this.response;
                // console.log(response);

                // redirect to checkout
                window.location.href = form_action;
            } else {

                // if error
                console.log("error");
            }
        }
    })
}
/* !== ADD PRODUCT TO CART */


/*
 *   REMOVE PRODUCT FROM CART
 *
 */
function remove_cart(){

    // 
    var remove_cart = document.querySelectorAll(".remove-cart-item");

    // loop through remove cart items
    if(remove_cart){

        // 
        [...remove_cart].forEach(function(element){
    
            // 
            element.addEventListener("click", (e) => {
        
                // prevent default link
                e.preventDefault();

                if(confirm("Remove product from cart?")){

                    // get local storage cart items value
                    var cart_items = localStorage.getItem("cart_items");
                    var cart_items = JSON.parse(cart_items);
            
                    // get cart item data
                    var page_id = e.currentTarget.parentNode.getAttribute('data-page-id');
            
                    // delete the cart item
                    delete cart_items[page_id];
                    
                    // update local storage
                    localStorage.setItem("cart_items", JSON.stringify(cart_items));
    
                    // remove element
                    e.currentTarget.parentNode.remove();
    
                    // {"2117":{"page_id":"2129","page_count":"1","word_count":"500"},"2129":{"page_id":"2129","page_count":"2","word_count":"1000"}}
                }
            })
        })
    }
}
/* !== REMOVE PRODUCT FROM CART */

/*
 *   UPDATE CART
 *
 */
// update the cart when the page count is changed
function update_cart_page_count(){

    // get all page number input fields
    var cart_item_page_count = document.querySelectorAll(".cart-item-page-count");

    // check if there's page number input fields
    if(cart_item_page_count){

        // loop through remove cart items
        [...cart_item_page_count].forEach(function(element){

            // on change trigger the update cart function
            element.addEventListener("change", (e) => {

                // add loader to form
                cart_order_form.classList.add("loading");

                // update the cart
                update_cart();
            })
        })
    }
}
// update the cart and the local storage data
function update_cart(){

    // get cart items
    const cart_items = document.querySelectorAll('.cart-item[data-page-id]');

    // cart items from local storage
    var ls_cart_items = JSON.parse(localStorage.getItem("cart_items"));

    // initialize data object
    var data = {};

    // loop through in page cart items
    [...cart_items].forEach(function(element){

        // get values
        var page_id = element.getAttribute('data-page-id');
        var page_count = element.querySelector(".cart-item-page-count").value;
        var word_count = "350"; // default word count

        // push values into data object
        data[page_id] = {"page_id": page_id, "page_count": page_count, "word_count": word_count};

        // update local storage
        // check if local storage has value
        if(ls_cart_items){ // if there's a value

            // check if the page_id exists in the object
            if(page_id in ls_cart_items){ // if it exists

                // delete from local storage object
                delete ls_cart_items[page_id];
            }

            // set local storage value
            localStorage.setItem("cart_items", JSON.stringify(data));
        } else { // if no value

            // set local storage value
            localStorage.setItem("cart_items", JSON.stringify(data));
        }
    })

    // reload cart contents
    cart_contents();
}
/* !== UPDATE CART */