<?php
defined( 'ABSPATH' ) || exit;

// ACTIVE CAMPAIGN API
// api documentation
// https://github.com/ActiveCampaign/activecampaign-api-php
// https://www.activecampaign.com/api/overview.php
require_once( dirname(__FILE__) . "/active-campaign/ActiveCampaign.class.php" );

// ACTIVE CAMPAIGN CREDS
define("NEW_ACTIVECAMPAIGN_URL", "https://outtheremedialtd.api-us1.com");
define("NEW_ACTIVECAMPAIGN_API_KEY", "d1ee1e83a057460ca14655ae6de02a0eeb404d13e0da0113331834be12b5ce67cdf466eb");

/*
    == Lists ==
    SEOi Members List - 1
    iRecommend Businesses - 2
    iRecommend Users - 3


    == Tags List ==
    
    // what are you? gravity forms list
    // after signup
    SEOi Member - 3 -- ok
    Business Owner - 12 -- ok
    Marketer - 13 -- ok 
    Reseller - 14 -- ok
    Interested in DIY Packages - 17
    Interested in Managed SEO Services - 18
    
    // book a call header button
    Clicked Booked A Call - 4 -- ok
    
    // not part of website??
    Client Had On Board Call - 15
    Missed onboarding call - 16
    SEO Strategy - 6
    Site Audit - 5

    //
    International SEO - 11
    Local SEO - 9
    National SEO - 10
    
    // after order
    Managed SEO Subscriber - 8
    Purchased DIY Package - 7

    // plugin generated?
    woocommerce-customer - 2
*/

// BOOK A CALL BUTTON
// -- ADD "Clicked Booked A Call" TAG
add_action( 'wp_ajax__activeCampaignBookACall', '_activeCampaignBookACall' );
add_action( 'wp_ajax_nopriv__activeCampaignBookACall', '_activeCampaignBookACall' ); 
function _activeCampaignBookACall(){

    // ACTIVE CAMPAIGN CREDENTIALS
    $ac = new ActiveCampaign( ACTIVECAMPAIGN_URL, ACTIVECAMPAIGN_API_KEY );

    // check if user is logged in
    if ( is_user_logged_in() ) {

        // user obj
        $user      = wp_get_current_user();
        $userEmail = $user->user_email;

        // add a tag to a contact
        $addTagToContact = $ac->api("contact/tag/add", array(
            "email" => $userEmail,
            "tags"  => "Clicked Booked A Call"
        ));
    } else {
        $userEmail = $_REQUEST['email'];

        if ( $userEmail ) {
            // add a tag to a contact
            $addTagToContact = $ac->api("contact/tag/add", array(
                "email" => $userEmail,
                "tags"  => "Clicked Booked A Call"
            ));
        }
    }

    die();
}

// SITE AUDIT BUTTON
// -- ADD "SITE AUDIT" TAG
add_action( 'wp_ajax__activeCampaignSiteAudit', '_activeCampaignSiteAudit' );
add_action( 'wp_ajax_nopriv__activeCampaignSiteAudit', '_activeCampaignSiteAudit' ); 
function _activeCampaignSiteAudit(){

    // ACTIVE CAMPAIGN CREDENTIALS
    $ac = new ActiveCampaign( ACTIVECAMPAIGN_URL, ACTIVECAMPAIGN_API_KEY );

    // check if user is logged in
    if ( is_user_logged_in() ) {

        // user obj
        $user      = wp_get_current_user();
        $userEmail = $user->user_email;

        // add a tag to a contact
        $addTagToContact = $ac->api("contact/tag/add", array(
            "email" => $userEmail,
            "tags"  => "Site Audit"
        ));
    } else {
        $userEmail = $_REQUEST['email'];

        if ( $userEmail ) {
            // add a tag to a contact
            $addTagToContact = $ac->api("contact/tag/add", array(
                "email" => $userEmail,
                "tags"  => "Site Audit"
            ));
        }
    }

    die();
}


// SIGN UP MODAL GRAVITY FORMS
// -- ADD "Business Owner" Tag
// -- ADD "Marketer" Tag
// -- ADD "Reseller" Tag
// -- ADD "SEOi Member" Tag
// -- ADD "Interested in DIY Packages" Tag
// -- ADD "Interested in Managed SEO Services" Tag
// add_action( 'gform_after_submission_13', '_after_submission', 10, 2 );
// add_action( 'gform_after_submission_4', '_after_submission', 10, 2 );
function _after_submission( $entry, $form ) {

    // ACTIVE CAMPAIGN CREDENTIALS
    $ac = new ActiveCampaign( NEW_ACTIVECAMPAIGN_URL, NEW_ACTIVECAMPAIGN_API_KEY );

    // user info
    $userEmail     = rgar( $entry, 2 );
    $userFirstName = $entry["11.3"];
    $userLastName  = $entry["11.6"];
    // $userFirstName = rgar( $entry, 11.3 );
    // $userLastName  = rgar( $entry, 11.6 );
    $phoneNumber   = rgar( $entry, 22 );

    // "what are you?"
    $userType = rgar( $entry, 18 );

    if ( $userType == "business owner" ) {
        $newUserType = "Business Owner";
    } elseif ( $userType == "marketer" ) {
        $newUserType = "Marketer";
    } elseif ( $userType == "reseller" ) {
        $newUserType = "Reseller";
    } else {
        $newUserType = "";
    }

    // interested in?
    $interest = rgar( $entry, 19 );

    if ( $interest == "DIY SEO Packages" ) {
        $newInterest = ", Interested in DIY Packages";
    } elseif ( $interest == "Managed SEO Packages"  ) {
        $newInterest = ", Interested in Managed SEO Services";
    } else { // intrested in both
        $newInterest = ", Interested in DIY Packages, Interested in Managed SEO Services";
    }

    $addContact = $ac->api("contact/add", array(
        "email"      => $userEmail,
        "first_name" => $userFirstName,
        "last_name"  => $userLastName,
        "phone"      => $phoneNumber,
        "p[1]"       => 1, // list id
        "tags"       => $newUserType . ", SEOi Member" . $newInterest
    ));
}

// active campaign create contact if user doesnt exist and update if it exists
// add_action('woocommerce_thankyou', '_afterCheckoutProcessActiveCampaign', 10, 1);
function _afterCheckoutProcessActiveCampaign( $order_id ) {
    $ac = new ActiveCampaign( NEW_ACTIVECAMPAIGN_URL, NEW_ACTIVECAMPAIGN_API_KEY );

    // order obj
    $order     = wc_get_order( $order_id );
    $productId = "";

    // user obj
    $user          = $order->get_user();
    $userId        = $order->get_user_id();
    $userEmail     = $user->user_email;
    $userFirstName = $user->first_name;
    $userLastName  = $user->last_name;
    $userPhone     = $order->get_billing_phone();

    // active campaign contact obj
    $viewContactByEmail = $ac->api( "contact/view?email=" . $userEmail );

    // $packagedServices = ["Blogger Outreach Service", "Guest Post Service", "On-Page SEO Service", "Content Writing Services", "Blog Writing Service", "Rank Tracker Basic", "Rank Tracker Business", "Rank Tracker Enterprise"];
    $packagedServices = [2090, 2105, 2117, 2129, 2134, 2111, 2203];

    // $managedServices  = ["SEO Management Service", "Local SEO Services", "National SEO Service", "International SEO Service", "eCommerce SEO Services", "Blog Management", "Social Media Marketing Service"];
    $managedServices = [2027, 2055, 2066, 2076, 2081, 2123];

    // loop throug the order items
    foreach ( $order->get_items() as $item_id => $item ) {
        $formattedMetaData = $item->get_formatted_meta_data( '_', true );


        // loop through all meta data to get the page id (named product id)
        // -- this is not the product id of the woocommerce product it is the page id of the service page
        foreach ( $formattedMetaData as $key => $md ) {
            if ( $md->key == "Product ID" ) {
                $productId = $md->value;
            }
        }
    }

    // check if the product id 
    if ( in_array( $productId, $packagedServices ) ) {
        $tag = "Managed SEO Subscriber";
    } elseif ( in_array( $productId, $managedServices ) ) {
        $tag = "Purchased DIY Package";
    }

    // check if the contact already exists in active campaign
    if ( (int)$viewContactByEmail->success ) {
        // if contact exist
        // add tag to the user / contact
        $addTagToContact = $ac->api("contact/tag/add", array(
            "email" => $userEmail,
            "tags"  => $tag
        ));
    } else {
        // if contact does not exist
        // add the user as a contact
        $addContact = $ac->api("contact/add", array(
            "email"      => $userEmail,
            "first_name" => $userFirstName,
            "last_name"  => $userLastName,
            "phone"      => $userPhone,
            "p[1]"       => 1, // list id
            "tags"       => $tag . ", SEOi Member"
        ));
    }
}

// ACTIVE CAMPAIGN AJAX TRIGGER
add_action( 'wp_ajax__activeCampaignEventTrigger', '_activeCampaignEventTrigger' ); 
add_action( 'wp_ajax_nopriv__activeCampaignEventTrigger', '_activeCampaignEventTrigger' ); 
function _activeCampaignEventTrigger(){
    // EVENT TRACKING ACTIVE CAMPAIGN
    if ( is_user_logged_in() ) {
        // variables
        $user       = wp_get_current_user();
        $userEmail  = $user->user_email;
        $pageUrl    = $_REQUEST['pageUrl'];
        $pageId     = $_REQUEST['pageId'];
        $pageTitle  = $_REQUEST['pageTitle'];
        $eventTitle = "Completed An Article";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://trackcmp.net/event");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, array(
        "actid"     => "610730536",
        "key"       => "6e2b9eeb4c6f085c9e2d1e0d2ccad05bb76d5ea6",
        "event"     => $eventTitle,
        "eventdata" => "The user has completed the seo learning article: " . $pageUrl,
        "visit"     => json_encode(array(
                // If you have an email address, assign it here.
                "email" => $userEmail,
            )),
        ));

        $result = curl_exec($curl);
        if ($result !== false) {
            $result = json_decode($result);
            if ($result->success) {
                echo 'succes';
            } else {
                echo 'error';
            }

            // echo $result->message;
        } else {
            echo 'error';
            // echo 'cURL failed to run: ', curl_error($curl);
        }

        // update user meta data
        $slug = basename( get_the_permalink( $pageId ) );
        $uniqueName = $slug . "_" . $user->ID;
        update_user_meta( $user->ID, $uniqueName, "done" );
    }
    // ========================================

    die();
}
