<?php
defined( 'ABSPATH' ) || exit;

// custom order form shown on the cart page
// add_action( "woocommerce_cart_is_empty", "_seoiOrderForm" );
// add_action( "woocommerce_before_cart", "_seoiOrderForm" );
function _seoiOrderForm(){
	$product_id   = isset( $_GET['pid'] ) ? $_GET['pid'] : "";
	$product_name = isset( $_GET['order'] ) ? $_GET['order'] : "";
	$word_count   = isset( $_GET['words'] ) ? $_GET['words'] : 500;
	$post_count   = isset( $_GET['posts'] ) ? $_GET['posts'] : 1;
	$page_count   = isset( $_GET['pages'] ) ? $_GET['pages'] : 1;
	$budget       = isset( $_GET['budget'] ) ? $_GET['budget'] : 500;
	$daType       = isset( $_GET['da'] ) ? $_GET['da'] : "";
	$citationType = isset( $_GET['cit'] ) ? $_GET['cit'] : "";
	$packageType  = isset( $_GET['type'] ) ? $_GET['type'] : "";
	$includeTechnical = isset( $_GET['technical'] ) ? $_GET['technical'] : "";

	/*
	 * 
	 * SEO Management Service    -- 2027
	 * Local SEO Services        -- 2055
	 * National SEO Service      -- 2066
	 * International SEO Service -- 2076
	 * eCommerce SEO Services    -- 2081
	 * Blog Management           -- 2123
	 * Rank Tracker Business     -- 2203
	 * 
	 * Blogger Outreach Service  -- 2090
	 * Guest Post Service        -- 2105
	 * On-Page SEO Services      -- 2117
	 * Content Writing Service   -- 2129
	 * Blog Writing Service      -- 2134
	 * Local SEO Citations       -- 2111
	 * 
	 */


	// if ( $product_name == "Content Writing Services" || $product_name == "Blog Writing Service" ) {
	if ( $product_id == 2129 || $product_id == 2134 ) {
		$price = ( 12 * $word_count ) / 100;
	// } elseif ( $product_name == "Blog Management" ) {
	} elseif ( $product_id == 2123 ) {
		$price = ( ( 10 * $word_count ) * $post_count ) / 100;
	} elseif ( $product_name == "Managed SEO" ) {
		$price = $budget;
	} else {
		$price = 0;
	}

	// website url
	if ( is_user_logged_in() ) {
		$user = wp_get_current_user();
		$userWebsites = get_the_author_meta( "_user_websites", $user->ID ) ? get_the_author_meta( "_user_websites", $user->ID ) : [];
	} else {
		$userWebsites = [];
	}

	// 
	if(isset($_GET['pid'])){
?>
		<form id="seoi-order-form">
			<div class="order-form-heading">
				<h1>Order: <strong><?php echo $product_name; ?></strong></h1>
			</div>

			<!-- product name is gonna be prepopulated depends on the order -->
			<input type="hidden" name="_productName" value="<?php echo $product_name; ?>">
			<input type="hidden" name="_productId" value="<?php echo $product_id; ?>">

			<?php //if ( $product_name == "Blog Management" ){ ?>
			<?php if ( $product_id == 2123 ){ ?>
				<fieldset class="half left">
					<label for="Blog Posts">Blog Posts</label>
					<input type="number" name="Blog Posts" value="<?php echo $post_count ?>" required>
				</fieldset>
				<fieldset class="half">
					<label for="Word Count">How many words?</label>
					<input type="number" name="Word Count" value="<?php echo $word_count ?>" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Page URL">If it already exists, what is the URL of the page?</label>
					<input type="text" name="Page URL" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Subject/s">What subject would you like the page to cover?</label>
					<input type="text" name="Subject/s" value="" required>
				</fieldset>
				<fieldset>
					<label for="Keywords">Suggested keywords</label>
					<input type="text" name="Keywords" value="" required>
				</fieldset>
				<fieldset>
					<label for="Additional Information">Do you have any additional information for the writer?</label>
					<textarea name="Additional Information"></textarea>
				</fieldset>
				<fieldset>
					<label for="">Subscription Length</label>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-3-months" value="3 Months" required>
						<label for="subscription-length-3-months">3 Month Subscription</label>
						<div class="desc">This allows us to research your business, competition and keywords and set up your strategy and plan. It will also allow you to start seeing results.</div>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-6-months" value="6 Months" required>
						<label for="subscription-length-6-months">6 Month Subscription</label>
						<div class="desc">This allows us to build a six-month plan giving you extra initial research and planning at no extra cost.</div>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-12-months" value="12 Months" required>
						<label for="subscription-length-12-months">12 Month Subscription</label>
						<div class="desc">This allows us to build a twelve-month plan giving you extra initial research and planning at no extra cost.</div>
					</div>
				</fieldset>
			<?php //} elseif ( $product_name == "On-Page SEO Service" ) { ?>
			<?php } elseif ( $product_id == 2111 ) { ?>
				<!-- <input type="hidden" name="Citation Type" value="<?php //echo $citationType; ?>"> -->
				<!-- <h3 class="fieldset-title">Business Citations</h3> -->
				<fieldset>
					<label for="Citation Type">Citation Type</label>
					<select name="Citation Type" id="" required>
						<option value="">Select an Option</option>
						<option value="30" <?php echo $citationType == "30" ? "selected" : ""; ?>>30 Local Business Citations</option>
						<option value="50" <?php echo $citationType == "50" ? "selected" : ""; ?>>50 Local Business Citations</option>
						<option value="80" <?php echo $citationType == "80" ? "selected" : ""; ?>>80 Local Business Citations</option>
					</select>
					<!-- <input type="text" name="Business Name" value="" required> -->
				</fieldset>
				<h3 class="fieldset-title">Business Location Info</h3>
				<fieldset class="half left">
					<label for="Business Name">Business Name</label>
					<input type="text" name="Business Name" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Business Location">Business Location</label>
					<input type="text" name="Business Location" value="United Kingdom" disabled>
				</fieldset>
				<fieldset class="half left">
					<label for="Address">Address</label>
					<input type="text" name="Address" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Town/City">Town/City</label>
					<input type="text" name="Town/City" value="" required>
				</fieldset>
				<fieldset class="half left">
					<label for="State/County/Region">State/County/Region</label>
					<input type="text" name="State/County/Region" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Zipcode/Postcode">Zipcode/Postcode</label>
					<input type="text" name="Zipcode/Postcode" value="" required>
				</fieldset>
				<fieldset>
					<label for="Business Telephone Number">Business Telephone Number</label>
					<input type="tel" name="Business Telephone Number" value="" required>
				</fieldset>
				<h3 class="fieldset-title">Business Location Contact Info</h3>
				<fieldset class="half left">
					<label for="Business Location Contact First Name">Business Location Contact First Name</label>
					<input type="text" name="Business Location Contact First Name" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Business Location Contact Last Name">Business Location Contact Last Name</label>
					<input type="text" name="Business Location Contact Last Name" value="" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Business Location Contact Email">Business Location Contact Email</label>
					<input type="text" name="Business Location Contact Email" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Mobile telephone number">Mobile telephone number</label>
					<input type="text" name="Mobile telephone number" value="" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Business fax number">Business fax number</label>
					<input type="text" name="Business fax number" value="">
				</fieldset>
				<fieldset class="half">
					<label for="Opening / Formation date">Opening / Formation date</label>
					<input type="date" name="Opening / Formation date" value="" required>
				</fieldset>
				<h3 class="fieldset-title">About the Business</h3>
				<fieldset class="half left">
					<label for="Business category">Business category</label>
					<select name="Business category" id="">
						<option value=""></option>
					</select>
				</fieldset>
				<fieldset class="half">
					<label for="Number of employees">Number of employees</label>
					<input type="number" name="Number of employees" value="" required>
				</fieldset>
				<fieldset>
					<label for="Description of the business">Description of the business:*</label>
					<textarea name="Description of the business"></textarea>
				</fieldset>
				<fieldset>
					<label for="Working Hours">Working Hours</label>
					<textarea name="Working Hours" placeholder="eg. Monday-Satuday 9am to 5pm" required></textarea>
				</fieldset>
				<fieldset>
					<label for="">Payment Method Accepted?</label>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Cash" id="payment-method-cash" value="Cash">
						<label for="payment-method-cash">Cash</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Visa" id="payment-method-visa" value="Visa">
						<label for="payment-method-visa">Visa</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Mastercard" id="payment-method-mastercard" value="Mastercard">
						<label for="payment-method-mastercard">Mastercard</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - American Express" id="payment-method-amex" value="American Express">
						<label for="payment-method-amex">American Express</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Personal Check" id="payment-method-personal-check" value="Personal Check">
						<label for="payment-method-personal-check">Personal Check</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Invoice" id="payment-method-invoice" value="Invoice">
						<label for="payment-method-invoice">Invoice</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Insurance" id="payment-method-insurance" value="Insurance">
						<label for="payment-method-insurance">Insurance</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - ATM / Debit" id="payment-method-atm-debit" value="ATM / Debit">
						<label for="payment-method-atm-debit">ATM / Debit</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Traveler's Checks" id="payment-method-travelers-check" value="Traveler's Checks">
						<label for="payment-method-travelers-check">Traveler's Checks</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Financing Available" id="payment-method-financing-available" value="Financing Available">
						<label for="payment-method-financing-available">Financing Available</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - PayPal" id="payment-method-paypal" value="PayPal">
						<label for="payment-method-paypal">PayPal</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Payment Method - Discover" id="payment-method-discover" value="Discover">
						<label for="payment-method-discover">Discover</label>
					</div>
				</fieldset>
				<h3 class="fieldset-title">Business Images</h3>
				<fieldset class="half left">
					<label for="Company Logo">Company Logo</label>
					<input type="file" name="Company Logo" accept="image/*" required>
				</fieldset>
				<fieldset class="half">
					<label for="Location Photos">Location Photos</label>
					<input type="file" name="Location Photos" multiple="multiple" accept="image/*" required>
				</fieldset>
				<h3 class="fieldset-title">Social Profile Links</h3>
				<fieldset class="half left">
					<label for="Facebook URL">Facebook URL</label>
					<input type="text" name="Facebook URL" value="" placeholder="https://facebook.com">
				</fieldset>
				<fieldset class="half ">
					<label for="Twitter URL">Twitter URL</label>
					<input type="text" name="Twitter URL" value="" placeholder="https://twitter.com">
				</fieldset>
				<fieldset class="half left">
					<label for="LinkedIn URL">LinkedIn URL</label>
					<input type="text" name="LinkedIn URL" value="" placeholder="https://linkedin.com">
				</fieldset>
				<fieldset class="half ">
					<label for="Pinterest URL">Pinterest URL</label>
					<input type="text" name="Pinterest URL" value="" placeholder="https://pinterest.com">
				</fieldset>
				<fieldset class="half left">
					<label for="Instagram URL">Instagram URL</label>
					<input type="text" name="Instagram URL" value="" placeholder="https://instagram.com">
				</fieldset>
				<h3 class="fieldset-title">Additional Information</h3>
				<p>If you would like to make our submissions team aware of any issues or concerns that you have before they submit to directories, please provide this information below</p>
				<fieldset>
					<textarea name="Additional Information"></textarea>
				</fieldset>
				<h3 class="fieldset-title">Terms &amp; Conditions</h3>
				<p>Please read and acknowledge the following before completing purchase:</p>
				<ul>
					<li>All citation submissions will be carried out within 7 days of purchase;</li>
					<li>You bear 100% responsibility for checking that the information supplied to us is correct before completing purchase;</li>
					<li>Some listing may not have photos, description or services displayed on their business- profile pages;</li>
					<li>We take all possible actions to remove duplicate listings but we can’t guarantee the success of duplicate removal on all sites.</li>
					<li>Once a submission campaign has started it may not be possible to change the information supplied to us;</li>
					<li>If submission to a selected directory or site is not possible, BrightLocal will submit you to a replacement site of similar value and authority;</li>
					<li>Not all submissions will result in live listings. We guarantee that a minimum 70% of submissions will result in live listings.</li>
				</ul>
				<fieldset>
					<div class="radio-checkbox-item">
						<input type="checkbox" name="Terms and Conditions" id="local-seo-citations-terms" value="Yes" required>
						<label for="local-seo-citations-terms">I have read and agree to full terms and conditions.</label>
					</div>
				</fieldset>
			<?php } elseif ( $product_id == 2117 ) { ?>
				<fieldset>
					<label for="Page Count">How many pages would you like optimised?</label>
					<input type="number" name="Page Count" value="<?php echo $page_count ?>">
				</fieldset>

				<!-- &words=750&technical=true -->
				<?php $word_count = isset( $_GET['words'] ) ? $_GET['words'] : ""; ?>
				<fieldset>
					<div class="radio-checkbox-item">
						<input type="checkbox" <?php echo $word_count ? "checked" : ""; ?> name="Include Content" id="include-content" value="Yes">
						<label for="include-content">Include Content</label>
					</div>
				</fieldset>
				<fieldset class="include-technical">
					<div class="radio-checkbox-item">
						<input type="checkbox" <?php echo $includeTechnical == "true" ? "checked" : ""; ?> name="Include Onsite and Technical SEO" id="include-technical-seo" value="Yes">
						<label for="include-technical-seo">Include Onsite and Technical SEO</label>
					</div>
				</fieldset>

				<?php if ( $word_count ): ?>
					<fieldset class="word-count">
						<label for="Word Count">How many words per page?</label>
						<input type="number" name="Word Count" value="<?php echo $word_count ?>" min="500" required>
					</fieldset>
				<?php endif ?>

				<fieldset>
					<label for="Keywords">What are the urls</label>
					<div class="website-item">
						<input type="text" name="Website URL 1" value="" placeholder="Website URL" required>
						<input type="text" name="Website URL 1 Keywords" value="" placeholder="Keywords" required>
					</div>
					<a href="" id="add-new-website-url-w-keywords">+ add a url</a>
				</fieldset>
				<fieldset>
					<label for="">Do you offer your products/services Locally?</label>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer your products/services Locally?" id="services-locally-yes" value="Yes" required>
						<label for="services-locally-yes">Yes</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer your products/services Locally?" id="services-locally-no" value="No">
						<label for="services-locally-no">No</label>
					</div>
				</fieldset>
				<fieldset>
					<label for="">Do you offer your products/services National?</label>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer products/services National?" id="services-national-yes" value="Yes" required>
						<label for="services-national-yes">Yes</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer products/services National?" id="services-national-no" value="No">
						<label for="services-national-no">No</label>
					</div>
				</fieldset>
				<fieldset>
					<label for="">Do you offer your services Internationally?</label>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer your services Internationally?" id="services-international-yes" value="Yes" required>
						<label for="services-international-yes">Yes</label>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Do you offer your services Internationally?" id="services-international-no" value="No">
						<label for="services-international-no">No</label>
					</div>
				</fieldset>
			<?php } elseif ( $product_name == "Page Optimisation" ) { ?>
				<fieldset>
					<label for="Package Type">Choose Package Type</label>
					<select name="Package Type" id="" required>
						<option value="">Select an option</option>
						<option value="optimization">Optimization Only</option>
						<option value="web-copy">Web Copy Only</option>
						<option value="web-copy-optimization">Web Copy + Optimization</option>
					</select>
				</fieldset>
				<fieldset>
					<label for="Page Count">How many pages?</label>
					<input type="number" name="Page Count" value="<?php echo $page_count ?>">
				</fieldset>
				<fieldset>
					<label for="Rewrite Content">Rewrite Content?</label>
					<input type="checkbox" name="Rewrite Content" value="Yes">
				</fieldset>
				<!-- if rewrite content is enabled show this part -->
				<fieldset class="hidden">
					<label for="Word Count">How many words?</label>
					<input type="number" name="Word Count" value="<?php echo $word_count ?>">
				</fieldset>
			<?php //} elseif ( $product_name == "Article Writing" || $product_name == "SEO Blog Writing" || $product_name == "Blog Writing Service" ) { ?>
			<?php } elseif ( $product_id == 2134 ) { ?>
				<fieldset class="half left">
					<label for="Page Count">How many pages?</label>
					<input type="number" name="Page Count" value="<?php echo $page_count ?>">
				</fieldset>
				<fieldset class="half">
					<label for="Word Count">How many words?</label>
					<input type="number" name="Word Count" value="<?php echo $word_count ?>" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Subject/s">What subject would you like the page to cover?</label>
					<input type="text" name="Subject/s" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Page/Website Link">Would you like to link to a page on your website?</label>
					<input type="text" name="Page/Website Link" value="" required>
				</fieldset>
				<fieldset>
					<label for="Keywords">Suggested keywords</label>
					<input type="text" name="Keywords" value="" required>
				</fieldset>
				<fieldset>
					<label for="Attachment/s">Any attachment the writer may find useful?</label>
					<input type="file" name="Attachment/s">
				</fieldset>
				<fieldset>
					<label for="Additional Information">Do you have any additional information for the writer?</label>
					<textarea name="Additional Information"></textarea>
				</fieldset>
			<?php //} elseif ( $product_name == "Content Writing Services" ) { ?>
			<?php } elseif ( $product_id == 2129 ) { ?>
				<fieldset class="half left">
					<label for="Page Count">How many pages?</label>
					<input type="number" name="Page Count" value="<?php echo $page_count ?>">
				</fieldset>
				<fieldset class="half">
					<label for="Word Count">How many words?</label>
					<input type="number" name="Word Count" value="<?php echo $word_count ?>" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Subject/s">What subject would you like the page to cover?</label>
					<input type="text" name="Subject/s" value="" required>
				</fieldset>
				<fieldset class="half">
					<label for="Page URL">If it already exists, what is the URL of the page?</label>
					<input type="text" name="Page URL" value="" required>
				</fieldset>
				<fieldset class="half left">
					<label for="Call to Action">What is the call to action of this page?</label>
					<select name="Call to Action" id="" required>
						<option value="">Select an option</option>
						<option>Call</option>
						<option>Register</option>
						<option>Enquire</option>
					</select>
				</fieldset>
				<fieldset class="half">
					<label for="USP">What is the USP of the product/services on this page?</label>
					<input type="text" name="USP" value="" required>
				</fieldset>
				<fieldset>
					<label for="Keywords">Suggested keywords</label>
					<input type="text" name="Keywords" value="" required>
				</fieldset>
				<fieldset>
					<label for="Attachment/s">Any attachment the writer may find useful?</label>
					<input type="file" name="Attachment/s" multiple>
				</fieldset>
				<fieldset>
					<label for="Additional Information">Do you have any additional information for the writer?</label>
					<textarea name="Additional Information"></textarea>
				</fieldset>
			<?php //} elseif ( $product_name == "Guest Post Service" || $product_name == "Blogger Outreach Service" ) { ?>
			<?php } elseif ( $product_id == 2090 || $product_id == 2105 ) { ?>
				<fieldset>
					<label for="DA10+">DA 10+ Websites *Low Tier*</label>
					<input type="number" name="DA10+" value="<?php echo $daType == 10 ? 1 : 0; ?>" min="0" data-prev-value="0">
				</fieldset>
				<fieldset>
					<label for="DA20+">DA 20+ Websites *Mid Tier*</label>
					<input type="number" name="DA20+" value="<?php echo $daType == 20 ? 1 : 0; ?>" min="0" data-prev-value="0">
				</fieldset>
				<fieldset>
					<label for="DA30+">DA 30+ Websites *High Tier*</label>
					<input type="number" name="DA30+" value="<?php echo $daType == 30 ? 1 : 0; ?>" min="0" data-prev-value="0">
				</fieldset>
				<fieldset>
					<label for="DA40+">DA 40+ Websites *Premium*</label>
					<input type="number" name="DA40+" value="<?php echo $daType == 40 ? 1 : 0; ?>" min="0" data-prev-value="0">
				</fieldset>
				<fieldset>
					<label for="DA50+">DA 50+ Websites *Platinum*</label>
					<input type="number" name="DA50+" value="<?php echo $daType == 50 ? 1 : 0; ?>" min="0" data-prev-value="0">
				</fieldset>

				<!-- DA Fields Project Details -->
				<div class="da-wrap">
					<div class="da-item <?php echo $daType == 10 ? "" : "hidden"; ?>" data-da-type="DA10+">
						<h4>DA 10+ Websites *Low Tier* Project Details</h4>
						<?php if ( $daType == 10 ) { ?>
							<div class="da-item-row" data-row-count="1">
								<fieldset>
									<label for="DA10+ Project 1 - Word Count">DA10+ Project 1 - Word Count</label>
									<input type="number" name="DA10+ Project 1 - Word Count" value="500" min="0" required>
								</fieldset>
								<fieldset>
									<label for="DA10+ Project 1 - Anchor Text">DA10+ Project 1 - Anchor Text</label>
									<input type="text" name="DA10+ Project 1 - Anchor Text" value="" required>
								</fieldset>
								<fieldset>
									<label for="DA10+ Project 1 - Target URL">DA10+ Project 1 - Target URL</label>
									<input type="text" name="DA10+ Project 1 - Target URL" value="" required>
								</fieldset>
							</div>
						<?php } ?>
					</div>
					<div class="da-item <?php echo $daType == 20 ? "" : "hidden"; ?>" data-da-type="DA20+">
						<h4>DA 20+ Websites *Mid Tier* Project Details</h4>
						<?php if ( $daType == 20 ) { ?>
							<div class="da-item-row" data-row-count="1">
								<fieldset>
									<label for="DA20+ Project 1 - Word Count">DA20+ Project 1 - Word Count</label>
									<input type="number" name="DA20+ Project 1 - Word Count" value="500" min="0" required>
								</fieldset>
								<fieldset>
									<label for="DA20+ Project 1 - Anchor Text">DA20+ Project 1 - Anchor Text</label>
									<input type="text" name="DA20+ Project 1 - Anchor Text" value="" required>
								</fieldset>
								<fieldset>
									<label for="DA20+ Project 1 - Target URL">DA20+ Project 1 - Target URL</label>
									<input type="text" name="DA20+ Project 1 - Target URL" value="" required>
								</fieldset>
							</div>
						<?php } ?>
					</div>
					<div class="da-item <?php echo $daType == 30 ? "" : "hidden"; ?>" data-da-type="DA30+">
						<h4>DA 30+ Websites *High Tier* Project Details</h4>
						<?php if ( $daType == 30 ) { ?>
							<div class="da-item-row" data-row-count="1">
								<fieldset>
									<label for="DA30+ Project 1 - Word Count">DA30+ Project 1 - Word Count</label>
									<input type="number" name="DA30+ Project 1 - Word Count" value="500" min="0" required>
								</fieldset>
								<fieldset>
									<label for="DA30+ Project 1 - Anchor Text">DA30+ Project 1 - Anchor Text</label>
									<input type="text" name="DA30+ Project 1 - Anchor Text" value="" required>
								</fieldset>
								<fieldset>
									<label for="DA30+ Project 1 - Target URL">DA30+ Project 1 - Target URL</label>
									<input type="text" name="DA30+ Project 1 - Target URL" value="" required>
								</fieldset>
							</div>
						<?php } ?>
					</div>
					<div class="da-item <?php echo $daType == 40 ? "" : "hidden"; ?>" data-da-type="DA40+">
						<h4>DA 40+ Websites *Premium* Project Details</h4>
						<?php if ( $daType == 40 ) { ?>
							<div class="da-item-row" data-row-count="1">
								<fieldset>
									<label for="DA40+ Project 1 - Word Count">DA40+ Project 1 - Word Count</label>
									<input type="number" name="DA40+ Project 1 - Word Count" value="500" min="0" required>
								</fieldset>
								<fieldset>
									<label for="DA40+ Project 1 - Anchor Text">DA40+ Project 1 - Anchor Text</label>
									<input type="text" name="DA40+ Project 1 - Anchor Text" value="" required>
								</fieldset>
								<fieldset>
									<label for="DA40+ Project 1 - Target URL">DA40+ Project 1 - Target URL</label>
									<input type="text" name="DA40+ Project 1 - Target URL" value="" required>
								</fieldset>
							</div>
						<?php } ?>
					</div>
					<div class="da-item <?php echo $daType == 50 ? "" : "hidden"; ?>" data-da-type="DA50+">
						<h4>DA 50+ Websites *Platinum* Project Details</h4>
						<?php if ( $daType == 50 ) { ?>
							<div class="da-item-row" data-row-count="1">
								<fieldset>
									<label for="DA50+ Project 1 - Word Count">DA50+ Project 1 - Word Count</label>
									<input type="number" name="DA50+ Project 1 - Word Count" value="500" min="0" required>
								</fieldset>
								<fieldset>
									<label for="DA50+ Project 1 - Anchor Text">DA50+ Project 1 - Anchor Text</label>
									<input type="text" name="DA50+ Project 1 - Anchor Text" value="" required>
								</fieldset>
								<fieldset>
									<label for="DA50+ Project 1 - Target URL">DA50+ Project 1 - Target URL</label>
									<input type="text" name="DA50+ Project 1 - Target URL" value="" required>
								</fieldset>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php //} elseif ( $product_name == "SEO Services" || $product_name == "SEO Management Service" || $product_name == "Local SEO Services" || $product_name == "National SEO Service" || $product_name == "International SEO Service" || $product_name == "eCommerce SEO Services" ) { ?>
			<?php } elseif ( $product_id == 2027 || $product_id == 2055 || $product_id == 2066 || $product_id == 2076 || $product_id == 2081 ) { ?>
				<fieldset class="budget">
					<label for="Budget">Choose Budget</label>
					<input type="number" name="Budget" value="<?php echo $budget; ?>" required>
				</fieldset>
				<fieldset>
					<label for="Competitor URL">Competitor URL</label>
					<input type="text" name="Competitor URL" value="">
				</fieldset>
				<fieldset>
					<label for="Keywords">Suggested Keywords</label>
					<input type="text" name="Keywords" value="">
				</fieldset>
				<fieldset>
					<label for="">Subscription Length</label>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-3-months" value="3 Months" required>
						<label for="subscription-length-3-months">3 Month Subscription</label>
						<div class="desc">This allows us to research your business, competition and keywords and set up your strategy and plan. It will also allow you to start seeing results.</div>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-6-months" value="6 Months" required>
						<label for="subscription-length-6-months">6 Month Subscription</label>
						<div class="desc">This allows us to build a six-month plan giving you extra initial research and planning at no extra cost.</div>
					</div>
					<div class="radio-checkbox-item">
						<input type="radio" name="Subscription Length" id="subscription-length-12-months" value="12 Months" required>
						<label for="subscription-length-12-months">12 Month Subscription</label>
						<div class="desc">This allows us to build a twelve-month plan giving you extra initial research and planning at no extra cost.</div>
					</div>
				</fieldset>
			<?php //} elseif ( $product_name == "Rank Tracker Basic" || $product_name == "Rank Tracker Business" || $product_name == "Rank Tracker Enterprise" ) { ?>
			<?php } elseif ( $product_id == 2203 ) { ?>
				<?php
					$keywordNum = 0;
					if ( $packageType == "basic" ) {
						$keywordNum = 50;
					} elseif ( $packageType == "business" ) {
						$keywordNum = 100;
					} elseif ( $packageType == "enterprise" ) {
						$keywordNum = 300;
					}
				?>
				<fieldset>
					<label for="Package Type">Package Type</label>
					<select name="Package Type" id="package-type" required>
						<option value="">Select an option</option>
						<option value="Basic" <?php echo $packageType == "basic" ? "selected" : ""; ?>>Basic</option>
						<option value="Business" <?php echo $packageType == "business" ? "selected" : ""; ?>>Business</option>
						<option value="Enterprise" <?php echo $packageType == "enterprise" ? "selected" : ""; ?>>Enterprise</option>
					</select>
				</fieldset>
				<fieldset>
					<label class="package-keywords" for="Keywords">Keywords (Add up to <?php echo $keywordNum; ?>)</label>
					<p>You can change your keywords on your dashboard at anytime</p>
					<input type="text" name="Keywords" value="">
					<a href="" data-max-keyword="<?php echo $keywordNum; ?>" id="add-new-keyword">add a keyword</a>
				</fieldset>
				<fieldset>
					<label for="Company Name">Company Name</label>
					<input type="text" name="Company Name" value="">
				</fieldset>
			<?php } else {
				if ( !is_admin() ) {
					// redirect if order name is not valid
					header("Location: https://seoi.io/seo-services/");
					exit();
				}
			} ?>

			<?php if ( empty( $userWebsites ) ) { ?>
				<fieldset>
					<label for="Website URL">Website URL</label>
					<input type="text" name="Website URL" value="" required>
				</fieldset>
			<?php } else {  ?>
				<fieldset class="">
					<label for="Website URL">Assign to your existing websites? (Website URL)</label>
					<select name="Website URL" id="" required>
						<option value="">Select an option</option>
						<?php foreach ( $userWebsites as $website ) { ?>
							<option><?php echo $website; ?></option>
						<?php } ?>
					</select>
					<a href="" id="add-new-website-url">or add a new url</a>
				</fieldset>
			<?php }  ?>

			<fieldset style="display: none;">
				<label for="_productPrice">Price (Static for test only)</label>
				<input type="number" name="_productPrice" value="<?php echo $price; ?>" readonly>
			</fieldset>

			<button type="submit" <?php echo $daType == "" ? "disabled" : "" ; ?>>Proceed to next step</button>
		</form>
<?php
	}
}

// add product to cart programmatically
// add_action( 'wp_ajax__addServiceToCart', '_addServiceToCart' ); 
// add_action( 'wp_ajax_nopriv__addServiceToCart', '_addServiceToCart' ); 
function _addServiceToCart(){
	// header('Content-Type: application/json');

	// empty cart
	global $woocommerce;
    $woocommerce->cart->empty_cart();

	// product id of SEOi Product
	$product_id = "";

	// order form data
	// $formData = $_REQUEST["formData"];

	$uploadedfile     = $_FILES['file'];
	$formOriginalData = $_REQUEST['formOriginalData'];
	$formOriginalData = json_decode(stripslashes($formOriginalData));

	if ( $uploadedfile ) {
		// intialize cart item data array
		$cart_item_data = array();

		// move uploaded file
		// create file array
	    $fileArr = array(
	    	'name'     => $_FILES['file']['name'],
	    	'tmp_name' => $_FILES['file']['tmp_name']
	    );

	    // upload this to wordpress media library
	    // return media/file id
	    $id = media_handle_sideload( $fileArr );

	    // if error storing permanently, unlink.
		if ( is_wp_error( $id ) ) {
		    @unlink( $fileArr['tmp_name'] );
		    return $id;
		}

		// get file url after uploading in media library
		$fileUrl = wp_get_attachment_url( $id );
	}



	// loop and assign the custom data
	if ( $formOriginalData ) {
		foreach ( $formOriginalData as $key => $data ) {
			if ( $data ) {
				if ( is_array( $data ) ) {
					$newData = implode(',', $data);
					// var_dump($newData);
					$cart_item_data["custom_order_item_data"][$key] = $newData;
				} else {
					$cart_item_data["custom_order_item_data"][$key] = $data;
				}
			}
			// $cart_item_data["custom_order_item_data"][$key] = $data ? $data : "n/a";
		}
	}

	// add attachment to custom order item data
	$cart_item_data["custom_order_item_data"]["Attachment"] = $fileUrl;

	/*
        OLD
        ---
        Article Writing Service == Blog Writing Service
        SEO content writing     ==> Content Writing Service
        Guest Post Service      == Guest Post Links ==> Guest Post Service
        Page Optimisation       == On Page SEO Services

		PRODUCT ID'S
		---
        SEOi Product - Full = 1692
		SEOi Product - Subscription (3 Months) = 1693
		SEOi Product - Subscription (6 Months) = 3425
		SEOi Product - Subscription (12 Months) = 3428
		SEOi Product - Monthly = 3407

		========================

		DIY Packages  (Buy and order as you need one-off payment)
		---
		https://seoi.io/blogger-outreach-service/ == 2090
		https://seoi.io/guest-post-service/       == 2105
		https://seoi.io/on-page-seo-service/      == 2117
		https://seoi.io/content-writing-service/  == 2129
		https://seoi.io/blog-writing-service/     == 2134
		https://seoi.io/local-seo-citations/      == 2111 
		https://seoi.io/search-engine-rank-tracking-tool/ == 2203 

		Managed SEO Services (Minium of 3 Month Subscription)
		---
		https://seoi.io/seo-management-service/         == 2027
		https://seoi.io/local-seo-services/             == 2055
		https://seoi.io/national-seo-service/           == 2066
		https://seoi.io/international-seo-service/      == 2076
		https://seoi.io/ecommerce-seo-services/         == 2081
		https://seoi.io/blog-management/                == 2123

		https://seoi.io/social-media-marketing-service/ == 1085 -- none
    */

	// $packagedServices = ["Blogger Outreach Service", "Guest Post Service", "On-Page SEO Service", "Content Writing Services", "Blog Writing Service", "Rank Tracker Basic", "Rank Tracker Business", "Rank Tracker Enterprise"];
	$packagedServices = [2090, 2105, 2117, 2129, 2134, 2111];

	// $managedServices  = ["SEO Management Service", "Local SEO Services", "National SEO Service", "International SEO Service", "eCommerce SEO Services", "Blog Management", "Social Media Marketing Service"];
	$managedServices  = [2027, 2055, 2066, 2076, 2081, 2123];

	//
	$rankTrackerServices = [2203];

	// if ( in_array( $formData["_productId"], $packagedServices ) ) {
	if ( in_array( $formOriginalData->_productId, $packagedServices ) ) {
		$product_id = 1692; // onetime payment
	// } elseif ( in_array( $formData["_productId"], $managedServices ) ) {
	} elseif ( in_array( $formOriginalData->_productId, $managedServices ) ) {
		if ($formOriginalData->{'Subscription Length'} == "3 Months") {
			$product_id = 1693; // subscription based -- minimum 3 months
		} elseif ($formOriginalData->{'Subscription Length'} == "6 Months") {
			$product_id = 3425; // subscription based -- minimum 6 months
		} elseif ($formOriginalData->{'Subscription Length'} == "12 Months") {
			$product_id = 3428; // subscription based -- minimum 12 months
		}

	} elseif ( in_array( $formOriginalData->_productId, $rankTrackerServices ) ) {
		$product_id = 3407; // Monthly
	}

	// $params( product_id, quantity, variation_id, variation_attr, cart_item_data )
	WC()->cart->add_to_cart( $product_id, '1', '0', array(), $cart_item_data );

	// 
	// echo json_encode( $response );

	// 
	die();
}

// function to change order item data after add to cart
// add_action('woocommerce_after_calculate_totals', '_seoiCustomCartFunctions', 30);
add_action( 'woocommerce_before_calculate_totals', '_seoiCustomCartFunctions', 30, 1 );
function _seoiCustomCartFunctions( $cart ) {
    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
        return;

    if ( did_action( 'woocommerce_before_calculate_totals' ) >= 2 )
        return;

    foreach ( $cart->get_cart() as $cart_item ) {
    	$product = $cart_item['data'];

		// if custom_order_item_data ==> the product uses the old code
		if($cart_item["custom_order_item_data"]){
			// change product name to the one on the order form
			$new_name = $cart_item["custom_order_item_data"]["_productName"];
			$new_id   = $cart_item["custom_order_item_data"]["_productId"];
	
			// rank tracker packages names
			if ( $new_id == "2203" ) {
				if ( $cart_item['custom_order_item_data']['Package Type'] == "Basic" ) {
					$new_name = "Rank Tracker Basic";
				} elseif ( $cart_item['custom_order_item_data']['Package Type'] == "Business" ) {
					$new_name = "Rank Tracker Business";
				} else {
					$new_name = "Rank Tracker Enterprise";
				}
			}
	
			if ( method_exists( $product, "set_name" ) ) {
				$product->set_name( $new_name );
			} else {
				$product->post->post_title = $new_name;
			}
			// ======================================================
	
			// calculate price based on the service
			// if ( $new_name == "Content Writing Services" || $new_name == "Blog Writing Service" ) {
			if ( $new_id == "2129" || $new_id == "2134" ) {
				$pageCount = (float) $cart_item['custom_order_item_data']['Page Count'];
				$wordCount = (float) $cart_item['custom_order_item_data']['Word Count'];
				$newPrice  = ( ( 12 * $wordCount ) * $pageCount ) / 100; // 12p per word
			} elseif ( $new_id == "2111" ) {
				if ( $cart_item['custom_order_item_data']['Citation Type'] == "30" ) {
					$newPrice = 120;
				} elseif ( $cart_item['custom_order_item_data']['Citation Type'] == "50" ) {
					$newPrice = 195;
				} elseif ( $cart_item['custom_order_item_data']['Citation Type'] == "80" ) {
					$newPrice = 295;
				}
			// } elseif ( $new_name == "On-Page SEO Service" ) {
			} elseif ( $new_id == "2117" ) {
	
				$pageCount        = (float) $cart_item['custom_order_item_data']['Page Count'];
				$includeTechnical = $cart_item['custom_order_item_data']['Include Onsite and Technical SEO'];
				$wordCount        = $cart_item['custom_order_item_data']['Word Count'];
	
				if ( $includeTechnical && $wordCount ) {
					$newPrice = ( ( ( ( 12 * $wordCount ) * $pageCount ) / 100 ) + ( 50 * $pageCount ) ) + 100;
				} elseif ( $includeTechnical ) {
					$newPrice = ( 50 * $pageCount ) + 100;
				} elseif ( $wordCount ) {
					$wordCount = (float) $cart_item['custom_order_item_data']['Word Count'];
					$newPrice  = ( ( ( 12 * $wordCount ) * $pageCount ) / 100 ) + ( 50 * $pageCount );
				} else {
					$newPrice = ( 50 * $pageCount );
				}
	
				// var_dump($newPrice);
	
			// } elseif ( $new_name == "Blog Management" ) {
			} elseif ( $new_id == "2123" ) {
				$wordCount = (float) $cart_item['custom_order_item_data']['Word Count'];
				$postCount = (float) $cart_item['custom_order_item_data']['Blog Posts'];
				$newPrice  = ( ( 10 * $wordCount ) * $postCount ) / 100; // 10p per word
			// } elseif ( $new_name == "SEO Services" || $new_name == "SEO Management Service" || $new_name == "Local SEO Services" || $new_name == "National SEO Service" || $new_name == "International SEO Service" || $new_name == "eCommerce SEO Services" ) {
			} elseif ( $new_id == "2027" || $new_id == "2055" || $new_id == "2066" || $new_id == "2076" || $new_id == "2081" ) { 
				$budget   = (float) $cart_item['custom_order_item_data']['Budget'];
				$newPrice = $budget;
			// } elseif ( $new_name == "Guest Post Service" || $new_name == "Blogger Outreach Service" ) {
			} elseif ( $new_id == "2090" || $new_id == "2105" ) {
				$da10 = 100 * (float) $cart_item['custom_order_item_data']['DA10+'];
				$da20 = 150 * (float) $cart_item['custom_order_item_data']['DA20+'];
				$da30 = 195 * (float) $cart_item['custom_order_item_data']['DA30+'];
				$da40 = 395 * (float) $cart_item['custom_order_item_data']['DA40+'];
				$da50 = 495 * (float) $cart_item['custom_order_item_data']['DA50+'];
	
				$newPrice = $da10 + $da20 + $da30 + $da40 + $da50;
	
				// this is so we can calculate the price per words dynamically
				$itemPrices = [];
				$daExcludedForPrice = array( "DA10+", "DA20+", "DA30+", "DA40+", "DA50+", "_productName", "_productPrice" );
				foreach ( $cart_item['custom_order_item_data'] as $key => $value ) {
					if ( !in_array( $key, $daExcludedForPrice ) ) {
						if ( $value > 500 ) {
							$value = $value - 500;
							$itemPrices[] = ( 12 * $value ) / 100;
						}
					}
				}
				$newPrice = $newPrice + array_sum($itemPrices);
			// } elseif ( $new_name == "Rank Tracker Basic" ) {
			// } elseif ( $new_name == "Rank Tracker Business" ) {
			// } elseif ( $new_name == "Rank Tracker Enterprise" ) {
			} elseif ( $new_id == "2203" ) {
				if ( $cart_item['custom_order_item_data']['Package Type'] == "Basic" ) {
					$newPrice = 20;
				} elseif ( $cart_item['custom_order_item_data']['Package Type'] == "Business" ) {
					$newPrice = 40;
				} else {
					$newPrice = 60;
				}
			} else {
				$newPrice = (float) $cart_item['custom_order_item_data']['_productPrice'];
			}
	
			// set price
			// if( isset($cart_item['custom_order_item_data']['_productPrice']) ) {
				// $finalPrice = $newPrice / 3; // divide by 3 for 3 months subscription
				$finalPrice = $newPrice;
				$product->set_price( $finalPrice );
			// }
			// ======================================================
		} elseif($cart_item["custom_product_data"]){

			// the product name
			$new_name = $cart_item["custom_product_data"]["Product Name"];
			$new_id = $cart_item["custom_product_data"]["Service ID"];

			// variable prices
			$new_price = 0;
			$new_prices = [];

			// set the new product name
			if (method_exists($product, "set_name")) {
				$product->set_name($new_name);
			} else {
				$product->post->post_title = $new_name;
			}

			// calculate price of the service
			if ($new_id == "2129" || $new_id == "2134") {

				// get data needed to calculate the price
				$pages = $cart_item["custom_product_data"]["Pages"];
				foreach($pages as $key => $page){
					$word_count   = (float) $page["Word Count"];
					$new_prices[] = ( ( ( 12 * $word_count ) * 1 ) / 100 );
				}

				// sum of all prices
				$new_price = array_sum($new_prices);
			} elseif($new_id == "2055" || $new_id == "2066" || $new_id == "2076" || $new_id == "2081"){
				// 2055 == Local SEO Services
				// 2066 == National SEO Services
				// 2076 == International SEO Services
				// 2081 == eCommerce SEO Services
				$budget    = (float) $cart_item['custom_product_data']['Budget'];
				$new_price = $budget;
			}

			// set the new price
			$final_price = $new_price;
			$product->set_price($final_price);
		}
    }
}

// update meta data for the order item
add_action( 'woocommerce_checkout_create_order_line_item', 'custom_checkout_create_order_line_item', 20, 4 );
function custom_checkout_create_order_line_item( $item, $cart_item_key, $values, $order ) {
    
	// if( ! isset( $values['custom_order_item_data'] ) ) return;

    if( ! empty( $values['custom_order_item_data'] ) ) {

    	// exclude these values from the meta data
    	$excludedValues = [ "_productName", "_productPrice" ];

    	foreach ( $values['custom_order_item_data'] as $key => $custom_data ){
    		if ( !in_array( $key, $excludedValues ) ) {
    			if ( $key == "_productId" ) {
			        $item->update_meta_data( "Product ID", $custom_data );
    			} else {
			        $item->update_meta_data( $key, $custom_data );
    			}
    		}
    	}
    }

	// for the new code
	if(!empty($values['custom_product_data'])) {

		// exclude these values from the meta data
		$excluded_values = ["Product Name"];
		
		foreach ( $values['custom_product_data'] as $key => $custom_data ){
			// if (!in_array( $key, $excluded_values)) {
				$item->update_meta_data($key, $custom_data);
			// }
		}
	}
}

// update meta after the checkout process
add_action('woocommerce_thankyou', '_afterCheckoutProcess', 10, 1);
function _afterCheckoutProcess( $order_id ) {
	$order          = wc_get_order( $order_id );
	$user           = $order->get_user();
	$user_id        = $order->get_user_id();
	$userFirstName  = $order->get_billing_first_name();
	$userLastName   = $order->get_billing_last_name();
	$userEmail      = $user->user_email; // get the user email
	$userWebsites   = get_the_author_meta( "_user_websites", $user_id ) ? get_the_author_meta( "_user_websites", $user_id ) : [];
	$webceoProjects = get_the_author_meta( "_webceo_projects", $user_id ) ? get_the_author_meta( "_webceo_projects", $user_id ) : [];
	$webceoUser     = get_the_author_meta( "_webceo_user", $user_id ) ? get_the_author_meta( "_webceo_user", $user_id ) : "";
	$orderWebsite   = "";
	$companyName    = "";
	$packageType    = "";
	$keywords       = "";
	
	// api endpoint
	$endpoint = "https://seo-tools.seoi.co.uk/api/";

	foreach ( $order->get_items() as $item_id => $item ) {
		$website           = $item->get_meta( 'Website URL', true );
		$orderWebsite      = $website;
		$productName       = $item->get_name();
		$formattedMetaData = $item->get_formatted_meta_data( '_', true );

		// REMOVE HTTPS, HTTP AND TRAILING SLASH
		// $website = preg_replace('#^https?://#', '', rtrim($website,'/'));
		saveUserWebsite($website);

		// push the website into the array
		if ( !in_array( $website, $userWebsites ) ) {
			$userWebsites[] = $website;
		}

		// 
		if ( $productName == "Rank Tracker Basic" ) {
            $packageType = "Basic";
        } elseif ( $productName == "Rank Tracker Business" ) {
            $packageType = "Business";
        } elseif ( $productName == "Rank Tracker Enterprise" ) {
            $packageType = "Enterprise";
        }

        // get the company name details from the order item meta data
        if ( $packageType ) {
			foreach ( $formattedMetaData as $key => $value ) {
				if ( $value->key == "Company Name" ) {
					$companyName = $value->value;
				} elseif ( $value->key == "Keywords" ) {
					$keywords = explode( ",", $value->value );
				}
			}
        }
	}

	// update the user meta websites assigned
	// update_user_meta( $user_id, "_user_websites", $userWebsites );


	/*echo "<pre>";
	var_dump($companyName);
	var_dump($packageType);
	echo "</pre>";*/


	/* WEBCEO API ADD PROJECT */
	/*=====================================*/
	/*=====================================*/
	if ( $packageType ) {

		/* WEBCEO API ADD ACCOUNT */
		if ( !$webceoUser ) {
			// $generatedPassword = "se".$user_id."co".date("Ymd")."oi";
			$addUser = array(
		        "method"       => "add_user",
		        "key"          => "a3f36b7e0caa64733a",
		        "data"         => array(
		            'user'     => $userEmail,
		            // 'role'     => "ROLE_CLIENT",
		            // 'password' => $generatedPassword,
		        )
		    );
		    $newWebceoUser = _getData( $addUser, $endpoint );

		    // update webceo user meta
		    $webceoUser = $newWebceoUser;
		    update_user_meta( $user_id, "_webceo_user", $webceoUser );
		}

		// remove http or https to website url
		$website = preg_replace("(^https?://)", "", $orderWebsite );

		// add project to webceo
		$addProject = array(
	        "method"     => "add_project",
	        "key"        => "a3f36b7e0caa64733a",
	        "data"       => array(
	            'user'   => $userEmail,
	            'domain' => $website,
	            'name'   => $companyName,
	            'limit'  => $packageType
	        )
	    );
	    $project = _getData( $addProject, $endpoint );

	    // update
	    $webceoProjects[$order_id] = $project;
	    $webceoProjects[$order_id]["domain"] = $website;
	    update_user_meta( $user_id, "_webceo_projects", $webceoProjects );

		// set keywords to project
		$setProjectKeywords = array(
			"method"       => "set_rankings_keywords",
	        "key"          => "a3f36b7e0caa64733a",
	        "data"         => array(
	            'project'  => $project["data"]["project"],
	            'keywords' => $keywords
	        )
		);
		$projectKeywords = _getData( $setProjectKeywords, $endpoint );

		// trigger rescan
		$triggerProjectRescan = array(
			"method"      => "rescan_project",
	        "key"         => "a3f36b7e0caa64733a",
	        "data"        => array(
	            'project' => $project["data"]["project"],
	            'tools'   => ["ranker"]
	        )
		);
		$projectRescan = _getData( $triggerProjectRescan, $endpoint );
	}

    // get project object
    /*$getProjectArgs = array(
        "method" => "get_project",
        "key"    => "a3f36b7e0caa64733a",
        "data"   => array(
            'user'    => $userEmail,
            'domain'  => $projectUrl,
            'project' => $projectId,
        )
    );
    $project = _getData( $getProjectArgs, $endpoint );

    // set project limits
    $setProjectLimitsArgs = array(
        "method" => "set_project",
        "key"    => "a3f36b7e0caa64733a",
        "data"   => array(
            'user'    => $userEmail,
            'domain'  => $projectUrl,
            'project' => $projectId,
            'limit'   => $packageType
        )
    );
    $setProjectLimit = _getData( $setProjectLimitsArgs, $endpoint );

    var_dump($project);*/
}

// get data -- curl for every webceo api call
function _getData( $data, $endpoint ) {
    $ch = curl_init( $endpoint );
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, "json=".urlencode(json_encode($data)));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    $json_result = json_decode($result, True)[0];

    return $json_result;
}