<?php 
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

// REQUIRE CONFIG FILE
require_once(ABSPATH . 'wp-content/themes/thrive-theme-child/includes/google/google-config.php');

class GOOGLE_ANALYTICS extends SEOI {

    // GET LIST OF ACCOUNTS
    public function accountList($user_id = NULL){

		// Validate user
		if($this->validateUser('', 'GOOGLE_ACCOUNTS', $user_id)){

			// Get site list
			return $this->getAccountList($user_id);
		} else {

			return false;
		}
	}

    // GET LIST OF PROPERTIES BY ACCOUNT
    public function propertyList($account_id = NULL){

        if(!$account_id){
            return false;
        }

		// Validate user
		if($this->validateUser('', 'GOOGLE_ACCOUNTS')){

			// Get site list
			return $this->getPropertyList($account_id);
		} else {

			return false;
		}
	}

    /**
	 *  GET PROPERTY REPORT
	 * 
	 * @param string $view_id
	 * @param string $start_date - '2022-01-01'
	 * @param string $end_date - '2022-01-31'
	 * 
	 * @return array || boolean
	 */
   /*  public function propertyReport(string $view_id = '', string $start_date = '', string $end_date = '', string $data_type = ''){

        if(!$view_id || !$start_date || !$end_date){
            return false;
        }

        // Validate user
		if($this->validateUser('', 'GOOGLE_ACCOUNTS')){

			// Get site list
			return $this->getPropertyReport($view_id, $start_date, $end_date, $data_type);
		} else {

			return false;
		}
    }
 */
	/**
	 * GET ANALYTICS REPORT
	 * 
	 * @param string $site_url
	 * @param string $start_date - '2022-01-01'
	 * @param string $end_date - '2022-01-31'
	 * @param string $data_type - the type of data we want to get from the report eg. last month, two months ago, three months ago
	 * @param string $load_type - 'load' || 'refresh'
	 * 
	 * @return array || boolean
	 */
	public function getAnalyticReport( string $site_url = '', string $start_date = '', string $end_date = '', string $data_type = '', string $load_type = 'load', $manager_id = NULL, $user_id = NULL){

		// return $this->validateUser('', 'GOOGLE_ACCOUNTS', $manager_id);
		// Validate user
		if($this->validateUser('', 'GOOGLE_ACCOUNTS', $manager_id)){

			// regex remove http:// or https:// from site url
			$site_url = preg_replace('#^https?://#', '', $site_url);
			// remove string sc:domain: from site url
			$site_url = str_replace('sc-domain:', '', $site_url);
			// remove trailing slash from site url
			$site_url = rtrim($site_url, '/');
			/* // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
			$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
			// IF EMPTY, GET THE CURRENT USER ID
			$user_id = $user_id ? $user_id : get_current_user_id(); */
			/* // GET MANAGER ID
			$accountManager = get_the_author_meta( "_assigned_account_manager", $user_id );
			// GET USER ID BY EMAIL
			$accountManager = get_user_by( "email", $accountManager );
			// GET THE CUSTOMER ID
			$manager_id = $accountManager ? $accountManager->ID : ''; */

			// GET THE JSON FILE
			$filename = $user_id.'_'.$data_type.'_property_report.json';
			$filepath = get_stylesheet_directory().'/includes/cache/'.$filename;


			/* return array(
				'user_id' => $user_id,
				'site_url' => $site_url,
				'load_type' => $load_type,
			);
 */
			
			

			// CHECK LOAD TYPE AND RETURN DATA FROM JSON IF LOAD TYPE IS LOAD
			if($load_type == 'load' && file_exists($filepath)){
				// GET DATA FROM JSON
				$json = file_get_contents($filepath);
				// GET DATA FROM JSON
				$data = json_decode($json, true);
				// RETURN DATA
				return $data;
			} else {

				// GET ACCOUNT LIST
				$account_list = $this->accountList($manager_id);

				/* return array(
					'filename' => $filename,
					'filepath' => $filepath,
					'load_type' => $load_type,
					'account_list' => $account_list,
				);
 */
				// REMOVE
				// $test = [];
				// CHECK AND LOOP THROUGH ACCOUNTS
				if($account_list && $account_list['items']){
					foreach($account_list['items'] as $account){
						// GET PROPERTY LIST
						// $property_list = $this->propertyList($account['id']);
						// $test[] = $account;
						// GET GA4 PROPERTY LIST
						$property_list = $this->getPropertyReport(array(
							'account_id' => 'accounts/'.$account['id'], 
							'user_id'    => $user_id,
							'manager_id'    => $manager_id,
							'type'       => 'get_property_list'
						));
						// $test[] = $property_list;
						// CHECK AND LOOP THROUGH PROPERTIES
						// if($property_list && $property_list['items']){
						if($property_list){
							// LOOP THROUGH PROPERTIES
							// foreach($property_list['items'] as $property){
							foreach($property_list as $key => $property_list_data){
								// CHECK IF KEY IS DATA
								if($key == 'data'){
									// $test[] = $property_list_data;
									// LOOP THROUGH THE LIST OF PROPERTIES PER ACCOUNT
									if($property_list_data['properties']){
										foreach($property_list_data['properties'] as $key => $property){
											// GET PROPERTY NAME - EG., properties/378943352
											$property_name = $property['name'];
											// $test[] = $property_name;
											// GET PARENT - EG., accounts/123456789
											$parent = $property['parent'];
											// DATA
											$data = array(
												'user_id' => $user_id,
												'manager_id' => $manager_id,
												'property_name' => $property_name,
											);
											// GET PROPERTY WEBSTREAM - RETURNS THE WEB URL OF THE PROPERTY
											$property_url = $this->getAnalyticsWebstreamData($data);
											// $test[] = $property_url;
											// regex remove http:// or https:// from property url
											$property_website = preg_replace('#^https?://#', '', $property_url);
											// remove trailing slash from property url
											$property_website = rtrim($property_website, '/');
											// REMOVE WWW FROM PROPERTY URL AND SITE URL
											$property_website = str_replace('www.', '', $property_website);
											// 
											$site_url = str_replace('www.', '', $site_url);
											// CHECK IF PROPERTY URL MATCHES SITE URL
											/* $test[] = array(
												'property_website' => $property_website,
												'site_url' => $site_url,
											); */
											if($property_website == $site_url){
												// BUILD ARRAY DATA
												$data = array(
													'time'       => date('Y-m-d_H-i-s'), // '2022-01-01
													'start_date' => $start_date,
													'end_date'   => $end_date,
													'data_type'  => $data_type,
													'user_id'    => $user_id,
													'manager_id' => $manager_id,
													'account_id' => $parent,
													'type' 	     => 'get_analytics_report',
												);
												// NEW GA4 PROPERTY REPORT
												return $this->getPropertyReport($data);
												// $test[] = $data;
											}
										}
									}
								}

								/*// PROPERTY URL
								$property_website = $property['websiteUrl'];
								// regex remove http:// or https:// from property url
								$property_website = preg_replace('#^https?://#', '', $property_website);
								// remove trailing slash from property url
								$property_website = rtrim($property_website, '/');
								// REMOVE WWW FROM PROPERTY URL AND SITE URL
								$property_website = str_replace('www.', '', $property_website);
								$site_url = str_replace('www.', '', $site_url);

								 // CHECK IF PROPERTY URL MATCHES SITE URL
								if($property_website == $site_url){
	
									// GET PROPERTY REPORT
									// $property_report = $this->propertyReport($property['defaultProfileId'], $start_date, $end_date, $data_type);
									// BUILD ARRAY DATA
									$data = array(
										'time'       => date('Y-m-d_H-i-s'), // '2022-01-01
										'start_date' => $start_date,
										'end_date'   => $end_date,
										'data_type'  => $data_type,
										'user_id'    => $user_id,
										'account_id' => $property['accountId'],
									);
									// NEW GA4 PROPERTY REPORT
									return $this->getPropertyReport($data);
								} */
							}
						}
					}

					// return $test;
				} else {
					return false;
				}

				// return $test;
			}

			
		} else {
			
			return false;
		}
	}
    
    // GET LIST OF ACCOUNTS
    private function getAccountList($user_id = NULL){

        // Get current user
		// $user = wp_get_current_user();
		// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
		/* $user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
		// IF EMPTY, GET THE CURRENT USER ID
		$user_id = $user_id ? $user_id : get_current_user_id(); */

		// Get access token
		$token_access = get_user_meta( $user_id, 'google_token_access', true );

        // Set up the HTTP headers with the access token
		$headers = array(
			"Authorization" => "Bearer ".$token_access,
			"Content-Type" => "application/json"
		);

		// Send the GET request to the API endpoint using wp_remote_post
		$response = wp_remote_post('https://www.googleapis.com/analytics/v3/management/accounts', array(
			"headers" => $headers,
			"method" => "GET"
		));

        // Check for errors in the response
		if (is_wp_error($response)) {

			return false;
		} else {

			// Return
			return json_decode( wp_remote_retrieve_body( $response ), true );
		}
    }

    // GET LIST OF PROPERTIES BY ACCOUNT
    private function getPropertyList($account_id = NULL){

        // Get current user
		// $user = wp_get_current_user();
		// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
		$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
		// IF EMPTY, GET THE CURRENT USER ID
		$user_id = $user_id ? $user_id : get_current_user_id();

		// Get access token
		$token_access = get_user_meta( $user_id, 'google_token_access', true );

        // Set up the HTTP headers with the access token
		$headers = array(
			"Authorization" => "Bearer ".$token_access,
			"Content-Type" => "application/json"
		);

		// Send the GET request to the API endpoint using wp_remote_post
        $url = 'https://www.googleapis.com/analytics/v3/management/accounts/'.$account_id.'/webproperties';
		$response = wp_remote_post($url, array(
			"headers" => $headers,
			"method" => "GET"
		));

        // Check for errors in the response
		if (is_wp_error($response)) {

			return false;
		} else {

			// Return
			return json_decode( wp_remote_retrieve_body( $response ), true );
		}
    }

    /**
	 * FETCH PROPERTY REPORT
	 * 
	 * @param array $data - array of data to be sent to the api
	 * @param string $account_id
	 * 
	 * @return array || boolean
	 * 
	 */
    // private function getPropertyReport(string $view_id = '', string $start_date = '',  string $end_date = '', string $data_type = ''){
    private function getPropertyReport($data){

		// Get current user
		// GET PROPERTY LIST DATA
		$property_list_data = $this->getPropertyAdminList($data['account_id'], $data['manager_id']);
		// CHECK IF PROPERTY LIST DATA IS NOT FALSE AND RESPONSE CODE IS 200
		if($data['type'] == 'get_analytics_report' && $property_list_data && $property_list_data['response_code'] == 200){
			// ADD PROPERTY LIST DATA TO DATA
			$data['property_list_data'] = $property_list_data;
			// GET FIRST PROPERTY
			$property = $property_list_data['data']['properties'][0];
			// GET PROPERTY NAME - EG., properties/378943352
			$data['property_name'] = $property['name'];
			// GET BATCH REPORT
			$batch_report = $this->getAnalyticsDataBatchReport($data);
			// INSERT BATCH REPORT TO DATA
			$data['batch_report'] = $batch_report;
			// SAVE DATA TO CACHE
			$this->saveDataToCache($data);
		} elseif($data['type'] == 'get_property_list'){
			$data = $property_list_data;
		}
		// RETURN THE REPORT
		return $data;
		// return $property_list_data;
    }
	/*
	 * GET PROPERTY ADMIN LIST
	 * 
	 * https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties/list
	 * 
	 * @param string $account_id
	 * @param string $user_id
	 * 
	 * @return array || boolean
	 *
	 */
	private function getPropertyAdminList(string $account_id = '', string $user_id = ''){
		// GET ACCESS TOKEN
		$accessToken = get_user_meta( $user_id, 'google_token_access', true );
		// URL ENCODE
		// $query = urlencode('parent:accounts/'.$account_id);
		$query = urlencode('parent:'.$account_id);
		// BUILD URL
		$url = 'https://analyticsadmin.googleapis.com/v1beta/properties?filter='.$query;
		// SETUP HTTP HEADERS
		$headers = array(
			"Authorization" => "Bearer ".$accessToken,
			"Content-Type"  => "application/json"
		);
		// RESPONSE
		$response = wp_remote_post($url, array(
			"headers" => $headers,
			"method"  => "GET",
		));
		// CHECK FOR ERRORS IN THE RESPONSE
		if (is_wp_error($response)) {
			// RETURN FALSE
			return false;
		} else {
			// GET RESPONSE DATA
			$response_code = wp_remote_retrieve_response_code( $response );
			$response_body = wp_remote_retrieve_body( $response );
			// DECODE RESPONSE DATA
			$responseData = json_decode( $response_body, true );
			// BUILD DATA
			$data = array(
				'url'           => $url,
				'response_code' => $response_code,
				'data'          => $responseData,
			);
			// RETURN DATA
			return $data;
		} 
	}

	/*
	 * GET ANALYTICS DATA BATCH REPORT
	 * https://developers.google.com/analytics/devguides/reporting/data/v1/rest/v1beta/properties/batchRunReports
	 * https://ga-dev-tools.google/ga4/query-explorer/
	 * 
	 * @param array $data - array of data to be sent to the api
	 * 
	 * @return array || boolean
	 * 
	 */
	private function getAnalyticsDataBatchReport(array $data = array()){
		// GET ACCESS TOKEN
		$accessToken = get_user_meta( $data['manager_id'], 'google_token_access', true );
		// BUILD URL
		$url = 'https://analyticsdata.googleapis.com/v1beta/'.$data['property_name'].':batchRunReports';

		/* return array(
			'url' => $url,
			'data' => $data,
		);
 */
		// SETUP HTTP HEADERS
		$headers = array(
			"Authorization" => "Bearer ".$accessToken,
			"Content-Type"  => "application/json"
		);
		// DATA
		// 
		if($data['data_type'] == 'last_month' || $data['data_type'] == 'two_months' || $data['data_type'] == 'three_months'){
			$responseData = '{
				"requests": [
					{
						"metrics": [
							{
								"name": "screenPageViews",
							}
						],
						"dateRanges": [
							{
								"startDate": "'.$data['start_date'].'",
								"endDate": "'.$data['end_date'].'",
							},
						],
					},
				],
			}';
		} else {
			$responseData = '{
				"requests": [
					{
						"metrics": [
							{
								"name": "organicGoogleSearchImpressions"
							},
							{
								"name": "organicGoogleSearchClicks"
							}
						],
						"dateRanges": [
							{
								"startDate": "'.$data['start_date'].'",
								"endDate": "'.$data['end_date'].'"
							},
						],
						"dimensions":[
							{
								"name": "yearMonth"
							}
						]
					},
				],
			}';
		}
		
		// RESPONSE
		$response = wp_remote_post($url, array(
			"headers" => $headers,
			// "method"  => "POST",
			"body"    => $responseData
		));
		// CHECK FOR ERRORS IN THE RESPONSE
		if (is_wp_error($response)) {
			// RETURN FALSE
			return false;
		} else {
			// GET RESPONSE DATA
			$response_code = wp_remote_retrieve_response_code( $response );
			$response_body = wp_remote_retrieve_body( $response );
			// DECODE RESPONSE DATA
			$responseData = json_decode( $response_body, true );
			// BUILD DATA
			$data = array(
				'url'           => $url,
				'response_code' => $response_code,
				'data'          => $responseData,
			);
			// RETURN DATA
			return $data;
		} 
	}

	/*
	 * GET ANALYTICS DATA
	 * - Use this method to get the web url of the property
	 * - https://developers.google.com/analytics/devguides/config/admin/v1/rest/v1beta/properties.dataStreams/list
	 * 
	 * @param {array} $data
	 * 
	 * @return {string} $property_url || {boolean}
	 * 
	 */
	private function getAnalyticsWebstreamData(array $data = NULL){

		/* dd($data['property_name']);
		die(); */

		// CHECK IF PROPERTY ID IS NULL
		if(!$data){
			// RETURN FALSE
			return false;
		}
		// GET ACCESS TOKEN
		$accessToken = get_user_meta( $data['manager_id'], 'google_token_access', true );
		// $asdasdasd = get_user_meta( $data['manager_id'], 'google_token_access', true );
		// BUILD URL
		// $url = 'https://analyticsadmin.googleapis.com/v1beta/'.$data['property_name'].'/dataStreams?key='.GOOGLE_SEARCH_AND_ANALYTICS_API_KEY;
		$url = 'https://analyticsadmin.googleapis.com/v1beta/'.$data['property_name'].'/dataStreams';
		// SETUP HTTP HEADERS
		$headers = array(
			"Authorization" => "Bearer ".$accessToken,
			"Content-Type"  => "application/json"
		);
		
		// RESPONSE
		$response = wp_remote_post($url, array(
			// GET
			"method"  => "GET",
			"headers" => $headers
		));
		// CHECK FOR ERRORS IN THE RESPONSE
		if (is_wp_error($response)) {
			// RETURN FALSE
			return false;
		} else {
			// GET RESPONSE DATA
			$response_code = wp_remote_retrieve_response_code( $response );
			$response_body = wp_remote_retrieve_body( $response );
			// GET ERROR MESSAGE
			$error_message = wp_remote_retrieve_response_message( $response );
			// DECODE RESPONSE DATA
			$responseData = json_decode( $response_body, true );
			// BUILD DATA
			/* $data = array(
				'token'         => $accessToken,
				'manager_token' => $asdasdasd,
				'user_id'       => $data['user_id'],
				'manager_id'    => $data['manager_id'],
				'url'           => $url,
				'response_code' => $response_code,
				'data'          => $responseData,
				'error_message' => $error_message,
			); */
			// RETURN DATA
			return $property_url = $responseData['dataStreams'][0]['webStreamData']['defaultUri'];
			// return $data;
			// return $responseData;
		} 

		// return $property_id;
	}

	/*
	 * SAVE THE REPORT TO A JSON FILE
	 * 
	 * @param array $data
	 * @param string $user_id
	 * @param string $data_type - the type of data we want to get from the report eg. last month, two months ago, three months ago
	 * 
	 */
	public function saveDataToCache(array $data = array()){

		// FILE NAME
		$file_name = $data['user_id'].'_'.$data['data_type'].'_property_report.json';
		// FILE PATH
		$file_path = get_stylesheet_directory()."/includes/cache/".$file_name;
		// OVERWRITE THE FILE
		return $json = file_put_contents($file_path, json_encode($data));
	}
}