<?php
/*
 * SIGN UP FORM AFTER SUBMISSION
 * FORM ID = 4
 * - save the website data to the user meta
 * 
 */
add_action('gform_after_submission_4', 'signupFormAfterSubmission', 10, 2);
function signupFormAfterSubmission($entry, $form) {

    // dd($entry);
    // dd($form);

    // GET WEBSITE
    $website = rgar($entry, '20');

    // GET EMAIL
    $email = rgar($entry, '2');

    // GET USER BY EMAIL
    $user = get_user_by('email', $email);

    // GET USER ID
    $user_id = $user->ID;

    /* // LOG IN THE USER
    $user = get_user_by( 'id', $user_id ); 
    wp_set_current_user( $user_id, $user->user_login );
    wp_set_auth_cookie( $user_id );
    do_action( 'wp_login', $user->user_login, $user ); */

    // SAVE WEBSITE TO USER META
    saveUserWebsite($website, $user_id);

    buildGoHighLevelContactGform($entry, $form);
}



// new seo strategy
// this will update the meta data
add_action('gform_after_submission_18', '_seoStrategyFormUpdateTodoList', 10, 2);
function _seoStrategyFormUpdateTodoList($entry, $form) {

    // form data
    $date_created   = $entry['date_created'];
    $entry_id       = $entry['id'];
    $customer_email = rgar($entry, '12');
    $manager_email  = rgar($entry, '10'); // current user email
    $manager_id     = rgar($entry, '11'); // seo manager id (default is 120 for the)

    // get user object by email
    $customer    = get_user_by('email', $customer_email);
    $customer_id = $customer->ID;

    // save the data as array to the user if the user exists
    $todo_list = get_user_meta($customer_id, 'todo_list', true);
    $todo_list = $todo_list ? $todo_list : array();
    
    // check if customer exists
    if($customer){

        // data
        $todo_list[] = array(
            'date_created' => $date_created,
            'entry_id'     => $entry_id,
        );

        // update the customer meta
        update_user_meta($customer_id, 'todo_list', $todo_list);
    } else {

        // data
        $todo_list[][$customer_email][] = array(
            'date_created' => $date_created,
            'entry_id'     => $entry_id,
        );

        // update manager meta
        // -- this is just for when the customer_email does not exists
        update_user_meta($manager_id, 'todo_list', $todo_list);
    }

    /*
     *
     * Generate the todo list based on the keyword site data
     *
     */
    $services = buildServices($customer_email, $entry_id);

    // update gform entry meta
    gform_update_meta( $entry_id, 'todo_list', $services );
}
/*
 * CUSTOMER - FREE SEO STRATEGY FORM
 * - FORM ID 17
 * 
 */
add_action('gform_after_submission_17', 'customer_seo_strategy', 10, 2);
function customer_seo_strategy($entry, $form) {

    // FORM DATA
    $date_created = $entry['date_created'];
    $entry_id     = $entry['id'];

    // USER EMAIL
    $user_email = rgar($entry, '10');
    // GET USER
    $user = get_user_by('email', $user_email);
    // GET USER ID
    $user_id = $user->ID;
    // GET THE EXISTING TODO LIST
    $todo_list = get_user_meta($user_id, 'todo_list', true);
    // CHECK IF TODO LIST IS NOT EMPTY AND IF EMPTY SET IT TO ARRAY
    $todo_list = $todo_list ? $todo_list : array();


    // SET THE TODO LIST
    $todo_list[] = array(
        'date_created' => $date_created,
        'entry_id'     => $entry_id,
    );
    // UPDATE THE TODO LIST
    update_user_meta($user_id, 'todo_list', $todo_list);
    // BUILD THE SERVICES
    $services = buildServices($user_email, $entry_id);
    // UPDATE THE ENTRY TODO LIST META
    gform_update_meta($entry_id, 'todo_list', $services);
    
}
// seo manager notification content for the customer
// add_filter( 'gform_notification_18', '_gform_notification_content', 10, 3 );
// add_filter( 'gform_notification_17', '_gform_notification_content', 10, 3 );
function _gform_notification_content( $notification, $form, $entry ) {
    // append a signature to the existing notification
    // message with .=
    if ( $notification['name'] == 'Customer Notification' ) {

        // data
        $date_created    = $entry['date_created'];
        $entry_id        = $entry['id'];
        $website         = rgar($entry, 1);
        $page_1          = rgar($entry, 4);
        $page_2          = rgar($entry, 6);
        $page_3          = rgar($entry, 5);
        $page_1_keywords = rgar($entry, 8);
        $page_2_keywords = rgar($entry, 3);
        $page_3_keywords = rgar($entry, 9);
        $addons          = rgar($entry, "7.1");

        // get wordcount
        $data = new SEOI_SEO();
        $website_wc = $data->page_word_count($website);
        $competitor_1_wc = $data->page_word_count($page_1); // competitor 1
        
        // 
        $top_sites_by_keyword_1 = $data->get_top_sites_by_keywords($page_1_keywords);
        $top_sites_by_keyword_2 = $data->get_top_sites_by_keywords($page_2_keywords);
        $top_sites_by_keyword_3 = $data->get_top_sites_by_keywords($page_3_keywords);

        ob_start();
        ?>
            <div id="wrapper" dir="ltr"
                style="background-color: #f7f7f7; margin: 0; padding: 70px 0; width: 100%; -webkit-text-size-adjust: none;">
                <table border="0" width="100%" cellspacing="0" cellpadding="0">
                    <tbody>
                        <tr>
                            <td align="center" valign="top">
                                <div id="template_header_image">
                                    <p style="margin-top: 0;"><img
                                            style="border: none; display: inline-block; font-size: 14px; font-weight: bold; height: auto; outline: none; text-decoration: none; text-transform: capitalize; vertical-align: middle; max-width: 100%; margin-left: 0; margin-right: 0;"
                                            src="<?php echo get_site_url(); ?>/wp-content/uploads/2020/12/seoi-logo-small.png" alt="SEOi" />
                                    </p>
                                </div>
                                <table id="template_container"
                                    style="background-color: #ffffff; border: 1px solid #dedede; box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1); border-radius: 3px;"
                                    border="0" width="600" cellspacing="0" cellpadding="0">
                                    <tbody>
                                        <tr>
                                            <td align="center" valign="top">
                                                <table id="template_body" border="0" width="600" cellspacing="0" cellpadding="0">
                                                    <tbody>
                                                        <tr>
                                                            <td id="body_content" style="background-color: #ffffff;" valign="top">
                                                                <table border="0" width="100%" cellspacing="0" cellpadding="20">
                                                                    <tbody>
                                                                        <tr>
                                                                            <td style="padding: 48px 48px 32px;" valign="top">
                                                                                <div id="body_content_inner"
                                                                                    style="color: #636363; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; font-size: 14px; line-height: 150%; text-align: left;">
                                                                                    <h3>Here's your FREE Generated SEO Strategy!</h3>
                                                                                    <p style="margin-bottom:10px;">Curabitur tempus, felis id accumsan aliquet, tellus magna lobortis orci, id fermentum lorem odio nec urna. Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>
                                                                                    
                                                                                    <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">User Email:
                                                                                                        <strong>{User Email:10}</strong>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Website:
                                                                                                        <strong>{Website:1}</strong>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    <!-- <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Page URL 1:
                                                                                                        <strong>{Page URL 1:4}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div> -->
                                                                                    <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Keyword 1:
                                                                                                        <strong>{Keywords for Page URL 1:8}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    <!-- <div style="">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Page URL 2:
                                                                                                        <strong>{Page URL 2:6}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div> -->
                                                                                    <div style="">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Keyword 2:
                                                                                                        <strong>{Keywords for Page URL 2:3}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    <!-- <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Page URL 3:
                                                                                                        <strong>{Page URL 3:5}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div> -->
                                                                                    <div>
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 0 solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Keyword 3:
                                                                                                        <strong>{Keywords for Page URL 3:9}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    <div style="margin-bottom: 20px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">Add Ons:
                                                                                                        <strong>{Add Ons (Add On Page Optimization):7.1}</strong></th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>
                                                                                    
                                                                                    <!-- wordcount -->
                                                                                    <div style="margin-bottom: 10px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/01/on-page-seo-service-150x150.png" alt="" width="70px">
                                                                                                    </th>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <h4 style="margin-bottom: 5px;">Word Count</h4>
                                                                                                        <p style="font-size: 14px; line-height: 1.4em;">Your websites word count is <strong><?php echo $website_wc; ?></strong> words. Your 1st Competitor has <strong><?php echo $competitor_1_wc; ?></strong></p>
                                                                                                        <a href="<?php echo get_site_url(); ?>/content-writing-service/" style="display:inline-block; color: white; text-transform: uppercase; font-size: 12px; background-color: #fa7d09; text-decoration: none; padding: 10px 25px; font-weight: bold;">Learn More</a>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>

                                                                                    <!-- technical seo -->
                                                                                    <div style="margin-bottom: 10px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/01/on-page-seo-service-150x150.png" alt="" width="70px">
                                                                                                    </th>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <h4 style="margin-bottom: 5px;">Technical SEO</h4>
                                                                                                        <p style="font-size: 14px; line-height: 1.4em;">Nam maximus neque eu magna tincidunt rutrum. Donec at arcu purus. Etiam varius purus sed orci ultricies lobortis. Pellentesque feugiat enim in dignissim ultrices. Sed id accumsan sapien.</p>
                                                                                                        <a href="<?php echo get_site_url(); ?>/on-page-seo-service/" style="display:inline-block; color: white; text-transform: uppercase; font-size: 12px; background-color: #fa7d09; text-decoration: none; padding: 10px 25px; font-weight: bold;">Learn More</a>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>

                                                                                    <!-- local seo citation -->
                                                                                    <div style="margin-bottom: 10px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/01/local-seo-citation.png" alt="" width="70px">
                                                                                                    </th>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <h4 style="margin-bottom: 5px;">Local SEO Citation</h4>
                                                                                                        <p style="font-size: 14px; line-height: 1.4em;">Nam maximus neque eu magna tincidunt rutrum. Donec at arcu purus. Etiam varius purus sed orci ultricies lobortis. Pellentesque feugiat enim in dignissim ultrices. Sed id accumsan sapien.</p>
                                                                                                        <a href="<?php echo get_site_url(); ?>/local-seo-citations/" style="display:inline-block; color: white; text-transform: uppercase; font-size: 12px; background-color: #fa7d09; text-decoration: none; padding: 10px 25px; font-weight: bold;">Learn More</a>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>

                                                                                    <!-- blogger-outreach-service -->
                                                                                    <div style="margin-bottom: 10px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/01/blogger-outreach-service-150x150.png" alt="" width="70px">
                                                                                                    </th>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <h4 style="margin-bottom: 5px;">Natural Powerful Backlinks</h4>
                                                                                                        <p style="font-size: 14px; line-height: 1.4em;">Suspendisse laoreet justo quis neque dignissim, at venenatis mauris aliquam. Aliquam sollicitudin orci sed dapibus volutpat. Aenean consequat non arcu a feugiat.</p>
                                                                                                        <a href="<?php echo get_site_url(); ?>/blogger-outreach-service/" style="display:inline-block; color: white; text-transform: uppercase; font-size: 12px; background-color: #fa7d09; text-decoration: none; padding: 10px 25px; font-weight: bold;">Learn More</a>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>

                                                                                    <!-- blog management -->
                                                                                    <div style="margin-bottom: 10px;">
                                                                                        <table class="td"
                                                                                            style="color: #636363; border: 1px solid #e5e5e5; vertical-align: middle; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border-bottom: 2px solid #e5e5e5;"
                                                                                            border="1" cellspacing="0"
                                                                                            cellpadding="6">
                                                                                            <thead>
                                                                                                <tr>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/01/blog-management-service-150x150.png" alt="" width="70px">
                                                                                                    </th>
                                                                                                    <th class="td"
                                                                                                        style="color: #636363; font-weight: normal; border: 1px solid #e5e5e5; vertical-align: middle; padding: 12px; text-align: left; border-bottom: 0;"
                                                                                                        scope="col">
                                                                                                        <h4 style="margin-bottom: 5px;">Blog Management Service</h4>
                                                                                                        <p style="font-size: 14px; line-height: 1.4em;">Nulla facilisi. Aenean varius iaculis urna, ac imperdiet tellus lacinia non. Pellentesque vitae tristique libero. In interdum tempor nulla in ornare. Sed egestas interdum ipsum nec ullamcorper.</p>
                                                                                                        <a href="<?php echo get_site_url(); ?>/blog-management/" style="display:inline-block; color: white; text-transform: uppercase; font-size: 12px; background-color: #fa7d09; text-decoration: none; padding: 10px 25px; font-weight: bold;">Learn More</a>
                                                                                                    </th>
                                                                                                </tr>
                                                                                            </thead>
                                                                                        </table>
                                                                                    </div>

                                                                                    <!--  -->
                                                                                    <!-- <p style="color: #757575; margin: 30px 0 20px;">We look forward to seeing you soon.</p> -->
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        <?php
        $notification['message'] = ob_get_clean();
    }
 
    return $notification;
}

// add_action('gfpd_post_save_pdf_18', 'save_free_seo_strategy_pdf_to_server', 10, 5);
// add_action('gfpd_post_save_pdf_17', 'save_free_seo_strategy_pdf_to_server', 10, 5);
// function save_free_seo_strategy_pdf_to_server($pdf_path, $filename, $settings, $entry, $form){

add_action('gfpdf_post_save_pdf', '_seoStrategyFormUploadFile', 10, 5);
function _seoStrategyFormUploadFile($pdf_path, $filename, $settings, $entry, $form) {

    /* Don't copy the PDF when the PDF Previewer is being used */
    if ( defined( 'DOING_PDF_PREVIEWER' ) && DOING_PDF_PREVIEWER ) {
        return;
    }

    /*  */
    if($form['id'] == '17' || $form['id'] == '18'){

        // form data
        $manager_id = rgar($entry, '11');
        $customer_email = rgar($entry, '12');
    
        // date
        $date = rgar( $entry, 'date_created' );
        $date = date('F_Y', strtotime($date));
    
        // initialize class
        $seoi = new NEW_SEOI_GOOGLE();
    
        // create the google drive folder structure
        $google_directory = $customer_email . "/Reports/" . $date . "/" . $filename;
    
        // upload the file to google drive
        $gdrive_upload = $seoi->googleDriveUploadFile($google_directory, $pdf_path);
    }

}
// add_action('gfpd_post_save_pdf_17', '_seoStrategyFormUploadFile2', 10, 5);
function _seoStrategyFormUploadFile2($pdf_path, $filename, $settings, $entry, $form) {

    /* Don't copy the PDF when the PDF Previewer is being used */
    if ( defined( 'DOING_PDF_PREVIEWER' ) && DOING_PDF_PREVIEWER ) {
        return;
    }

    // form data
    $manager_id = rgar($entry, '11');
    $customer_email = rgar($entry, '12');

    // date
    $date = rgar( $entry, 'date_created' );
    $date = date('F_Y', strtotime($date));

	// initialize class
	$seoi = new NEW_SEOI_GOOGLE();

	// create the google drive folder structure
	$google_directory = $customer_email . "/Reports/" . $date . "/" . $filename;

	// upload the file to google drive
	$gdrive_upload = $seoi->googleDriveUploadFile($google_directory, $pdf_path);
}

/*
 * SEND REPORT - GFORM 1 
 * - UPDATE THE TODO LIST IF THE REPORT IS SENT
 * 
 */
add_action('gform_after_submission_1', '_sendCustomerReport', 10, 2);
function _sendCustomerReport($entry, $form) {
    
    // GET ENTRY 16 - THE TODO LIST ENTRY ID
    $todo_list_entry_id = rgar($entry, '16');
    // CHECK IF IS A COPY
    $is_copy = rgar($entry, '17');
    // 
    if($is_copy == 'true'){
        // GET TODO LIST ENTRY
        $todo_list_entry = GFAPI::get_entry($todo_list_entry_id);
        // GET TODO DATA
        $todo_data = rgar($todo_list_entry, '19');
        // DECODE TODO DATA
        $todo_data = json_decode($todo_data, true);
        // CHECK IF EMPTY AND INITIALIZE ARRAY
        if(empty($todo_data)) {
            $todo_data[] = array(
                'date' => date("Y-m-d H:i:s"),
                'data' => '',
                'status' => 'Completed',
                'closed_date' => '',
                'due_date' => '',
                'is_copy' => false
            );
        }
        // ADD REPORT SENT DATE
        $todo_data[0]['report_sent_date'] = date("Y-m-d H:i:s");
        // ADD REPORT SENT IF TRUE
        $todo_data[0]['report_sent'] = true;
        // ENCODE TODO DATA
        $todo_data = json_encode($todo_data);
        // UPDATE ENTRY
        GFAPI::update_entry_field( $todo_list_entry_id, 19, $todo_data );
    } else {
        // PARENT
        // UPDATE ENTRY META REPORT SENT
        gform_update_meta( $todo_list_entry_id, 'report_sent', true);
        gform_update_meta( $todo_list_entry_id, 'report_sent_data', [
            'entry_id' => $todo_list_entry_id,
            'date' => date("Y-m-d H:i:s"),
            'report_sent' => true
        ] );
    }
}


/*
 * GO HIGH LEVEL
 * - ADD CONTACT TO GO HIGH LEVEL
 * - CONNECTED TO GF FORM 4 AFTER SIGN UP
 * 
 */
function buildGoHighLevelContactGform($entry, $form){

    // WHAT ARE YOU? - business owner, marketer, reseller, other
    $customer_type = rgar($entry, '18');
    $customer_tag = "User - " . ucwords($customer_type);
    // CHECK IF WHAT ARE YOU IS OTHER
    if($customer_type == 'other'){
        // GET THE OTHER FIELD
        $customer_type = rgar($entry, '17');
        // SET THE TAG
        $customer_tag = "User - " . ucwords($customer_type);
    }

    // 
    $field_ids = array();
    // REQUIRED FIELDS
    $required_types = array("name", "email", "phone");
    // CHECK IF THE FORM HAS THE REQUIRED FIELDS
    foreach ($required_types as $type) {
        // 
        $field_exists = false;
        // LOOP THROUGH THE FORM FIELDS
        foreach ($form['fields'] as $field) {
            // CHECK IF THE FIELD TYPE IS EQUAL TO THE REQUIRED TYPE
            if ($field["type"] == $type) {
                // SET FIELD EXISTS TO TRUE
                $field_exists = true;
                // SET FIELD ID
                $field_ids[$type] = $field["id"];
                break;
            }
        }
        // IF FIELD DOES NOT EXIST BREAK THE LOOP
        if (!$field_exists) {
            break;
        }
    }

    // CHECK IF THE FORM HAS THE REQUIRED FIELDS
	if (count($field_ids) >= count($required_types)) {
        // NAME FIELDS
        $name_field_id = $field_ids['name'];
        if (class_exists('GFAPI')) {
            $name_subfields = GFAPI::get_field($form, $name_field_id)->inputs;
        }
        // CHECK IF THE NAME FIELD HAS SUBFIELDS
        if (count($name_subfields) >= 2) {
            $prefix_name = rgar($entry, $name_field_id . '.' . '2');
            $first_name  = rgar($entry, $name_field_id . '.' . '3');
            $middle_name = rgar($entry, $name_field_id . '.' . '4');
            $last_name   = rgar($entry, $name_field_id . '.' . '6');
            $prefix_name = rgar($entry, $name_field_id . '.' . '8');
            $name_value  = trim($prefix_name . ' ' . $first_name . ' ' . $middle_name . ' ' . $last_name . ' ' . $prefix_name);
        } else {
            $name_value = rgar($entry, $name_field_id);
        }

        // GET OTHER FIELDS
        $email = rgar($entry, $field_ids['email']);
        $phone = rgar($entry, $field_ids['phone']);
        
        // BUILD THE CONTACT DATA
        $contact_data = array(
            'name'  => $name_value,
            'email' => $email,
            'phone' => $phone,
            'tags'  => $customer_tag,
        );

        // GO HIGH LEVEL
        addGoHighLevelContact($contact_data);
    }
}