<?php

/*
 *  CART VIEW
 *
 */
// add_action( "woocommerce_cart_is_empty", "_cart_view" );
// add_action( "woocommerce_before_cart", "_cart_view" );
function _cart_view(){

    // for the old code
    if(!isset($_GET['pid'])){
?>
    <h1 class="cart-order-heading">Cart</h1>
    <form id="cart-order-form" action="<?php echo wc_get_checkout_url(); ?>" method="POST" enctype="multipart/form-data"></form>
<?php
    }
}


/*
 *  CART VIEW AJAX
 *  -- after the page loads
 *
 */
add_action("wp_ajax__cart_view_ajax", "_cart_view_ajax");
add_action("wp_ajax_nopriv__cart_view_ajax", "_cart_view_ajax");
function _cart_view_ajax(){

    // woo
    global $woocommerce;

    // get data
    $cart_items = $_REQUEST["cart_items"];
    $cart_items = isset($_REQUEST["cart_items"]) ? json_decode(html_entity_decode(stripslashes ($cart_items))) : "";

    // start content
    ob_start();

    // if cart items exists
    if(count((array)$cart_items)){
?>
        <?php
            foreach($cart_items as $key => $item){

                // vars
                $budget_count = intval($item->budget_count);
                $page_count   = intval($item->page_count);
                $word_count   = intval($item->word_count);
                $page_title   = get_the_title($key);
        ?>
                <div class="cart-item" data-page-id="<?php echo $key; ?>">
                    <a href="" class="remove-cart-item" title="remove-item">&times;</a>

                    <h3><?php echo $page_title; ?></h3>

                    <!-- hidden fields -->
                    <input type="hidden" name="cart_info[<?php echo $key; ?>][page_id]" value="<?php echo $key; ?>">

                    <!-- website -->
                    <fieldset class="half left">
                        <label for="">Main Website URL</label>
                        <input type="text" name="cart_info[<?php echo $key; ?>][Website URL]" value="" required>
                    </fieldset>

                    <?php
                        // 2055 == Local SEO Services
                        // 2066 == National SEO Services
                        // 2076 == National SEO Services
                        // 2081 == eCommerce SEO Services
                        if($key == 2055 || $key == 2066 || $key == 2076 || $key == 2081){ 
                    ?>
                        <fieldset class="half">
                            <label for="">Choose Budget</label>
                            <input type="number" max="99999" step="100" name="cart_info[<?php echo $key; ?>][Budget]" value="<?php echo $budget_count; ?>" required>
                        </fieldset>
                        <fieldset class="half left">
                            <label for="">Competitor URL</label>
                            <input type="text" name="cart_info[<?php echo $key; ?>][Competitor URL]" value="" required>
                        </fieldset>
                        <fieldset class="half">
                            <label for="">Suggested Keywords</label>
                            <input type="text" name="cart_info[<?php echo $key; ?>][Keywords]" value="" required>
                        </fieldset>
                        <fieldset>
                            <label for="">Subscription Length</label>
                            <div class="radio-checkbox-item">
                                <input type="radio" name="cart_info[<?php echo $key; ?>][Subscription Length]" id="<?php echo $key; ?>-subscription-length-3-months" value="3 Months" required>
                                <label for="<?php echo $key; ?>-subscription-length-3-months">3 Month Subscription</label>
                                <div class="desc">This allows us to research your business, competition and keywords and set up your strategy and plan. It will also allow you to start seeing results.</div>
                            </div>
                            <div class="radio-checkbox-item">
                                <input type="radio" name="cart_info[<?php echo $key; ?>][Subscription Length]" id="<?php echo $key; ?>-subscription-length-6-months" value="6 Months" required>
                                <label for="<?php echo $key; ?>-subscription-length-6-months">6 Month Subscription</label>
                                <div class="desc">This allows us to build a six-month plan giving you extra initial research and planning at no extra cost.</div>
                            </div>
                            <div class="radio-checkbox-item">
                                <input type="radio" name="cart_info[<?php echo $key; ?>][Subscription Length]" id="<?php echo $key; ?>-subscription-length-12-months" value="12 Months" required>
                                <label for="<?php echo $key; ?>-subscription-length-12-months">12 Month Subscription</label>
                                <div class="desc">This allows us to build a twelve-month plan giving you extra initial research and planning at no extra cost.</div>
                            </div>
                        </fieldset>
                    <?php } else { ?>
                        <fieldset class="half">
                            <label for="">How many pages?</label>
                            <input type="number" class="cart-item-page-count" min="1" max="99" name="cart_info[<?php echo $key; ?>][Page Count]" value="<?php echo $page_count; ?>" required>
                        </fieldset>
    
                        <!--  -->
                        <?php for($i=1; $i<=$page_count; $i++){ ?>
                            <div class="cart-item-info" data-page-count="<?php echo $i; ?>">
                                <fieldset class="half left">
                                    <label for="">How many words?</label>
                                    <input type="number" min="350" max="9999" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Word Count]" value="<?php echo $i == 1 ? ($word_count ? $word_count : 350) : 350; ?>" required>
                                </fieldset>
                                <fieldset class="half">
                                    <label for="">What subject would you like the page to cover?</label>
                                    <input type="text" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Subject]" value="" required>
                                </fieldset>
                                <fieldset class="half left">
                                    <label for="">If it already exists, what is the URL of the page?</label>
                                    <input type="text" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][URL]" value="">
                                </fieldset>
                                <fieldset class="half">
                                    <label for="">What is the call to action of this page?</label>
                                    <select name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Call to Action]" required>
                                        <option value="" selected disabled>Select an option</option>
                                        <option>Call</option>
                                        <option>Register</option>
                                        <option>Enquire</option>
                                    </select>
                                </fieldset>
                                <fieldset class="">
                                    <label for="">Suggested keywords</label>
                                    <input type="text" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Keywords]" value="">
                                </fieldset>
                                <fieldset class="">
                                    <label for="">What is the USP(Unique Selling Point) of the product/services on this page?</label>
                                    <input type="text" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Unique Selling Point]" value="">
                                </fieldset>
                                <fieldset class="">
                                    <label for="">Any attachment the writer may find useful? (PDF or Images only)</label>
                                    <input type="file" name="cart_info[<?php echo $key; ?>][Pages][Page <?php echo $i; ?>][Attachment/s]" value="" accept="image/*, .pdf">
                                </fieldset>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
        <?php } ?>

        <fieldset><button type="submit">Submit</button></fieldset>
<?php 
    } else { // !cart_items

        // empty the cart
        $woocommerce->cart->empty_cart();

        // 
        echo "<a href='".get_site_url()."'>Back to Home</a>";
    }


    $response["content"] = ob_get_clean();
    // !== end content

    // return json
    echo json_encode($response);

    // kill ajax
    die();
}