<?php
defined( 'ABSPATH' ) || exit;

/*
 *
 * SEO Manager - Customer Orders Dashboard
 * - Order information
 *
 *
 */
add_action( 'woocommerce_account_assigned-orders_endpoint', '_assignedOrdersEnpointContent' );
function _assignedOrdersEnpointContent() {
	// get user data
    $user           = wp_get_current_user();
    $userRole       = $user->roles[0];
    // $assignedOrders = get_the_author_meta( "_assigned_orders", $user->ID );

    if ( $userRole == "account_manager" ) {
        // list customer orders
        if ( isset( $_GET['user'] ) && !isset( $_GET['type'] ) ) {

            // check if the user id is correct and if it is assigned to this account manager
            $customerData = get_users( array(
               'meta_key'    => "_assigned_account_manager",
               'meta_value'  => $user->user_email,
               'number'      => -1,
               'count_total' => false,
               'include'     => array( $_GET['user'] )
            ) );

            // if the customer data is assigned to this account manager and is valid
            if ( $customerData ) {

                // get customer orders
                $customerOrders = wc_get_orders( array(
                    'customer_id' => $_GET['user'],
                    'orderby'    => 'date',
                    'order'      => 'DESC',
                ) );

                if ( $customerOrders ) {
                ?>
                    <div class="table-wrap">
                        <table class="dashboard-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Item Status</th>
                                    <!-- <th>Item ID</th> -->
                                    <th>Order Date</th>
                                    <th>Order ID</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    foreach ( $customerOrders as $key => $order ) {
                                        $orderId    = $order->get_id();
                                        $orderItems = $order->get_items();
                                        $orderDate  = $order->get_date_created();
                                        $orderDate  = date( 'd-m-Y', strtotime( $orderDate ) );

                                        foreach ( $orderItems as $key => $item ) {
                                            $productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
                                            // $productName = get_the_title( $productId );
                                            $productName = $item->get_name();
                                            $itemId      = $productId . "_" . $orderId; // this is a combination of the product id + order id
                                            $itemOrderStatus = get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) ? get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) : 'Processing';
                                        ?>
                                                <tr>
                                                    <td><?php echo $productName; ?></td>
                                                    <td><?php echo $itemOrderStatus; ?></td>
                                                    <!-- <td><?php //echo $itemId; ?></td> -->
                                                    <td><?php echo $orderDate; ?></td>
                                                    <td><?php echo $orderId; ?></td>
                                                    <td><a href="?type=orderItem&itemId=<?php echo $itemId; ?>&orderId=<?php echo $orderId; ?>&pId=<?php echo $productId; ?>&user=<?php echo $_GET['user']; ?>">Manage</a></td>
                                                </tr>
                                        <?php
                                        } // end orderItems foreach
                                    } // end customerOrders foreach
                                ?>
                            </tbody>
                        </table>
                    </div>
                <?php
                } // end if customerOrders
            } else {
                echo "<p>Error! This user is either invalid or is not assigned to your account.</p>";
            }
        } elseif ( isset( $_GET['type'] ) ) { // else if isset
            // order item datas
            if ( isset( $_GET['pId'] ) && isset( $_GET['orderId'] ) ) {

                // check if the order_id is legitimate
                $validateOrder = get_post_type( $_GET['orderId'] );

                if ( $validateOrder ) {
                    
                    // get the order
                    $order = new WC_Order( $_GET['orderId'] );

                    // get order date
                    $orderDate = $order->get_date_created();
                    $orderDate = date( 'd-m-Y', strtotime( $orderDate ) );

                    // validate if the itemId exists within the order
                    $validateOrderItems = [];

                    // get all order items
                    $order_items = $order->get_items();

                    // customer data
                    $customerData      = $order->get_user();
                    $customerFirstName = $order->get_billing_first_name();
                    $customerLastName  = $order->get_billing_last_name();
                    $customerEmail     = $customerData->user_email;
                    $customerPhone     = $order->get_billing_phone();

                    // loop order items
                    foreach ( $order_items as $key => $item ) {
                        $productId = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();

                        // check if the itemId exists within the order
                        if ( $_GET['pId'] == $productId ) {

                            // validate that the product exists
                            $validateOrderItems[] = true;

                            // get order item status -- custom status
                            $itemStatus = get_post_meta( $_GET['orderId'], '_order_item_status_'.$_GET['orderId'].'_'.$_GET['pId'], true ) ? get_post_meta( $_GET['orderId'], '_order_item_status_'.$_GET['orderId'].'_'.$_GET['pId'], true ) : 'Processing';
                            $itemStatusMetaKey = "_order_item_status_" . $_GET['orderId'] . '_' . $_GET['pId'];

                            // get order item meta data
                            $formattedMetaData = $item->get_formatted_meta_data( '_', true );

                            // declare the process
                            $declaredProcess = array( "Processing", "Draft", "Title Creation", "Content Ready", "Order Ready", "Completed" );

                            // get website from order
                            // note: this is also saved on the user meta
                            $website = $item->get_meta( 'Website URL', true );
                        ?>
                            <div class="account-order-data-wrap">
                                <div class="order-item-details-wrap">
                                    <!-- order item details here -->
                                    <div class="order-item-details">
                                        <h3>Order Item Details</h3>
                                        <ul>
                                            <li>Order Item Name: <?php echo $item->get_name(); ?></li>
                                            <li>Order Date: <?php echo $orderDate; ?></li>
                                            <li>Website: <?php echo $website; ?></li>
                                            <li>Status: 
                                                <div class="dashboard-order-item-status">
                                                    <select name="" id="order-item-status-select">
                                                        <?php foreach ( $declaredProcess as $key => $dp ){ ?>
                                                            <option value="<?php echo $dp; ?>" <?php echo $itemStatus == $dp ? "selected" : ""; ?>><?php echo $dp; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                    <a href="" class="save-order-item-status" data-item-status-meta-key="<?php echo $itemStatusMetaKey; ?>" data-order-id="<?php echo $_GET['orderId']; ?>">Update Status</a>
                                                </div>
                                            </li>
                                            <li>Item ID: <?php echo $_GET['itemId']; ?></li>
                                            <li>Order ID: <?php echo $_GET['orderId']; ?></li>
                                        </ul>
                                    </div>

                                    <div class="order-item-details">
                                        <h3>Customer Details</h3>
                                        <ul>
                                            <li>Name: <?php echo $customerFirstName; ?> <?php echo $customerLastName; ?></li>
                                            <li>Email: <?php echo $customerEmail; ?></li>
                                            <li>Phone: <?php echo $customerPhone; ?></li>
                                        </ul>
                                    </div>

                                    <?php if ( $formattedMetaData ) { ?>
                                        <div class="order-item-details">
                                            <h3>Additional Information</h3>
                                            <ul>
                                                <?php foreach( $formattedMetaData as $key => $mData ) { ?>
                                                    <li><?php echo $mData->key; ?>: <?php echo $mData->value; ?></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php
                                    // meta data
                                  /*  if ( $formattedMetaData ) {
                                        echo "<h3>Additional Information</h3>";
                                        foreach ( $formattedMetaData as $key => $mData ) {
                                            echo "<p>".$mData->key.": ".$mData->value."</p>";
                                        }
                                    } // end formatted meta data*/

                                    // gform data
                                    // $form_id = '1'; // Title: Order Item Data Form
                                    // $formEntries = GFAPI::get_entries( $form_id );
                                    $orderItemGformEntries = get_the_author_meta( "_order_item_gform_entries", $_GET['user'] );
                                    $orderItemGformEntries = $orderItemGformEntries ? $orderItemGformEntries : array();
                                ?>
                                <div class="processes-wrap account-manager-gform">
                                    <ul class="process-tabs" style="font-size: 16px;">
                                        <li class="active" data-tab="information">Information</li>
                                        <li data-tab="reports">Reports</li>
                                    </ul>
                                    <div class="process-tab-content active" data-tab="information">
                                        <?php if ( array_key_exists( $_GET['itemId'], $orderItemGformEntries ) ){ ?>
                                            <?php
                                                $count = 1;
                                                // 
                                                $downloadableData = array();

                                                foreach ( $orderItemGformEntries[$_GET['itemId']]['process'] as $key => $process ) {
                                            ?>
                                                <div class="process-item-wrap <?php echo $process['approved'] ? "approved" : ""; ?>">
                                                    <div class="number"><?php echo $count; ?></div>
                                                    <div class="process-title">
                                                        <h4><?php echo $key; ?></h4>
                                                        <div class="process-status">Status: <?php echo $process['approved'] ? "Approved" : "Pending Approval"; ?></div>
                                                    </div>

                                                    <div class="table-wrap">
                                                        <table class="dashboard-table process-table">
                                                            <thead>
                                                                <tr>
                                                                    <!-- <th>Entry Number</th> -->
                                                                    <th>Message Log</th>
                                                                    <!-- <th>File Download</th> -->
                                                                    <!-- <th></th> -->
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                    // reverse array so new items will always be on top
                                                                    $processEntries = array_reverse( $process['entries'] );

                                                                    // date day_month_year
                                                                    // check if date today is already in array
                                                                    // $currentMonth = date("F_Y");
                                                                    // if ( !array_key_exists( $currentMonth, $downloadableData )  ) {
                                                                        // $downloadableData[$currentMonth] = [];
                                                                        // $downloadableData[] = [];
                                                                    // }

                                                                    foreach ( $processEntries as $key => $entry_id ) {
                                                                        // get gform entry object
                                                                        $entry = GFAPI::get_entry( $entry_id );

                                                                        // get gform entry data
                                                                        $comments = rgar( $entry, '2' );
                                                                        $file     = rgar( $entry, '3' );
                                                                        $fromUser = rgar( $entry, '9' );
                                                                        $files    = rgar( $entry, '10' );
                                                                        $fromUser = get_user_by( "email", $fromUser );

                                                                        $month = date("F",strtotime($entry["date_created"]));

                                                                        // insert downloadable file into data
                                                                        if ( $file ) {
                                                                            $downloadableData[$month][$entry_id]["date_created"] = $entry["date_created"];
                                                                            $downloadableData[$month][$entry_id]["file"] = $file;
                                                                        }
                                                                        if ( $files ) {
                                                                            $downloadableData[$month][$entry_id]["date_created"] = $entry["date_created"];
                                                                            $downloadableData[$month][$entry_id]["files"] = json_decode($files);
                                                                        }
                                                                ?>
                                                                        <tr>
                                                                            <td>
                                                                                <div class="user-info">
                                                                                    <div class="name"><?php echo $fromUser->display_name; ?></div>
                                                                                    <div class="date"><?php echo date( "F j, Y, g:i a", strtotime( $entry['date_created'] ) ); ?></div>
                                                                                </div>
                                                                                <div class="message">
                                                                                    <?php echo apply_filters( "the_content", $comments ); ?>
                                                                                    <div class="process-actions">
                                                                                        <?php if ( $file ){ ?>
                                                                                            <a href="<?php echo $file; ?>" title="Download File/s" download class="file-download"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>
                                                                                        <?php } ?>
                                                                                        <?php if ( $files ){ ?>
                                                                                            <!-- <pre><?php //var_dump($files); ?></pre> -->
                                                                                            <a href="" title="Download File/s" class="file-download multiple-file-download" data-files=<?php echo $files; ?>><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>
                                                                                        <?php } ?>
                                                                                    </div>
                                                                                </div>
                                                                                <?php if ($process['entry_edits'] ){
                                                                                    echo "<table>";
                                                                                    foreach ( $process['entry_edits'] as $key => $requests ) {
                                                                                        if ( $key == $entry_id ) {
                                                                                            foreach ( $requests as $key => $request ) {
                                                                                                $erEntry     = GFAPI::get_entry( $request );
                                                                                                $erComments  = rgar( $erEntry, '1' );
                                                                                                $erFiles     = rgar( $erEntry, '2' );
                                                                                                $erFiles     = $erFiles ? json_decode( $erFiles ) : "";
                                                                                                $newFromUser = rgar( $erEntry, '9' );
                                                                                                $newFromUser = get_user_by( "email", $newFromUser );
                                                                                            ?>
                                                                                                <tr>
                                                                                                    <td>
                                                                                                        <div class="user-info">
                                                                                                            <div class="name"><?php echo $newFromUser->display_name; ?></div>
                                                                                                            <div class="date"><?php echo date( "F j, Y, g:i a", strtotime( $erEntry['date_created'] ) ); ?></div>
                                                                                                        </div>
                                                                                                        <div class="message">
                                                                                                            <?php echo apply_filters( "the_content", $erComments ); ?>
                                                                                                            <div class="process-actions">
                                                                                                                <?php
                                                                                                                    if ( $erFiles ){
                                                                                                                        echo '<a href="" class="downloadMultipleFiles" title="Download File/s"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>';
                                                                                                                        echo '<div class="d-none multipleFilesDownload">';
                                                                                                                        foreach ( $erFiles as $key => $file ) {
                                                                                                                            echo "<a href='".$file."' download></a>";
                                                                                                                        }
                                                                                                                        echo '</div';
                                                                                                                    }
                                                                                                                ?>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </td>
                                                                                                </tr>
                                                                                            <?php
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    echo "</table>";
                                                                                } ?>
                                                                            </td>
                                                                        </tr>
                                                                <?php } ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            <?php $count++; } ?> 
                                        <?php } ?>
                                        <div class="gform-wrap">
                                            <?php echo do_shortcode( "[gravityform id=1 title=false description=false ajax=true]" ); ?>
                                        </div>
                                    </div>
                                    <div class="process-tab-content reports" data-tab="reports">
                                        <!-- Downloadable Data -->
                                        <?php if ($downloadableData): ?>
                                            <div class="process-title">
                                                <h4>Reports</h4>
                                            </div>
                                            <div class="table-wrap">
                                                <table class="dashboard-table user-downloadables">
                                                    <thead>
                                                        <tr>
                                                            <th>Month</th>
                                                            <th>Date Uploaded</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($downloadableData as $mainkey => $dd) { $monthCtr = 1; ?>
                                                            <?php foreach ($dd as $key => $ddData): ?>
                                                                <tr>
                                                                    <td><?php
                                                                        // $month = substr($mainkey, 0, strpos($mainkey, "_"));

                                                                        // var_dump($mainkey);
                                                                        echo $monthCtr == 1 ? $mainkey : "";
                                                                    ?></td>
                                                                    <?php foreach ($ddData as $key => $ddD): ?>
                                                                        <td><?php 
                                                                            if ( $key == "date_created" ) {
                                                                                $newdate = date( "F j, Y", strtotime($ddD) );
                                                                                echo $newdate;
                                                                            } elseif( $key == "files" ) {
                                                                                foreach ($ddD as $key => $f) {
                                                                                    $filename = basename(parse_url($f, PHP_URL_PATH));
                                                                                    echo $key > 0 ? ", " : "";
                                                                                    // echo "<a href='".$f."' download>".$filename."</a>";
                                                                                    $fileId    = "modal-" . $key;
                                                                                    echo "<a href='' data-pdf-url='".$f."' class='pdf-modal'>".$filename."</a>";
                                                                                }
                                                                            } else {
                                                                                $filename = basename(parse_url($ddD, PHP_URL_PATH));
                                                                                echo "<a href='".$ddD."' download>".$filename."</a>";
                                                                            }
                                                                        ?></td>
                                                                    <?php endforeach ?>
                                                                </tr>
                                                            <?php $monthCtr++; endforeach; ?>
                                                        <?php } ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php else: ?>
                                            <p style="font-size: 14px;">No reports found.</p>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                    <?php
                        } // end if
                    } // end foreach loop order items

                    // if $validateOrderItems is empty that means there is valid order item
                    if ( empty( $validateOrderItems ) ) {
                        echo "<p>Error! Invalid Order.</p>";
                    }
                } else {
                    echo "<p>Error! Invalid Order Item.</p>";
                }
            }
        } else { // else isset

            // get assigned customers
            $assignedCustomers = get_the_author_meta( "_assigned_customers", $user->ID );

            // get total orders count
            $orderCountTotal = [];
            foreach ( $assignedCustomers as $acCount ) {
                $customer = get_user_by( "id", $acCount );
                $customerOrders = wc_get_orders( array(
                    'customer_id' => $customer->ID,
                    'orderby'    => 'date',
                    'order'      => 'DESC',
                ) );
                $orderCountTotal[] = count( $customerOrders );
            }
?>
            <div class="account-order-data-wrap">
                <div class="order-item-details-wrap">
                    <div class="order-item-details">
                        <h3>Assigned Account Details</h3>
                        <ul>
                            <li>Customer Accounts: <?php echo count( $assignedCustomers ); ?></li>
                            <li>Total Orders: <?php echo array_sum( $orderCountTotal ); ?></li>
                        </ul>
                    </div>
                </div>

                <div class="processes-wrap">
                    <div class="process-item-wrap no-process">
                        <div class="table-wrap">
                            <table class="dashboard-table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Orders</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        // reverse array so new customers will always be on top
                                        $assignedCustomers = array_reverse( $assignedCustomers );

                                        foreach ( $assignedCustomers as $ac ) {
                                            $customer = get_user_by( "id", $ac );

                                            // get customer orders
                                            $customerOrders = wc_get_orders( array(
                                                'customer_id' => $customer->ID,
                                                'orderby'    => 'date',
                                                'order'      => 'DESC',
                                            ) );
                                    ?>
                                                <tr>
                                                    <td><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
                                                    <td><?php echo $customer->user_email; ?></td>
                                                    <td><?php echo count( $customerOrders ); ?></td>
                                                    <td><a href="?user=<?php echo $customer->ID; ?>" class="link-full">Manage Orders</a></td>
                                                </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
<?php
        } // end if isset 
    } else { // else user
    	echo "<p>You don't have permission to access this content.</p>";
    } // end if user
}


// pre populate client email
add_filter('gform_field_value_client_email', '_gformClientEmail');
function _gformClientEmail( $value ){
    if ( isset( $_GET['orderId'] ) ) {
        $order         = new WC_Order( $_GET['orderId'] );
        $customerData  = $order->get_user();
        $customerEmail = $customerData->user_email;

        return $customerEmail;
    }
}

// update order item custom meta with gform data
// add_action( 'gform_after_submission_1', '_gformUpdateOrderItemData', 10, 2 );
function _gformUpdateOrderItemData( $entry, $form ) {

    // get the order item entries if exists
    $orderItemGformEntries = get_the_author_meta( "_order_item_gform_entries", $_GET['user'] );

    // if there is no data declare the variable
    if ( !is_array( $orderItemGformEntries ) ) {
        $orderItemGformEntries = array();
    }

    // process
    $process = rgar( $entry, 8 );

    // check if the value is already in the array
    if ( !array_key_exists( $_GET['itemId'], $orderItemGformEntries ) ) {
        $orderItemGformEntries[$_GET['itemId']] = array(
            'process'    => array(
                $process => array(
                    'entries'       => array( $entry['id'] ),
                    'date_approved' => "",
                    'approved'      => false
                ),
            )
        );
    } else {
        // update entry ids if array key exists
        $orderItemGformEntries[$_GET['itemId']]['process'][$process]['entries'][] = $entry['id'];
        $orderItemGformEntries[$_GET['itemId']]['process'][$process]['date_approved'] = "";
        $orderItemGformEntries[$_GET['itemId']]['process'][$process]['approved'] = false;
    }

    /*echo "<pre>";
    var_dump($orderItemGformEntries);
    echo "</pre>";*/

    // update the user meta
    update_user_meta( $_GET['user'], "_order_item_gform_entries", $orderItemGformEntries );
}

// PRE POPULATE PROCESS SELECT FIELD GFORM
/* add_filter( 'gform_pre_render_1', 'populate_posts' );
add_filter( 'gform_pre_validation_1', 'populate_posts' );
add_filter( 'gform_pre_submission_filter_1', 'populate_posts' );
add_filter( 'gform_admin_pre_render_1', 'populate_posts' ); */
function populate_posts( $form ) {
    foreach ( $form['fields'] as $field ) {
 
        if ( $field->type != 'select' || strpos( $field->cssClass, 'process-dropdown' ) === false ) {
            continue;
        }
        
        // declare the process
        // $process = array( "Processing", "Draft", "Title Creation", "Title Ready", "Article Creation", "Article Ready", "Completed" );
        $process = array( "Processing", "Draft", "Title Creation", "Content Ready", "Order Ready", "Completed" );
    
        $choices = array();
 
        foreach ( $process as $p ) {
            $choices[] = array( 'text' => $p, 'value' => $p );
        }
 
        // update 'Select a Post' to whatever you'd like the instructive option to be
        $field->placeholder = 'Select a Process';
        $field->choices     = $choices;
    }
 
    return $form;
}

// account manager - update order item status
add_action( 'wp_ajax__accountManagerUpdateOrderItemStatus', '_accountManagerUpdateOrderItemStatus' ); 
add_action( 'wp_ajax_nopriv__accountManagerUpdateOrderItemStatus', '_accountManagerUpdateOrderItemStatus' ); 
function _accountManagerUpdateOrderItemStatus(){
    $orderId = $_REQUEST['orderId'];
    $orderItemStatus = $_REQUEST['orderItemStatus'];
    $orderItemStatusMetaKey = $_REQUEST['orderItemStatusMetaKey'];

    // update the meta field
    update_post_meta( $orderId, $orderItemStatusMetaKey, $orderItemStatus );

    die();
}