<?php
defined( 'ABSPATH' ) || exit;

/*
 *
 * SEO manager page general hooks and functions
 * 
 * - My account menu (sequence)
 * - Custom menu links and pages (report history, seo learning)
 * - Some webceo code
 *
 *
 */

add_action( "woocommerce_account_dashboard", "_seoManagerDashbaord", 10 );
function _seoManagerDashbaord(){
    $user     = wp_get_current_user();
    $userRole = $user->roles[0];

    // seo learning posts marked done
    $doneLearningPosts = [];

    // get posts that has been marked done
    $seoLearningQuery = new WP_Query( array(
        "post_type"      => "learning_hub",
        "posts_per_page" => -1,
        "post_status"    => "publish"
    ) );

    // 
    if ( $userRole != "account_manager" ) {
    ?>
        <h3 style="display: none;">Seo Learning you need to read</h3>
    <?php

        if ( $seoLearningQuery->have_posts() ) {
            while ( $seoLearningQuery->have_posts() ) { $seoLearningQuery->the_post();
                $slug       = basename( get_permalink( get_the_ID() ) );
                $uniqueName = $slug . "_" . $user->ID;
                $value      = get_the_author_meta( $uniqueName, $user->ID );
                if ( $value == "done" ) {
                    $doneLearningPosts[] = get_the_ID();
                }
            } wp_reset_postdata();
        }

        // get posts that has not been marked done
        // I did it like this so we can control how many
        $seoLearning = new WP_Query( array(
            "post_status"    => "publish",
            "post_type"      => "learning_hub",
            "posts_per_page" => 3,
            "orderby"        => "rand",
            "post__not_in"   => $doneLearningPosts
        ) );
        if ( $seoLearning->have_posts() ) {
            echo "<ul class='dashboard-seo-learnings' style='display: none;'>";
            while ( $seoLearning->have_posts() ) { $seoLearning->the_post();
            ?>
                <li class="seo-learning-item">
                    <h4><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h4>
                    <div class="sli-excerpt">
                        <?php echo get_the_excerpt(); ?>
                    </div>
                    <a href="<?php the_permalink(); ?>" class="sli-readmore">Read Article</a>
                </li>
            <?php
            } wp_reset_postdata();
            echo "</ul>";
        }
    ?>
        <!-- <br> -->
        <!-- <h3 class="order-now-title">Order now</h3> -->
    <?php
        /*
            DIY Packages  (Buy and order as you need one-off payment)
            ---
            https://seoi.io/blogger-outreach-service/ == 2090
            https://seoi.io/guest-post-service/       == 2105
            https://seoi.io/on-page-seo-service/      == 2117
            https://seoi.io/content-writing-service/  == 2129
            https://seoi.io/blog-writing-service/     == 2134
            https://seoi.io/local-seo-citations/      == 2111

            Managed SEO Services (Minium of 3 Month Subscription)
            ---
            https://seoi.io/seo-management-service/         == 2027
            https://seoi.io/local-seo-services/             == 2055
            https://seoi.io/national-seo-service/           == 2066
            https://seoi.io/international-seo-service/      == 2076
            https://seoi.io/ecommerce-seo-services/         == 2081
            https://seoi.io/blog-management/                == 2123
        */
        // $seoPackages = [ 2090, 2105, 2111, 2117, 2129, 2134 ];
        $seoPackages = [2090, 2105, 2117, 2129, 2134, 2111];

        // $managedServices = [ 2027, 2055, 2066, 2076, 2081, 2123, 1085 ];
        $managedServices  = [2027, 2055, 2066, 2076, 2081, 2123];

        $seoPackagesQuery = new WP_Query( array(
            "post_type"      => "page",
            "posts_per_page" => -1,
            "post_status"    => "publish",
            "post__in"       => $seoPackages
        ) );
        if ( $seoPackagesQuery->have_posts() ) {
            echo '<h3 class="order-now-title">Packaged Services</h3>';
            echo "<ul class='dashboard-products'>";
            while ( $seoPackagesQuery->have_posts() ) { $seoPackagesQuery->the_post();
            ?>
                <li class="product-item">
                    <div class="wrap">
                        <div class="img-wrap">
                            <div class="img" style="background-image: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), "medium_large" ); ?>);"></div>
                        </div>
                        <div class="content-wrap">
                            <div class="content-inner-wrap">
                                <h4><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h4>
                                <!-- <div class="pi-excerpt">
                                    <?php //echo get_the_excerpt(); ?>
                                </div> -->
                                <a href="<?php the_permalink(); ?>" class="pi-readmore">Learn More</a>
                                <a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="pi-order">Order Now</a>
                            </div>
                        </div>
                    </div>
                </li>
            <?php
            } wp_reset_postdata();
            echo "</ul>";
        }

        $managedServicesQuery = new WP_Query( array(
            "post_type"      => "page",
            "posts_per_page" => -1,
            "post_status"    => "publish",
            "post__in"       => $managedServices
        ) );
        if ( $managedServicesQuery->have_posts() ) {
            echo '<h3 class="order-now-title">Managed SEO Services</h3>';
            echo "<ul class='dashboard-products'>";
            while ( $managedServicesQuery->have_posts() ) { $managedServicesQuery->the_post();
            ?>
                <li class="product-item">
                    <div class="wrap">
                        <div class="img-wrap">
                            <div class="img" style="background-image: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), "medium_large" ); ?>);"></div>
                        </div>
                        <div class="content-wrap">
                            <div class="content-inner-wrap">
                                <h4><a href="<?php the_permalink(); ?>"><?php the_title() ?></a></h4>
                                <!-- <div class="pi-excerpt">
                                    <?php //echo get_the_excerpt(); ?>
                                </div> -->
                                <a href="<?php the_permalink(); ?>" class="pi-readmore">Learn More</a>
                                <a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="pi-order">Order Now</a>
                            </div>
                        </div>
                    </div>
                </li>
            <?php
            } wp_reset_postdata();
            echo "</ul>";
        }

    } else { // if account manager
        // get assigned customers
        $assignedCustomers = get_the_author_meta( "_assigned_customers", $user->ID );

       /* echo "<pre style='display: none;'>";
        var_dump($assignedCustomers);
        echo "</pre>";
        echo "<div style='display: none;'>";
        echo do_shortcode('[gravityforms id=10 title=false description=false ajax=true]');
        echo "</div>";*/

        // get total orders count
        $orders = [];

        // loop all assigned customers
        foreach ( $assignedCustomers as $acCount ) {

            // get user object
            $customer = get_user_by( "id", $acCount );

            // get all orders from customer
            $customerOrders = wc_get_orders( array(
                'customer_id' => $customer->ID,
                'orderby'    => 'date',
                'order'      => 'DESC',
            ) );

            // loop all customer orders
            foreach ( $customerOrders as $key => $order ) {

                // get order variables
                $orderId    = $order->get_id();
                $orderItems = $order->get_items();

                // loop order item for each customer order
                foreach ( $orderItems as $key => $item ) {
                    $productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
                    $productName = $item->get_name();
                    $itemId      = $productId . "_" . $orderId; // this is a combination of the product id + order id
                    $itemOrderStatus = get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) ? get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) : 'Processing';

                    // insert the order id of each order item based on the itemOrderStatus
                    // *there's only 1 order item per order so this works
                    switch ( $itemOrderStatus ) {
                        case 'Processing':
                            $orders['Processing'][$orderId] = $customer->ID;
                            break;

                        case 'Draft':
                            $orders['Draft'][$orderId] = $customer->ID;
                            break;

                        case 'Title Creation':
                            $orders['Title Creation'][$orderId] = $customer->ID;
                            break;

                        case 'Content Ready':
                            $orders['Content Ready'][$orderId] = $customer->ID;
                            break;

                        case 'Order Ready':
                            $orders['Order Ready'][$orderId] = $customer->ID;
                            break;

                        case 'Completed':
                            $orders['Completed'][$orderId] = $customer->ID;
                            break;
                        
                        default:
                            $orders['n/a'][$orderId] = $customer->ID; // for old orders
                            break;
                    }
                }
            }
        }

        if ( $orders ){
    ?>
            <h3 class="order-now-title">Open Orders</h3>
    <?php
            $process = array( "Processing", "Draft", "Title Creation", "Content Ready", "Order Ready", "Completed" );

            foreach ( $process as $p ) {
                if ( $orders[$p] ) {
                ?>
                    <div class="dashboard-account-manager-processes">
                        <h3><?php echo $p ?></h3>
                        <div class="table-wrap">
                            <table class="dashboard-table">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Item Status</th>
                                        <th>Customer</th>
                                        <th>Order ID</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        foreach ( $orders[$p] as $key => $user_id ) {
                                            processOrderItem( $key, $user_id );
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                <?php
                }
            }
        } else {
            echo "No customers assigned";
        } 
    }
}
function processOrderItem( $order_id, $user_id ){
    $order = wc_get_order( $order_id );

    // get order variables
    $orderId    = $order->get_id();
    $orderItems = $order->get_items();
    $orderDate  = $order->get_date_created();


    $customer = get_user_by( "id", $user_id );

    
    // echo "<pre>";
    // var_dump($orderItems);
    // var_dump($order->get_status());
    // echo "</pre>";

    if($order->get_status() != "cancelled"){

        // loop order item for each customer order
        foreach ( $orderItems as $key => $item ) {
            $productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
            $productName = $item->get_name();
            $itemId      = $productId . "_" . $orderId; // this is a combination of the product id + order id
            $itemOrderStatus = get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) ? get_post_meta( $orderId, '_order_item_status_'.$orderId.'_'.$productId, true ) : 'Processing';

            
            // echo $productName;
            // echo $itemId . " - " . $orderId . "<br>";
        ?>
            <tr>
                <td><?php echo $productName; ?></td>
                <td><?php echo $itemOrderStatus; ?></td>
                <!-- <td><?php //echo $itemId; ?></td> -->
                <td><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
                <td><?php echo $orderId; ?></td>
                <td><a href="/seo-manager/assigned-orders/?type=orderItem&itemId=<?php echo $itemId; ?>&orderId=<?php echo $orderId; ?>&pId=<?php echo $productId; ?>&user=<?php echo $user_id; ?>">Manage</a></td>
            </tr>
        <?php
        }
    }
}

// DISPLAY ORDER ITEM STATUS ON ADMIN DASHBOARD
// LET THE ADMIN SELECT THE STATUS OF THE ITEM ON THE ORDER
add_action( 'woocommerce_before_order_itemmeta', '_cstm_wc_metafields_admin_dashboard', 10, 3 );
function _cstm_wc_metafields_admin_dashboard( $item_id, $item, $_product ){
    global $woocommerce, $post;

    // 
    if ( $post->post_type == 'shop_order' ) {

        // item id
        // this is a combination of the product id + order id
        $itemId = $_product->get_id() . "_" . $post->ID; 

        // order item status
        // $choices = array( "Processing", "Draft", "Title Creation", "Title Ready", "Article Creation", "Article Ready", "Completed" );
        $choices = array( "Processing", "Draft", "Title Creation", "Content Ready", "Order Ready", "Completed" );
        $order_item_status = get_post_meta( $post->ID, '_order_item_status_'.$post->ID.'_'.$_product->get_id(), true ) ? get_post_meta( $post->ID, '_order_item_status_'.$post->ID.'_'.$_product->get_id(), true ) : 'Processing';
        echo '<input type="hidden" name="_order_item_status_nonce_'.$post->ID.'_'.$_product->get_id().'" value="'.wp_create_nonce().'">';
    ?>
            <div style="display: none;"><label for=""><strong>Order Item Status: </strong></label>
            <select name="order_item_status_<?php echo $post->ID; ?>_<?php echo $_product->get_id(); ?>" id="">
                <option value="" disabled>Select an option</option>
                <?php foreach ( $choices as $value ){ ?>
                    <option value="<?php echo $value; ?>" <?php echo $order_item_status == $value ? "selected" : ""; ?>><?php echo $value; ?></option>
                <?php } ?>
            </select></div>
    <?php
    } // end if post_type
}

// Save the data of the Meta field
add_action( 'save_post', '_save_cstm_wc_metafields', 10, 1 );
if ( ! function_exists( '_save_cstm_wc_metafields' ) ) {
    function _save_cstm_wc_metafields( $post_id ) {
        global $woocommerce, $post;
        if ( $post->post_type == 'shop_order' ) {
            // get all services ordered
            $order = new WC_Order($post->ID);
            $order_items = $order->get_items();
            foreach  ($order_items as $key => $item ) {
                // Order item status
                $productId = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
                $nonceText = "_order_item_status_nonce_".$post->ID."_".$productId;
                $metaKey   = "_order_item_status_".$post->ID."_".$productId;
                $metaSlug  = "order_item_status_".$post->ID."_".$productId;

                // item id
                $itemId = $productId . "_" . $post->ID;

                // We need to verify this with the proper authorization (security stuff).

                // Check if our nonce is set.
                if ( ! isset( $_POST[ $nonceText ] ) ) {
                    return $post_id;
                }
                $nonce = $_REQUEST[ $nonceText ];

                //Verify that the nonce is valid.
                if ( ! wp_verify_nonce( $nonce ) ) {
                    return $post_id;
                }

                // If this is an autosave, our form has not been submitted, so we don't want to do anything.
                if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
                    return $post_id;
                }

                // Check the user's permissions.
                if ( 'page' == $_POST[ 'post_type' ] ) {
                    if ( ! current_user_can( 'edit_page', $post_id ) ) {
                        return $post_id;
                    }
                } else {

                    if ( ! current_user_can( 'edit_post', $post_id ) ) {
                        return $post_id;
                    }
                }
                // --- Its safe for us to save the data ! --- //

                // Sanitize user input  and update the meta field in the database.

                // update order item status metafield
                update_post_meta( $post_id, $metaKey, $_POST[$metaSlug] );

                // reset
                /*$test = array();
                update_user_meta( 8, "_assigned_orders", $test );
                update_user_meta( 9, "_assigned_orders", $test );
                update_post_meta( $post_id, $prevAccountManagerKey, "" );*/
            }
        }
    }
}

// ADD CUSTOM MENU ITEMS TO SEO MANAGER DASHBOARD
/* Add Link (Tab) to My Account menu*/
add_filter ( 'woocommerce_account_menu_items', '_cstmLinkToMyAccountTab', 40 );
function _cstmLinkToMyAccountTab( $menu_links ){
    // custom endpoints
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'seo-learning' => 'SEO Learning' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'report-history' => 'Report History' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'assigned-orders' => 'Assigned Orders' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'seo-strategies' => 'SEO Strategies' ) + array_slice( $menu_links, 5, NULL, true );

    // get user data
    $user = wp_get_current_user();
    $userRole = $user->roles[0];

    if ( $userRole == "account_manager" ) {
        $menu_links = array(
            'dashboard'        => __( 'Dashboard', 'woocommerce' ),
            'assigned-orders'  => __( 'Assigned Orders', 'woocommerce' ),
            'seo-strategies'   => __( 'SEO Strategies', 'woocommerce' ),
            'new-dashboard'   => __( 'New Dashboard', 'woocommerce' ),
            // 'orders'           => __( 'Your Orders', 'woocommerce' ),
            // 'subscriptions'    => __( 'Subs', 'woocommerce' ),
            // 'downloads'        => __( 'Download', 'woocommerce' ),
            // 'edit-address'     => __( 'Addresses', 'woocommerce' ),
            // 'report-history'   => __( 'Report History', 'woocommerce' ),
            // 'seo-learning'     => __( 'SEO Learning', 'woocommerce' ),
            // 'payment-methods'  => __( 'Payment', 'woocommerce' ),
            // 'edit-account'     => __( 'Account Details', 'woocommerce' ),
            'customer-logout'  => __( 'Logout', 'woocommerce' ),
        );
    } else {
        // re arrange menu items / show menu items that you want
        $menu_links = array(
            'dashboard'        => __( 'Dashboard', 'woocommerce' ),
            'orders'           => __( 'Your Orders', 'woocommerce' ),
            // 'subscriptions'    => __( 'Subscriptions', 'woocommerce' ),
            // 'downloads'        => __( 'Download', 'woocommerce' ),
            'edit-address'     => __( 'Addresses', 'woocommerce' ),
            'report-history'   => __( 'Report History', 'woocommerce' ),
            'seo-learning'     => __( 'SEO Learning', 'woocommerce' ),
            'payment-methods'  => __( 'Payment', 'woocommerce' ),
            'edit-account'     => __( 'Account Details', 'woocommerce' ),
            'customer-logout'  => __( 'Logout', 'woocommerce' ),
        );
    }

    return $menu_links;
 
}
/* Register Permalink Endpoint */
add_action( 'init', '_cstmMyAccountTabLinkEndpoint' );
function _cstmMyAccountTabLinkEndpoint() {
    add_rewrite_endpoint( 'seo-learning', EP_PAGES );
    add_rewrite_endpoint( 'report-history', EP_PAGES );
    add_rewrite_endpoint( 'assigned-orders', EP_PAGES );
    add_rewrite_endpoint( 'seo-strategies', EP_PAGES );
}

// SEO MANAGER - SEO LEARNING CONTENT
add_action( 'woocommerce_account_seo-learning_endpoint', '_seoLearningEnpointContent' );
function _seoLearningEnpointContent() {
    $parentCats = get_terms( "learning_hub_categories", array(
        "hide_empty" => false,
        "parent"     => 0
    ) );

    if ( $parentCats ) {
    ?>


        <div class="seo-learning-items">
            <ul class='seo-learning-items-wrap'>
                <?php
                foreach ( $parentCats as $key => $parentCat ) {
                    $childCats = get_terms( "learning_hub_categories", array(
                        "hide_empty" => true,
                        "parent"     => $parentCat->term_id
                    ) );

                    $learningArticles = new WP_Query( array(
                        "post_type"      => "learning_hub",
                        "posts_per_page" => -1,
                        "post_status"    => "publish",
                        "tax_query"      => array(
                            array(
                                "taxonomy" => "learning_hub_categories",
                                "field"    => "id",
                                "terms"    => array( $parentCat->term_id )
                            )
                        )
                    ) );

                    if ( $childCats ) {
                        echo "<li><h3>" . $parentCat->name . "</h3>";
                        echo "<ul class='seo-learning-parent'>";
                        foreach ( $childCats as $key => $childCat ) {
                            echo "<li><h4>" . $childCat->name . "</h4>";
                                if ( $learningArticles->have_posts() ) {
                                    echo "<ul class='seo-learning-child'>";
                                    while ( $learningArticles->have_posts() ) { $learningArticles->the_post();

                                        $image      = get_the_post_thumbnail_url( get_the_ID(), "medium_large" );
    			                        $slug       = basename( get_permalink( get_the_ID() ) );
    			                        $user       = wp_get_current_user();
    			                        $uniqueName = $slug . "_" . $user->ID;
    			                        $status     = get_the_author_meta( $uniqueName, $user->ID );
                                    ?>
                                        <li class="seo-learning-item <?php echo $status ? "completed" : "" ; ?>">
                                            <?php if ( $image ){ ?>
                                                <a href="<?php echo get_the_permalink(); ?>" class="img" style="background-image: url(<?php echo $image; ?>);"></a>
                                            <?php } ?>
                                            <a class="sli-link" href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                        </li>
                                    <?php
                                        // echo "<li><a href='".get_the_permalink()."'>".get_the_title()." -- ".$status."</a></li>";
                                    } wp_reset_postdata();
                                    echo "</ul>";
                                }
                            echo "</li>";
                        }
                        echo "</ul>";
                        echo "</li>";
                    } else {
                        // if the parent cat has no child cat get its immediate posts
                        if ( $learningArticles->have_posts() ) {
                            echo "<li><h3>" . $parentCat->name . "</h3>";
                            echo "<ul class='seo-learning-parent'>";
                            while ( $learningArticles->have_posts() ) { $learningArticles->the_post();

                                $image      = get_the_post_thumbnail_url( get_the_ID(), "medium_large" );
    	                        $slug       = basename( get_permalink( get_the_ID() ) );
    	                        $user       = wp_get_current_user();
    	                        $uniqueName = $slug . "_" . $user->ID;
    	                        $status     = get_the_author_meta( $uniqueName, $user->ID );
                            ?>
                                <li class="seo-learning-item <?php echo $status ? "completed" : "" ; ?>">
                                    <?php if ( $image ) { ?>
                                        <a href="<?php echo get_the_permalink(); ?>" class="img" style="background-image: url(<?php echo $image; ?>);"></a>
                                    <?php } ?>
                                    <a class="sli-link" href="<?php echo get_the_permalink(); ?>">
                                        <h4>
                                            <?php echo get_the_title(); ?>
                                            <svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-check-circle-outlined" data-name="" style=""><path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"></path></svg>
                                        </h4>
                                        <div class="excerpt">
                                            <?php if ( get_the_excerpt() ) { ?>
                                                <?php echo get_the_excerpt(); ?>
                                            <?php } else { ?>
                                                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer rutrum tellus venenatis.
                                            <?php } ?>
                                        </div>
                                    </a>
                                </li>
                            <?php

                                // echo "<li><a href='".get_the_permalink()."'>".get_the_title()." -- ".$status."</a></li>";
                            } wp_reset_postdata();
                            echo "</ul>";
                            echo "</li>"; 
                        }
                    }
                }
                ?>
            </ul>
        </div>
    <?php
    }
}

// SEO MANAGER - REPORT HISTORY (CONECTED TO WEBCEO)
add_action( 'woocommerce_account_report-history_endpoint', '_reportHistoryEnpointContent' );
function _reportHistoryEnpointContent() {
    $endpoint  = "https://seo-tools.seoi.co.uk/api/"; // this is the endpoint api url
    $user      = wp_get_current_user(); // get the logged in user
    $userEmail = $user->user_email; // get the user email
    // $userSite  = $user->user_url ? parse_url( $user->user_url )['host'] : ""; // the website of the current user
    // $mainEmail = "sean@seoi.co.uk"; // main account used in webceo -- usually the one who generates the reports

    // webceo projects meta
    $webceoProjects = get_the_author_meta( "_webceo_projects", $user->ID );

    // 
    $webceoUser = get_the_author_meta( "_webceo_user", $user->ID );


    // get all projects
    $allProjectsId = [];
    $getAllProjects = array(
        "method" => "get_projects",
        "key"    => "a3f36b7e0caa64733a",
        "user"   => $userEmail
    );
    $allProjects = _getData( $getAllProjects, $endpoint );

    // we need to update _webceo_projects if the project has been deleted on webceo
    if ( $allProjects ) {
        foreach ( $allProjects['data'] as $key => $p ) {
            /*echo "<pre>";
            var_dump($p['project']);
            echo "</pre>";*/
            $allProjectsId[] = $p['project'];

            // check if the project domain is the same with the users website
            // if ( $p['domain'] == $userSite ) {
                // echo "<a href='' class='reportHistoryPDF' data-project-id='".$p['project']."'>Download the Latest Report</a><br>";
            // }
        }
    }

    // loop and display assigned webceo projects
    if ( $webceoProjects ) {
?>
    <div class="account-order-data-wrap">
        <?php foreach ( $webceoProjects as $key => $webceoProject ) { ?>
            <?php if ( in_array( $webceoProject["data"]["project"] , $allProjectsId ) ) { ?>
                <div class="table-wrap mb-3">
                    <table class="dashboard-table">
                        <thead>
                            <tr>
                                <th>Project</th>
                                <th>Website</th>
                                <th>Last Processed</th>
                                <th></th>
                            </tr>
                        </thead>
                        <?php
                            // webceo project args
                            $getProjectArgs = array(
                                "method" => "get_project",
                                "key"    => "a3f36b7e0caa64733a", // webceo api key -> found in settings
                                "data"   => array(
                                    'user'    => $userEmail,
                                    'domain'  => $webceoProject["domain"],
                                    'project' => $webceoProject["data"]["project"],
                                )
                            );

                            // project curl
                            $project = _getData( $getProjectArgs, $endpoint );
                        ?>
                        <tbody>
                            <tr>
                                <td><?php echo $project["data"]["name"]; ?></td>
                                <td><?php echo $webceoProject["domain"]; ?></td>
                                <td class="date"><?php echo $webceoProject["date_updated"]; ?></td>
                                <td><a href='' class='reportHistoryPDF' data-order-id="<?php echo $key; ?>" data-project-id='<?php echo $webceoProject["data"]["project"]; ?>'>Download</a></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            <?php } else { ?>
                <?php
                    // unset( $webceoProjects[$key] );
                // $webceoProjects[$orderId]["date_updated"] = $date;
                // update_user_meta( $user->ID, "_webceo_projects", $webceoProjects );
                ?>
            <?php } ?>
        <?php } ?>
    </div>
<?php
    }

    // $url = preg_replace("(^https?://)", "", $url );
    $userWebsites = get_the_author_meta( "_user_websites", $user->ID );
    // var_dump($userWebsites);

    // echo "<a href='' class='reportHistoryPDF' data-project-id='ca87a76d'>Download the Latest Report</a><br>";

     // download button for the file
    echo "<a href='' id='pdfDownloadTrigger' style='display: none;' target='_blank' download>Download PDF</a>";
}

// REPORT HISTORY DOWNLOAD PDF AJAX
add_action( 'wp_ajax__downloadReportHistory', '_downloadReportHistory' ); 
add_action( 'wp_ajax_nopriv__downloadReportHistory', '_downloadReportHistory' ); 
function _downloadReportHistory(){
    header('Content-Type: application/json');

    $user      = wp_get_current_user(); // get the logged in user
    $endpoint  = "https://seo-tools.seoi.co.uk/api/"; // this is the endpoint api url
    $projectId = $_REQUEST['projectId'];
    $orderId   = $_REQUEST['orderId'];

    // WEBCEO Report ID's - https://seo-tools.seoi.co.uk/help-center/api/appendix-b.html
   	$latestPDF = array(
        "method" => "download_pdf_report",
        "key"    => "a3f36b7e0caa64733a",
        "data"   => array(
            'project'      => $projectId,
            'report_id'    => 2,
            'callback_url' => "https://seoi.co.uk/api/callback.php"
        )
    );
    $response['generatePDF'] = _getData( $latestPDF, $endpoint );

    // if ( $generatePDF ) {
   	// get the pdf url generated by the callback.php
    /*$file = file_get_contents( "https://seoi.co.uk/api/file.txt" );
    if ( $file ) { // validate if pdf there's data
		$file = json_decode($file, true)['json'];
		$response['pdf']  = json_decode($file)->pdf_url;
    }*/
    // }

    // update last updated date
    $date = date("F j, Y g:i a");
    $response['date'] = $date;
    $webceoProjects = get_the_author_meta( "_webceo_projects", $user->ID );
    $webceoProjects[$orderId]["date_updated"] = $date;
    update_user_meta( $user->ID, "_webceo_projects", $webceoProjects );

    // user id
    $response['userId'] = $user->ID;

    // 
    echo json_encode( $response );

    die();
}

// SEO MANAGER - CUSTOMER SEO STRATEGIES
add_action( 'woocommerce_account_seo-strategies_endpoint', '_seoStrategiesEndpointContent' );
function _seoStrategiesEndpointContent(){
    $user     = wp_get_current_user();
    $userRole = $user->roles[0];

    if ( $userRole != "account_manager" ) {
        $accountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );
        $accountManager = get_user_by( "email", $accountManager );

        // strategies
        $strategies = get_the_author_meta( "seo_strategies", $accountManager->ID );
        $strategyPages = [];

        // get customer orders
        $customerOrderItems = [];
        $customer_orders = wc_get_orders( array(
            'customer_id' => $user->ID,
            'orderby'     => 'date',
            'order'       => 'DESC',
        ) );

        // get all items from every customer order
        foreach ( $customer_orders as $key => $co ) {
            $order       = new WC_Order( $co->ID );
            $order_items = $order->get_items();
            foreach ( $order_items as $key => $item ) {
                $customerOrderItems[] = $item->get_name();
            }
        }


        if ( $strategies ) {

            // check if the account manager has a strategy for the user
            if ( $strategies[$user->ID] ) {

                // data
                $formData   = $strategies[$user->ID];
                $customerId = $formData["Customer ID"];
                $pageCount  = $formData["Page Count"];

                /*echo "<pre>";
                var_dump($formData);
                echo "</pre>";*/

                // page names
                $pageNames = [];
                foreach ( $formData as $key => $value ) {
                    if ( strpos( $key, "Page Name" ) !== false ) {
                        $pageNames[] = $value;
                    }   
                }
            ?>
                <div class="user-free-seo-strategy">
                    <ul class="fss-tab-header">
                        <?php
                            foreach ( $pageNames as $key => $pageName ):
                                $tabName = str_replace( " ", "_", strtolower( $pageName ) );
                        ?>
                            <li class="<?php echo $key == 0 ? 'active' : ''; ?>" data-tab="<?php echo $tabName; ?>">
                                <a href=""><?php echo $pageName; ?></a>
                            </li>
                        <?php endforeach ?>
                    </ul>

                    <div class="fss-tab-contents">
                        <?php
                            foreach ( $pageNames as $key => $pageName ):
                                $pageNumber  = $key + 1;
                                $tabName     = str_replace(  " ", "_", strtolower( $pageName ) );
                                $hiddenClass = $key == 0 ? "" : "hidden";
                                $comments    = $formData["Page " . $pageNumber . " Comments"];

                                // website url
                                $websiteUrlIndex = "Page ".$pageNumber." Website URL";
                                $websiteUrl = $formData[$websiteUrlIndex];

                                // other data
                                $keywordCount     = $formData["Page " . $pageNumber . " Keyword Count"];
                                $keywords         = [];
                                $onPageTechnical  = [];
                                $contentWriting   = [];
                                $localSeoCitation = [];
                                $backlinks        = [];
                                $contentMarketing = [];

                                // assign data
                                foreach ( $formData as $key => $value ) {
                                    for ( $i=1; $i <= $keywordCount; $i++ ) { 
                                        if ( strpos( $key, "Page " . $pageNumber . " Keyword " . $i ) !== false ) {
                                            $keywords["Keyword " . $i][$key] = $value;
                                        } elseif ( strpos( $key, "Page " . $pageNumber . " On-page and Technical" ) !== false ) {
                                            $onPageTechnical[$key] = $value;
                                        } elseif ( strpos( $key, "Page " . $pageNumber . " Content Writing" ) !== false ) {
                                            $contentWriting[$key] = $value;
                                        } elseif ( strpos( $key, "Page " . $pageNumber . " Local SEO Citation" ) !== false ) {
                                            $localSeoCitation[$key] = $value;
                                        } elseif ( strpos( $key, "Page " . $pageNumber . " Backlinks" ) !== false ) {
                                            $backlinks[$key] = $value;
                                        } elseif ( strpos( $key, "Page " . $pageNumber . " Content Marketing" ) !== false ) {
                                            $contentMarketing[$key] = $value;
                                        }
                                    }
                                }
                        ?>
                                <div class="fss-tab-content <?php echo $hiddenClass; ?>" data-tab="<?php echo $tabName; ?>">
                                    <ul class="fss-data">
                                        <li>
                                            <div class="label">Website</div>
                                            <div class="data"><?php echo $websiteUrl; ?></div>
                                        </li>
                                    </ul>

                                    <!--  -->
                                    <?php if ( $keywords ): ?>
                                        <?php foreach ( $keywords as $key => $value ): ?>
                                            <ul class="fss-data fss-keywords">
                                                <?php
                                                    $x = 1;
                                                    foreach ( $value as $key => $data ):
                                                        $label = "";
                                                        if ( $x == 1 ) {
                                                            $label = "Keyword";
                                                        } elseif ( $x == 2 ) {
                                                            $label = 'MS <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Monthly Searches">?</a>';
                                                        } elseif ( $x == 3 ) {
                                                            $label = 'CPC <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Cost per Click">?</a>';
                                                        } elseif ( $x == 4 ) {
                                                            $label = 'EP1T <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Estimated Position 1 Traffic">?</a>';
                                                        } else {
                                                            $label = "Competitor";
                                                        }
                                                ?>
                                                    <li>
                                                        <div class="label"><?php echo $label; ?></div>
                                                        <div class="data"><?php echo $data; ?></div>
                                                    </li>
                                                <?php $x++; endforeach; ?>
                                            </ul>
                                        <?php endforeach ?>
                                    <?php endif ?>

                                                        
                                    <?php
                                        if ( $onPageTechnical ):
                                            // additional space
                                            echo "<br>";

                                            // remove first key
                                            array_shift( $onPageTechnical );

                                            // remove second key (comment)
                                            $comment = $onPageTechnical["Page " . $pageNumber . " On-page and Technical SEO Comment"];
                                            if ( $comment ) {
                                                array_shift( $onPageTechnical );
                                            }

                                            for ( $i=1; $i <= $keywordCount; $i++ ) {
                                    ?>
                                                <ul class="fss-data fss-scores">
                                                    <?php $x = 1; foreach ( $onPageTechnical as $key => $value ): ?>
                                                        <?php
                                                            if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                $label = ( $x == 1 ) ? "Your Score" : "Competitor";
                                                        ?>
                                                            <li>
                                                                <div class="label"><?php echo $label; ?></div>
                                                                <div class="data"><?php echo $value; ?></div>
                                                            </li>  
                                                        <?php $x++; endif; ?>
                                                    <?php endforeach ?>
                                                </ul>
                                            <?php } ?>

                                            <!-- comment -->
                                            <?php if ( $comment ): ?>
                                                <div class="fss-content comments">
                                                    <div class="fss-content-wrap">
                                                        <h3>On-page and Technical SEO Comment</h3>
                                                        <?php echo apply_filters( "the_content", $comment ); ?>
                                                    </div>
                                                </div>
                                            <?php endif ?>

                                        <?php
                                            // check if the product has been ordered
                                            $technicalSeoCompleted = false;
                                            $technicalSeoPageTitle = "On-Page SEO Services And packages: Technical SEO";
                                            if ( in_array( $technicalSeoPageTitle, $customerOrderItems ) ) {
                                                $technicalSeoCompleted = true;
                                            }
                                        ?>
                                        <div class="fss-content technical-seo">
                                            <div class="fss-content-wrap">
                                                <h3>Technical SEO</h3>
                                                <p>Technical SEO is crucial to get right it makes sure your site can be found by the search engines and that your site speed and technical aspects are up to the search engines Standards. </p>
                                                <h4>Technical SEO Packages Includes:</h4>
                                                <ul>
                                                    <li>Sitemap.xml Creation</li>
                                                    <li>Robots.txt File Creation</li>
                                                    <li>Schema Markup</li>
                                                    <li>Speed Optimisation</li>
                                                    <li>Leverage Browser Caching</li>
                                                    <li>Image Compression and Serve Scale</li>
                                                    <li>Fix All Possible Audit Issues</li>
                                                </ul>
                                            </div>
                                            <div class="fss-buttons-wrap">
                                                <div class="fss-buttons">
                                                    <h4>Technical SEO Package from £50</h4>
                                                    <a href="" class="btn-order btn-find-out-more">Find Out More</a>
                                                    <a href="" class="btn-order">Order Now</a>
                                                </div>
                                            </div>
                                        </div>
                                        <?php if ( !$technicalSeoCompleted ): ?>
                                            <div class="fss-content on-page">
                                                <div class="fss-content-wrap">
                                                    <h3>On-Page</h3>
                                                    <p>On-page SEO and technical SEO is crucial and where you should start. Optimising your pages for your keywords and making sure the search engine can find your content.</p>
                                                    <h4>On-Page SEO Package includes:</h4>
                                                    <ul>
                                                        <li>Full Site Audit</li>
                                                        <li>Keyword Research</li>
                                                        <li>Optimised Title & Meta Description</li>
                                                        <li>Optimised H1, H2 Heading</li>
                                                        <li>Inbound / Outbound linking</li>
                                                        <li>Slugs and Permalinks optimisation</li>
                                                        <li>Google Analytics & Search Console</li>
                                                        <li>Configuration</li>
                                                        <li>Inbound / Outbound linking</li>
                                                    </ul>
                                                </div>
                                                <div class="fss-buttons-wrap">
                                                    <div class="fss-buttons">
                                                        <h4>On-page SEO Package from £50</h4>
                                                        <a href="<?php echo get_site_url(); ?>/on-page-seo-service/" class="btn-order btn-find-out-more">Find Out More</a>
                                                        <a href="<?php echo get_site_url(); ?>/cart/?order=On-Page%20SEO%20Services%20And%20packages:%20Technical%20SEO&pid=2117" class="btn-order">Order Now</a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif ?>
                                        <br>
                                    <?php endif ?>

                                    <!--  -->
                                    <?php
                                        if ( $contentWriting ):
                                            // remove first key
                                            array_shift( $contentWriting );

                                            // remove second key (comment)
                                            $cwComments = $contentWriting["Page " . $pageNumber . " Content Writing Comment"];
                                            if ( $cwComments ) {
                                                array_shift( $contentWriting );
                                            }

                                            for ( $i=1; $i <= $keywordCount; $i++ ) {
                                    ?>
                                                <ul class="fss-data fss-scores">
                                                    <?php $x = 1; foreach ( $contentWriting as $key => $value ): ?>
                                                        <?php
                                                            if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                $label = ( $x == 1 ) ? "Your Content Writing" : "Competitor";
                                                        ?>
                                                            <li>
                                                                <div class="label"><?php echo $label; ?></div>
                                                                <div class="data"><?php echo $value; ?></div>
                                                            </li>  
                                                        <?php $x++; endif; ?>
                                                    <?php endforeach ?>
                                                </ul>
                                            <?php } ?>

                                            <!-- comment -->
                                            <?php if ( $cwComments ): ?>
                                                <div class="fss-content comments">
                                                    <div class="fss-content-wrap">
                                                        <h3>Content Writing Comment</h3>
                                                        <?php echo apply_filters( "the_content", $cwComments ); ?>
                                                    </div>
                                                </div>
                                            <?php endif ?>

                                        <?php
                                            // check if the product has been ordered
                                            $seoContentWritingCompleted = false;
                                            $seoContentWritingPageTitle = "Content Writing Services: Expert SEO Content writers";
                                            if ( in_array( $seoContentWritingPageTitle, $customerOrderItems ) ) {
                                                $seoContentWritingCompleted = true;
                                            }

                                            $citationBuildingCompleted = false;
                                            $citationBuildingPageTitle = "Local SEO Citations";
                                            if ( in_array( $citationBuildingPageTitle, $customerOrderItems ) ) {
                                                $citationBuildingCompleted = true;
                                            }
                                        ?>

                                        <?php if ( !$seoContentWritingCompleted ): ?>
                                            <div class="fss-content seo-content-writing">
                                                <div class="fss-content-wrap">
                                                    <h3>SEO Content Writing</h3>
                                                    <p>Content is king when it comes to digital marketing and SEO it is proven that pages with more content rank higher than pages with less content. Google whats to offer its users as much information as possible for their Search query.</p>
                                                    <p>It is crucial to have well written and optimised content and to beat your competitors add more relevant and useful information.</p>
                                                </div>
                                                <div class="fss-buttons-wrap">
                                                    <div class="fss-buttons">
                                                        <h4>SEO Content Writing Packages from £60</h4>
                                                        <a href="<?php echo get_site_url(); ?>/content-writing-service/" class="btn-order btn-find-out-more">Find Out More</a>
                                                        <a href="<?php echo get_site_url(); ?>/cart/?order=Content%20Writing%20Services:%20Expert%20SEO%20Content%20writers&pid=2129" class="btn-order">Order Now</a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif ?>

                                        <?php if ( !$citationBuildingCompleted ): ?>
                                            <div class="fss-content citation-building">
                                                <div class="fss-content-wrap">
                                                    <h3>Citation Building And Clean Up</h3>
                                                    <p>Correct business citations are the fourth most crucial local ranking Factors. It's crucial to have all your business citation correct and up to date. By having consistent and accurate citations, it lets Google and the other search engines know your business is a well-known business, builds trust that your information is up to date.</p>
                                                    <h4>Our SEO Citation Packages Include:</h4>
                                                    <ul>
                                                        <li>Manually submitted Citations</li>
                                                        <li>NAP Citations</li>
                                                        <li>100% live citations</li>
                                                        <li>Manually submitted work</li>
                                                        <li>Create new account for every listing</li>
                                                        <li>Zero duplicate citations</li>
                                                        <li>Only the top quality citation sites</li>
                                                        <li>Full report with login details</li>
                                                    </ul>
                                                </div>
                                                <div class="fss-buttons-wrap">
                                                    <div class="fss-buttons">
                                                        <h4>Citation Building Packages from £120</h4>
                                                        <a href="<?php echo get_site_url(); ?>/local-seo-citations/" class="btn-order btn-find-out-more">Find Out More</a>
                                                        <a href="<?php echo get_site_url(); ?>/cart/?order=Local%20SEO%20Citations&cit=30&pid=2111" class="btn-order">Order Now</a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif ?>
                                        <br>
                                    <?php endif ?>

                                    <!--  -->
                                    <?php
                                        if ( $backlinks ):
                                            // remove first key
                                            array_shift( $backlinks );

                                            // remove second key (comment)
                                            $bComments = $backlinks["Page " . $pageNumber . " Backlinks Comment"];
                                            if ( $bComments ) {
                                                array_shift( $backlinks );
                                            }

                                            for ( $i=1; $i <= $keywordCount; $i++ ) {
                                    ?>
                                                <ul class="fss-data fss-scores">
                                                    <?php $x = 1; foreach ( $backlinks as $key => $value ): ?>
                                                        <?php
                                                            if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                $label = ( $x == 1 ) ? "Your Backlinks" : "Competitor";
                                                        ?>
                                                            <li>
                                                                <div class="label"><?php echo $label; ?></div>
                                                                <div class="data"><?php echo $value; ?></div>
                                                            </li>  
                                                        <?php $x++; endif; ?>
                                                    <?php endforeach ?>
                                                </ul>
                                            <?php } ?>

                                            <!-- comment -->
                                            <?php if ( $bComments ): ?>
                                                <div class="fss-content comments">
                                                    <div class="fss-content-wrap">
                                                        <h3>Backlinks Comment</h3>
                                                        <?php echo apply_filters( "the_content", $bComments ); ?>
                                                    </div>
                                                </div>
                                            <?php endif ?>

                                        <?php
                                            // check if the product has been ordered
                                            $bloggerOutreachCompleted = false;
                                            $bloggerOutreachPageTitle = "Blogger Outreach Service";
                                            if ( in_array( $bloggerOutreachPageTitle, $customerOrderItems ) ) {
                                                $bloggerOutreachCompleted = true;
                                            }
                                        ?>

                                        <?php if ( !$bloggerOutreachCompleted ): ?>
                                            <div class="fss-content link-building">
                                                <div class="fss-content-wrap">
                                                    <h3>Link Building</h3>
                                                    <p>Backlinks are the number one ranking factor and we believe always will be. High-quality, natural backlinks from relevant high DA blog are some of the most powerful links you can receive. These links we secure from our blogger outreach service are a great way to scale and build natural backlinks to your site.</p>
                                                    <p>Our in content Backlinks are powerful natural backlinks.</p>
                                                </div>
                                                <div class="fss-buttons-wrap">
                                                    <div class="fss-buttons">
                                                        <h4>Blogger Outreach Packages from £100</h4>
                                                        <a href="<?php echo get_site_url(); ?>/blogger-outreach-service/" class="btn-order btn-find-out-more">Find Out More</a>
                                                        <a href="<?php echo get_site_url(); ?>/cart/?order=Blogger%20Outreach%20Service&da=10&pid=2090" class="btn-order">Order Now</a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif ?>

                                        <div class="fss-content content-marketing">
                                            <div class="fss-content-wrap">
                                                <h3>Content Marketing</h3>
                                                <p>Another important ranking factor is relevant content on the site linked to the keyword and subjects you are trying to rank for. If search engines see your site offers a wealth of information in you given field you who site will rank higher for your target keywords.</p>
                                                <p>By adding a blog post to your blog you can start to rank for 1000 of keywords. Each blog post is a doorway for new clients to walk through.</p>
                                                <p>We can research and find blog post topics and create blog posts to build your rankings and keywords.</p>
                                            </div>
                                            <div class="fss-buttons-wrap">
                                                <div class="fss-buttons">
                                                    <h4>Blog Writing Packages from £60</h4>
                                                    <a href="<?php echo get_site_url(); ?>/blog-writing-service/" class="btn-order btn-find-out-more">Find Out More</a>
                                                    <a href="<?php echo get_site_url(); ?>/cart/?order=Blog%20Writing%20Service:%20Professional%20Article%20Writers&pid=2134" class="btn-order">Order Now</a>
                                                </div>
                                                <div class="fss-buttons">
                                                    <h4>Blog Management Service from £200</h4>
                                                    <a href="<?php echo get_site_url(); ?>/blog-management/" class="btn-order btn-find-out-more">Find Out More</a>
                                                    <a href="<?php echo get_site_url(); ?>/cart/?order=Blog%20Management%20Service:%20SEO%20Content%20Marketing%20Plan&pid=2123" class="btn-order">Order Now</a>
                                                </div>
                                            </div>
                                        </div> 
                                    <?php endif ?>

                                    <?php if ( $comments ): ?>
                                        <div class="fss-content comments">
                                            <div class="fss-content-wrap">
                                                <h3>Comments</h3>
                                                <?php echo apply_filters( "the_content", $comments ); ?>
                                            </div>
                                        </div>
                                    <?php endif ?>
                                </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php
            }
        }
    } else {
        $strategies = get_the_author_meta( "seo_strategies", $user->ID );
        // $assignedCustomers = get_the_author_meta( "_assigned_customers", $user->ID );
        // check if the user already has the an seo strategy
        // create one 

        if ( isset( $_POST["Customer_ID"] ) ) {
            $customer = get_user_by( "id", $_POST["Customer_ID"] );
            $formData = $strategies[$_POST["Customer_ID"]];

            /*echo "<pre>";
            var_dump($formData);
            echo "</pre>";*/

            // if theres data alteady
            if ( $formData ){ 
?>
                <div class="create-strategy-wrap">
                    <div class="cs-add-page">
                        <input type="text">
                        <a href="" id="add-cs-page">+ Add Page</a>
                    </div>

                    <form action="" id="create-strategy-form">
                        <?php
                            $pageCount = $formData["Page Count"];
                            $pageNames = [];
                            foreach ( $formData as $key => $value ) {
                                if ( strpos( $key, "Page Name" ) !== false ) {
                                    $pageNames[] = $value;
                                }   
                            }
                        ?>
                        <input type="hidden" name="Customer ID" value="<?php echo $_POST["Customer_ID"]; ?>">
                        <input type="hidden" name="Page Count" value="<?php echo $pageCount; ?>">
                        <ul class="cs-header-tabs">
                            <?php
                                foreach ( $pageNames as $key => $pageName ):
                                    $tabName = str_replace(  " ", "_", strtolower( $pageName ) );
                            ?>
                                <li class="<?php echo $key == 0 ? 'active' : ''; ?>" data-tab="<?php echo $tabName; ?>"><a href=""><?php echo $pageName; ?></a></li>
                            <?php endforeach ?>
                        </ul>

                        <div class="cs-content-tabs">
                            <?php
                                $strategyPages = [];
                                foreach ( $pageNames as $key => $pageName ) {
                                    $pageNumber  = $key + 1;
                                    $tabName     = str_replace(  " ", "_", strtolower( $pageName ) );
                                    $hiddenClass = $key == 0 ? "" : "hidden";

                                    // website url
                                    $websiteUrlIndex = "Page ".$pageNumber." Website URL";
                                    $websiteUrl = $formData[$websiteUrlIndex];

                                    // other data
                                    $keywordCount     = $formData["Page " . $pageNumber . " Keyword Count"] == "0" ? 1 : $formData["Page " . $pageNumber . " Keyword Count"];
                                    $keywords         = [];
                                    $onPageTechnical  = [];
                                    $contentWriting   = [];
                                    $localSeoCitation = [];
                                    $backlinks        = [];
                                    $contentMarketing = [];


                                    foreach ( $formData as $key => $value ) {
                                        for ($i=1; $i <= $keywordCount; $i++) { 
                                            if ( strpos( $key, "Page " . $pageNumber . " Keyword " . $i ) !== false ) {
                                                $keywords["Keyword " . $i][$key] = $value;
                                            } elseif ( strpos( $key, "Page " . $pageNumber . " On-page and Technical" ) !== false ) {
                                                $onPageTechnical[$key] = $value;
                                            } elseif ( strpos( $key, "Page " . $pageNumber . " Content Writing" ) !== false ) {
                                                $contentWriting[$key] = $value;
                                            } elseif ( strpos( $key, "Page " . $pageNumber . " Local SEO Citation" ) !== false ) {
                                                $localSeoCitation[$key] = $value;
                                            } elseif ( strpos( $key, "Page " . $pageNumber . " Backlinks" ) !== false ) {
                                                $backlinks[$key] = $value;
                                            } elseif ( strpos( $key, "Page " . $pageNumber . " Content Marketing" ) !== false ) {
                                                $contentMarketing[$key] = $value;
                                            }
                                        }
                                    }

                                    /*echo "<pre>";
                                    var_dump($keywordCount);
                                    var_dump($onPageTechnical);
                                    var_dump($contentWriting);
                                    var_dump($localSeoCitation);
                                    var_dump($backlinks);
                                    var_dump($contentMarketing);
                                    echo "</pre>";*/
                            ?>
                                <div class="cs-content-tab <?php echo $hiddenClass; ?>" data-tab-count="<?php echo $pageNumber; ?>" data-tab="<?php echo $tabName; ?>">
                                    <!--  -->
                                    <input type="hidden" name="Page <?php echo $pageNumber; ?> Page Name" value="<?php echo $pageName; ?>">
                                    <input type="hidden" name="Page <?php echo $pageNumber; ?> Keyword Count" value="<?php echo $keywordCount; ?>">
                                    
                                    <!--  -->
                                    <?php if ( $pageNumber > 1 ): ?>
                                        <div class="remove-page-wrap">
                                            <a href="" class="remove-page"><div>&times;</div> Remove Page</a>
                                        </div>
                                    <?php endif ?>

                                    <!--  -->
                                    <div class="item">
                                        <label for="Page <?php echo $pageNumber; ?> Website URL">Website URL</label>
                                        <input type="text" name="Page <?php echo $pageNumber; ?> Website URL" value="<?php echo $websiteUrl; ?>" placeholder="Website URL" required="">
                                    </div>
                                    <!--  -->

                                    <!-- KEYWORDS -->
                                    <?php if ( $keywords ): ?>
                                        <div class="item keywords">
                                            <?php $count = 1; foreach ( $keywords as $key => $keywordData ): ?>
                                                <div class="item-child keyword" data-keyword-number="<?php echo $count; ?>">
                                                    <?php
                                                        $xCount = 1;
                                                        foreach ( $keywordData as $key => $value ):
                                                            if ( strpos( $key, "Competitor" ) == false ):
                                                                $label = "";
                                                                $labelText = "";
                                                                if ( $xCount == 1 ) {
                                                                    $labelText = "Keyword " . $count;
                                                                } elseif ( $xCount == 2 ) {
                                                                    $label = " MS";
                                                                    $labelText = 'MS <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Monthly Searches">?</a>';
                                                                } elseif ( $xCount == 3 ) {
                                                                    $label = " CPC";
                                                                    $labelText = 'CPC <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Cost per Click">?</a>';
                                                                } elseif ( $xCount == 4 ) {
                                                                    $label = " EP1T";
                                                                    $labelText = 'EP1T <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Estimated Position 1 Traffic">?</a>';
                                                                }
                                                    ?>
                                                                <fieldset>
                                                                    <label for="Page <?php echo $pageNumber; ?> Keyword <?php echo $count; ?><?php echo $label; ?>"><?php echo $labelText; ?></label>
                                                                    <input type="text" name="Page <?php echo $pageNumber; ?> Keyword <?php echo $count; ?><?php echo $label; ?>" value="<?php echo $value; ?>">
                                                                </fieldset>
                                                    <?php
                                                            endif;
                                                        $xCount++; endforeach;

                                                        $zCount = 1;
                                                        $keywordCompetitor = [];
                                                        foreach ( $keywordData as $key => $value ):
                                                            if ( strpos( $key, "Competitor" ) !== false ):
                                                                $keywordCompetitor[$key] = $value;
                                                            endif;
                                                        $zCount++; endforeach;
                                                    ?>
                                                    <div class="keyword-competitors">
                                                        <?php if ( $keywordCompetitor ): ?>
                                                            <?php foreach ( $keywordCompetitor as $key => $kc ): ?>
                                                                <div class="kc-child competitor">
                                                                    <label for="<?php echo $key; ?>">Competitor</label>
                                                                    <input type="text" name="<?php echo $key; ?>" value="<?php echo $kc; ?>" required>
                                                                </div>
                                                            <?php endforeach ?>
                                                        <?php endif ?>
                                                        <a href="" class="remove-cs-competitors <?php $keywordCompetitor ? "" : "hidden"; ?>">&times; remove</a>
                                                        <a href="" class="small-btn add-cs-competitors">+ Add Competitor</a>
                                                    </div>
                                                </div>
                                            <?php $count++; endforeach; ?>

                                            <!--  -->
                                            <a href="" class="remove-cs-keywords">&times; remove</a>
                                            <a href="" class="small-btn add-cs-keywords">+ Add Keyword</a>
                                        </div>
                                    <?php else: ?>
                                        <div class="item keywords">
                                            <a href="" class="remove-cs-keywords hidden">&times; remove</a>
                                            <a href="" class="small-btn add-cs-keywords">+ Add Keyword</a>
                                        </div>
                                    <?php endif; ?> 
                                    <!-- KEYWORDS END -->

                                    <div class="item select-item-products">
                                        <h4>Select Included Products</h4>
                                        <div class="item-child">
                                            <input type="checkbox" id="<?php echo "Page " . $pageNumber . " On-page and Technical SEO"; ?>"  name="<?php echo "Page " . $pageNumber . " On-page and Technical SEO"; ?>" value="on-page-technical" <?php echo $onPageTechnical["Page " . $pageNumber . " On-page and Technical SEO"] == "on-page-technical" ? "checked" : ""; ?>>
                                            <label for="<?php echo "Page " . $pageNumber . " On-page and Technical SEO"; ?>">On-page and Technical SEO</label>

                                            <?php if ( $onPageTechnical["Page " . $pageNumber . " On-page and Technical SEO Comment"] ): ?>
                                                <textarea name="<?php echo "Page " . $pageNumber . " On-page and Technical SEO Comment"; ?>" id="<?php echo "Page " . $pageNumber . " On-page and Technical SEO Comment"; ?>" placeholder="Comment here.."><?php echo $onPageTechnical["Page " . $pageNumber . " On-page and Technical SEO Comment"]; ?></textarea>
                                            <?php endif ?>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="<?php echo "Page " . $pageNumber . " Content Writing"; ?>" name="<?php echo "Page " . $pageNumber . " Content Writing"; ?>" value="content-writing" <?php echo $contentWriting["Page " . $pageNumber . " Content Writing"] == "content-writing" ? "checked" : ""; ?>>
                                            <label for="<?php echo "Page " . $pageNumber . " Content Writing"; ?>">Content Writing</label>
                                            
                                            <?php if ( $contentWriting["Page " . $pageNumber . " Content Writing Comment"] ): ?>
                                                <textarea name="<?php echo "Page " . $pageNumber . " Content Writing Comment"; ?>" id="<?php echo "Page " . $pageNumber . " Content Writing Comment"; ?>" placeholder="Comment here.."><?php echo $contentWriting["Page " . $pageNumber . " Content Writing Comment"]; ?></textarea>
                                            <?php endif ?>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="<?php echo "Page " . $pageNumber . " Local SEO Citation"; ?>" name="<?php echo "Page " . $pageNumber . " Local SEO Citation"; ?>" value="local-seo-citation" <?php echo $localSeoCitation["Page " . $pageNumber . " Local SEO Citation"] == "local-seo-citation" ? "checked" : ""; ?>>
                                            <label for="<?php echo "Page " . $pageNumber . " Local SEO Citation"; ?>">Local SEO Citation</label>
                                            
                                            <?php if ( $localSeoCitation["Page " . $pageNumber . " Local SEO Citation Comment"] ): ?>
                                                <textarea name="<?php echo "Page " . $pageNumber . " Local SEO Citation Comment"; ?>" id="<?php echo "Page " . $pageNumber . " Local SEO Citation Comment"; ?>" placeholder="Comment here.."><?php echo $localSeoCitation["Page " . $pageNumber . " Local SEO Citation Comment"]; ?></textarea>
                                            <?php endif ?>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="<?php echo "Page " . $pageNumber . " Backlinks"; ?>" name="<?php echo "Page " . $pageNumber . " Backlinks"; ?>" value="backlinks" <?php echo $backlinks["Page " . $pageNumber . " Backlinks"] == "backlinks" ? "checked" : ""; ?>>
                                            <label for="<?php echo "Page " . $pageNumber . " Backlinks"; ?>">Backlinks</label>
                                            
                                            <?php if ( $backlinks["Page " . $pageNumber . " Backlinks Comment"] ): ?>
                                                <textarea name="<?php echo "Page " . $pageNumber . " Backlinks Comment"; ?>" id="<?php echo "Page " . $pageNumber . " Backlinks Comment"; ?>" placeholder="Comment here.."><?php echo $backlinks["Page " . $pageNumber . " Backlinks Comment"]; ?></textarea>
                                            <?php endif ?>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="<?php echo "Page " . $pageNumber . " Content Marketing"; ?>" name="<?php echo "Page " . $pageNumber . " Content Marketing"; ?>" value="content-marketing" <?php echo $contentMarketing["Page " . $pageNumber . " Content Marketing"] == "content-marketing" ? "checked" : ""; ?>>
                                            <label for="<?php echo "Page " . $pageNumber . " Content Marketing"; ?>">Content Marketing</label>
                                            
                                            <?php if ( $contentMarketing["Page " . $pageNumber . " Content Marketing Comment"] ): ?>
                                                <textarea name="<?php echo "Page " . $pageNumber . " Content Marketing Comment"; ?>" id="<?php echo "Page " . $pageNumber . " Content Marketing Comment"; ?>" placeholder="Comment here.."><?php echo $contentMarketing["Page " . $pageNumber . " Content Marketing Comment"]; ?></textarea>
                                            <?php endif ?>
                                        </div>
                                    </div>

                                    <div class="item item-products">
                                        <?php
                                            if ( $onPageTechnical ):
                                                // remove first key
                                                array_shift( $onPageTechnical );

                                                // remove second key (comment)
                                                if ( $onPageTechnical["Page " . $pageNumber . " On-page and Technical SEO Comment"] ) {
                                                    array_shift( $onPageTechnical );
                                                }

                                                // 
                                                for ( $i=1; $i <= $keywordCount; $i++ ) {
                                        ?>
                                                <div class="item-child item-child-technical" data-count="<?php echo $i; ?>">
                                                    <?php $x = 1; foreach ( $onPageTechnical as $key => $value ): ?>
                                                        <?php
                                                            if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                $label = $x == 1 ? "Your On-Page And Technical Score" : "Competitor";
                                                                $class = $x == 1 ? "" : "technical-competitor";
                                                        ?>
                                                            <fieldset class="<?php echo $class; ?>">
                                                                <label for="<?php echo $key; ?>"><?php echo $label; ?></label>
                                                                <input type="number" name="<?php echo $key; ?>" value="<?php echo $value; ?>">
                                                            </fieldset>
                                                        <?php $x++; endif; ?>
                                                    <?php endforeach; ?>
                                                    <a href="" class="remove-btn remove-technical-competitors hidden">&times; remove</a>
                                                    <br><a href="" class="small-btn add-technical-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                </div>
                                            <?php } ?>
                                        <?php endif ?>

                                        <?php
                                            if ( $contentWriting ):
                                                // remove first key
                                                array_shift( $contentWriting );

                                                // remove second key (comment)
                                                if ( $contentWriting["Page " . $pageNumber . " Content Writing Comment"] ) {
                                                    array_shift( $contentWriting );
                                                }

                                                for ( $i=1; $i <= $keywordCount; $i++ ) {
                                        ?>
                                                    <div class="item-child item-child-content-writing" data-count="<?php echo $i; ?>">
                                                        <?php $x = 1; foreach ( $contentWriting as $key => $value ): ?>
                                                            <?php
                                                                if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                    $label = $x == 1 ? "Your Content Writing" : "Competitor";
                                                                    $class = $x == 1 ? "" : "content-writing-competitor";
                                                            ?>
                                                                <fieldset class="<?php echo $class; ?>">
                                                                    <label for="<?php echo $key; ?>"><?php echo $label; ?></label>
                                                                    <input type="number" name="<?php echo $key; ?>" value="<?php echo $value; ?>">
                                                                </fieldset>
                                                            <?php $x++; endif; ?>
                                                        <?php endforeach; ?>
                                                        <a href="" class="remove-btn remove-content-writing-competitors hidden">&times; remove</a>
                                                        <br><a href="" class="small-btn add-content-writing-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                    </div>
                                            <?php } ?>
                                        <?php endif ?>

                                        <?php
                                            if ( $backlinks ):
                                                // remove first key
                                                array_shift( $backlinks );

                                                // remove second key (comment)
                                                if ( $backlinks["Page " . $pageNumber . " Content Writing Comment"] ) {
                                                    array_shift( $backlinks );
                                                }

                                                for ( $i=1; $i <= $keywordCount; $i++ ) {
                                        ?>
                                                    <div class="item-child item-child-backlinks" data-count="<?php echo $i; ?>">
                                                        <?php $x = 1; foreach ( $backlinks as $key => $value ): ?>
                                                            <?php
                                                                if ( strpos( $key, "Keyword " . $i ) !== false ):
                                                                    $label = $x == 1 ? "Your Backlinks" : "Competitor";
                                                                    $class = $x == 1 ? "" : "backlinks-competitor";
                                                            ?>
                                                                <fieldset class="<?php echo $class; ?>">
                                                                    <label for="<?php echo $key; ?>"><?php echo $label; ?></label>
                                                                    <input type="number" name="<?php echo $key; ?>" value="<?php echo $value; ?>">
                                                                </fieldset>
                                                            <?php $x++; endif; ?>
                                                        <?php endforeach; ?>
                                                        <a href="" class="remove-btn remove-backlinks-competitors hidden">&times; remove</a>
                                                        <br><a href="" class="small-btn add-backlinks-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                    </div>
                                            <?php } ?>
                                        <?php endif ?>
                                    </div>

                                    <div class="item item-comments">
                                        <label for="Page <?php echo $pageNumber; ?> Comments">Comments</label>
                                        <textarea name="Page <?php echo $pageNumber; ?> Comments" id="Page <?php echo $pageNumber; ?> Comments"><?php echo $formData["Page " . $pageNumber . " Comments"]; ?></textarea>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <button type="submit">Submit</button><a href="" class="remove-strategy">Delete Strategy</a>
                    </form>
                </div>
            <?php } else { ?>
                <div class="create-strategy-wrap">
                    <div class="cs-add-page">
                        <input type="text">
                        <a href="" id="add-cs-page">+ Add Page</a>
                    </div>

                    <form class="hidden" action="" id="create-strategy-form">
                        <input type="hidden" name="Customer ID" value="<?php echo $_POST["Customer_ID"]; ?>">
                        <input type="hidden" name="Page Count" value="">
                        <ul class="cs-header-tabs"></ul>
                        <div class="cs-content-tabs"></div>
                        <button type="submit" disabled>Submit</button><a href="" class="remove-strategy hidden">Delete Strategy</a>
                    </form>
                </div>
            <?php } ?>
<?php
        } else {
            $assignedCustomers = get_the_author_meta( "_assigned_customers", $user->ID );
            if ( $assignedCustomers ) {
?>
                <form id="assignedCustomersForm" action="" method="POST">
                    <select name="Customer ID" required>
                        <option value=''>- Select -</option>
                        <?php
                            foreach ( $assignedCustomers as $key => $customerId ) {
                                $customer = get_user_by( "id", $customerId );
                                if ( $customer ) { // check if customer exists
                                    $firstName = $customer->user_firstname;
                                    $lastName  = $customer->user_lastname;
                                    echo "<option value='" . $customerId . "'>" . $customerId . " - ". $firstName . " " . $lastName . "</option>";
                                }
                            }
                        ?>
                    </select>
                    <button type="submit">Submit</button>
                </form>
<?php
            }
        }
    } // end user validation
}

// create free seo strategy
/*add_action( 'wp_ajax__createStrategy', '_createStrategy' );
add_action( 'wp_ajax_nopriv__createStrategy', '_createStrategy' );
function _createStrategy(){
    $user     = wp_get_current_user();
    $formData = $_REQUEST["formData"];
    $empty    = $_REQUEST["empty"];

    // check if all data will be deleted
    if ( $empty == "true" ) {
       $strategies = [];
    } else {
        $strategies = get_the_author_meta( "seo_strategies", $user->ID );
        $strategies = $strategies ? $strategies : [];

        $strategies[$formData["Customer ID"]] = $formData;
    }

    // update seo strategies meta
    update_user_meta( $user->ID, "seo_strategies", $strategies );

    die();
}
*/

// pre populate data fields for form 10
/*add_filter('gform_field_value_account_manager_10', '_gform10AccountManagerId');
function _gform10AccountManagerId( $value ){
    $user = wp_get_current_user();
    return $user->ID;
}
add_filter('gform_field_value_customer_id_10', '_gform10CustomerId');
function _gform10CustomerId( $value ){
    return $_GET['user'];
}
add_filter('gform_field_value_customer_email_10', '_gform10CustomerEmail');
function _gform10CustomerEmail( $value ){
    $user = get_user_by( "id", $_GET['user'] );
    return $user->user_email;
}

// update order item custom meta with gform data -- form 10
add_action( 'gform_after_submission_10', '_gformAddReportDetails', 10, 2 );
function _gformAddReportDetails( $entry, $form ) {
    $account_manager_id = rgar( $entry, 3 );
    $customer_id        = rgar( $entry, 4 );
    $customer_email     = rgar( $entry, 5 );

    // get the order item entries if exists
    $rfdAccountManager = get_the_author_meta( "_reportFilesAndDetails", $account_manager_id );
    $rfdCustomer       = get_the_author_meta( "_reportFilesAndDetails", $customer_id );

    // if there is no data declare the variable
    if ( !is_array( $rfdAccountManager ) ) {
        $rfdAccountManager = array();
    }
    if ( !is_array( $rfdCustomer ) ) {
        $rfdCustomer = array();
    }

    // check if the value is already in the array
    if ( !in_array( $entry['id'], $rfdAccountManager ) ) {
        $rfdAccountManager[] = $entry['id'];
    }
    if ( !in_array( $entry['id'], $rfdCustomer ) ) {
        $rfdCustomer[] = $entry['id'];
    }

    // update the account manager meta and user meta
    update_user_meta( $account_manager_id, "_reportFilesAndDetails", $rfdAccountManager );
    update_user_meta( $customer_id, "_reportFilesAndDetails", $rfdCustomer );

    // $entry = GFAPI::get_entry( $entry_id );
    // echo "<div style='display:none;'>";
    // echo "</div>";
}*/

