<?php
/*
	seo-manager/assigned-orders/
	-- assigned orders to the account manager
*/
add_shortcode( 'assigned-orders', '_assigned_orders' );
function _assigned_orders() {
	ob_start();

	// get user data
	$user_id   = get_current_user_id();
	$user      = get_user_by("ID", $user_id);
	$user_role = $user->roles[0];
	
	// dd($user_role);
	// dd($user_id);

	if ($user_role == "account_manager") {

		// get all assigned customers
		$assigned_customers = get_the_author_meta("_assigned_customers", $user_id);

		// dd($assigned_customers);

		// if specific customer is assigned
		if (isset($_GET["cid"])) {
			// $customer_id = $_GET["customer"];
			$assigned_customers = array($_GET["cid"]);
		}

		// dd($assigned_customers);
		
		if ($assigned_customers) {
			// echo "<h3 class='assigned-orders-title'>Customer Orders</h3>";
			?>
				<div class="bg-white p-3 mb-3 border-top-5 border-orange">
					<div class="text fw-medium">Customer Orders</div>
				</div>
			<?php
			
			foreach ($assigned_customers as $customer_key => $customer_id) {

				$customer_id = (int)$customer_id;

				
				// customer data
				$customer = get_user_by("ID", $customer_id);
				$customer_first_name = $customer->first_name;
				$customer_last_name = $customer->last_name;
				$customer_email = $customer->user_email;

				/*
				// woocommerce order statuses
					'wc-pending'    => _x( 'Pending payment', 'Order status', 'woocommerce' ),
					'wc-processing' => _x( 'Processing', 'Order status', 'woocommerce' ),
					'wc-on-hold'    => _x( 'On hold', 'Order status', 'woocommerce' ),
					'wc-completed'  => _x( 'Completed', 'Order status', 'woocommerce' ),
					'wc-cancelled'  => _x( 'Cancelled', 'Order status', 'woocommerce' ),
					'wc-refunded'   => _x( 'Refunded', 'Order status', 'woocommerce' ),
					'wc-failed'     => _x( 'Failed', 'Order status', 'woocommerce' ),
				*/

				// check if a customer is already a customer / has bought a services
				/* $customer_has_bought = get_posts( array(
			        'numberposts' => 1, // one order is enough
			        'meta_key'    => '_customer_user',
			        'meta_value'  => $customer_id,
			        'post_type'   => 'shop_order', // WC orders post type
			        'post_status' => array('wc-completed', 'wc-cancelled', 'on-going'),
			        'fields'      => 'ids', // Return Ids "completed"
			    ) ); */

				$customer_has_bought = wc_get_orders(array(
					'customer' => $customer_id,
					'limit' => -1,
					'status' => array('wc-completed', 'wc-cancelled', 'on-going', 'wc-processing'),
				));

				// dd($customer_id);
				// dd($customer_has_bought);
				
				if (count($customer_has_bought) > 0) {
					// get subscription products first
					// get customer subscriptions
					$customer_subscriptions = get_posts( array(
					    // 'posts_per_page ' => 5,
					    'numberposts' => -1,
					    'meta_key'    => '_customer_user',
					    'meta_value'  => $customer_id, // Or $user_id or get_current_user_id()
					    'post_type'   => 'shop_subscription', // WC orders post type
					    'post_status' => 'wc-active', // Only orders with status "completed"
						// 'orderby'     => 'date', // newest
						// 'order'       => 'DESC',
					) );

					/* echo "<pre>";
					var_dump($customer_subscriptions);
					echo "</pre>"; */

					// declare related subscriptions
					$related_subscriptions = [];
					?>
					<table class='assigned-orders-table mt-3'>
						<thead>
							<tr>
								<th colspan="5" class="position-relative">
									<?php echo $customer_first_name . " " . $customer_last_name; ?> - <?php echo $customer_email; ?>
									<?php if(!isset($_GET["view"])){ ?>
										<form method="GET" class="d-inline-block position-absolute" style="right: 11px;top: 7px;">
											<input type="hidden" name="cid" value="<?php echo $customer_id; ?>">
											<input type="hidden" name="view" value="all">
											<button type="submit" class="btn-orange small-text px-2 lh-1 fw-regular" >View All Orders</button>
										</form>
									<?php } ?>
								</th>
							</tr>
							<tr>
								<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ): ?>
									<th class="woocommerce-orders-table__header woocommerce-orders-table__header-<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
								<?php endforeach; ?>
							</tr>	
						</thead>
						<?php

							$subscription_order_ids = "";

							// loop through all customer subscriptions
							if ($customer_subscriptions) {
								
								foreach ($customer_subscriptions as $key => $customer_subscription) {
									$subscription = new WC_Subscription($customer_subscription->ID);
									$subscription_parent_order = $subscription->get_parent_id();
									$subscription_order_ids = $subscription->get_related_orders();
									$related_subscriptions[] = $subscription_order_ids;

									
									// 
									if(isset($_GET["view"]) && $_GET["view"] == "all") { // show all
									} else {
										// get the first order
										$lastKey = key(array_slice($subscription_order_ids, -1, 1, true)); // this is the parent order
										$subscription_order_ids = array($lastKey);
										
										// cut the array to 5 -- only show 4 orders 5 if we add the first order above
										$subscription_order_ids = array_slice($subscription_order_ids, 0, 4);
									}

									// add the parent order to the first position of the array
									array_unshift($subscription_order_ids, $subscription_parent_order);

									// ongoing subscriptions
									if ($subscription_order_ids) {
										$ongoing_customer_orders = get_posts(array(
											'numberposts' => -1,
											// 'numberposts' => 5,
											// 'posts_per_page ' => 5,
											'post_type'   => wc_get_order_types( 'view-orders' ),
											'post_status' => array_keys( wc_get_order_statuses() ),
											// 'include'     => $subscription_order_ids,
											'post__in'     => $subscription_order_ids,
											// 'post__in'     => array($lastKey),
											'orderby'     => "post__in",
											// 'orderby'     => "DATE",
											// 'order'       => "ASC" 
										));

										if ($ongoing_customer_orders) {
										?>
											<!-- <table class="report-history-table <?php //echo $key == 0 ? "mt-3": ""; ?>"> -->
												
												<tbody>
													<?php
														foreach ($ongoing_customer_orders as $key => $subscription_order) {
															$order = wc_get_order( $subscription_order );
															$item_count = $order->get_item_count() - $order->get_item_count_refunded();
													?>
															
															<tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $order->get_status() ); ?> order">
																<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
																	<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
																		<?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
																			<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

																		<?php elseif ( 'order-number' === $column_id ) : ?>
																			<a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
																				<?php echo esc_html( _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number() ); ?>
																			</a>
																			<?php if ($key == 0): ?>- Managed Service<?php endif ?>

																		<?php elseif ( 'order-date' === $column_id ) : ?>
																			<time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

																		<?php elseif ( 'order-status' === $column_id ) : ?>
																			<?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>

																		<?php elseif ( 'order-total' === $column_id ) : ?>
																			<?php
																			/* translators: 1: formatted order total 2: total order items */
																			echo wp_kses_post( sprintf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ) );
																			?>

																		<?php elseif ( 'order-actions' === $column_id ) : ?>
																			<?php
																			$actions = wc_get_account_orders_actions( $order );

																			if ( ! empty( $actions ) ) {
																				foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
																					echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . ' Order</a>';
																				}
																			}
																			?>
																		<?php endif; ?>
																	</td>
																<?php endforeach; ?>
															</tr>	
													<?php } ?>
												</tbody>
											<!-- </table> -->
										<?php
										}
									}
								}
							}
							
							// if(isset($_GET["view"]) && $_GET["view"] == "all" ){

								// merge all orders and exclude them from main query below
								$exclude_in_main = array_merge(...$related_subscriptions);

								// get normal products
								$customer_orders = get_posts(array(
									// 'numberposts' => -1,
									'numberposts' => isset($_GET["view"]) && $_GET["view"] == "all" ? -1 : 5,
									'meta_key'    => '_customer_user',
									'meta_value'  => $customer_id,
									'post_type'   => wc_get_order_types( 'view-orders' ),
									'post_status' => array_keys( wc_get_order_statuses() ),
									'exclude'     => $exclude_in_main,
									'orderby'     => "DATE",
									'order'       => "DESC"
								));
								// $customer_orders = false;
								if ($customer_orders) {
									foreach ( $customer_orders as $customer_order ) {
										$order      = wc_get_order($customer_order); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
										$item_count = $order->get_item_count() - $order->get_item_count_refunded();
									?>
										<tr class="normal-orders woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $order->get_status() ); ?> order">
											<?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) : ?>
												<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
													<?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
														<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

													<?php elseif ( 'order-number' === $column_id ) : ?>
														<a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
															<?php echo esc_html( _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number() ); ?>
														</a>

													<?php elseif ( 'order-date' === $column_id ) : ?>
														<time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

													<?php elseif ( 'order-status' === $column_id ) : ?>
														<?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>

													<?php elseif ( 'order-total' === $column_id ) : ?>
														<?php
														/* translators: 1: formatted order total 2: total order items */
														echo wp_kses_post( sprintf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ) );
														?>

													<?php elseif ( 'order-actions' === $column_id ) : ?>
														<?php
														$actions = wc_get_account_orders_actions( $order );

														if ( ! empty( $actions ) ) {
															foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
																echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button button ' . sanitize_html_class( $key ) . '">View Order</a>';
															}
														}
														?>
													<?php endif; ?>
												</td>
											<?php endforeach; ?>
										</tr>
									<?php
									}
								} elseif(!$customer_orders && empty($subscription_order_ids)) {
								?>
									<tr class="no-orders woocommerce-orders-table__row woocommerce-orders-table__row--status-no-orders order">
										<td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-no-orders" colspan="6">
											<?php esc_html_e( 'No Packaged Service.', 'woocommerce' ); ?>
										</td>
									</tr>
								<?php
								}
							//} // end isset view
						?>
					</table>
				<?php
				/*echo "<pre>";
				var_dump($related_subscriptions);
				var_dump($exclude_in_main);
				echo "</pre>";*/
				} else {
				?>
					<div class="alert alert-warning rounded-0" role="alert">The customer doesn't have any active orders.</div>
				<?php
				}
			}
		} else {
		?>
			<div class="alert alert-danger rounded-0" role="alert">No assigned customer found.</div>
		<?php
		}
	} else {
	?>
		<div class="alert alert-danger rounded-0" role="alert">You don't have the correct permission to view this page.</div>
	<?php
	}

	return ob_get_clean();
}