<?php
add_shortcode( 'seo-customer-information', '_client_information' );
function _client_information() {

    // check get and post if client id is set
    if ( isset( $_GET['client_id'] ) ) {
        $client_id = $_GET['client_id'];
    } elseif ( isset( $_POST['client_id'] ) ) {
        $client_id = $_POST['client_id'];
    } else {
        $client_id = '';
    }

    // current manager user id
    $user_id = get_current_user_id();
    $current_user_obj = get_user_by("id", $user_id);
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">Client Information</div>
    </div>

    <?php
    // bootstrap notification
    if(isset($_POST['save_google_drive_id']) && $_POST['save_google_drive_id'] == "true"){
    ?>
        <div class="alert alert-success alert-dismissible fade show rounded-0" role="alert">
            <strong>Success!</strong> Your changes have been saved.
        </div>
    <?php
    }

    // 
    if(in_array("administrator", $current_user_obj->roles)){

        // get all customers
        $customers_per_page = 10;
        $allcustomers_query = array(
            'role__in' => array("customer", "subscriber"),
            'number'   => -1,
            'fields'   => array('id')
        );
        /* $all_customers = get_users(array(
            'role__in' => array("customer", "subscriber"),
            'number'   => -1,
            'fields'   => array('id')
        )); */
        $assignedcus_query = array(
            'role__in' => array("customer", "subscriber"),
            'number'   => $customers_per_page,
            'paged'    => 1
        );
        /* $assigned_customers = get_users(array(
            'role__in' => array("customer", "subscriber"),
            'number'   => $customers_per_page,
            'paged'    => 1
        )); */
        

        // merge customer into one array
        if(isset($_GET["cid"])){

            $assignedcus_query = array_merge($assignedcus_query, array(
                'include' => array($_GET["cid"]),
            ));
            $allcustomers_query = array_merge($allcustomers_query, array(
                'include' => array($_GET["cid"]),
            ));

        }
        
        // get current page url with query string
        /* $current_page_url = get_current_page_url();
        echo "<pre>";
        var_dump($current_page_url);
        echo "</pre>"; */

        /* global $wp;

        // get current url with query string.
        $current_url =  home_url( $wp->request ); 

        // get the position where '/page.. ' text start.
        $pos = strpos($current_url , '/page');

        // remove string from the specific postion
        $finalurl = substr($current_url,0,$pos); */

     /*    echo "<pre>";
        var_dump(get_site_url());
        echo "</pre>"; 
         */

        $assigned_customers = get_users($assignedcus_query);
        $all_customers = get_users($allcustomers_query);

    } else {

        // get all assigned customers
        $assigned_customers = get_the_author_meta("_assigned_customers", $user_id);
    }


    // ob start
    ob_start();

    // check if the client id exists
    if(!$client_id){

        // check if there are assigned customers
        if($assigned_customers && !in_array("administrator", $current_user_obj->roles)){
?>
            <table class="table bg-white">
                <thead>
                    <tr>
                        <th class="fw-regular text">Name</th>
                        <th class="fw-regular text">Email</th>
                        <th class="fw-regular text"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    foreach($assigned_customers as $key => $customer_id){
                        $user       = get_user_by("id", $customer_id);
                        $first_name = isset($user->first_name) ? $user->first_name : "";
                        $last_name  = isset($user->last_name) ? $user->last_name : "";
                        $email      = isset($user->user_email) ? $user->user_email : "";

                        if($user){
                    ?>
                            <tr>
                                <td class="text"><?php echo $first_name; ?> <?php echo $last_name; ?></td>
                                <td class="text"><?php echo $email; ?></td>
                                <td class="text">
                                    <form action="" method="GET" class="d-inline-block">
                                        <input type="hidden" name="client_id" value="<?php echo $customer_id; ?>">
                                        <!-- <button type="submit" class="btn-orange-outline py-2 px-3 rounded-0 text lh-1">View Information</button> -->
                                        <button type="submit" class="d-inline-block btn-orange rounded-0 my-1 lh-1 p-2 mr-1 small-text">View Information</button>
                                    </form>
                                    <a href="<?php echo get_site_url(); ?>/seo-manager/todos/?cid=<?php echo $customer_id; ?>" class="d-inline-block btn-orange-outline rounded-0 my-1 lh-1 p-2 mr-1 small-text">Todo List</a>
                                    <a href="<?php echo get_site_url(); ?>/seo-manager/assigned-orders/?cid=<?php echo $customer_id; ?>" class="d-inline-block btn-orange-outline rounded-0 my-1 lh-1 p-2 mr-1 small-text">View Orders</a>
                                    <a href="<?php echo get_site_url(); ?>/seo-manager/seo-strategy/?cid=<?php echo $customer_id; ?>" class="d-inline-block btn-orange-outline rounded-0 my-1 lh-1 p-2 mr-1 small-text">SEO Strategy</a>
                                    <a href="<?php echo get_site_url(); ?>/seo-manager/?cid=<?php echo $customer_id; ?>&view=user" class="d-inline-block btn-orange-outline rounded-0 my-1 lh-1 p-2 mr-1 small-text">View As</a>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php } ?>
                </tbody>
            </table>
        <?php } // !assigned customers ?>
    <?php }?>
    
    <!-- the information -->
    <?php
    if($client_id){ 

        // $customer_id = 1; // this is for testing
        $customer_id  = $client_id;
        $customer_obj = get_user_by("id", $customer_id);
        
        // woocommerce variables
        $customer_wc = new WC_Customer($customer_id);
        $billing     = $customer_wc->get_billing();
        $gform_entry = $customer_wc->get_meta("entry_id");
        $total_spent = $customer_wc->get_total_spent();
        $total_spent_formatted = wc_price($total_spent);

        // gform
        // What are you? - 18
        // What are you? (Other) - 17
        // Website - 20
        // I'm intrested in - 19
        if($gform_entry){
            $form_entry         = GFAPI::get_entry($gform_entry);
            $what_are_you       = rgar($form_entry, "18");
            $what_are_you_other = rgar($form_entry, "17");
            $website            = rgar($form_entry, "20");
            $interested_in      = rgar($form_entry, "19");
            $date_joined        = $form_entry["date_created"];

            // REMOVE ONCE NOT NEEDED
            // saveUserWebsite($website, $customer_id);
        }
    ?>
        <table class="table bg-white mt-3">
            <thead>
                <tr>
                    <th class="text fw-regular" colspan="2">Customer Information</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text">Name</td>
                    <td class="text"><?php echo $customer_obj->first_name; ?> <?php echo $customer_obj->last_name; ?></td>
                </tr>
                <tr>
                    <td class="text">Email</td>
                    <td class="text"><?php echo $customer_obj->user_email; ?></td>
                </tr>
                <tr>
                    <td class="text">Phone Number</td>
                    <td class="text"><?php echo $customer_wc->get_billing_phone(); ?></td>
                </tr>
                <?php if($gform_entry){ ?>
                    <tr>
                        <td class="text">Date Joined</td>
                        <td class="text"><?php echo date("F j, Y (g:i a)", strtotime($date_joined)); ?></td>
                    </tr>
                <?php } ?>
                <?php if($website){ ?>
                    <tr>
                        <td class="text">Website</td>
                        <td class="text"><?php echo $website; ?></td>
                    </tr>
                <?php } // ?>
                <tr>
                    <td class="text">Company Name</td>
                    <td class="text"></td>
                </tr>
                <?php if($customer_wc->get_billing()){ ?>
                    <tr>
                        <td class="text">Address</td>
                        <td class="text"><?php
                            echo $billing["address_1"] . " " . $billing["address_2"] . " " . $billing["city"] . "" . $billing["essex"] . " " . $billing["postcode"];
                        ?></td>
                    </tr>
                <?php } // if billing ?>
                <tr>
                    <td class="text">Total Spent</td>
                    <td class="text"><?php echo $total_spent_formatted; ?></td>
                </tr>
            </tbody>
        </table>
        
        <!-- sign up form entries -->
        <?php if($gform_entry){ ?> 
            <table class="table bg-white mt-3">
                <thead>
                    <tr>
                        <th colspan="2" class="text fw-regular">Sign Up Form Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($what_are_you){ ?>
                        <tr>
                            <td class="text">What are you?</td>
                            <td class="text"><?php echo $what_are_you; ?></td>
                        </tr>
                    <?php } ?>
                    <?php if($what_are_you_other){ ?>
                        <tr>
                            <td class="text">What are you? (Other)</td>
                            <td class="text"><?php echo $what_are_you_other; ?></td>
                        </tr>
                    <?php } ?>
                    <?php if($interested_in){ ?>
                        <tr>
                            <td class="text">Interested in</td>
                            <td class="text"><?php echo $interested_in; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        <?php } //gform ?>

        <!--  -->
        <?php
            // get user google drive id meta
            $google_drive_id = get_user_meta($customer_id, "google_drive_id", true);
            $google_drive_id = isset($_POST["google_drive_id"]) ? $_POST["google_drive_id"] : $google_drive_id;

            // save the google drive id
            save_google_drive_id($customer_id, $google_drive_id);
        ?>
        <table class="table bg-white mt-3">
            <thead>
                <tr>
                    <th colspan="2" class="text fw-regular">Additional Customer Data</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Google Drive Folder ID</td>
                    <td>
                        <form action="" method="POST">
                            <input type="hidden" name="save_google_drive_id" value="true">
                            <input type="hidden" name="client_id" value="<?php echo $customer_id; ?>">
                            <input type="text" class="rounded-0 lh-1 w-100" name="google_drive_id" value="<?php echo $google_drive_id; ?>"><br>
                            <button type="submit" class="mt-1 rounded-0 btn-orange-outline py-2 px-3 small-text lh-1">Submit</button>
                        </form>
                    </td>
                </tr>
            </tbody> 
        </table>
    <?php } ?>

    <!-- for admin view -->
    <?php if(in_array("administrator", $current_user_obj->roles) && !$client_id){ ?>
        <?php
            // get managers
            $seo_managers = get_users(array(
                'role__in' => array("account_manager"),
                'number'   => -1,
                'fields'   => array("id", "user_email")
            ));
        ?>
        <div class="assigned-orders-filter">
            <form action="">
                <!-- <h3>Filter Results</h3> -->
                <input type="text" placeholder="Search by name">
                <select name="" id="by_manager">
                    <option value="">-- Filter by Manager --</option>
                    <?php foreach($seo_managers as $key => $seo_manager){ ?>
                        <option value="<?php echo $seo_manager->user_email; ?>"><?php echo $seo_manager->user_email; ?></option>
                    <?php } ?>
                </select>
                <select name="user_rating" id="by_user_rating">
                    <option value="All" selected>All</option>  
                    <option value="User">User</option>
                    <option value="Bronze">Bronze</option>
                    <option value="Silver">Silver</option>
                    <option value="Gold">Gold</option>
                    <option value="Platinum">Platinum</option>
                </select>
                <button type="submit">Filter</button>
                <a href="<?php echo get_site_url(); ?>/seo-manager/client-information/">Reset Filter</a>
            </form>
        </div>
        <div class="assigned-orders-admin-table">
            <!-- <table class="assigned-orders-table"> -->
            <table class="table bg-white mt-3">
                <thead>
                    <tr>
                        <th class="text fw-regular">Name</th>
                        <th class="text fw-regular">Rating</th>
                        <th class="text fw-regular">Email</th>
                        <th class="text fw-regular">Assigned Manager</th>
                        <th class="text fw-regular">Total Spent</th>
                        <th class="text fw-regular">Client Information</th>
                    </tr>
                </thead>
                <tbody>
                    <?php //if(in_array("administrator", $current_user_obj->roles)){

                        // 
                        foreach($assigned_customers as $key => $customer){

                            // get total spent per customer
                            $customer_wc = new WC_Customer($customer->ID);
                            $total_spent = $customer_wc->get_total_spent();
                            $total_spent_formatted = wc_price($total_spent);

                            // user rating switch case
                            switch($total_spent){
                                case $total_spent >= 500 && $total_spent < 1000:
                                    $user_rating = "Bronze";
                                    break;
                                case $total_spent >= 1000 && $total_spent < 2500:
                                    $user_rating = "Silver";
                                    break;
                                case $total_spent >= 2500 && $total_spent < 5000:
                                    $user_rating = "Gold";
                                    break;
                                case $total_spent >= 5000:
                                    $user_rating = "Platinum";
                                    break;
                                default:
                                    $user_rating = "User";
                            }
                            

                            // 
                            $customer_manager = get_the_author_meta( "_assigned_account_manager", $customer->ID );
                        ?>
                            <tr data-customer-id="<?php echo $customer->ID; ?>">
                                <td class="text"><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
                                <td class="text"><?php echo $user_rating; ?></td>
                                <td class="text"><?php echo $customer->user_email; ?></td>
                                <td class="text">
                                    <select name="" class="select-manager w-100">
                                        <option value="">-- Select a Manager --</option>
                                        <?php foreach($seo_managers as $key => $sm){ ?>
                                            <option value="<?php echo $sm->id; ?>" <?php echo $customer_manager == $sm->user_email ? "selected" : ""; ?>><?php echo $sm->user_email; ?></option>
                                        <?php } ?>
                                    </select>
                                    <a href="" class="select-manager-save">Save</a>
                                </td>
                                <td class="text"><?php echo $total_spent_formatted; ?></td>
                                <td class="text">
                                    <form action="" method="POST" class="td-client-form">
                                        <input type="hidden" value="<?php echo $customer->ID; ?>" name="client_id">
                                        <button class="btn-orange-outline lh-1 rounded-0 text py-2 px-3" type="submit">View Information</button>
                                    </form>
                                </td>
                            </tr>
                        <?php
                        }
                    //} ?>
                </tbody>
            </table>
        </div>
        <div class="table-pagination user-pagination" data-customers-per-page="<?php echo $customers_per_page; ?>">
            <?php
                // var_dump(ceil(count($all_customers) / 10));
                $i = 1;
                while($i <= ceil(count($all_customers) / 10)){
                    $active_class = $i == 1 ? "active" : "";
                    echo "<div class='paginate-item " . $active_class . "'>" . $i . "</div>";
                    $i++;
                }
            ?>
        </div>
    <?php } ?>
<?php
    // return
    return ob_get_clean();
}

// ajax client informationd ata
add_action("wp_ajax_nopriv__client_information_data", "_client_information_data");
add_action("wp_ajax__client_information_data", "_client_information_data");
function _client_information_data(){

    // variables
    $customer_id  = $_REQUEST["customer_id"];
    $customer_obj = get_user_by("id", $customer_id);

    // 
    $customer_wc = new WC_Customer($customer_id);
    $billing     = $customer_wc->get_billing();
    $gform_entry = $customer_wc->get_meta("entry_id");
    $total_spent = $customer_wc->get_total_spent();
    $total_spent_formatted = wc_price($total_spent);

    // user rating switch case
    switch($total_spent){
        case $total_spent >= 500 && $total_spent < 1000:
            $user_rating = "Bronze";
            break;
        case $total_spent >= 1000 && $total_spent < 2500:
            $user_rating = "Silver";
            break;
        case $total_spent >= 2500 && $total_spent < 5000:
            $user_rating = "Gold";
            break;
        case $total_spent >= 5000:
            $user_rating = "Platinum";
            break;
        default:
            $user_rating = "User";
    }

    // gform
    // What are you? - 18
    // What are you? (Other) - 17
    // Website - 20
    // I'm intrested in - 19
    if($gform_entry){
        $form_entry         = GFAPI::get_entry($gform_entry);
        $what_are_you       = rgar($form_entry, "18");
        $what_are_you_other = rgar($form_entry, "17");
        $website            = rgar($form_entry, "20");
        $interested_in      = rgar($form_entry, "19");
        $date_joined        = $form_entry["date_created"];
    }
    ?>
        <table class="assigned-orders-table mt-3">
            <thead>
                <tr>
                    <th colspan="2">Customer Information</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Name</td>
                    <td><?php echo $customer_obj->first_name; ?> <?php echo $customer_obj->last_name; ?></td>
                </tr>
                <tr>
                    <td>Email</td>
                    <td><?php echo $customer_obj->user_email; ?></td>
                </tr>
                <tr>
                    <td>Phone Number</td>
                    <td><?php echo $customer_wc->get_billing_phone(); ?></td>
                </tr>
                <?php if($gform_entry){ ?>
                    <tr>
                        <td>Date Joined</td>
                        <td><?php echo date("F j, Y (g:i a)", strtotime($date_joined)); ?></td>
                    </tr>
                <?php } // ?>
                <?php if($website){ ?>
                    <tr>
                        <td>Website</td>
                        <td><?php echo $website; ?></td>
                    </tr>
                <?php } // ?>
                <?php if($customer_wc->get_billing()){ ?>
                    <tr>
                        <td>Address</td>
                        <td><?php
                            echo $billing["address_1"] . " " . $billing["address_2"] . " " . $billing["city"] . "" . $billing["essex"] . " " . $billing["postcode"];
                        ?></td>
                    </tr>
                <?php } // if billing ?>
                <tr>
                    <td>Total Spent</td>
                    <td><?php echo $total_spent_formatted; ?></td>
                </tr>
            </tbody>
        </table>
        <?php if($gform_entry){ ?> 
            <table class="assigned-orders-table mt-3">
                <thead>
                    <tr>
                        <th colspan="2">Sign Up Form Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($what_are_you){ ?>
                        <tr>
                            <td>What are you?</td>
                            <td><?php echo $what_are_you; ?></td>
                        </tr>
                    <?php } ?>
                    <?php if($what_are_you_other){ ?>
                        <tr>
                            <td>What are you? (Other)</td>
                            <td><?php echo $what_are_you_other; ?></td>
                        </tr>
                    <?php } ?>
                    <?php if($interested_in){ ?>
                        <tr>
                            <td>Interested in</td>
                            <td><?php echo $interested_in; ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        <?php } //gform ?>
        
        <table class="table mt-3">
            <thead>
                <tr>
                    <th colspan="2">Additional Customer Data</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Google Drive Folder ID</td>
                    <td>
                        <form action="" method="POST">
                            <input type="hidden" name="" value="<?php echo $_POST["customer_id"]; ?>">
                            <input type="text" name="" value="">
                            <button type="submit">Submit</button>
                        </form>
                    </td>
                </tr>
            </tbody> 
        </table>
    <?php

    die();
}

// save account manager information to user
add_action("wp_ajax_nopriv__save_account_manager_user_information", "_save_account_manager_user_information");
add_action("wp_ajax__save_account_manager_user_information", "_save_account_manager_user_information");
function _save_account_manager_user_information(){

    $user_id = $_REQUEST["customer_id"]; // customer id
    $manager_id = $_REQUEST["manager_id"];
    $manager_email = $_REQUEST["manager_email"];

    // get new account manager by email
    $account_manager = get_user_by( "email", $manager_email);

    // check if the account manager has a value
    if ( $account_manager ) {

        // get the assigned customers of the account manager
        $assignedCustomers = get_the_author_meta( "_assigned_customers", $account_manager->ID );

        // check if the assigned customers array exists
        if ( !$assignedCustomers ) {
            $assignedCustomers = array();
        }

        // check if the user id is already in the array of assigned customers
        if ( !in_array( $user_id, $assignedCustomers ) ) {
            
            // insert into array if not
            $assignedCustomers[] = $user_id;

            // update account manager
            update_user_meta( $account_manager->ID, "_assigned_customers", $assignedCustomers );
        }
    } else {
        // if the current account manager is blank / error
        // remove the account manager from this customer
        
        // get the current account manager
        $currentAccountManager = get_the_author_meta( "_assigned_account_manager", $user_id );

        // get the account manager user object
        $accountManager = get_user_by( "email", $currentAccountManager );

        // get the assigned customers of the account manager
        $assignedCustomers = get_the_author_meta( "_assigned_customers", $accountManager->ID );
        
        // check if the assigned customers array exists
        if ( !$assignedCustomers ) {
            $assignedCustomers = array();
        }
        
        // remove the customers account on the account managers account
        if ( ( $key = array_search( $user_id, $assignedCustomers ) ) !== false) {
            unset( $assignedCustomers[$key] );
        }

        // update account manager
        update_user_meta( $accountManager->ID, "_assigned_customers", $assignedCustomers );
    }

    // update customer account manager
    update_user_meta( $user_id, "_assigned_account_manager", $manager_email );

    die();
}

// save account manager information to user
add_action("wp_ajax_nopriv__paginate_user_table", "_paginate_user_table");
add_action("wp_ajax__paginate_user_table", "_paginate_user_table");
function _paginate_user_table(){

    // page
    $page = intval($_REQUEST["page"]);
    $customers_per_page = intval($_REQUEST["customers_per_page"]);

    $assigned_customers = get_users(array(
        'role__in' => array("customer", "subscriber"),
        'number'   => $customers_per_page,
        'paged'    => $page
    ));
?>
    <table class="table bg-white mt-3">
        <thead>
            <tr>
                <th class="text fw-regular">Name</th>
                <th class="text fw-regular">Rating</th>
                <th class="text fw-regular">Email</th>
                <th class="text fw-regular">Assigned Manager</th>
                <th class="text fw-regular">Total Spent</th>
                <th class="text fw-regular">Client Information</th>
            </tr>
        </thead>
        <tbody>
            <?php
                // get managers
                $seo_managers = get_users(array(
                    'role__in' => array("account_manager"),
                    'number'   => -1,
                    'fields'   => array("id", "user_email")
                ));

                // 
                foreach($assigned_customers as $key => $customer){

                    // get total spent per customer
                    $customer_wc = new WC_Customer($customer->ID);
                    $total_spent = $customer_wc->get_total_spent();
                    $total_spent_formatted = wc_price($total_spent);

                    // user rating switch case
                    switch($total_spent){
                        case $total_spent >= 500 && $total_spent < 1000:
                            $user_rating = "Bronze";
                            break;
                        case $total_spent >= 1000 && $total_spent < 2500:
                            $user_rating = "Silver";
                            break;
                        case $total_spent >= 2500 && $total_spent < 5000:
                            $user_rating = "Gold";
                            break;
                        case $total_spent >= 5000:
                            $user_rating = "Platinum";
                            break;
                        default:
                            $user_rating = "User";
                    }

                    // 
                    $customer_manager = get_the_author_meta( "_assigned_account_manager", $customer->ID );
                    
            ?>
                    <tr data-customer-id="<?php echo $customer->ID; ?>">
                        <td class="text"><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
                        <td class="text"><?php echo $user_rating; ?></td>
                        <td class="text"><?php echo $customer->user_email; ?></td>
                        <td class="text">
                            <select name="" class="select-manager w-100">
                                <option value="">-- Select a Manager --</option>
                                <?php foreach($seo_managers as $key => $sm){ ?>
                                    <option value="<?php echo $sm->id; ?>" <?php echo $customer_manager == $sm->user_email ? "selected" : ""; ?>><?php echo $sm->user_email; ?></option>
                                <?php } ?>
                            </select>
                            <a href="" class="select-manager-save">Save</a>
                        </td>
                        <td class="text"><?php echo $total_spent_formatted; ?></td>
                        <td class="text">
                            <form action="" method="POST" class="td-client-form">
                                <input type="hidden" value="<?php echo $customer->ID; ?>" name="client_id">
                                <button class="btn-orange-outline lh-1 rounded-0 text py-2 px-3" type="submit">View Information</button>
                            </form>
                        </td>
                    </tr>
            <?php } ?>
        </tbody>
    </table>
<?php

    die();
}

/*
 * /seo-manager/client-information/
 * 
 */
add_action("wp_ajax_nopriv__filter_user_table", "_filter_user_table");
add_action("wp_ajax__filter_user_table", "_filter_user_table");
function _filter_user_table(){

    // 
    $search_term = $_REQUEST["search_term"];
    $search_manager = $_REQUEST["search_manager"];
    $search_user_rating = $_REQUEST["search_user_rating"];
    $filter_results = "";

    $filter_args = array(
        'role__in' => array("customer", "subscriber"),
        'number'   => -1,
        'fields'   => array("id", "user_email")
    );
    if($search_term){
        $filter_args = array_merge($filter_args, array(
            'search' => $search_term . "*"
        ));
    }
    if($search_manager){
        $filter_args = array_merge($filter_args, array(
            'meta_key'   => "_assigned_account_manager",
            'meta_value' => $search_manager
        ));
    }
    if($search_term || $search_manager || $search_user_rating){
        $filter_results = get_users($filter_args);
    }
?>
        <table class="table bg-white mt-3">
            <thead>
                <tr>
                    <th class="text fw-regular">Name</th>
                    <th class="text fw-regular">Rating</th>
                    <th class="text fw-regular">Email</th>
                    <th class="text fw-regular">Assigned Manager</th>
                    <th class="text fw-regular">Total Spent</th>
                    <th class="text fw-regular">Client Information</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if($filter_results){

                        // get managers
                        $seo_managers = get_users(array(
                            'role__in' => array("account_manager"),
                            'number'   => -1,
                            'fields'   => array("id", "user_email")
                        ));

                        // validate users
                        $validate_users = [];

                        foreach($filter_results as $key => $customer){

                            // get total spent per customer
                            $customer_wc = new WC_Customer($customer->id);
                            $total_spent = $customer_wc->get_total_spent();
                            $total_spent_formatted = wc_price($total_spent);

                            // user rating switch case
                            switch($total_spent){
                                case $total_spent >= 500 && $total_spent < 1000:
                                    $user_rating = "Bronze";
                                    break;
                                case $total_spent >= 1000 && $total_spent < 2500:
                                    $user_rating = "Silver";
                                    break;
                                case $total_spent >= 2500 && $total_spent < 5000:
                                    $user_rating = "Gold";
                                    break;
                                case $total_spent >= 5000:
                                    $user_rating = "Platinum";
                                    break;
                                default:
                                    $user_rating = "User";
                            }

                            // check user rating
                            if($search_user_rating){
                                if($search_user_rating != $user_rating && $search_user_rating != "All"){
                                    continue;
                                }
                            }

                            // 
                            $customer_manager = get_the_author_meta("_assigned_account_manager", $customer->id);

                            // customer object
                            $customer = get_user_by("id", $customer->id);
                ?>
                            <tr data-customer-id="<?php echo $customer->ID; ?>">
                                <td class="text"><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
                                <td class="text"><?php echo $user_rating; ?></td>
                                <td class="text"><?php echo $customer->user_email; ?></td>
                                <td class="text">
                                    <select name="" class="select-manager w-100">
                                        <option value="">-- Select a Manager --</option>
                                        <?php foreach($seo_managers as $key => $sm){ ?>
                                            <option value="<?php echo $sm->id; ?>" <?php echo $customer_manager == $sm->user_email ? "selected" : ""; ?>><?php echo $sm->user_email; ?></option>
                                        <?php } ?>
                                    </select>
                                    <a href="" class="select-manager-save">Save</a>
                                </td>
                                <td class="text"><?php echo $total_spent_formatted; ?></td>
                                <td class="text">
                                    <form action="" method="POST" class="td-client-form">
                                        <input type="hidden" value="<?php echo $customer->ID; ?>" name="client_id">
                                        <button type="submit" class="btn-orange-outline py-2 px-3 rounded-0 text lh-1">View Information</button>
                                    </form>
                                </td>
                            </tr>
                <?php   
                        // 
                        $validate_users[] = $customer->id;

                        } // end foreach

                        // check if there are no results
                        if(!$validate_users){
                ?>
                            <tr>
                                <td colspan="4">Customer not found</td>
                            </tr>
                <?php
                        }
                    } else {
                ?>
                        <tr>
                            <td colspan="4">Customer not found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php
    die();
}

// save the google drive id to the user meta
function save_google_drive_id($customer_id = NULL, $google_drive_id = NULL){

    // check if the data needs to be saved
    if(isset($_POST["save_google_drive_id"]) && $_POST["save_google_drive_id"] == "true" && $customer_id && $google_drive_id){

        // save the google drive id to the user meta
        update_user_meta($customer_id, "google_drive_id", $google_drive_id);
    }
}