<?php
add_shortcode( 'dashboard-overview', 'dashboardOverview' );
function dashboardOverview() {
	ob_start();

    /*
    	User ID's
		- seo manager : 120
	    - test user : 121
	    - arman safehouse : 124
	    - adam amgas : 123

    	===

		User Roles
		- account_manager
		- administrator
		- customer
		- subscriber
    */

	// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$user_id = $user_id ? $user_id : get_current_user_id();
    $user            = get_user_by("ID", $user_id);
    $user_email      = $user->user_email;
    $user_role       = $user->roles[0];
    $user_first_name = $user->first_name;
    $user_last_name  = $user->last_name;
	
    // check if customer has a managed order
    // for customers only
    $managed_orders_urls = [];
    if ($user_role == "customer" || $user_role == "subscriber") {
	    $customer_orders = wc_get_orders( array(
	    	'post_status' => array("on-going"),
		    'customer_id' => $user_id,
		    'orderby'     => 'date',
		    'order'       => 'DESC',
		) );
	    foreach ($customer_orders as $key => $order_obj) {
	    	$order = new WC_Order( $order_obj->ID );
	    	$order_items = $order->get_items();

	    	foreach ($order_items as $key => $item) {
	    		$page_product_id = "";
	    		$website = $item->get_meta( 'Website URL', true );

	    		// get order line item meta data
	    		$formattedMetaData = $item->get_formatted_meta_data( '_', true );

	    		if ($formattedMetaData) {
	    			foreach ($formattedMetaData as $key => $md) {
	    				if ( $md->key == "Product ID" ) {
	    					// this is the page id
	                		$page_product_id = $md->value;
	            		}
	    			}
	    		}
	    		 
	    		// check if the product id is in the array of managed services
	    		if (in_array($page_product_id, MANAGED_SERVICES)) {
		    		// check if the website is already in the array
		    		if (!in_array($website, $managed_orders_urls)) {
		    			$managed_orders_urls[] = preg_replace('/^www\./', '', trim($website, "/")); // remove slash "/"
		    		}
	    		}
	    	}
	    }
    } elseif ($user_role == "account_manager") {
    	$assigned_customers = get_users( array(
	       'meta_key'    => "_assigned_account_manager",
	       'meta_value'  => $user_email,
	       'number'      => -1,
	       'count_total' => false
	    ) );
    	
    	foreach ($assigned_customers as $key => $customer) {
		    $customer_orders = wc_get_orders( array(
		    	'post_status' => array("on-going"),
			    'customer_id' => $customer->ID,
			    'orderby'     => 'date',
			    'order'       => 'DESC',
			) );

			foreach ($customer_orders as $key => $order_obj) {
		    	$order = new WC_Order( $order_obj->ID );
		    	$order_items = $order->get_items();

		    	foreach ($order_items as $key => $item) {
		    		$page_product_id = "";
		    		$website = $item->get_meta( 'Website URL', true );

		    		// get order line item meta data
		    		$formattedMetaData = $item->get_formatted_meta_data( '_', true );

		    		if ($formattedMetaData) {
		    			foreach ($formattedMetaData as $key => $md) {
		    				if ( $md->key == "Product ID" ) {
		    					// this is the page id
		                		$page_product_id = $md->value;
		            		}
		    			}
		    		}
		    		 
		    		// check if the product id is in the array of managed services
		    		if (in_array($page_product_id, MANAGED_SERVICES)) {
			    		// check if the website is already in the array
			    		if (!in_array($website, $managed_orders_urls)) {
			    			$managed_orders_urls[] = preg_replace('/^www\./', '', trim($website, "/")); // remove slash "/"
			    		}
		    		}
		    	}
		    }
    	}
    } elseif ($user_role == "administrator"){
    	// administrators should be able to see all projects regardless
    	foreach ($all_projects["data"] as $key => $project_data) {
    		$managed_orders_urls[] = preg_replace('/^www\./', '', trim($project_data["domain"], "/"));
    	}
    }

	/* // GET ORDER 6615
	$ASDASDASDASD = wc_get_order( 6615 );
	$billing_first_name = $ASDASDASDASD->get_billing_first_name();
	$billing_last_name = $ASDASDASDASD->get_billing_last_name();
	$billing_email = $ASDASDASDASD->get_billing_email();
	// IF ORDER HAS SUBSCRIPTION
	$validate_subscription = [];
	// LOOP OVER ORDER ITEMS
	foreach ( $ASDASDASDASD->get_items() as $item_id => $item ) {
		// DATA
		$product_id = $item->get_product_id();
		$product = $item->get_product();
		$item_type = $product->get_type();
		// CHECK IF ITEM TYPE HAS STRING SUBSCRIPTION
		if (strpos($item_type, 'subscription') !== false) {
			$validate_subscription[] = true;
		}
	}
	dd($validate_subscription); */
?>

	<!--  -->
	<div>
		<div class="container-fluid p-0">
			<div class="row">
				<div class="col-12">
					<div class="header-5 fw-bold mb-1">Hello, <?php echo $user_first_name; ?></div>
					<div class="text fw-light lh-1"><?php echo ucwords(str_replace("_", " ", $user_role)); ?></div>
				</div>
			</div>

			<?php
				

				// GET USER WEBSITES
				/* $user_websites = get_user_meta( $user_id, '_user_websites', true );
				dd($user_websites); */
			?>

			<!-- LINE AFTER THE TITLE -->
			<div class="row"><div class="col-12"><hr class="hr my-4"></div></div>

			<?php if ($user_role == "administrator"){

				// customers not assigned
				$customers = get_users(array(
					'role'    => 'subscriber',
					'orderby' => 'user_nicename',
					'order'   => 'ASC',
					// meta
					'meta_query' => array
					(
						'relation' => 'OR',
						array(
							'key' => '_assigned_account_manager',
							'value' => '-- Select a Manager --',
							'compare' => '=='
						),
						array(
							'key' => '_assigned_account_manager',
							'compare' => 'NOT EXISTS'
						)
					)
				));

				// assigned customers
				$assignedcustomers_all = get_users(array(
					'role'    => 'subscriber',
					'orderby' => 'user_nicename',
					'order'   => 'ASC',
					// limit
					'number' => -1,
					// meta
					'meta_query' => array
					(
						'relation' => 'AND',
						array(
							'key' => '_assigned_account_manager',
							'value' => '-- Select a Manager --',
							'compare' => '!='
						),
						array(
							'key' => '_assigned_account_manager',
							'compare' => 'EXISTS'
						)
					)
				));
			?>
				<table class="table bg-white">
					<thead>
						<tr>
							<th class="text fw-medium" colspan="4">Unassigned Customers</th>
						</tr>
						<tr>
							<th class="text fw-medium">Name</th>
							<th class="text fw-medium">Email</th>
							<th class="text fw-medium">Date Registered</th>
							<th class="text fw-medium"></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach($customers as $key => $customer){ ?>
							<tr>
								<td class="text"><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
								<td class="text"><?php echo $customer->user_email; ?></td>
								<td class="text"><?php echo date('F j, Y', strtotime($customer->user_registered)); ?></td>
								<td class="text"><a href="<?php echo get_site_url(); ?>/seo-manager/client-information/?cid=<?php echo $customer->ID; ?>">Assign Customer</a></td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
				<table class="table bg-white">
					<thead>
						<tr>
							<th class="text fw-medium" colspan="4">Active Customers</th>
						</tr>
						<tr>
							<th class="text fw-medium">Name</th>
							<th class="text fw-medium">Email</th>
							<th class="text fw-medium">Date Registered</th>
							<th class="text fw-medium"></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach($assignedcustomers_all as $key => $customer){ ?>
							<tr>
								<td class="text"><?php echo $customer->first_name; ?> <?php echo $customer->last_name; ?></td>
								<td class="text"><?php echo $customer->user_email; ?></td>
								<td class="text"><?php echo date('F j, Y', strtotime($customer->user_registered)); ?></td>
								<td class="text"><a href="<?php echo get_site_url(); ?>/seo-manager/client-information/?client_id=<?php echo $customer->ID; ?>">View Information</a></td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
			<?php } ?>

			<!--  -->
			<?php
			if ($user_role == "account_manager"){

				// get all assigned customers
				$assigned_customers = get_the_author_meta("_assigned_customers", $user_id);

				// customers w/o managed services
				$no_managed_services_customers = [];
			?>
				<div class="row">
					<div class="col-12 mb-3">
						<div class="bg-white border-1 p-3">
							<div class="text fw-semibold lh-1 mb-3">Active Customer Managed Services</div>
							<table class="table m-0">
								<tbody>
									<?php
									if($assigned_customers){

										// loop through all assigned customers
										foreach($assigned_customers as $customer_key => $customer_id){

											// customer data
											$customer = get_user_by("ID", $customer_id);
											$customer_first_name = isset($customer->first_name) ? $customer->first_name : "";

											// get customer subscriptions if there's any
											$customer_subscriptions = get_posts( array(
												'numberposts' => -1,
												'meta_key'    => '_customer_user',
												'meta_value'  => $customer_id, // Or $user_id or get_current_user_id()
												'post_type'   => 'shop_subscription', // WC orders post type
												'post_status' => 'wc-active'
											) );
											
											// check if there's any active subscriptions
											if ($customer_subscriptions) {

												// loop through all subscriptions
												foreach ($customer_subscriptions as $key => $customer_subscription) {

													// 
													$subscription = new WC_Subscription($customer_subscription->ID);
													$subscription_parent_order = $subscription->get_parent_id();
													$subscription_order_ids = $subscription->get_related_orders();
			
													// get parent subscription order object
													$customer_order = wc_get_order(end($subscription_order_ids));
													$order_status = esc_html( wc_get_order_status_name($customer_order->get_status()));
			
													// get product title
													// Get and Loop Over Order Items
													foreach ($customer_order->get_items() as $item_id => $item) {
														$product_name = $item->get_name();
													}
													?>
														<tr>
															<td class="text lh-3"><a href="<?php echo get_site_url(); ?>/seo-manager/view-order/<?php echo end($subscription_order_ids); ?>">#<?php echo end($subscription_order_ids); ?></a> - Managed Service</td>
															<td class="text lh-3"><?php echo $customer_first_name; ?></td>
															<td class="text lh-3"><?php echo $product_name; ?></td>
															<td class="text lh-3"><?php echo $order_status; ?></td>
															<td class="text lh-3"><a href="<?php echo get_site_url(); ?>/seo-manager/view-order/<?php echo end($subscription_order_ids); ?>">View Order</a></td>
														</tr>
													<?php
												}
											} else {
												$no_managed_services_customers[] = $customer_id;
											}
										}
									} else {
									?>
										<tr>
											<td>No Managed Services.</td>
										</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-12 mb-3">
						<div class="bg-white border-1 p-3">
							<div class="text fw-semibold lh-1 mb-3">Active Packaged Services</div>
							<table class="table m-0">
								<tbody>
									<?php
									// check if there are orders
									$are_there_orders = [];
									
									// 
									foreach ($no_managed_services_customers as $key => $customer_id) {

										// customer data
										$customer = get_user_by("ID", $customer_id);
										$customer_first_name = isset($customer->first_name) ? $customer->first_name : "";

										// get all customer orders
										$customer_orders = get_posts( array(
											'numberposts' => -1,
											'meta_key'    => '_customer_user',
											'meta_value'  => $customer_id,
											'post_type'   => wc_get_order_types('view-orders'),
											// 'post_status' => array_keys('wc-on-going'), // wc_get_order_statuses()
											'post_status' => array('wc-on-going'), // wc_get_order_statuses()
										));

										// check if there's a customer order
										if ($customer_orders) {

											// loop through all orders
											foreach ($customer_orders as $key => $customer_order) {

												// 
												$are_there_orders[] = true;

												// get parent subscription order object
												$customer_order_obj = wc_get_order($customer_order->ID);
												$order_status = esc_html( wc_get_order_status_name($customer_order_obj->get_status()));

												// get product title
												// Get and Loop Over Order Items
												foreach ($customer_order_obj->get_items() as $item_id => $item) {
													$product_name = $item->get_name();
												}
											?>

													<tr>
														<td class="text lh-3"><a href="<?php echo get_site_url(); ?>/seo-manager/view-order/<?php echo $customer_order->ID; ?>">#<?php echo $customer_order->ID; ?></a> - Parent Subscription</td>
														<td class="text lh-3"><?php echo $customer_first_name; ?></td>
														<td class="text lh-3"><?php echo $product_name; ?></td>
														<td class="text lh-3"><?php echo $order_status; ?></td>
														<td class="text lh-3"><a href="<?php echo get_site_url(); ?>/seo-manager/view-order/<?php echo $customer_order->ID; ?>">View Order</a></td>
													</tr>
											<?php
											}
										}
									}

									if (!in_array(true, $are_there_orders)) {
										echo "<tr><td class='text lh-1'>No active orders.</td></tr>";
									}
									?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			<?php } ?>

			<!-- services -->
			<?php 
			if($user_role != "account_manager" && $user_role != "administrator") {

				

				/* // CONNECT GOOGLE CONFIG TO VALIDATE USER
				// INITIATE SEOI CLASS
				$seoi = new SEOI();
				// VALIDATE USER
				$validateUser = $seoi->validateUser('', 'GOOGLE_ACCOUNTS'); */



				
			


			/* return array(
				'user_id' => $user_id,
				'site_url' => $site_url,
				'load_type' => $load_type,
			);
 */
			
			
				/* // GET THE JSON FILE
				// $load_type = isset($urlParams['code']) ? 'refresh' : 'load';
				$filename = $user_id.'_last_month_property_report.json';
				$filepath = get_stylesheet_directory().'/includes/cache/'.$filename;

				dd($filename);
				dd($filepath);

			// CHECK LOAD TYPE AND RETURN DATA FROM JSON IF LOAD TYPE IS LOAD
			if(file_exists($filepath)){
				// GET DATA FROM JSON
				$json = file_get_contents($filepath);
				// GET DATA FROM JSON
				$data = json_decode($json, true);
				// RETURN DATA
				// return $data;
				dd($data);
			}

 */


				
				// GET THE SAVED KEYWORDS
				$savedKeywords = get_user_meta( $user_id, 'google_user_keyword_basket', true );
				// $siteData = get_user_meta( $user->ID, 'google_site_data', true );
				$siteData = get_user_meta( $user_id, 'google_site_data', true );

				$user_websites = get_user_meta( $user_id, '_user_websites', true );

				/* dd($user_websites);
				dd($siteData); */

				if($siteData && $user_websites){

					// GET THE SITE
					$site = $siteData['site'];

					// FILTER URLS SO WE CAN COMPARE
					$filtered_site = filterWebsiteUrl($site);
					$filtered_site_validation = [];
			
					// LOOP THROUGH USER WEBSITES
					foreach($user_websites as $key => $user_website){
						// FILTER URLS SO WE CAN COMPARE
						$filtered_user_website = filterWebsiteUrl($user_website);
						// COMPARE
						if($filtered_site == $filtered_user_website){
							// SET THE FILTERED SITE
							$filtered_site_validation[] = true;
						}
					}
			
					// CHECK IF ARRAY HAS TRUE
					if(in_array(true, $filtered_site_validation)){

						// arrows used for the pdf
						$up_arrow = "data:image/png;base64,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";
						$down_arrow = "data:image/png;base64,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";
			?>
						<!-- ANALYTICS TOP BAR -->
						<div class="bg-white p-3 mb-3 border-top-5 border-orange" id="load-analytics-topbar">
							<div class="mb-2 text skeleton">Please connect your Google account to view your ranked website data.</div>
							<div class="skeleton d-inline-block">
								<a href="" class="btn-orange fw-light text py-1 px-3">Loading Site Data</a>
							</div>
						</div>

						<!-- ANALYTICS DATA -->
						<div class="row" id="load-analytics">
							<div class="col-12 col-lg-4 mb-4">
								<div class="bg-white p-0 border">
									<div class="fw-medium text border-bottom p-2 skeleton">Google Analytics: Site Views</div>
									<div class="p-2 pt-3 skeleton" style="min-height: 250px;"></div>
								</div>
							</div>
							<div class="col-12 col-lg-4 mb-4">
								<div class="bg-white p-0 border">
									<div class="fw-medium text border-bottom p-2 skeleton">Google Analytics: Site Views</div>
									<div class="p-2 pt-3 skeleton" style="min-height: 250px;"></div>
								</div>
							</div>
							<div class="col-12 col-lg-4 mb-4">
								<div class="bg-white p-0 border">
									<div class="fw-medium text border-bottom p-2 skeleton">Google Analytics: Site Views</div>
									<div class="p-2 pt-3 skeleton" style="min-height: 250px;"></div>
								</div>
							</div>
						</div>

						<!-- KEYWORDS DATA -->
						<div class="row">
							<?php
								/* dd($site);
								dd($savedKeywords); */
							?>
							<?php if($savedKeywords){ ?>
								<div class="col-12 col-lg-6">
									<table class="bg-white table">
										<thead>
											<tr>
												<th class="text fw-medium" colspan="3">Starred Keywords</th>
											</tr>
											<tr>
												<th class="text fw-medium">Keyword</th>
												<th class="text fw-medium">Past Position</th>
												<th class="text fw-medium">Current Position</th>
											</tr>
										</thead>
										<tbody>
											<?php if($savedKeywords[$site]){ ?>
												<?php
												// first 5
												$savedKeywords[$site] = array_slice($savedKeywords[$site], 0, 5);

												foreach($savedKeywords[$site] as $key => $keyword){
													// GET THE PAST POSITION
													$past_position = $keyword['positions'][0] ? round($keyword['positions'][0], 2) : '-';
													// GET THE CURRENT POSITION
													$current_position = $keyword['positions'][1] ? round($keyword['positions'][1], 2) : '-';
												?>
													<tr>
														<td class="text fw-medium"><?php echo $keyword['keyword']; ?></td>
														<!-- <td class="text fw-medium"><?php //echo $keyword['positions'][0] ? round($keyword['positions'][0], 2) : '-'; ?></td> -->
														<td class="text fw-medium"><?php echo $past_position; ?></td>
														<td class="text fw-medium">
															<?php //echo $keyword['positions'][1] ? round($keyword['positions'][1], 2) : '-'; ?>
															<?php echo $current_position; ?>
															<?php
																if ($past_position != "-" && $current_position > $past_position) {
																	echo "<img src='".$down_arrow."'>";
																} elseif ($past_position != "-" && $current_position < $past_position) {
																	echo "<img src='".$up_arrow."'>";
																}
															?>
														</td>
													</tr>
												<?php } ?>
											<?php } else { ?>
												<tr>
													<td class="text fw-medium" colspan="3">No starred keywords.</td>
												</tr>
											<?php } ?>
											<tr>
												<td colspan="3" class="text-left"><a href="<?php echo get_site_url(); ?>/seo-manager/rankings/" class="btn-orange px-3 py-1 small-text text-uppercase">View All Starred Keywords</a></td>
											</tr>
										</tbody>
									</table>
								</div>
							<?php } ?>

							<?php if($siteData){ ?>
								<div class="col-12 col-lg-6">
									<table class="bg-white table">
										<thead>
											<tr>
												<th class="text fw-medium" colspan="3">Top 5 Moved Keywords</th>
											</tr>
											<tr>
												<th class="text fw-medium">Keyword</th>
												<th class="text fw-medium">Past Position</th>
												<th class="text fw-medium">Current Position</th>
											</tr>
										</thead>
										<tbody>
											<?php
												$past_month = $siteData["last_month"]["rows"];
												$past_2_months = $siteData["2_months_ago"]["rows"];
						
												$top_moved = array();
												foreach ($past_month as $key => $value) {
						
													$past_position = "-";
						
													foreach ($past_2_months as $key => $pv) {
						
														if ($value["keys"][0] == $pv["keys"][0]) {
						
															// past position
															$past_position = round($pv["position"], 2);
						
															// get the difference
															$diff = $past_position - $value["position"];
															$diff = round($diff, 2);
						
															// insert value into array by diff
															if($diff >= 1){
																$top_moved[$diff] = $value;
															}
														}
													}
												}
						
												// arrange array by key
												krsort($top_moved);

												// first 5
												$top_moved = array_slice($top_moved, 0, 5);
						
											?>
											<?php if($top_moved){ ?>
												<?php
												foreach($top_moved as $key => $value){

													$past_position = "-";

													foreach ($past_2_months as $key => $pv) {
														if ($value["keys"][0] == $pv["keys"][0]) {
															$past_position = round($pv["position"], 2);
														}
													}
												?>
													<tr>
														<td class="text fw-medium"><?php echo $value['keys'][0]; ?></td>
														<td class="text fw-medium"><?php echo round($past_position, 2); ?></td>
														<td class="text fw-medium"><?php 
															echo round($value["position"], 2);

															if ($past_position != "-" && $value["position"] > $past_position) {
																echo "<img src='".$down_arrow."'>";
															} elseif ($past_position != "-" && $value["position"] < $past_position) {
																echo "<img src='".$up_arrow."'>";
															}
														?></td>
													</tr>
												<?php } ?>
											<?php } else { ?>
												<tr>
													<td class="text fw-medium" colspan="3">No Top Moved keywords.</td>
												</tr>
											<?php } ?>
											<tr>
												<td colspan="3" class="text-left"><a href="<?php echo get_site_url(); ?>/seo-manager/rankings/?keywords=all" class="btn-orange px-3 py-1 small-text text-uppercase">View All Rankings</a></td>
											</tr>
										</tbody>
									</table>
								</div>
							<?php } ?>

							<!-- ACTIVE TODOS -->
							<?php
								// GET TODOS
								$todos = get_user_meta($user_id, "todo_list", true);
								// dd($todos);
								// CHECK IF THERE ARE TODOS
								if($todos){
							?>
									<div class="col-12 col-lg-6">
										<table class="bg-white table">
											<thead>
												<tr>
													<th class="text fw-medium" colspan="3">Active Todos</th>
												</tr>
												<tr>
													<th class="text fw-medium">Keywords</th>
													<th class="text fw-medium">URL</th>
													<th></th>
												</tr>
											</thead>
											<tbody>
												<?php 
												// REVERSE THE ARRAY
												$todos = array_reverse($todos);
												// ACTIVE TODOS
												$activeTodos = [];
												// LOOP THROUGH TODOS
												foreach($todos as $key => $todo){
													// GET GRAVITYFORM ENTRY OBJECT
													$entry = GFAPI::get_entry($todo['entry_id']);
													// ENTRY ID
													$entryId = $todo['entry_id'];
													// KEYWORDS
													$keyword1 = rgar($entry, '8');
													$keyword2 = rgar($entry, '3');
													$keyword3 = rgar($entry, '9');
													// PAGE URL
													$pageUrl = rgar($entry, '1');
													// GET THE TODO LIST DATA
													$additionalData = rgar($entry, '19');
													// INITIALIZE THE IS COPY VARIABLE
													$isCopy = false;
													// GET THE TODO LIST STATUS
													$parentTodoStatus = rgar($entry, '13') == "" ? "Ongoing" : rgar($entry, '13');
													// CHECK PARENT TODO STATUS
													if($parentTodoStatus == "Ongoing"){
														$activeTodos[] = array(
															"entry_id" => $entryId,
															"status"   => $parentTodoStatus,
															"page_url" => $pageUrl,
															"keywords" => array(
																$keyword1, $keyword2, $keyword3
															)
														);
													}
													// CHECK IF ADDITIONAL DATA
													if($additionalData){
														// DECODE THE TODO LIST DATA
														$additionalData = json_decode($additionalData, true);
														// ADDITIONAL TODO LIST DATA
														$additional_todos = $additionalData;
														// LOOP THROUGHT THE DECODED TODO LIST DATA
														foreach($additional_todos as $key => $atodo){
															// CHECK STATUS
															$todoStatus = $atodo["status"]; // Status is the old key
															$newkey = $key+1;
															if($todoStatus == "Ongoing"){
																$activeTodos[] = array(
																	"entry_id" => $entryId."-".$newkey,
																	"status"   => $todoStatus,
																	"page_url" => $pageUrl,
																	"keywords" => array(
																		$keyword1, $keyword2, $keyword3
																	)
																);
															}
														}
													}
												}

												// LOOP THROUGH TODOS
												foreach($activeTodos as $key => $todo){
													// REMOVE EMPTY VALUES
													$todo['keywords'] = array_filter($todo['keywords']);
													// ARRAY TO STRING
													$keywords = is_array($todo['keywords']) ? implode(", ", $todo['keywords']) : $todo['keywords'];
												?>
													<tr>
														<td class="text fw-medium"><?php
														echo $keywords;
															/* echo $keyword1 ? $keyword1 . "<br>" : "";
															echo $keyword2 ? $keyword2 . "<br>" : "";
															echo $keyword3 ? $keyword3 . "<br>" : ""; */
														?></td>
														<td class="text fw-medium lh-2"><?= $todo['page_url']; ?></td>
														<td class="text fw-medium lh-2"><form action='/seo-manager/todos/list/?eid=<?php echo $todo['entry_id']; ?>' method='POST'><input type='hidden' name='entry_id' value=''><button type='submit' class='rounded-0 text py-2 px-3 btn-orange-outline lh-1'>View Todo #<?php echo $todo['entry_id']; ?></button></form></td>
													</tr>
													<?php //} ?>
												<?php } // !loop todos ?>
											</tbody>
										</table>
									</div>
							<?php } // !todos ?>
						</div>
					<?php } else { // !if has website ?>
						<div class="bg-white p-3 mb-3 border-top-5 border-orange">
							<div class="text">Create your first SEO Strategy <a href="<?php echo get_site_url(); ?>/seo-manager/seo-strategy/">here</a> or generate your website data <a href="<?php echo get_site_url(); ?>/seo-manager/rankings/">here</a> so we start tracking your rankings.</div>
						</div>
					<?php }// !if has website ?>
				<?php } else { ?>

					<?php
						// $user_websites = get_user_meta( $user_id, '_user_websites', true );

						// dd($user_websites);

						// if(!$user_websites){
					?>
					<div class="bg-white p-3 mb-3 border-top-5 border-orange">
						<div class="text">Create your first SEO Strategy <a href="<?php echo get_site_url(); ?>/seo-manager/seo-strategy/">here</a> or generate your website data <a href="<?php echo get_site_url(); ?>/seo-manager/rankings/">here</a> so we start tracking your rankings.</div>
					</div>
				<?php } ?>

				<!-- row -->
				<div class="row">
					<?php 
					echo do_shortcode('[seo_feed]');
					?>
					<div class="col-12 col-lg-6">
						<table class="table bg-white">
							<thead>
								<tr>
									<th class="text fw-medium">Latest Blog Posts</th>
								</tr>
							</thead>
							<tbody>
								<?php
									// BLOG TOP 5 NEWEEST POSTS
									$blogPosts = new WP_Query(array(
										"post_type"      => "post",
										"posts_per_page" => 5,
										"post_status"    => "publish",
									));
									if($blogPosts->have_posts()){
										while($blogPosts->have_posts()){ $blogPosts->the_post();
											// get thumbnail url
											$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');
											?>
												<tr>
													<td class="text fw-medium">
														<a class="d-flex flex-nowrap align-items-center" href="<?php the_permalink(); ?>">
															<?php if($thumbnail_url){ ?>
																<div class="position-relative rounded-circle overflow-hidden mr-2" style="height: 30px; width: 30px;">
																	<picture>
																		<img class="position-absolute w-100 h-100" style="object-fit:cover;" src="<?php echo $thumbnail_url; ?>" alt="<?php echo get_the_title(); ?>">
																	</picture>
																</div>
															<?php } ?>
															<span class="lh-2"><?php the_title(); ?></span>
														</a>
													</td>
												</tr>
											<?php
											// echo "<tr><td class='text'><a href='".get_the_permalink()."'>".get_the_title()."</a></td></tr>";
										} wp_reset_postdata();
									}
								?>
							</tbody>
						</table>
					</div>
					<div class="col-12 col-lg-6"></div>
				</div>

				<!-- PRODUCTS -->
				<div class="row">
					<div class="col-12">
						<div class="bg-white border-1 p-3">
							<?php
								// MANAGED_SERVICES
								$managedServices = new WP_Query(array(
									// "post_type"      => "page",
									"post_type"      => "product",
									"posts_per_page" => -1,
									"post_status"    => "publish",
									// 'post__in'       => MANAGED_SERVICES
									// taxonomy
									'tax_query' => array(
										array(
											'taxonomy' => 'product_cat',
											'field'    => 'id',
											'terms'    => array(112),
										),
									),
								));
							?>
							<div class="text fw-semibold lh-1 mb-3">Managed Services</div>
							<table class="table m-0">
								<thead>
									<tr>
										<th class="p-3 small-text lh-1 fw-regular">Product</th>
										<th class="p-3"></th>
									</tr>
								</thead>
								<tbody>
									<?php
									if($managedServices->have_posts()){

										// loop through the managed services
										while($managedServices->have_posts()){ $managedServices->the_post();

											$related_page = get_post_meta(get_the_ID(), 'related_page', true);
									?>
											<tr>
												<td class="p-3 text lh-1 align-middle"><?php the_title(); ?></td>
												<td class="p-2 text lh-1 align-middle">
													<!-- <a href="<?php //the_permalink(); ?>" class="btn-orange-outline small-text m-1 py-2 px-3 text-uppercase">Learn More</a> -->
													<a href="<?php echo get_the_permalink($related_page); ?>" class="btn-orange-outline small-text m-1 py-2 px-3 text-uppercase">Learn More</a>
													<!-- <a href="<?php //echo get_site_url(); ?>/cart?order=<?php //echo get_the_title(); ?>&pid=<?php //echo get_the_ID(); ?>" class="btn-orange small-text m-1 py-2 px-3 text-uppercase">Order Now</a> -->
													<a href="<?php the_permalink(); ?>" class="btn-orange small-text m-1 py-2 px-3 text-uppercase">Order Now</a>
												</td>
											</tr>
										<?php } ?>
									<?php } else { ?>
										<tr>
											<td colspan="2 text">No Service.</td>
										</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
					<div class="col-12 mt-3">
						<div class="bg-white border-1 p-3">
							<?php
								/* // PACKAGED_SERVICES
								$packagedServices = new WP_Query(array(
									"post_type"      => "page",
									"posts_per_page" => -1,
									"post_status"    => "publish",
									'post__in'       => PACKAGED_SERVICES
								)); */
								// MANAGED_SERVICES
								$packagedServices = new WP_Query(array(
									"post_type"      => "product",
									"posts_per_page" => -1,
									"post_status"    => "publish",
									'tax_query' => array(
										array(
											'taxonomy' => 'product_cat',
											'field'    => 'id',
											'terms'    => array(113),
										),
									),
								));
							?>
							<div class="text fw-semibold lh-1 mb-3">Packaged Services</div>
							<table class="table m-0">
								<thead>
									<tr>
										<th class="p-3 small-text lh-1 fw-regular">Product</th>
										<th class="p-3"></th>
									</tr>
								</thead>
								<tbody>
									<?php
									if($packagedServices->have_posts()){

										// loop through the managed services
										while($packagedServices->have_posts()){ $packagedServices->the_post();

											$related_page = get_post_meta(get_the_ID(), 'related_page', true);
											// dd($related_page);
									?>
											<tr>
												<td class="p-3 text lh-1 align-middle"><?php the_title(); ?></td>
												<td class="p-2 text lh-1 align-middle">
													<!-- <a href="<?php //the_permalink(); ?>" class="btn-orange-outline small-text m-1 py-2 px-3 text-uppercase">Learn More</a> -->
													<a href="<?php echo get_the_permalink($related_page); ?>" class="btn-orange-outline small-text m-1 py-2 px-3 text-uppercase">Learn More</a>
													<!-- <a href="<?php //echo get_site_url(); ?>/cart?order=<?php //echo get_the_title(); ?>&pid=<?php //echo get_the_ID(); ?>" class="btn-orange small-text m-1 py-2 px-3 text-uppercase">Order Now</a> -->
													<a href="<?php the_permalink(); ?>" class="btn-orange small-text m-1 py-2 px-3 text-uppercase">Order Now</a>
												</td>
											</tr>
										<?php } ?>
									<?php } else { ?>
										<tr>
											<td colspan="2 text">No Service.</td>
										</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
<?php
    return ob_get_clean();
}

/* 
 * AJAX LOAD GOOGLE ANALYTICS OVERVIEW DATA
 * 
 */
add_action('wp_ajax_load_google_analytics_overview_data', 'load_google_analytics_overview_data');
add_action('wp_ajax_nopriv_load_google_analytics_overview_data', 'load_google_analytics_overview_data');
function load_google_analytics_overview_data(){
    // JSON HEADER
    header('Content-Type: application/json');

	// URL PARAMS
	$urlParams = isset($_REQUEST['urlParams']) ? $_REQUEST['urlParams'] : [];

    // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$user_id = isset($urlParams['cid']) ? $urlParams['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$user_id = $user_id ? $user_id : get_current_user_id();

	// GET MANAGER ID
    $accountManager = get_the_author_meta( "_assigned_account_manager", $user_id );
    // GET USER ID BY EMAIL
    $accountManager = get_user_by( "email", $accountManager );
    // GET THE CUSTOMER ID
    $manager_id = $accountManager ? $accountManager->ID : $user_id; // if no manager, use the current user id

    // GET THE SITE DATA
    $siteData = get_user_meta( $user_id, 'google_site_data', true );

    // INIT VARIABLES
    $siteViewsLastMonth = '';
    $siteViewsTwoMonthsAgo = '';
    $siteViewsThreeMonthsAgo = '';
	// 
	$user_websites = get_user_meta( $user_id, '_user_websites', true );
	
	// TOP BAR
	ob_start();

    // CHECK IF SITE DATA IS NOT EMPTY
    if($siteData && $user_websites){

		// THE DATA
        $site = $siteData['site'];

		// FILTER URLS SO WE CAN COMPARE
		$filtered_site = filterWebsiteUrl($site);
		$filtered_site_validation = [];

		// LOOP THROUGH USER WEBSITES
		foreach($user_websites as $key => $user_website){
			// FILTER URLS SO WE CAN COMPARE
			$filtered_user_website = filterWebsiteUrl($user_website);
			// COMPARE
			if($filtered_site == $filtered_user_website){
				// SET THE FILTERED SITE
				$filtered_site_validation[] = true;
			}
		}

		// CHECK IF ARRAY HAS TRUE
		if(in_array(true, $filtered_site_validation)){

			// GOOGLE ANALYTICS CLASS
			$googleAnalytics = new GOOGLE_ANALYTICS();
	
			// get last month start and end date
			$lastMonthStartDate = date('Y-m-d', strtotime('first day of last month'));
			$lastMonthEndDate = date('Y-m-d', strtotime('last day of last month'));
			// two months ago start and end date
			$twoMonthsAgoStartDate = date('Y-m-d', strtotime('first day of last month -1 month'));
			$twoMonthsAgoEndDate = date('Y-m-d', strtotime('last day of last month -1 month'));
			// three months ago start and end date
			$threeMonthsAgoStartDate = date('Y-m-d', strtotime('first day of last month -2 month'));
			$threeMonthsAgoEndDate = date('Y-m-d', strtotime('last day of last month -2 month'));
	
			// LOAD TYPE
			$load_type = isset($urlParams['code']) ? 'refresh' : 'load';
			// $load_type = 'refresh';
	
			
			
			$siteViewsLastMonth = $googleAnalytics->getAnalyticReport($site, $lastMonthStartDate, $lastMonthEndDate, 'last_month', $load_type, $manager_id, $user_id);
			$siteViewsTwoMonthsAgo = $googleAnalytics->getAnalyticReport($site, $twoMonthsAgoStartDate, $twoMonthsAgoEndDate, 'two_months', $load_type, $manager_id, $user_id);
			$siteViewsThreeMonthsAgo = $googleAnalytics->getAnalyticReport($site, $threeMonthsAgoStartDate, $threeMonthsAgoEndDate, 'three_months', $load_type, $manager_id, $user_id); 
			// IMPRESSIONS AND CLICKS DATA
			$ic_lastMonth = $googleAnalytics->getAnalyticReport($site, $lastMonthStartDate, $lastMonthEndDate, 'ic_last_month', $load_type, $manager_id, $user_id);
			$ic_twoMonthsAgo = $googleAnalytics->getAnalyticReport($site, $twoMonthsAgoStartDate, $twoMonthsAgoEndDate, 'ic_two_months', $load_type, $manager_id, $user_id);
			$ic_threeMonthsAgo = $googleAnalytics->getAnalyticReport($site, $threeMonthsAgoStartDate, $threeMonthsAgoEndDate, 'ic_three_months', $load_type, $manager_id, $user_id); 
	
			// SCREEN VIEWS
			$batchReportLastMonth = isset($siteViewsLastMonth['batch_report']['data']['reports']) ? $siteViewsLastMonth['batch_report']['data']['reports'] : [];
			$batchReportTwoMonthsAgo = isset($siteViewsTwoMonthsAgo['batch_report']['data']['reports']) ? $siteViewsTwoMonthsAgo['batch_report']['data']['reports'] : [];
			$batchReportThreeMonthsAgo = isset($siteViewsThreeMonthsAgo['batch_report']['data']['reports']) ? $siteViewsThreeMonthsAgo['batch_report']['data']['reports'] : [];
			// IMPRESSIONS AND CLICKS
			$icReportLastMonth = isset($ic_lastMonth['batch_report']['data']['reports']) ? $ic_lastMonth['batch_report']['data']['reports'] : [];
			$icReportTwoMonthsAgo = isset($ic_twoMonthsAgo['batch_report']['data']['reports']) ? $ic_twoMonthsAgo['batch_report']['data']['reports'] : []; 
			$icReportThreeMonthsAgo = isset($ic_threeMonthsAgo['batch_report']['data']['reports']) ? $ic_threeMonthsAgo['batch_report']['data']['reports'] : [];
		}
		



		// var_dump($siteViewsLastMonth);
		// $response['asd'] = $siteViewsLastMonth;
    }

   

	// dd($siteData);
	
	// dd($user_websites);
	/* dd($lastMonthStartDate);
	dd($lastMonthEndDate);
	dd($siteViewsLastMonth); */
	/* dd($twoMonthsAgoEndDate);
	dd($siteViewsTwoMonthsAgo); */
	// dd($batchReportTwoMonthsAgo);
	// dd($batchReportLastMonth[0]['rows']);
	// if($siteViewsLastMonth || $siteViewsTwoMonthsAgo || $siteViewsThreeMonthsAgo){
	if($batchReportLastMonth[0]['rows'] || $batchReportTwoMonthsAgo[0]['rows'] || $batchReportThreeMonthsAgo[0]['rows']){
?>
        <div class="mb-2 text skeleton"><?php echo $siteData ? "Please click the button below to update your site data." : "Please connect your Google account to view your ranked website data."; ?></div>
        <style>.google-btn .tcb-icon{color: white !important;}</style>
        <div class="skeleton d-inline-block">
            <a href="<?= GOOGLE_SEARCH_AND_ANALYTICS_OAUTH_URL; ?>" class="btn-orange fw-light text py-1 px-3 google-btn"><svg style="position: relative; top: -1px;" fill="white" class="tcb-icon" viewBox="0 0 488 512" data-id="icon-google-brands" data-name=""><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"></path></svg> <?php echo $siteData ? "Update Site Data" : "Connect Google"; ?></a>
        </div>
<?php
	} else {
		echo "Please connect your Google console and analytics for your rank tracker and site data <a href='https://seoi.io/seo-manager/rankings/'>here</a>.";
	}
    $response['topbar'] = ob_get_contents(); // get topbar
    ob_end_clean(); // close

    // START ANALYTICS DATA 
    ob_start();
    // if($siteViewsLastMonth || $siteViewsTwoMonthsAgo || $siteViewsThreeMonthsAgo){ 
	if($batchReportLastMonth[0]['rows'] || $batchReportTwoMonthsAgo[0]['rows'] || $batchReportThreeMonthsAgo[0]['rows']){
    // $asd = false;
	// if($asd){ 
?>
        <?php
			

			// dd($batchReportLastMonth);

            $googleChartLabels = array('3 Months Ago', '2 Months Ago', 'Last Month');
            // $googleChartLabels = array('Last Month', '2 Months Ago', '3 Months Ago');
            $siteViewsValues = array(
				$batchReportThreeMonthsAgo[0]['rows'][0]['metricValues'][0]['value'] ? $batchReportThreeMonthsAgo[0]['rows'][0]['metricValues'][0]['value'] : 0,
				$batchReportTwoMonthsAgo[0]['rows'][0]['metricValues'][0]['value'] ? $batchReportTwoMonthsAgo[0]['rows'][0]['metricValues'][0]['value'] : 0,
				$batchReportLastMonth[0]['rows'][0]['metricValues'][0]['value'] ? $batchReportLastMonth[0]['rows'][0]['metricValues'][0]['value'] : 0,
                /* $siteViewsLastMonth['reports'][0]['data']['totals'][0]['values'][0],
                $siteViewsTwoMonthsAgo['reports'][0]['data']['totals'][0]['values'][0],
                $siteViewsThreeMonthsAgo['reports'][0]['data']['totals'][0]['values'][0] */
            );

			// dd($siteViewsValues);
        ?>
        <div class="col-12 col-md-6 col-xl-4 mb-4">
            <div class="bg-white p-0 border">
                <div class="fw-medium text border-bottom p-2 skeleton">Site Views</div>
                <div class="p-2 pt-4 skeleton">
                    <canvas id="chartSiteViews" style="width:100%;" data-labels='<?= json_encode($googleChartLabels); ?>' data-values='<?= json_encode($siteViewsValues); ?>'></canvas>
                </div>
            </div>
        </div>
        <?php
		// dd($icReportThreeMonthsAgo);

		if($icReportThreeMonthsAgo && $icReportTwoMonthsAgo && $icReportLastMonth){
		
            $impressionsValues = array(
				$icReportThreeMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] ? $icReportThreeMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] : 0,
				$icReportTwoMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] ? $icReportTwoMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] : 0,
				$icReportLastMonth[0]['rows'][1]['metricValues'][0]['value'] ? $icReportLastMonth[0]['rows'][1]['metricValues'][0]['value'] : 0,
                /* $siteViewsLastMonth['reports'][0]['data']['totals'][0]['values'][1],
                $siteViewsTwoMonthsAgo['reports'][0]['data']['totals'][0]['values'][1],
                $siteViewsThreeMonthsAgo['reports'][0]['data']['totals'][0]['values'][1] */
            );
        ?>
			<div class="col-12 col-md-6 col-xl-4 mb-4">
				<div class="bg-white p-0 border">
					<div class="fw-medium text border-bottom p-2 skeleton">Impressions</div>
					<div class="p-2 pt-4 skeleton">
						<canvas id="chartImpressions" style="width:100%;" data-labels='<?= json_encode($googleChartLabels); ?>' data-values='<?= json_encode($impressionsValues); ?>'></canvas>
					</div>
				</div>
			</div>
		<?php } ?>


        <?php
		if($icReportThreeMonthsAgo && $icReportTwoMonthsAgo && $icReportLastMonth){
            $clickValues = array(
				$icReportThreeMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] ? $icReportThreeMonthsAgo[0]['rows'][1]['metricValues'][1]['value'] : 0,
				$icReportTwoMonthsAgo[0]['rows'][1]['metricValues'][0]['value'] ? $icReportTwoMonthsAgo[0]['rows'][1]['metricValues'][1]['value'] : 0,
				$icReportLastMonth[0]['rows'][1]['metricValues'][0]['value'] ? $icReportLastMonth[0]['rows'][1]['metricValues'][1]['value'] : 0,
                /* $siteViewsLastMonth['reports'][0]['data']['totals'][0]['values'][2],
                $siteViewsTwoMonthsAgo['reports'][0]['data']['totals'][0]['values'][2],
                $siteViewsThreeMonthsAgo['reports'][0]['data']['totals'][0]['values'][2] */
            );
        ?>
			<div class="col-12 col-md-6 col-xl-4 mb-4">
				<div class="bg-white p-0 border">
					<div class="fw-medium text border-bottom p-2 skeleton">Clicks</div>
					<div class="p-2 pt-4 skeleton">
						<canvas  id="chartClicks" style="width:100%;" data-labels='<?= json_encode($googleChartLabels); ?>' data-values='<?= json_encode($clickValues); ?>'></canvas>
					</div>
				</div>
			</div>
		<?php } ?>
<?php

    } //
    $response['analytics'] = ob_get_clean();
    

    // RESPONSE
    echo json_encode($response);

    // END
    die();
}