<?php
    // CHECK IF DATA IS AVAILABLE
    if($strategyData['keyword_data']){

        // SET DATA
        $keywords = $strategyData['keywords'];
        $keyword_compare = [];

        // LOOP THROUGH KEYWORDS
        foreach($strategyData['keyword_data'] as $key => $data){
?>
            <div class="table-wrap">
                <div class="text fw-bold mt-4 mb-2">Keyword: "<?php echo $data['keyword']; ?>" Top 3 Competitor Data</div>
                <table class="metric-table table bg-white">
                    <thead>
                        <tr>
                            <th class="text fw-medium">Competitor URL</th>
                            <th class="text fw-medium">Word Count</th>
                            <th class="text fw-medium">Headings</th>
                            <th class="text fw-medium">Paragraphs</th>
                            <th class="text fw-medium">Images</th>
                            <th class="text fw-medium">Domain Authority</th>
                            <th class="text fw-medium">Backlinks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php

                            // average data
                            $average_data = [
                                // define keys
                                'headings' => [],
                                'p' => [],
                                'img' => [],
                                'wc' => [],
                                'da' => [],
                                'bl' => []
                            ];
                            

                            // loop through the sites
                            foreach($data['data'] as $key => $site_data){


                                // reset array
                                $headings = [];
                                $check_empty = [];
                                
                                // site data
                                $page_link      = $site_data['page_link'];
                                $page_wc = $site_data['word_count'];
                                $page_da = $site_data['domain_authority'];
                                $page_backlinks = $site_data['backlinks'];
                                $page_p = $site_data['p'];
                                $page_img = $site_data['img'];
                                
                                // add to headings array
                                $headings[] += $site_data['h1'];
                                $headings[] += $site_data['h2'];
                                $headings[] += $site_data['h3'];
                                $headings[] += $site_data['h4'];
                                $headings[] += $site_data['h5'];
                                $headings[] += $site_data['h6'];
                                
                                // check if not crawled
                                $check_empty[] += array_sum($headings);
                                $check_empty[] += $page_p;
                                $check_empty[] += $page_img;
                                $check_empty[] += $page_wc;
                                
                                // populate avarage data
                                $average_data['headings'][] += array_sum($headings);
                                $average_data['p'][] += $page_p;
                                $average_data['img'][]+= $page_img;
                                $average_data['wc'][] += $page_wc;
                                $average_data['da'][] += $page_da;
                                $average_data['bl'][] += $page_backlinks;

                                // FOR THE CONTENT
                                // if($key == 2){ // restrict to third competitor
                                    /* $keyword_compare['word_count'][] = $page_wc;
                                    $keyword_compare['img'][] = $page_img;
                                    $keyword_compare['p'][] = $page_p;
                                    $keyword_compare['headings'][] = array_sum($headings);
                                    $keyword_compare['backlinks'][] = $page_backlinks;
                                    $keyword_compare['domain_authority'][] = $page_da; */
                                // }
                        ?>
                                <tr>
                                    <td class="small-text fw-medium"><?php echo $page_link; ?></td>
                                    <?php if(array_sum($check_empty) > 0){ ?>
                                        <td class="small-text fw-medium"><?php echo $page_wc; ?></td>
                                        <td class="small-text fw-medium"><?php echo array_sum($headings); ?></td>
                                        <td class="small-text fw-medium"><?php echo $page_p; ?></td>
                                        <td class="small-text fw-medium"><?php echo $page_img; ?></td>
                                    <?php } else { ?>
                                        <td class="small-text fw-medium" colspan="4" style="text-align:center;">Page can't be crawled</td>
                                    <?php } ?>
                                    <td class="small-text fw-medium"><?php echo $page_da; ?></td>
                                    <td class="small-text fw-medium"><?php echo number_format($page_backlinks); ?></td>
                                </tr>
                        <?php } ?>

                        <!-- average data -->
                        <?php
                            $keyword_compare['word_count'] = getAverageData($average_data, 'wc');
                            $keyword_compare['headings'] = getAverageData($average_data, 'headings');
                            $keyword_compare['p'] = getAverageData($average_data, 'p');
                            $keyword_compare['img'] = getAverageData($average_data, 'img');
                            $keyword_compare['domain_authority'] = getAverageData($average_data, 'da');
                            $keyword_compare['backlinks'] = getAverageData($average_data, 'bl');
                        ?>
                        <tr class="bg-white">
                            <td class="small-text fw-bold">Average:</td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'wc'); ?></td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'headings'); ?></td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'p'); ?></td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'img'); ?></td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'da'); ?></td>
                            <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'bl'); ?></td>
                        </tr>
                        <!-- !end average row -->

                        <!--  -->
                        <?php 
                        if($data['own_data']){
                            $own_data = $data['own_data'];
                            $headings[] += $own_data['h1'];
                            $headings[] += $own_data['h2'];
                            $headings[] += $own_data['h3'];
                            $headings[] += $own_data['h4'];
                            $headings[] += $own_data['h5'];
                            $headings[] += $own_data['h6'];
                        ?>
                            <tr style="background-color: #f2f2f2;">
                                <th class="text fw-medium">Your Url</th>
                                <th class="text fw-medium">Word Count</th>
                                <th class="text fw-medium">Headings</th>
                                <th class="text fw-medium">Paragraphs</th>
                                <th class="text fw-medium">Images</th>
                                <th class="text fw-medium">Domain Authority</th>
                                <th class="text fw-medium">Backlinks</th>
                            </tr>
                            <tr>
                                <td class="small-text fw-bold">(<?php echo $own_data["position"] ?>) <?php echo $own_data["page_link"]; ?></td>
                                <td class="small-text fw-bold"><?php echo $own_data["word_count"]; ?></td>
                                <td class="small-text fw-bold"><?php echo array_sum($headings); ?></td>
                                <td class="small-text fw-bold"><?php echo $own_data["p"]; ?></td>
                                <td class="small-text fw-bold"><?php echo $own_data["img"]; ?></td>
                                <td class="small-text fw-bold"><?php echo $own_data["domain_authority"]; ?></td>
                                <td class="small-text fw-bold"><?php echo $own_data["backlinks"]; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        <?php } ?>
<?php } ?>