<?php
/*
 * 
 * /seo-manager/managers/
 *
 */
add_shortcode( 'seo-managers-view', '_seo_managers_view' );
function _seo_managers_view() {
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">SEO Managers</div>
    </div>
<?php

    // get all users
    $account_managers = get_users(array(
        'role'    => 'account_manager',
        'orderby' => 'user_nicename',
        'order'   => 'ASC'
    ));
    $seo_account_managers = get_users(array(
        'role'    => 'seo_account_manager',
        'orderby' => 'user_nicename',
        'order'   => 'ASC'
    ));
?>
    <!-- <div class="client-information-box"> -->
        <table class="table bg-white mt-3">
            <thead>
                <tr>
                    <th class="text fw-regular">Name</th>
                    <th class="text fw-regular">Email</th>
                    <th class="text fw-regular">Clients</th>
                    <th class="text fw-regular">Total Client Spending</th>
                    <th class="text fw-regular"></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    foreach($account_managers as $key => $account_manager){

                        // get all assigned customers
                        $assigned_customers = get_the_author_meta("_assigned_customers", $account_manager->ID);

                        // get total spent 
                        $overall_spent = 0;

                        // check if the array exists
                        if($assigned_customers){

                            // loop through the assigned customers
                            foreach($assigned_customers as $customer_id){

                                // get total spent per customer
                                $customer_wc   = new WC_Customer($customer_id);
                                $total_spent   = $customer_wc->get_total_spent();
                                $overall_spent = $overall_spent+$total_spent;
                            }
                        }
                ?>
                    <tr>
                        <td class="text"><?php echo $account_manager->first_name . " " . $account_manager->last_name; ?></td>
                        <td class="text"><?php echo $account_manager->user_email; ?></td>
                        <td class="text"><?php echo is_array($assigned_customers) ? count($assigned_customers) : 0; ?></td>
                        <td class="text"><?php echo wc_price($overall_spent); ?></td>
                        <td class="text">
                            <form action="/seo-manager/managers/manager/" method="GET">
                                <input type="hidden" name="id" value="<?php echo $account_manager->ID; ?>">
                                <button type="submit" class="btn-orange-outline text lh-1 rounded-0 py-2 px-3">View Manager Information</button>
                            </form>
                            <!-- <a href="/seo-manager/managers/manager/?id=<?php echo $account_manager->ID; ?>">View Information</a> -->
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    <!-- </div> -->

    <div class="bg-white p-3 mb-3 border-top-5 border-orange mt-5">
        <div class="text fw-medium">SEO Account Managers</div>
    </div>
    <table class="table bg-white mt-3">
            <thead>
                <tr>
                    <th class="text fw-regular">Name</th>
                    <th class="text fw-regular">Email</th>
                    <th class="text fw-regular">Clients</th>
                    <th class="text fw-regular">Total Client Spending</th>
                    <th class="text fw-regular"></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    foreach($seo_account_managers as $key => $account_manager){

                        // get all assigned customers
                        $assigned_customers = get_the_author_meta("_assigned_customers", $account_manager->ID);

                        // get total spent 
                        $overall_spent = 0;

                        // check if the array exists
                        if($assigned_customers){

                            // loop through the assigned customers
                            foreach($assigned_customers as $customer_id){

                                // get total spent per customer
                                $customer_wc   = new WC_Customer($customer_id);
                                $total_spent   = $customer_wc->get_total_spent();
                                $overall_spent = $overall_spent+$total_spent;
                            }
                        }
                ?>
                    <tr>
                        <td class="text"><?php echo $account_manager->first_name . " " . $account_manager->last_name; ?></td>
                        <td class="text"><?php echo $account_manager->user_email; ?></td>
                        <td class="text"><?php echo is_array($assigned_customers) ? count($assigned_customers) : 0; ?></td>
                        <td class="text"><?php echo wc_price($overall_spent); ?></td>
                        <td class="text">
                            <form action="/seo-manager/managers/manager/" method="GET">
                                <input type="hidden" name="id" value="<?php echo $account_manager->ID; ?>">
                                <button type="submit" class="btn-orange-outline text lh-1 rounded-0 py-2 px-3">View Manager Information</button>
                            </form>
                            <!-- <a href="/seo-manager/managers/manager/?id=<?php echo $account_manager->ID; ?>">View Information</a> -->
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
<?php
}


/*
 * 
 * https://seoi.io/seo-manager/managers/manager/?id=1
 * Date Created: August 19, 2022
 * Data Updated: August 19, 2022
 * 
 * id - the id of the account manager
 *
 */
add_shortcode('seo-manager-details', 'seoManagerDetails');
function seoManagerDetails() {
    
    // get seo manager details
    $manager_id = $_GET['id'];
    $manager    = get_user_by('id', $manager_id);

?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">SEO Manager Information</div>
    </div>
<?php

    // check if the manager exists
    if($manager_id && $manager){

       /*  echo "<pre>";
        var_dump($manager);
        echo "</pre>"; */
?>
        <!-- <div class="client-information-box mb-3"> -->
            <table class="table bg-white mt-3">
                <thead>
                    <tr>
                        <th class="text fw-regular">Name</th>
                        <th class="text fw-regular">Email</th>
                        <th class="text fw-regular">Clients</th>
                        <th class="text fw-regular">Total Client Spending</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        // foreach($account_managers as $key => $account_manager){

                            // get all assigned customers
                            $assigned_customers = get_the_author_meta("_assigned_customers", $manager_id);

                            // get total spent 
                            $overall_spent = 0;

                            // check if the array exists
                            if($assigned_customers){

                                // loop through the assigned customers
                                foreach($assigned_customers as $customer_id){

                                    // get total spent per customer
                                    $customer_wc   = new WC_Customer($customer_id);
                                    $total_spent   = $customer_wc->get_total_spent();
                                    $overall_spent = $overall_spent+$total_spent;
                                }
                            }
                    ?>
                        <tr>
                            <td class="text"><?php echo $manager->first_name . " " . $manager->last_name; ?></td>
                            <td class="text"><?php echo $manager->user_email; ?></td>
                            <td class="text"><?php echo is_array($assigned_customers) ? count($assigned_customers) : 0; ?></td>
                            <td class="text"><?php echo wc_price($overall_spent); ?></td>
                        </tr>
                    <?php //} ?>
                </tbody>
            </table>
        <!-- </div> -->
        <!-- <div class="client-information-box">
            <table class="assigned-orders-table" id="manager-appsheet-data">
                <thead>
                    <tr>
                        <th colspan="2">Appsheet Details</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        /* $appsheet_app_id = get_the_author_meta( "_appsheet_app_id", $manager_id );
                        $appsheet_access_key = get_the_author_meta( "_appsheet_access_key", $manager_id );
                        $appsheet_table_name = get_the_author_meta( "_appsheet_table_name", $manager_id ); */
                    ?>
                    <tr>
                        <td>App ID:</td>
                        <td><input id="appsheet-app-id" class="w-100 rounded-0" type="text" value="<?php //echo $appsheet_app_id ? $appsheet_app_id : ""; ?>"></td>
                    </tr>
                    <tr>
                        <td>Application Access Key:</td>
                        <td><input id="appsheet-access-key" class="w-100 rounded-0" type="text" value="<?php //echo $appsheet_access_key ? $appsheet_access_key : ""; ?>"></td>
                    </tr>
                    <tr>
                        <td>Table Name:</td>
                        <td><input id="appsheet-table-name" class="w-100 rounded-0" type="text" value="<?php //echo $appsheet_table_name ? $appsheet_table_name : ""; ?>"></td>
                    </tr>
                    <tr>
                        <td colspan="2"><a href="" class="py-2 px-3 text-white" style="background-color: #fa7d09;" data-manager-id="<?php //echo $manager_id; ?>">Save Appsheet Details</a></td>
                    </tr>
                </tbody>
            </table>
        </div> -->
<?php
    } else {

        // redirect to the seo managers page if the manager details can't be found
        header("Location: https://seoi.io/seo-manager/managers/");
    }
}

// save app sheet details
/* add_action('wp_ajax_saveAppsheetDetails', 'saveAppsheetDetails');
add_action('wp_ajax_nopriv_saveAppsheetDetails', 'saveAppsheetDetails');
function saveAppsheetDetails(){
    
    // get the app id
    $app_id = $_REQUEST['app_id'];
    // get the access key
    $access_key = $_REQUEST['access_key'];
    // get the table name
    $table_name = $_REQUEST['table_name'];
    // get the manager id
    $manager_id = $_REQUEST['manager_id'];
    
    // update the app sheet details
    update_user_meta($manager_id, '_appsheet_app_id', $app_id);
    update_user_meta($manager_id, '_appsheet_access_key', $access_key);
    update_user_meta($manager_id, '_appsheet_table_name', $table_name);
    
    // return success
    echo "success";

    die();
} */