<?php
add_shortcode( 'seo-rankings', 'seoRankings' );
function seoRankings() {
    
    // Start Buffer
    ob_start();

    // Initialize SEOI
    $seoi = new SEOI();

    

    // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
    $user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
    // IF EMPTY, GET THE CURRENT USER ID
    $user_id = $user_id ? $user_id : get_current_user_id();
    // GET MANAGER ID
    $accountManager = get_the_author_meta( "_assigned_account_manager", $user_id );
    // GET USER ID BY EMAIL
    $accountManager = get_user_by( "email", $accountManager );
    // GET THE CUSTOMER ID
    $manager_id = $accountManager ? $accountManager->ID : $user_id; // USE USER IF NO MANAGER IS SET

    // Validate User
    $validateUser = $seoi->validateUser('', '', $manager_id);

    $user_websites = get_user_meta( $user_id, '_user_websites', true );


    // get current url without parameters
    $action_url = strtok($_SERVER["REQUEST_URI"], '?');
    // var_dump($asd); 

   /*  dd($user_id);
    dd($manager_id);
    dd($validateUser); */

    ?>
    <div class="bg-white mb-3 p-3 border-top-5 border-orange">
        <div class="text fw-medium">SEO Rankings</div>
    </div>
    <?php
    
    
    // Check if user is valid
    if( $validateUser ){
        // Initialize Google Search Console
        $searchConsole = new GOOGLE_SEARCH_CONSOLE();
        
        // User site list
        $siteList = $searchConsole->siteList($manager_id, $user_id); // seo manager id, customer id


        // $asdasdas = get_user_meta( $user_id, '_user_websites', true );

        
        
        

        // Check if keyword _POST is set
        // FOR SAVING THE KEYWORDS
        if(isset($_POST['keyword'])){

            // data
            $_keyword       = $_POST['keyword'];
            $_position      = $_POST['position'];
            $_past_position = $_POST['past_position'];  
            $_current_site  = $_POST['current_site'];  

            
            // save keyword data
            $searchConsole->saveKeywordData( $_keyword, $_position, $_past_position, $_current_site );
            // dd($_POST);
            // dd($TEST);
        }

        // Check if site list is not empty
        if( !empty($siteList) ){

           /*  dd($manager_id);
            dd($user_id);
            dd($validateUser);
            dd($siteList);
            // dd($asdasdas); */

           /*  $token = get_user_meta( $user_id, 'google_token', true );
            $token_access = get_user_meta( $user_id, 'google_token_access', true );
            $token_expires = get_user_meta( $user_id, 'google_token_expires', true );
            $token_expires = $token_expires ? intval($token_expires) : 0;
            $token_created = get_user_meta( $user_id, 'google_token_created', true );
            $token_refresh = get_user_meta( $user_id, 'google_token_refresh', true );
            dd($token);
            dd($token_access);
            dd($token_expires); */

            // GET SAVED SITE DATA JUST FOR THE DATE AND SITE URL
            $siteData = get_user_meta( $user_id, 'google_site_data', true );
            $originalSiteData = $siteData;
            
            // $tracked_pages = get_user_meta( $user_id, 'google_tracked_pages', true );
            // $tracked_pages = get_user_meta( $user_id, 'google_tracked_pages', true );
            // $tracked_pages = $tracked_pages ? $tracked_pages[$site_url] : [];


            
            
            // update_user_meta( $user_id, 'google_site_data', '' );
            // die();
            // dd(count($siteData['pages']));
            /* if(count($siteData['pages']) === 0){
                dd($siteData['pages']);
            } */
            // IF REMOVE
            if(isset($_GET['action']) && $_GET['action'] == 'remove' && !empty($siteData) && isset($siteData['pages']) && isset($_GET['inner']) ){
                // dd($_GET);
                // CHECK IF THE INNER PAGE IS IN THE PAGES
                $inner = $_GET['inner'];
				foreach($siteData['pages'] as $key => $tracked_page){
					// CHECK IF INNER PAGE IS EQUAL TO THE TRACKED PAGE
					if($inner == $tracked_page['site']){
                        // SET SITE DATA
						// $siteData['pages'][$key] = $data;
                        // remover from array
                        unset($siteData['pages'][$key]);
					}
				}
                // SAVE THE SITE DATA
		        update_user_meta( $user_id, 'google_site_data', $siteData );
                // RE-ASSIGN SITE DATA
                $originalSiteData = $siteData;
            } 
            // else {
                // CHECK IF SITE URL IS SET
                if(isset($_GET['site']) && !isset($_GET['action'])){
                    // SET SITE URL
                    $site_url = $_GET['site'];
                    $original_site_url = $site_url; // original site url
                    /* $sanitized_site_url = str_replace('sc-domain:', 'https://', $site_url);
                    // add trailing slash
                    $sanitized_site_url = rtrim($sanitized_site_url, '/').'/'; */
                    $inner = isset($_GET['inner']) ? $_GET['inner'] : "";
                    // $inner = isset($_GET['inner']) ? $_GET['inner'] : $sanitized_site_url;
                    // $site_url = 'sc-domain:seoi.co.uk';

                    // GET UPDATED SITE DATA
                    $siteData = $site_url ? $searchConsole->siteData($site_url, $manager_id, $user_id, $inner) : '';

                    /* // dd($sanitized_site_url);
                    dd($site_url);
                    dd($original_site_url);
                    dd($siteData); */

                    // SET INNER PAGE URL AS SITE URL
                    if(isset($siteData['pages'])){
                        foreach($siteData['pages'] as $key => $tracked_page){
                            if(isset($_GET['inner']) && $_GET['inner'] == $tracked_page['site']){
                                // SET SITE URL
                                $site_url = isset($tracked_page['site']) ? $tracked_page['site'] : '';
                                // SET SITE DATA
                                $siteData = $tracked_page;
                            }
                        }
                    }
                } elseif (!empty($siteData)){
                    // SET SITE URL FROM SAVED SITE DATA
                    $site_url = $siteData["site"]; // default
                    $original_site_url = $site_url; // original site url
                    // $site_url = isset($_GET['inner']) ? $_GET['inner'] : $site_url;

                    // SET INNER PAGE URL AS SITE URL
                    if(isset($siteData['pages'])){
                        foreach($siteData['pages'] as $key => $tracked_page){
                            if(isset($_GET['inner']) && $_GET['inner'] == $tracked_page['site']){
                                // SET SITE URL
                                $site_url = isset($tracked_page['site']) ? $tracked_page['site'] : '';
                                // SET SITE DATA
                                $siteData = $tracked_page;
                            }
                        }
                    }
                }
            // }

            

            // DATE SITE DATA IS GENERATED
            $dateSiteGenerated = isset($siteData['date_generated']) ? $siteData['date_generated'] : '';

            // get updated site data
            // $siteData = $site_url ? $searchConsole->siteData($site_url, $user_id) : '';
            
            // dd($dateSiteGenerated);

            // RESET GOOGLE SITE DATA META -- !DELETE LATER
            /* update_user_meta( $user_id, 'google_site_data', '' );
            update_user_meta( $user_id, 'google_token', '' );
            update_user_meta( $user_id, 'google_token_access', '' );
            update_user_meta( $user_id, 'google_token_expires', '' );
            update_user_meta( $user_id, 'google_token_created', '' );
            update_user_meta( $user_id, 'google_token_refresh', '' ); */

            // existing keyword basket
            $keyword_data = get_user_meta( $user_id, 'google_user_keyword_basket', true );
            // dd($keyword_data);
            // GET KEYWORD DATA FOR SPECIFIC SITE
            $keyword_data = isset($keyword_data[$site_url]) ? $keyword_data[$site_url] : [];
        ?>
            

            <?php if(isset($_POST['keyword'])){ ?>
                <div class="alert alert-success alert-dismissible fade show rounded-0" role="alert">
                    <strong>Success!</strong> Your changes have been saved.
                </div>
            <?php } ?>
            
            <?php
                // GET THE VIEW AS TO CHECK IF THE USER IS VIEWING AS A CUSTOMER
                $view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
            ?>
            <?php //if($view_as == 'user'){ ?>
                <table class="table bg-white">
                    <thead>
                        <tr>
                            <th class="text fw-medium">Site URL</th>
                            <th class="text fw-medium">Permission Level</th>
                            <th class="text fw-medium"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($siteList as $key => $site){ ?>
                            <?php //if($site['permissionLevel'] == 'siteOwner' || $site['permissionLevel'] == 'siteFullUser'){ ?>
                                <tr>
                                    <td class="text"><?php
                                    // the site url
                                    $siteSiteUrl = $site['siteUrl'];

                                    // remove sc-domain: from site url and add https:// add trailing slash
                                    $siteSiteUrl = str_replace('sc-domain:', 'https://', $siteSiteUrl);
                                    echo $siteSiteUrl = rtrim($siteSiteUrl, '/').'/';

                                    ?></td>
                                    <td class="text"><?php
                                        // add space before capital letters
                                        $permissionLevel = preg_replace('/(?<!\ )[A-Z]/', ' $0', $site['permissionLevel']);
                                        // capitalize first letter
                                        echo $permissionLevel = ucfirst($permissionLevel);
                                    ?></td>
                                    <td class="text">
                                        <?php if($site['permissionLevel'] == 'siteOwner' || $site['permissionLevel'] == 'siteFullUser'){ ?>
                                            <form action="<?php echo $action_url; ?>" method="GET">
                                                <input type="hidden" name="site" value="<?= $site['siteUrl']; ?>">
                                                <?php
                                                    // if inner is set, add it to the form
                                                    if(isset($_GET['inner'])){
                                                        echo '<input type="hidden" name="inner" value="'.$_GET['inner'].'">';
                                                    }
                                                ?>
                                                <?php //if($siteData){ ?>
                                                    <!-- <input type="hidden" name="update" value="true"> -->
                                                <?php //} ?>
                                                <style>.google-btn .tcb-icon{color: white !important;}</style>

                                                <button type="submit" class="btn-orange google-btn py-2 px-2 px-lg-4 small-text lh-1"><svg style="position: relative; top: -1px;" fill="currentColor" class="tcb-icon" viewBox="0 0 488 512" data-id="icon-google-brands" data-name=""><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"></path></svg> Set / Update Data</button>

                                                
                                            </form>
                                            <!-- <a href="<?php //echo GOOGLE_SEARCH_AND_ANALYTICS_OAUTH_URL_RANKINGS; ?>">Test</a> -->
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php //} ?>
                        <?php } ?>
                    </tbody>
                </table>
            <?php //} ?>
        <?php
        }

      /*   // dd($keyword_data);
        // dd($user_websites);
        dd($siteData);
        // dd($_GET); */
        
        // check if site data is not empty
        // if( !empty($siteData['data']) && $user_websites ){
        if( $user_websites ){
            
            // FILTER ONLY THE KEYWORDS THAT ARE IN THE KEYWORD BASKET
            // if(!empty($siteData['data']) && isset($_GET['keywords']) && $_GET['keywords'] == 'starred'){
            if(!empty($siteData['data']) && !isset($_GET['keywords']) || isset($_GET['keywords']) && $_GET['keywords'] == ''){
                // Filter data2 if it exists in data1
                $filteredData2 = array_filter($siteData['data'], function ($item2) use ($keyword_data) {
                    // Extract the keyword from data2
                    $keyword2 = $item2["keys"][0];
                    
                    // Check if the keyword from data2 exists in keyword_data
                    return isset($keyword_data[$keyword2]);
                });
                // Convert the filtered data back to an indexed array
                $filteredData2 = array_values($filteredData2);
                $siteData['data'] = $filteredData2;
            } 
            /* elseif (!empty($siteData['data']) && isset($_GET['keywords']) && $_GET['keywords'] == 'all'){

            } */

            // GET THE SITE
            $site = $siteData['site'];

            // FILTER URLS SO WE CAN COMPARE
            $filtered_site = filterWebsiteUrl($site);
            $filtered_site_validation = [];
    
            // LOOP THROUGH USER WEBSITES
            foreach($user_websites as $key => $user_website){
                // FILTER URLS SO WE CAN COMPARE
                $filtered_user_website = filterWebsiteUrl($user_website);
                // COMPARE
                if($filtered_site == $filtered_user_website){
                    // SET THE FILTERED SITE
                    $filtered_site_validation[] = true;
                }
            }
    
            // CHECK IF ARRAY HAS TRUE
            if(in_array(true, $filtered_site_validation)){
            
                // arrows used for the pdf
                $up_arrow = "data:image/png;base64,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";
                $down_arrow = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAPCAYAAAAyPTUwAAAACXBIWXMAAC4jAAAuIwF4pT92AAAGumlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS42LWMxNDUgNzkuMTYzNDk5LCAyMDE4LzA4LzEzLTE2OjQwOjIyICAgICAgICAiPiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdEV2dD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlRXZlbnQjIiB4bWxuczpwaG90b3Nob3A9Imh0dHA6Ly9ucy5hZG9iZS5jb20vcGhvdG9zaG9wLzEuMC8iIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ0MgMjAxOSAoV2luZG93cykiIHhtcDpDcmVhdGVEYXRlPSIyMDIxLTExLTI0VDIyOjIzOjE1KzA4OjAwIiB4bXA6TWV0YWRhdGFEYXRlPSIyMDIxLTExLTI0VDIyOjIzOjE1KzA4OjAwIiB4bXA6TW9kaWZ5RGF0ZT0iMjAyMS0xMS0yNFQyMjoyMzoxNSswODowMCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpkN2Q3NGVlNy1kYjQzLWRlNGEtOTNlNy0wYTA5YWJiMzQ4N2YiIHhtcE1NOkRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3ODViMGY2MS1hYzg2LTg1NDItODNkYS05YTg4MWZjMTc5YzUiIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDoxNjVhZWZkYi1kNjEwLWQwNDUtYWU0NC1lOTE4ZGE0OGNjOWUiIHBob3Rvc2hvcDpDb2xvck1vZGU9IjMiIHBob3Rvc2hvcDpJQ0NQcm9maWxlPSJzUkdCIElFQzYxOTY2LTIuMSIgZGM6Zm9ybWF0PSJpbWFnZS9wbmciPiA8eG1wTU06SGlzdG9yeT4gPHJkZjpTZXE+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjcmVhdGVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjE2NWFlZmRiLWQ2MTAtZDA0NS1hZTQ0LWU5MThkYTQ4Y2M5ZSIgc3RFdnQ6d2hlbj0iMjAyMS0xMS0yNFQyMjoyMzoxNSswODowMCIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTkgKFdpbmRvd3MpIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJzYXZlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDpkN2Q3NGVlNy1kYjQzLWRlNGEtOTNlNy0wYTA5YWJiMzQ4N2YiIHN0RXZ0OndoZW49IjIwMjEtMTEtMjRUMjI6MjM6MTUrMDg6MDAiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCBDQyAyMDE5IChXaW5kb3dzKSIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8L3JkZjpTZXE+IDwveG1wTU06SGlzdG9yeT4gPHBob3Rvc2hvcDpUZXh0TGF5ZXJzPiA8cmRmOkJhZz4gPHJkZjpsaSBwaG90b3Nob3A6TGF5ZXJOYW1lPSLihpEiIHBob3Rvc2hvcDpMYXllclRleHQ9IuKGkSIvPiA8cmRmOmxpIHBob3Rvc2hvcDpMYXllck5hbWU9IuKGkyIgcGhvdG9zaG9wOkxheWVyVGV4dD0i4oaTIi8+IDwvcmRmOkJhZz4gPC9waG90b3Nob3A6VGV4dExheWVycz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5XesKsAAAAZklEQVQoz2P4//8/Awgjg//iAQZwNlQehJkYsIMJ2ARxKWYYVUwbxaBYA+IEJL4AEE/AZfIDIC4AKjgApBWA+AJUDFMx48sNH4CUAxALALE8EG8AiqFGO3pCgjrnAbaExIie4vABAC/ZONz1qSeQAAAAAElFTkSuQmCC";
                
            
               /*  dd(get_site_url());
                dd($action_url);
                // dd($original_site_url);
                // dd($originalSiteData['pages']);  */
        ?>
                <table class="table bg-white">
                    <thead>
                        <tr>
                            <th colspan="6">
                                <!-- Site: <strong><?php 
                                    // remove sc-domain: from site url and add https:// add trailing slash
                                    // echo rtrim(str_replace('sc-domain:', 'https://', $original_site_url), '/').'/';
                                    ?></strong> -->

                                <div>
                                    <h5 class="mb-0" style="font-weight: bold;">Add a Power Page</h5>
                                    <form class="d-lg-flex align-items-center" action="<?php echo $action_url; ?>" style="" id="strategyPowerPage">
                                        <input type="hidden" value="<?php echo $original_site_url; ?>" name="site_url">
                                        <input type="hidden" value="<?php echo $user_id; ?>" name="user_id">
                                        <input type="text" name="power_page" class="rounded-0 px-2 text fw-regular w-100 mr-1" style="height:40px; max-width: 350px;"  placeholder="Eg. https://yourwebsite.com/page-one/" required><br>
                                        <button type="submit" class="btn-orange text fw-regular px-3 py-0 rounded-0 mt-1 mt-lg-0" style="height:40px;">Add a page</button>
                                    </form>
                                </div>

                                <div class="mt-4">
                                    <h5 class="mb-0" style="font-weight: bold;">Power Pages</h5>
                                    <?php
                                        if(isset($originalSiteData['pages'])){
                                            // build url
                                            echo "<ul class='p-0 m-0' style='list-style:none;'>";
                                            $url = get_site_url().$action_url;
                                            echo "<li class='p-0 m-0 mr-1 mb-1 d-inline-block small-text'><a href='".$url."' style='
                                            background: #dddddd;
                                            display: inline-block;
                                            padding: 2px 10px;
                                            border-radius: 35px;
                                            color: #636060;
                                            font-weight: bold;
                                            text-decoration: none;
                                        '>".rtrim(str_replace('sc-domain:', 'https://', $original_site_url), '/').'/'."</a></li>";
                                            foreach($originalSiteData['pages'] as $key => $tracked_page){
                                                
                                                $params = "?inner=".urlencode($tracked_page['site'])."&site=".urlencode($original_site_url);
                                                $url = $url.$params;
                                                // encode url
                                                // $url = $url."?"urlencode($params);
                                                // selected
                                                echo "<li class='p-0 m-0 mr-1 mb-1 d-inline-block small-text'><a href='".$url."' style='
                                                background: #dddddd;
                                                display: inline-block;
                                                padding: 2px 10px;
                                                border-radius: 35px;
                                                color: #636060;
                                                font-weight: bold;
                                                text-decoration: none;
                                            '>".$tracked_page['site']."</a></li>";
                                            }
                                            echo "</ul>";
                                        }
                                    ?>
                                </div>
                            </th>
                            <!-- <th colspan="1">+</th> -->
                        </tr>
                        <tr>
                            <th colspan="3">Date Generated: <strong><?php 
                            // echo $dateSiteGenerated; 
                            // FORMAT DATE TO BE READABLE WITH TIME
                            echo date('F j, Y, g:i a', strtotime($dateSiteGenerated));
                            ?></strong></th>
                            <th colspan="2">
                                <form action="<?php echo $action_url; ?>" method="GET" class="w-100">
                                    <input type="hidden" name="site" value="<?php echo $original_site_url; ?>">
                                    <select name="inner" id="site-page-select" class="w-100" style="height: 40px;" onchange="document.getElementById('site-page-select').form.submit()">
                                        <option <?php echo isset($_GET['inner']) ? "" : "selected"; ?> value="<?php echo $original_site_url; ?>"><?php echo rtrim(str_replace('sc-domain:', 'https://', $original_site_url), '/').'/'; ?></option>
                                        <?php
                                            // LOOP THROUGH TRACKED PAGES
                                            $test = [];
                                            if(isset($originalSiteData['pages'])){
                                                foreach($originalSiteData['pages'] as $key => $tracked_page){
                                                    // selected
                                                    $selected = isset($_GET['inner']) && $_GET['inner'] == $tracked_page['site'] ? "selected" : "";
                                                    echo "<option ".$selected." value='".$tracked_page['site']."'>".$tracked_page['site']."</option>";
                                                    $test[] = $selected == "selected" ? true : "";
                                                }
                                            }
                                        ?>
                                    </select>
                                </form>
                                <?php if(in_array(true, $test)){ ?>
                                    
                                    <form action="<?php echo $action_url; ?>" method="GET">
                                        <?php
                                            if(isset($_GET['inner'])){ 
                                                // if inner is set, add it to the form
                                                echo '<input type="hidden" name="inner" value="'.$_GET['inner'].'">';
                                            }
                                        ?>
                                        <input type="hidden" name="action" value="remove">
                                        <input type="hidden" name="site" value="<?php echo $original_site_url; ?>">
                                        <button type="submit" class="btn p-0 small-text text-danger">Remove</button>
                                    </form>
                                <?php } ?>
                            </th>
                            <th colspan="1">
                                <form action="<?php echo $action_url; ?>" method="GET" class="w-100">
                                        <?php
                                            // if inner is set, add it to the form
                                            if(isset($_GET['inner'])){
                                                echo '<input type="hidden" name="inner" value="'.$_GET['inner'].'">';
                                            }
                                        ?>
                                    <select name="keywords" id="keyword-select" class="w-100 px-2 text" style="height: 40px;" onchange="document.getElementById('keyword-select').form.submit()">
                                        <option value="" <?php echo isset($_GET['keywords']) && $_GET['keywords'] == 'all' ? '' : 'selected'; ?>>Starred Keywords</option>
                                        <option value="all" <?php echo isset($_GET['keywords']) && $_GET['keywords'] == 'all' ? 'selected' : ''; ?>>View All</option>
                                    </select>
                                </form>
                            </th>
                            
                        </tr>
                        <tr>
                            <th class="text fw-medium">Keyword</th>
                            <th class="text fw-medium">Clicks</th>
                            <th class="text fw-medium">Impressions</th>
                            <th class="text fw-medium">Past Position</th>
                            <th class="text fw-medium">Current Position</th>
                            <th class="text fw-medium">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if(!empty($siteData['data'])){
                            // loop through site data
                            foreach($siteData['data'] as $key => $data){						
                                // GET THE PAST POSITION
                                $past_position = $data['past_position'] ? round($data['past_position'], 2) : '-';
                                // GET THE CURRENT POSITION
                                $current_position = $data['position'] ? round($data['position'], 2) : '-';
                            ?>
                                    <tr>
                                        <td class="text"><?php echo $data['keys'][0]; ?></td>
                                        <td class="text"><?php echo $data['clicks']; ?></td>
                                        <td class="text"><?php echo $data['impressions'] ? round($data['impressions'], 2) : '-'; ?></td>
                                        <td class="text"><?php 
                                            // echo $data['past_position'] ? round($data['past_position'], 2) : '-'; 
                                            echo $past_position;
                                        ?></td>
                                        <td class="text">
                                            <?php //echo $data['position'] ? round($data['position'], 2) : '-'; ?>
                                            <?php
                                                echo $current_position;
                                                // CALCULATE THE DIFFERENCE BETWEEN THE CURRENT POSITION AND THE PAST POSITION
                                                if ($past_position != "-" && $current_position > $past_position) {
                                                    echo "<img src='".$down_arrow."'>";
                                                } elseif ($past_position != "-" && $current_position < $past_position) {
                                                    echo "<img src='".$up_arrow."'>";
                                                }
                                            ?>
                                        </td>
                                        <td><form action="<?php //echo $action_url; ?>" method="POST">
                                            <input type="hidden" name="current_site" value="<?php echo $site_url; ?>">
                                            <input type="hidden" name="keyword" value="<?php echo $data['keys'][0]; ?>">
                                            <input type="hidden" name="position" value="<?php echo $data['position']; ?>">
                                            <input type="hidden" name="past_position" value="<?php echo $data['past_position']; ?>">
                                            <button type="submit" title="Add '<?php echo $data['keys'][0]; ?>' to Keyword Basket" class="p-0 lh-1 bg-transparent border-0 shadow-none">
                                                <?php
                                                // check if keyword is in keyword basket as a key
                                                if( $keyword_data && array_key_exists($data['keys'][0], $keyword_data) ){
                                                ?>
                                                    <svg class="tcb-icon" viewBox="0 0 576 512" data-id="icon-star-solid" data-name=""><path d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"></path></svg>
                                                <?php } else { ?>
                                                    <svg class="tcb-icon" viewBox="0 0 576 512" data-id="icon-star-outlined" data-name=""><path d="M528.1 171.5L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6zM388.6 312.3l23.7 138.4L288 385.4l-124.3 65.3 23.7-138.4-100.6-98 139-20.2 62.2-126 62.2 126 139 20.2-100.6 98z"></path></svg>
                                                <?php } ?>
                                            </button>
                                        </form></td>
                                    </tr>
                            <?php } ?>
                        <?php } else { ?>
                            <tr>
                                <td colspan="6">Sorry! We couldn't find any website data. Please make sure that the website connected to your <a href="<?php echo get_site_url(); ?>/seo-manager/edit-account/">account</a> is verified in your Google Search Console.</td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            <?php } // !user_websites ?>
        <?php } else { ?>
            <div class="alert alert-warning alert-dismissible fade show rounded-0" role="alert">
                <?php
                    

                    if(!$user_websites){
                ?>
                    Please add a website to your <a href="<?php echo get_site_url(); ?>/seo-manager/edit-account/">account</a> so we can start tracking your rankings.
                <?php } else { ?>
                    Sorry! We couldn't find any website data. Please make sure that the website connected to your <a href="<?php echo get_site_url(); ?>/seo-manager/edit-account/">account</a> is verified in your Google Search Console.
                <?php } ?>
            </div>
        <?php
        }
    } else {

        // INVALID USER
    ?>
        <div class="bg-white p-3 border">
            <?php
                    

                if(!$user_websites){
            ?>
                Please add a website to your <a href="<?php echo get_site_url(); ?>/seo-manager/edit-account/">account</a> so we can start tracking your rankings.
            <?php } else { ?>
                <!-- <div class="text fw-medium">SEO Rankings</div> -->
                <!-- <hr style="opacity: 0.5;"> -->
                <div class="mb-2 text">Now connect your Google console and analytics for your rank tracker and site data.</div>
                <!-- <a href="<?php //echo SEARCH_CONSOLE_OAUTH_URL; ?>" class="btn-orange fw-light text py-1 px-3">Connect Google</a> -->
                <style>.google-btn .tcb-icon{color: white !important;}</style>
                <a href="<?= GOOGLE_SEARCH_AND_ANALYTICS_OAUTH_URL_RANKINGS; ?>" class="btn-orange fw-light text py-1 px-3 google-btn"><svg style="position: relative; top: -1px;" fill="white" class="tcb-icon" viewBox="0 0 488 512" data-id="icon-google-brands" data-name=""><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"></path></svg> Connect Google</a>
            <?php } ?>
        </div>
    <?php
    }

    // Return
    return ob_get_clean();
}

// add action seo_strategy_power_page
add_action('wp_ajax_seo_strategy_power_page', 'seo_strategy_power_page');
add_action('wp_ajax_nopriv_seo_strategy_power_page', 'seo_strategy_power_page');
function seo_strategy_power_page(){
    // json header
    header('Content-Type: application/json');

    // siteurl
    $site_url = $_POST['siteurl'];
    // powerpage
    $power_page = $_POST['powerpage'];
    // user id
    $user_id = $_POST['user_id'];

    // GET TRACKED PAGES
    $tracked_pages = get_user_meta( $user_id, 'google_site_data', true );

    // ob_start();

    // CHECK IF PAGES KEY EXISTS
    if( !array_key_exists('pages', $tracked_pages) ){
        // SET THE POWER PAGE
        // $tracked_pages[$site_url]['pages'] = [];
        $tracked_pages['pages'] = [];
    }
    // https://seoi.io/affordable-seo-company/
    // CHECK IF PAGES IS EMPTY
    if(count($tracked_pages['pages']) === 0){
    // if( !$tracked_pages[$site_url]['pages'] ){
        // dd($tracked_pages);
        // SET THE POWER PAGE
        $tracked_pages['pages'][] = array(
            'site' => $power_page,
            // 'asdasdasd' => "aszxxxxxxxd",
        );
    } else {
        // 
        $site_exists = false;
        if(count($tracked_pages['pages']) < 5){
            // LOOP THROUGH TRACKED PAGES
            foreach($tracked_pages['pages'] as $key => $tracked_page){
                // CHECK IF POWER PAGE EXISTS AS IN ARRAY OF PAGES AS SITE
                if($tracked_page['site'] == $power_page){
                    // SET SITE EXISTS TO TRUE
                    $site_exists = true;
                }
            }
            // ADD
            if(!$site_exists){

                $tracked_pages['pages'][] = array(
                    'site' => $power_page,
                    // 'asdasdasd' => "asd",
                );
            }
        }
    }

    // $json_response['test'] = ob_get_clean();

    

    // UPDATE TRACKED PAGES
    update_user_meta( $user_id, 'google_site_data', $tracked_pages );
    


    // 
    // echo json_encode($tracked_pages['pages']);
    // echo json_encode($site_exists);
    

    die();
}