<?php
/*
	seo-manager/todos/
	-- seo strategy todos
*/
add_shortcode( 'seo-todo', '_seo_todo' );
function _seo_todo() {
    ob_start();
    
    // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$current_user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$current_user_id = $current_user_id ? $current_user_id : get_current_user_id();
    // GET USER OBJECT BY ID
    $user = get_user_by( 'id', $current_user_id );
    // GET USER ROLE
    $user_role = $user->roles[0];
    // GET VIEW AS -- FOR ACCOUNT MANAGER
    $view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
    // GET THE SEOI CLASS
    $newSeoi = new SEOI();
    // VALIDATE USER -- VALIDATE IF THE USER HAS A VALID GOOGLE ACCOUNT OR TOKEN IS NOT EXPIRED OR VALID
    $validateUser = $newSeoi->validateUser('todos', '', $current_user_id);
    // MANAGED ROLES
    $managed_roles = array("administrator", "seo_manager", "account_manager");

    // GET ASSIGNED USERS. IF USER IS NOT AN ACCOUNT MANAGER, SET THE ASSIGNED CUSTOMERS TO THE CURRENT USER ID
    $assignedCustomers[] = isset($_GET["cid"]) ? $_GET["cid"] : $current_user_id;
    $assignedCustomers = $user_role == "account_manager" ? get_the_author_meta("_assigned_customers", $current_user_id) : $assignedCustomers;

    // CHECK IF THERE'S A CUSTOMER
    if($assignedCustomers){
?>
        <div class="bg-white p-3 border-top-5 border-orange">
            <div class="text fw-medium">Todo Lists</div>
        </div>
            <!-- <div class="bg-white p-3 mt-3 border">
                <div class="mb-2 text">Please connect your Google account first.</div>
                <style>.google-btn .tcb-icon{color: white !important;}</style>
                <a href="<?php //echo GOOGLE_SEARCH_AND_ANALYTICS_OAUTH_URL_TODOS; ?>" class="btn-orange fw-light text py-1 px-3 google-btn"><svg style="position: relative; top: -1px;" fill="white" class="tcb-icon" viewBox="0 0 488 512" data-id="icon-google-brands" data-name=""><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"></path></svg> Connect Google</a>
            </div> -->
        <?php
            // LOOP THROUGH THE ASSIGNED CUSTOMERS TO GET THE TODO LIST OF EACH CUSTOMER
            foreach($assignedCustomers as $customer_id){
                // GET TODOS
                $todo_list = get_user_meta($customer_id, "todo_list", true) ?? [];
                // GET CUSTOMER OBJECT BY ID
                $customer = get_user_by('id', $customer_id);
                // CHECK IF CUSTOMER IS VALID
                if($customer){
                    // GET CUSTOMER EMAIL
                    $customer_email = $customer->user_email;
                    // GET CUSTOMER NAME
                    $customer_name = get_user_meta($customer_id, "first_name", true) . " " . get_user_meta($customer_id, "last_name", true);
        ?>
                    <table class="table bg-white m-0 mt-3">
                        <thead>
                            <tr>
                                <th class="text fw-medium" colspan="7">
                                    <?php echo $customer_name; ?> (<span class="small-text"><?php echo $customer_email; ?>)</span>
                                </th>
                            </tr>
                            <tr>
                                <td class="text fw-medium">Status</td>
                                <td class="text fw-medium">Date Created</td>
                                <td class="text fw-medium">Due Date</td>
                                <td class="text fw-medium">Closed Date</td>
                                <td class="text fw-medium">Keywords</td>
                                <td class="text fw-medium">URL</td>
                                <td></td>
                            </tr>
                        </thead>
                    </table>
        <?php
                    // CHECK IF TODO LIST IS AN ARRAY AND IS NOT EMPTY
                    if($todo_list){
                        // INITIALIZE ARRAY
                        $ongoing_todos = array();
                        $completed_todos = array();
                        // LOOP THROUGH THE TODO LIST AND SEPARATE THE ONGOING TODOS AND COMPLETED TODOS
                        foreach($todo_list as $todo){
                            // GET THE ENTRY ID
                            $entry_id = $todo['entry_id'];
                            // GET THE ENTRY
                            $entry = GFAPI::get_entry( $entry_id );
                            // GET THE TODO LIST STATUS
                            $parentTodoStatus = rgar($entry, '13') == "" ? "Ongoing" : rgar($entry, '13');
                            // GET THE TODO LIST DATA
                            $additional_todos = rgar($entry, '19');
                            // INITIALIZE THE IS COPY VARIABLE
                            $isCopy = false;
                            // 
                            $todoStatus = "";
                            // CHECK IF ADDITIONAL TODOS IS EMPTY
                            if($additional_todos){
                                // DECODE THE TODO LIST DATA
                                $additional_todos = json_decode($additional_todos, true);
                                // LOOP THROUGHT THE DECODED TODO LIST DATA
                                foreach($additional_todos as $key => $atodo){
                                    // GET THE TODO LIST STATUS
                                    $todoStatus = isset($atodo["status"]) ? $atodo["status"] : $atodo["Status"]; // Status is the old key
                                    // CHECK IF THE TODO LIST IS A COPIED TODO LIST
                                    $isCopy = isset($atodo["is_copy"]) ? $atodo["is_copy"] : false;
                                }
                            }
                            // CHECK IF THE TODO LIST IS COMPLETED AND NOT A COPIED TODO LIST
                            if($parentTodoStatus != "Completed"){
                                $ongoing_todos[] = $todo;
                            } elseif($parentTodoStatus == "Completed" && $todoStatus == "Ongoing"){
                                $ongoing_todos[] = $todo;
                            } else {
                                $completed_todos[] = $todo;
                            }
                        }

                        // REVERSE BOTH ARRAYS
                        $ongoing_todos = array_reverse($ongoing_todos);
                        $completed_todos = array_reverse($completed_todos);

                        // CHECK IF ONGOING TODOS
                        if($ongoing_todos){
                            // ASSIGN THE COMPLETED TODOS AS THE MAIN TODOS
                            $mainTodos = $ongoing_todos;
                            // GET TEMPLATE PART
                            include('inc/todos/todos-table.php');
                        }
                        // CHECK IF COMPLETED TODOS
                        if($completed_todos){
                            // ASSIGN THE COMPLETED TODOS AS THE MAIN TODOS
                            $mainTodos = $completed_todos;
                            // GET TEMPLATE PART
                            include('inc/todos/todos-table.php');
                        }
                    } else {

                        if(!in_array($user_role, $managed_roles)){
                            // CREATE YOUR FIRST SEO STRATEGY TODO LIST HERE
                            echo '<div class="alert alert-warning rounded-0" role="alert">Create your first SEO Strategy <a href="https://seoi.io/seo-manager/seo-strategy/">here.</a></div>';
                        } else {
                            echo '<div class="alert alert-danger rounded-0" role="alert">No todo lists found.</div>';
                        }
                    } // !$todo_list
                } // !$customer
            } // !$assignedCustomers loop
        ?>
<?php } else { ?>
    <div class="alert alert-danger rounded-0 mt-3" role="alert">No customer assigned.</div>
<?php
    } // !assignedCustomers 

    return ob_get_clean();
}




/*
 * SEO MANAGER TODOS LIST
 *  
 */
add_shortcode( 'seo-todo-list', '_seo_todo_list' );
function _seo_todo_list(){
    ob_start();

    // GET THE VIEW AS TO CHECK IF THE USER IS VIEWING AS A CUSTOMER
    $view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
    // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$current_user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$current_user_id = $current_user_id ? $current_user_id : get_current_user_id();
    // GET USER BY ID
    $user = get_user_by('id', $current_user_id);
    // GET USER ID
    $user_id = $user->ID;
    // GET USER ROLE
    $user_role = $user->roles[0];
    // GET ENTRY ID
    $entry_id = $_GET["eid"] ? $_GET["eid"] : $_POST["entry_id"];
    // GET ADDITIONAL TODO KEY
    $additional_todo_key = (strpos($entry_id, "-") !== false) ? explode("-", $entry_id)[1] : null;
    // GET ENTRY ID WITHOUT THE ADDITIONAL TODO KEY
    $entry_id = (strpos($entry_id, "-") !== false) ? explode("-", $entry_id)[0] : $entry_id;
    // MANAGED ROLES
    $managed_roles = array("administrator", "seo_manager", "account_manager");
    // REDIRECT URL
    $redirect_url = site_url() . '/seo-manager/todos/';

    // GET ENTRY
    $entry = GFAPI::get_entry($entry_id);
    // GET CUSTOMER EMAIL 
    $customer_email = rgar($entry, '12');
    // GET USER OBJECT BY CUSTOMER EMAIL
    $customer = get_user_by('email', $customer_email);
    // GET CUSTOMER ID
    $customer_id = $customer->ID;
    

    // VALIDATE IF ENTRY ID IS VALID
    if(!is_numeric($entry_id)){
        wp_redirect( $redirect_url );
        exit;
    }

    // VALIDATE IF ENTRY ID IS IN YOUR TODO LIST
    $customer_todo_list = get_user_meta($customer_id, "todo_list", true);

    if(!in_array($user_role, $managed_roles)){ // FOR USERS

        // VALIDATE IF ENTRY ID IS IN YOUR TODO LIST
        $customer_todo_list = get_user_meta($customer_id, "todo_list", true);
        // CHECK IF THE USER HAS A TODO LIST
        if($customer_todo_list){
            // GET AN ARRAY OF ALL VALUES IN COLUMN 'entry_id'
            $customer_todo_entries = array_column($customer_todo_list, 'entry_id');
            // dd($customer_todo_entries);
            // CHECK IF ENTRY ID IS IN THE TODO LIST
            if($customer_todo_entries && !in_array($entry_id, $customer_todo_entries)){
                wp_redirect( $redirect_url );
                exit;
            }
        } else {
            wp_redirect( $redirect_url );
            exit;
        }

    } else {

        if($customer) { // FOR MANAGERS
            // CHECK IF THE CUSTOMER ID IS IN THE ASSIGNED CUSTOMERS
            $assignedCustomers = get_the_author_meta("_assigned_customers", $user_id);
            $assignedCustomers = $assignedCustomers ? $assignedCustomers : array();


            // CHECK IF CUSTOMER IS IN THE ASSIGNED CUSTOMERS
            if(!in_array($customer_id, $assignedCustomers) ){
                wp_redirect( $redirect_url );
                exit;
            }
        } else {
            wp_redirect( $redirect_url );
            exit;
        }
    }

    /* if(!in_array($user_role, $managed_roles)){
        if(!$customer){
            wp_redirect( $redirect_url );
            exit;
        } elseif($customer) {

            // CHECK IF THE CUSTOMER ID IS IN THE ASSIGNED CUSTOMERS
            $assignedCustomers = get_the_author_meta("_assigned_customers", $current_user_id);

            // VALIDATE IF ENTRY ID IS IN YOUR TODO LIST
            $customer_todo_list = get_user_meta($customer_id, "todo_list", true);
            dd($customer_todo_list);
            // CHECK IF THE USER HAS A TODO LIST
            if($customer_todo_list){
                // GET AN ARRAY OF ALL VALUES IN COLUMN 'entry_id'
                $customer_todo_entries = array_column($customer_todo_list, 'entry_id');
                // CHECK IF ENTRY ID IS IN THE TODO LIST
                if($customer_todo_entries && !in_array($entry_id, $customer_todo_entries)){
                    wp_redirect( $redirect_url );
                    exit;
                }
            }
        }
    } */

   

    // FOR THE MANAGER
    if($view_as == 'user' || in_array($user_role, $managed_roles)){

        // GENERATE NEW TOKENS
        $seoi = new NEW_SEOI_GOOGLE();
        // GET TOKENS
        $refresh_token = $seoi->get_tokens("refresh");
        // GENERATE NEW ACCESS TOKEN FOR THE API
        $tokens = $seoi->generate_new_tokens($refresh_token);
        // Initialize SEOI
        $newSeoi = new SEOI();
        // Validate User
        $validateUser = $newSeoi->validateUser('', '', $current_user_id);
    }

?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">Todo List</div>
    </div>

    <?php if($view_as == 'user' || in_array($user_role, $managed_roles)){ ?>
        <?php if(!$validateUser){ ?>
            <div class="bg-white p-3 border mb-3">
                <div class="mb-2 text">Please connect your Google account first.</div>
                <style>.google-btn .tcb-icon{color: white !important;}</style>
                <a href="<?php echo GOOGLE_SEARCH_AND_ANALYTICS_OAUTH_URL_TODOS; ?>" class="btn-orange fw-light text py-1 px-3 google-btn"><svg style="position: relative; top: -1px;" fill="white" class="tcb-icon" viewBox="0 0 488 512" data-id="icon-google-brands" data-name=""><path d="M488 261.8C488 403.3 391.1 504 248 504 110.8 504 0 393.2 0 256S110.8 8 248 8c66.8 0 123 24.5 166.3 64.9l-67.5 64.9C258.5 52.6 94.3 116.6 94.3 256c0 86.5 69.1 156.6 153.7 156.6 98.2 0 135-70.4 140.8-106.9H248v-85.3h236.1c2.3 12.7 3.9 24.9 3.9 41.4z"></path></svg> Connect Google</a>
            </div>
<?php
        }
    } // !$validateUser


    // GET THE TODO LIST DATA
    $todo_data = rgar($entry, '19');
    // GET WEBSITE
    $website = rgar($entry, '1');
    // GET THE TODO LIST
    $todo_list = gform_get_meta($entry_id, 'todo_list');
    // GET USER FULL NAME
    $customer_full_name = $customer->first_name . " " . $customer->last_name;
    // GET STATUS
    $status = rgar($entry, '13') ?? "Ongoing";
    // KEYWORD REPORT
    $strategyData = gform_get_meta($entry_id, 'seo_strategy');
    // KEYWORDS
    $keyword_1 = rgar($entry, '8');
    $keyword_2 = rgar($entry, '3');
    $keyword_3 = rgar($entry, '9');
    // INITIALIZE THE IS COPY VARIABLE -- PARENT TODO LIST ITEMS ARE NOT COPIED
    $isCopy = false;
    // GET THE DATE CREATED
    $date = rgar( $entry, 'date_created' );
    $date = date('F_Y', strtotime($date));


    // GET THE COPIED TODO LIST DATA
    if($todo_data && $additional_todo_key){
        // DECDOE TODO LIST DATA
        $existing_todo_data = json_decode($todo_data, true);
        // CHANGE THE VARIABLE NAME SO IT DOESN'T CONFLICT WITH THE CONDITIONALS
        $new_additional_todo_key = $additional_todo_key - 1;
        // GET COPIED TODO ITEM TODO LIST
        $todo_list = $existing_todo_data[$new_additional_todo_key]['data'];
        // GET STATUS
        $status = $existing_todo_data[$new_additional_todo_key]["status"] ? $existing_todo_data[$new_additional_todo_key]["status"] : 'Ongoing';
    }
    
    // CHECK IF ENTRY EXISTS
    if(!$entry){
        wp_redirect( $redirect_url );
        exit;
    }

    // CHECK IF SAVE TYPE IS SET
    if(isset($_POST['save_type'])){

        // SHOW SAVED NOTIFICATION
        echo "<div class='alert alert-success alert-dismissible fade show rounded-0' role='alert'><strong>Success!</strong> Your changes have been saved.</div>";

        // SAVE DUE DATE
        if($_POST["save_type"] == "date"){
            // CHANGE DUE DATE
            $due_date = changeTodoDueDate($_POST['todo_due_date'], $entry_id);
        }

        // CLOSE AND COPY TODO LIST
        if($_POST['save_type'] == "close_todo"){
            // CHANGE TODO STATUS
            changeTodoStatus($entry_id, 'Ongoing');
            // CLOSE AND COPY TODO LIST
            closeAndCopyTodoList($entry_id, 'Closed and copied this todo list to a new list.', true, $customer_email);
        }

        // GENERATE A NEW GOOGLE DRIVE FOLDER
        if($_POST["save_type"] == "generate_folder"){
            // BUILD FOLDER DATA
            $folderData = array(
                'entry_id' => $_POST['entry_id'],
                'month' => $_POST['month'],
                'customer_email' => $customer_email,
            );
            // PASS FOLDER DATA TO THE FUNCTION
            generateGoogleDriveFolder($folderData);
        }

        // CHANGE TODO STATUS AND/OR UPLOAD FILES
        if($_POST["save_type"] == "status" || $_POST["save_type"] == "upload"){
            // CHECK IF TODO LIST IS COPIED
            if($additional_todo_key){
                // DECODE TODO LIST DATA
                $passed_todo_data = json_decode($todo_data, true);
                // GET THE STATUS OF THE ADDITIONAL TODO LIST
                $status = $passed_todo_data[$additional_todo_key-1]["status"] ?? "Ongoing";
                // UPDATE TODO STATUS OF THE COPIED TODO LIST
                $status = changeTodoStatus($entry_id, $status, true, $passed_todo_data, $additional_todo_key);
                // GET UPDATED ENTRY
                $entry = GFAPI::get_entry($entry_id);
                // GET UPDATED TODO LIST DATA
                $todo_data = rgar($entry, '19');
                // DECODE TODO LIST DATA
                $passed_todo_data = json_decode($todo_data, true);
                // CHECK IF STATUS IS COMPLETED
                if($status == "Completed"){
                    // UPDATE CLOSED DATE
                    $closed_date = changeTodoClosedDate($status, $entry_id, true, $passed_todo_data, $additional_todo_key); 
                }
            } else {
                // UPDATE TODO STATUS
                $status = changeTodoStatus($entry_id, $status);
                // UPDATE CLOSED DATE
                $closed_date = changeTodoClosedDate($status, $entry_id); 
            }
        }

        // SAVE THE TODO COMMENTS
        // if($_POST["save_type"] == "save" && $additional_todo_key){
        if($_POST["save_type"] == "save"){
            // SAVE TO GFORM META
            $test = saveTodoComments($entry_id, $todo_list, $_POST["save_type"], $additional_todo_key);
        } 

        if($_POST["save_type"] == "upload"){

            // GET REPORT GENERATED DATA
            // - THIS IS USED TO CHECK IF THE REPORT IS GENERATED INTO THE GOOGLE DOC FILE
            $report_generated = gform_get_meta($entry_id, 'report_generated') ?? [];
            // ADD KEY
            $report_generated[$_GET["eid"]] = [
                "entry_id" => $_GET["eid"],
                "date"     => date('Y-m-d H:i:s')
            ];
            // UPDATE IF REPORT HAS BEEN GENERATED
            gform_update_meta($entry_id, 'report_generated', $report_generated);

            // assign the todos
            $todos_post = $_POST["todos"];
            // dd($_POST);
            $todos_post = $additional_todo_key ? $todo_list : $todos_post; // if additional todo key is set, use the todo list data


            // UPDATE TODO LIST
            if($todos_post){
                // LOOP THROUGH THE TODOS
                foreach($todos_post as $todo){
                    // CHECK IF ADDITIONAL TODO KEY IS SET
                    if($additional_todo_key){
                        $td_include = $todo["Include in Report"] ? $todo["Include in Report"] : "";
                    } else {
                        $td_include = $todo["include_in_report"] ? $todo["include_in_report"] : "";
                    }

                    // CHECK IF TODO IS INCLUDED IN THE REPORT
                    if($td_include == "on"){
                        // CHECK IF ADDITIONAL TODO KEY IS SET
                        if($additional_todo_key){
                            $td_comment = $todo["Comments"] ? $todo["Comments"] : "";
                            $td_todo = $todo["To Do"] ? $todo["To Do"] : "";
                            $td_info = $todo["Info"] ? $todo["Info"] : "";
                            $td_report_link = $todo["Report Link"] ? $todo["Report Link"] : "";
                        } else {
                            $td_comment = $todo["todo_comment"] ? $todo["todo_comment"] : "";
                            $td_todo = $todo["todo"] ? $todo["todo"] : "";
                            $td_info = $todo["todo_info"] ? $todo["todo_info"] : "";
                            $td_report_link = $todo["report_link"] ? $todo["report_link"] : "";
                        }

                        // UPLOAD THE TODO COMMENTS TO THE REPORT FILE
                        todoComments($customer_email, $_POST["month"], $td_comment, $td_todo, $td_info, $td_report_link, $td_include, $website, $entry_id);
                        // dd($test);
                    }
                }
            }
        }
    }

    // ==========================================
    // RE-GET ENTRY AND OTHER DATA AFTER SAVING TO GET THE UPDATED DATA
    $entry = GFAPI::get_entry($entry_id);
    // GET THE TODO LIST DATA
    $todo_data = rgar($entry, '19'); // 
    // GET DUE DATE
    $due_date = rgar($entry, '15');
    $due_date = isset($_POST['todo_due_date']) ? $_POST['todo_due_date'] : $due_date;
    $due_date = $due_date == "" ? "" : date('Y-m-d', strtotime($due_date));
    // GET THE TODO LIST
    $todo_list = gform_get_meta($entry_id, 'todo_list');
    // GOOGLE DRIVE LINK
    $gdrive_link = rgar($entry, '17');
    // CHECK IF THERE'S A GOOGLE DRIVE LINK
    $gdrive_id = $gdrive_link ? end(explode("/", $gdrive_link)) : "";
    // SELECTED MONTH
    $selected_month = rgar($entry, '18'); 
    // GET HISTORY
    $history = rgar($entry, "14");
    // GET STATUS
    $status = rgar($entry, '13') ?? "Ongoing";
    // KEYWORD GENERATED
    $keyword_generated = gform_get_meta($entry_id, 'keyword_generated');
    // REPORT GENERATED
    $report_sent_data = gform_get_meta($entry_id, 'report_sent_data');
    // CHECK IF THE TODO LIST ALREADY HAS A COPY
    $hasCopy = false;

    // GET THE COPIED TODO LIST DATA
    // if($todo_data && $additional_todo_key){
    if($todo_data){
        // DECDOE TODO LIST DATA
        $existing_todo_data = json_decode($todo_data, true);
        // 
        $hasCopy = true;
        // 
        if($additional_todo_key){
            // CHANGE THE VARIABLE NAME SO IT DOESN'T CONFLICT WITH THE CONDITIONALS
            $nkey = $additional_todo_key - 1;
            // GET COPIED TODO ITEM TODO LIST
            $todo_list = $existing_todo_data[$nkey]['data'];
            // GET STATUS
            $status = $existing_todo_data[$nkey]["status"] ? $existing_todo_data[$nkey]["status"] : 'Ongoing';
            // GET IS COPY
            $isCopy = $existing_todo_data[$nkey]["is_copy"] ? $existing_todo_data[$nkey]["is_copy"] : false;
            // IF KEYWORD REPORT HAS BEEN GENERATED
            $keyword_generated = $existing_todo_data[$nkey]['keyword_generated'] ? $existing_todo_data[$nkey]['keyword_generated'] : "";
            // IF REPORT SENT
            $report_date = $existing_todo_data[$nkey]['report_sent_date'] ? $existing_todo_data[$nkey]['report_sent_date'] : "";
            $report_sent_data = $report_date ? array("date" => $report_date) : "";
        }
    }

    // dd($todo_data);
    // dd($existing_todo_data);

    // INFORMATION TABLE
    include('inc/todos/todos-list-information-table.php');

    // ONLY SHOW THE KEYWORD TABLE IF THE TODO LIST IS NOT COMPLETE
    if($status != "Completed"){
        // KEYWORD DATA TABLE
        include('inc/todos/todos-list-keyword-data-table.php');
    }

    // ONLY SHOW THE LIST ACCORDION TO THE MANAGER
    if($view_as == 'user' || in_array($user_role, $managed_roles)){
        if($status != "Completed" && $selected_month){
            // TODO LIST ACCORDION
            include('inc/todos/todos-list-accordion-todo.php');
        }
    }

    // SHOW RESULTS AND SERVICES FOR USERS
    if(!in_array($user_role, $managed_roles) && !$view_as){
        // RESULTS AND SERVICES
        include('inc/todos/todos-list-services-results.php');
    }

    // ONLY SHOW THE OTHER TODO ITEM ACTIONS TO THE MANAGER
    if($view_as == 'user' || in_array($user_role, $managed_roles)){

        // SHOW ONLY IF USER IS VALID
        if($validateUser){
        
            // CLASS INIT
            $newGoogle = new GOOGLE_SEARCH_CONSOLE();
            // VALIDATE WEBSITE - check if the websit is inside the user site list
            $validateWebsite = $newGoogle->validateUserSite($website, $user_id, $customer_id); 

           /*  dd($isCopy);
            dd($validateWebsite);
            dd($selected_month);
            dd($hasCopy); */

            // TRIGGER COPY THE TODO LIST
            if(!$isCopy && $validateWebsite && $selected_month && !$hasCopy){
    ?>
                <div class="bg-white p-3 mb-3 border">
                    <form method="POST" class="d-inline-block" style="right: 11px;top: 9px;">
                        <input type="hidden" name="save_type" value="close_todo">
                        <button type="submit" class="btn-orange-outline small-text px-2 lh-1 fw-regular" style="border-radius: 0;">Close and Copy Todo List</button>
                    </form>
                    <small class="d-block">Copy this todo list and open a new one. Please do note that this is final and it will permanently close this existing todo list.</small> 
                </div>
    <?php 
            }

            // LAST MONTH W/ YEAR
            $last_month = date("F Y", strtotime("-1 month"));
            // PAST 2 MONTHS
            $past_2_months = date("F Y", strtotime("-2 month"));
            // CURRENT MONTH
            $current_month = date("F Y");
            // NEXT MONTH
            $next_month = date("F Y", strtotime("last day of next month"));

            // GENERATE GOOGLE DRIVE FOLDER
            if(!$gdrive_link && $status != "Completed" && !$selected_month){
                include('inc/todos/todos-list-generate-google-folder.php');
            }
            // GENERATE REPORT
            if($status != "Completed" && $selected_month){
                include('inc/todos/todos-list-generate-report.php');
            }
            // NEXT STEPS
            if(isset($_POST["save_type"]) && $_POST["save_type"] == "upload" || $status == "Completed"){ 
                if($selected_month){
                    include('inc/todos/todos-list-next-steps.php');
                }
            }
        } // !$validateUser
            
        // HISTORY
        include('inc/todos/todos-list-history.php');
    }
    // ==========================================
    // ==========================================
    // ==========================================
    // ==========================================

    
    return ob_get_clean();
}

// 
add_action('wp_ajax_editAppsheetTodo', 'editAppsheetTodo');
add_action('wp_ajax_nopriv_editAppsheetTodo', 'editAppsheetTodo');
function editAppsheetTodo(){

    // 
    $appsheet = $_REQUEST['appsheet_data'];
    $comments = $_REQUEST['comments'];
    $status = $_REQUEST['status'];
    $original_comments = $_REQUEST['original_comments'];

    // insert comments
    $appsheet[0]["Comments"] = $comments;

    // 
    $data = array(
        "_RowNumber" => $appsheet[0]["_RowNumber"],
        "ID"         => $appsheet[0]["ID"],
        "Comments"   => $comments
    );

    // add status
    if($status){
        $data["Status"] = $status;
    }

    // save the data
    $google = new NEW_SEOI_GOOGLE(); 
    $appsheet_data = $google->appSheetEditData($data);
    $result = json_decode($appsheet_data, true);

    // check if the data was saved
    if($result["Rows"]){
        echo "success";
    }else{
        echo "error";
    }

    /*
     *
     * 
     * populate the monthly report
     * 
     * 
     */
    $gdrive_folder_id = "1-Cbnk1-0NW7r3__3M8bgquYOzUhuvGCa"; // default parent folder id
	$file_id = "1UQng53FncJYYGxxVMb57NByWMrs9cnsinEsZIXL2B3c"; // deafault report file id
    $file_name = "Monthly General Report (".date('F Y').")"; // file name

    // 
    $seoiGoogle = new NEW_SEOI_GOOGLE();

    // get month today to be used as the folder name
    $month_year = date('F_Y');

    // create the folder or return the folder id if it exists
    $reportfolderid = $seoiGoogle->googleDriveCreateFolder("user_1/monthly_reports/".$month_year."/", $gdrive_folder_id, "reports");

    // check if report file already exists
    $copied_file_id = $seoiGoogle->googleDriveCheckFolder($file_name, $reportfolderid, "document");

    // copy the original report in google drive if the report doesnt exist yet
    if(!$copied_file_id){

        // 
        $copied_file_id = $seoiGoogle->googleDriveCopyFile($file_id, $gdrive_folder_id);
        $copied_file_id = $seoiGoogle->googleDriveUpdateFile($reportfolderid, $copied_file_id["id"], $file_name);
        $copied_file_id = $copied_file_id["id"];

        // update the document with the correct initial details
        // $seoiGoogledocindex = $seoiGoogle->googleDocsGet($copied_file_id); // get the document
        // update the date -- note: Don't update the website name as sometimes the website name is not the same as the client name
        $asdads = $seoiGoogle->googleDocsUpdate($copied_file_id, "\n\n".date('F Y'), 42); // update the document
    }

    // google docs api get document
    // returns the index of the updates table inside the report document
    $table_index = $seoiGoogle->googleDocsGet($copied_file_id); 

    // google docs api update document
    // add the comments in the updates table inside the report document
    $updatetestdoc = $seoiGoogle->googleDocsUpdate($copied_file_id, $original_comments . "\n\n", $table_index);

    die();
}

// upload comments to the report in google drive
function todoComments($customer_email, $date, $comments = NULL, $todo = NULL, $info = NULL, $report_link = NULL, $include_in_report = NULL, $website = NULL, $entry_id = NULL){

    /* dd($customer_email);
    dd($date);
    dd($comments);
    dd($todo);
    dd($info);
    dd($report_link);
    dd($include_in_report);
    dd($website);
    dd($entry_id);
    die(); */
 
    // initialize class
    $seoi = new NEW_SEOI_GOOGLE();

    // create the google drive folder structure
    // $google_directory = $customer_email . "/Reports/" . $date . "/";
    $google_directory = $customer_email . "/Reports/" . $date . "/";

    // remove _ from the date
    $date = str_replace("_", " ", $date);

    
    // report details
    $file_name = "Monthly General Report (".$date.")"; // file name
    $file_id = "1UQng53FncJYYGxxVMb57NByWMrs9cnsinEsZIXL2B3c"; // deafault report file id

    // create the folder or return the folder id if it exists
    $reportfolderid = $seoi->googleDriveCreateFolder($google_directory, "", "reports");

    // CHECK IF REPORT FOLDER ID IS AN ARRAY
    if(is_array($reportfolderid) && isset($reportfolderid["error"])){
        return;
    }


    // save google drive folder id to the database
    saveGoogleDriveLink($entry_id, $reportfolderid);
    saveSelectedMonth($entry_id, $date);
    


    // check if report file already exists
    $copied_file_id = $seoi->googleDriveCheckFolder($file_name, $reportfolderid, "document");
    /* dd($file_name);
    dd($reportfolderid);
    dd($copied_file_id);
    die(); */

    // copy the original report in google drive if the report doesnt exist yet
    if(!$copied_file_id){

        // 
        $copied_file_id = $seoi->googleDriveCopyFile($file_id);
        $copied_file_id = $seoi->googleDriveUpdateFile($reportfolderid, $copied_file_id["id"], $file_name);
        $copied_file_id = $copied_file_id["id"];

        // update the document with the correct initial details -- ADD WEBSITE NAME
        // $seoiGoogledocindex = $seoiGoogle->googleDocsGet($copied_file_id); // get the document
        // update the date -- note: Don't update the website name as sometimes the website name is not the same as the client name
        // $seoi->googleDocsUpdate($copied_file_id, "\n\n".$date, 42); // update the document
        // $date_under_title = "\n\n".$date()
        // $test = $seoi->googleDocsUpdate($copied_file_id, $date, 42); // update the document
        $updatedfile = $seoi->googleDocsUpdate($copied_file_id, array("insertText" => array(
            "text"     => $website,
            "location" => array("index" => 42)
        )), 42);
    }
   

    // google docs api get document
    // returns the index of the updates table inside the report document
    $table_index = $seoi->googleDocsGet($copied_file_id); // starting table index
    /* dd($table_index);
    die(); */

    // table cell index usually table_index + 4
    // -- note: the border counts as 1 index
    $uploaded_table_index = $table_index + 1; // the uploaded table index
    $first_column_index = $table_index + 4; // first column index
    $second_column_index = $first_column_index + 3; // second column index
   /*  dd($table_index);
    dd($first_column_index);
    dd($second_column_index); */
    // upload table
    $uploaded_table = $seoi->googleDocsUpdate($copied_file_id, array("insertTable" => array(
        "columns"  => 1,
        "rows"     => 1,
        "location" => array("index" => $table_index)
    )), $table_index);
    // format table -- border color
    $format_table_border = $seoi->googleDocsUpdate($copied_file_id, array("updateTableCellStyle" => array(
        "tableStartLocation" => array("index" => $uploaded_table_index),
        "fields"             => "*",
        "tableCellStyle"     => array(
            "borderBottom"   => array(
                "dashStyle"  => "SOLID",
                "width"      => array(
                    "magnitude" => 1, 
                    "unit"      => "PT"
                ),
                "color" => array(
                    "color" => array(
                        "rgbColor"  => array(
                            "red"   => 0.94, 
                            "green" => 0.94, 
                            "blue"  => 0.94
                        )
                    )
                )
            ),
            "borderLeft"     => array(
                "dashStyle"  => "SOLID",
                "width"      => array(
                    "magnitude" => 1, 
                    "unit"      => "PT"
                ),
                "color" => array(
                    "color" => array(
                        "rgbColor"  => array(
                            "red"   => 0.94, 
                            "green" => 0.94, 
                            "blue"  => 0.94
                        )
                    )
                )
            ),
            "borderRight"    => array(
                "dashStyle"  => "SOLID",
                "width"      => array(
                    "magnitude" => 1, 
                    "unit"      => "PT"
                ),
                "color" => array(
                    "color" => array(
                        "rgbColor"  => array(
                            "red"   => 0.94, 
                            "green" => 0.94, 
                            "blue"  => 0.94
                        )
                    )
                )
            ),
            "borderTop"      => array(
                "dashStyle"  => "SOLID",
                "width"      => array(
                    "magnitude" => 1, 
                    "unit"      => "PT"
                ),
                "color" => array(
                    "color" => array(
                        "rgbColor"  => array(
                            "red"   => 0.94, 
                            "green" => 0.94, 
                            "blue"  => 0.94
                        )
                    )
                )
            ),
            "contentAlignment" => "TOP",
        )
    )), $table_index);
    // format table -- first column width
    $format_table_width = $seoi->googleDocsUpdate($copied_file_id, array("updateTableColumnProperties" => array(
        "tableStartLocation"    => array("index" => $uploaded_table_index),
        "fields"                => "*",
        "columnIndices"         => array(0),
        "tableColumnProperties" => array(
            "widthType" => "FIXED_WIDTH",
            "width"     => array(
                // "magnitude" => 80, 
                "magnitude" => 500, 
                "unit"      => "PT"
            )
        )
    )), $uploaded_table_index);
    // upload image inside table
   /*  $uploaded_image = $seoi->googleDocsUpdate($copied_file_id, array("insertInlineImage" => array(
        // "uri"        => "https://drive.google.com/uc?export=view&id=1nO-ucPG5foL_icyLcvdKANm9d05R11_s",
        "uri"        => "https://drive.google.com/uc?export=view&id=1VvAjappsw9rGtAcfSg12cqqQDkDsolVg",
        // https://drive.google.com/file/d/1VvAjappsw9rGtAcfSg12cqqQDkDsolVg/view?usp=sharing
        
        "location"   => array("index" => $first_column_index),
        "objectSize" => array(
            "width"  => array(
                "magnitude" => 64, 
                "unit"      => "PT"
            )
        )
    )), $first_column_index);
 */


     // convert the comments into an array for each html tag
    $comments = stripslashes($comments);
    $test = $comments;
    $parts = explode("\n", $test);

    // 
    // if($parts){
    if(!empty($parts)){

        // 
        $text_type = "";

        // reverse the array
        $parts = array_reverse($parts);

        // loop through the comments
        foreach($parts as $key => $part){

           if($part){

               // regex check if the part contains <h1> or <h2> or <h3> or <h4> or <h5> or <h6>
               if(preg_match("/<h[1-6]>/", $part)){

                   // 
                   $text_type = "header";
                //    uploadTodoComments("\n\n".$part, $second_column_index, $copied_file_id, $text_type);
                   uploadTodoComments("\n\n".$part, $first_column_index, $copied_file_id, $text_type);
               } elseif(preg_match("/<p>/", $part)){

                    // 
                    $text_type = "paragraph";
                    // uploadTodoComments($part, $second_column_index, $copied_file_id, $text_type);

                    // get href link
                    $link = "";
                    if(preg_match("/<a href=\"(.*?)\">/", $part, $matches)){
                        $link = $matches[1];
                    }

                    // get text inside the link
                    $link_text = "";
                    if(preg_match("/<a href=\"(.*?)\">(.*?)<\/a>/", $part, $matches)){
                        $link_text = $matches[2];
                    }

                    $test = strip_tags($part);

                    // FIND THE INDEX OF THE LINK TEXT
                    $link_text_index = strpos($test, $link_text);

                    // uploadTodoComments("\n\n".$part, $second_column_index, $copied_file_id, $text_type, $link_text, $link);
                    uploadTodoComments("\n\n".$part, $first_column_index, $copied_file_id, $text_type, $link_text, $link);
               }
           }
        }
    }


    // dd($uploaded_image);
    /* dd($parts);
    dd($copied_file_id);
    dd($first_column_index);
    // dd($second_column_index);
    dd($report_link); */
    // upload link inside second column of the table
    if($report_link){

       /*  // $asdadasd = ',https://drive.google.com/file/d/1-qB1ZqPgiVvVnPkIFHfggeAECgLCHpmp/view,https://seoi.io/';
        $report_link = explode(",", $report_link);
        $report_link = array_filter($report_link);
        // $asdadasd = array_values($asdadasd);
        dd($asdadasd); */

        $report_link = explode(",", $report_link);
        $report_link = array_filter($report_link);
        $report_label = $todo == "Supporting Content Marketing" ? "\n\nSee Link Here" : "\n\nSee Report Here";
        foreach($report_link as $key => $reportlink){
            // uploadTodoComments("\n\nSee Report Here", $first_column_index, $copied_file_id, "paragraph", "See Report Here", $reportlink);
            uploadTodoComments($report_label, $first_column_index, $copied_file_id, "paragraph", "See Report Here", $reportlink);
        }


        // $test = uploadTodoComments("\n\nSee Report Here", $second_column_index, $copied_file_id, "paragraph", "See Report Here", $report_link);
        // uploadTodoComments("\n\nSee Report Here", $first_column_index, $copied_file_id, "paragraph", "See Report Here", $report_link);
    }


    // upload paragraph inside second column of the table
    $info = stripslashes($info);
    // uploadTodoComments($info, $second_column_index, $copied_file_id, "paragraph");
    uploadTodoComments($info, $first_column_index, $copied_file_id, "paragraph");

  
    // upload header inside second column of the table
    // uploadTodoComments($todo."\n\n", $second_column_index, $copied_file_id, "header");
    uploadTodoComments($todo."\n\n", $first_column_index, $copied_file_id, "header");

    // update history
    logTodoHistory("Uploaded comments to the report", $entry_id); 
   
}

//
function uploadTodoComments($comment, $table_index, $file_id, $text_type, $link_text = NULL, $link = NULL){

    // remove the html tags
    $formatted_comment = strip_tags($comment);

    // initialize class
    $seoi = new NEW_SEOI_GOOGLE();

    // upload the comment
    // google docs api update document
    // add the comments in the updates table inside the report document
    $update_doc = $seoi->googleDocsUpdate($file_id, array("insertText" => array(
        "text"     => $formatted_comment,
        "location" => array("index" => $table_index)
    )), $table_index);

    // format the text
    formatTodoComments($formatted_comment, $table_index, $file_id, $text_type, $link_text, $link);
}

// 
function formatTodoComments($comment, $table_index, $file_id, $text_type, $link_text = NULL, $link = NULL){

    // initialize class
    $seoi = new NEW_SEOI_GOOGLE();

    // get string length 
    $end_index = strlen($comment) + $table_index; // add table index to get end index

    // 
    $text_style = array();

    if($text_type == "header"){
        $text_style = array(
            "bold" => true,
            "fontSize" => array(
                "magnitude" => 14,
                "unit" => "PT"
            )
        );

        updateFormat($file_id, $text_style, $table_index, $table_index, $end_index);

    } elseif($text_type == "paragraph"){
        $text_style = array(
            "fontSize" => array(
                "magnitude" => 11,
                "unit" => "PT"
            )
        );

        // update paragraph
        updateFormat($file_id, $text_style, $table_index, $table_index, $end_index);

        // check if the comment contains a link
        if($link_text && $link){

            // get link position
            $link_start_position = strpos($comment, $link_text) + $table_index;

            // get link end position
            $link_end_position = $link_start_position + strlen($link_text);

            // style the link
            $link_style = array(
                "link" => array(
                    "url" => $link
                ),
                "fontSize" => array(
                    "magnitude" => 11,
                    "unit" => "PT"
                )
            );

            /* echo "<pre>";
            var_dump($file_id);
            var_dump($link_text);
            var_dump($link);
            var_dump($comment);
            var_dump($table_index);
            var_dump($link_start_position);
            var_dump($link_end_position);
            // var_dump($slink_style);
            echo "</pre>"; */

            // update
            updateFormat($file_id, $link_style, $table_index, $link_start_position, $link_end_position);

            /* $format_doc = $seoi->googleDocsUpdate($file_id, array(
                "updateTextStyle" => array(
                    "textStyle" => $stext_style,
                    "range" => array(
                        "startIndex" => $link_position,
                        "endIndex"   => $link_end_position
                    ),
                    "fields" => "bold,fontSize,link"
                )
            ), $table_index);  */
        }
    } /* elseif($text_type == "link"){
        $text_style = array(
            "link" => array(
                "url" => $link
            ),
            "fontSize" => array(
                "magnitude" => 11,
                "unit" => "PT"
            )
        );
    } */

    // format the string
    /* $format_doc = $seoi->googleDocsUpdate($file_id, array(
        "updateTextStyle" => array(
            "textStyle" => $text_style,
            "range" => array(
                "startIndex" => $table_index,
                "endIndex"   => $end_index
            ),
            "fields" => "bold,fontSize,link"
        )
    ), $table_index); */
}

// update the formatted google docs
function updateFormat($file_id, $text_style, $table_index, $start_index, $end_index){

    $seoi = new NEW_SEOI_GOOGLE();

    $format_doc = $seoi->googleDocsUpdate($file_id, array(
        "updateTextStyle" => array(
            "textStyle" => $text_style,
            "range" => array(
                "startIndex" => $start_index,
                "endIndex"   => $end_index
            ),
            "fields" => "bold,fontSize,link"
        )
    ), $table_index);
}

// 
function saveTodoComments($entry_id, $todo_list, $save_type, $additional_todo_key = NULL, $todo = NULL, $todos = NULL){

    /* dd($entry_id);
    dd($todo_list);
    dd($save_type); */
    

    // 
    // $todo = isset($todo) ? $todo : $todo;
    $todo = isset($_POST["todo"]) ? $_POST["todo"] : $todo;
    // $todos = isset($_POST) ? $_POST : $todos;
    $todos = isset($todos) ? $todos : $_POST;

    

    // get the comments fromt the $_post
    // check if the key contains the word "todo_comment"
    $comments = "";
    $comment_key = "";
    $internal_notes = "";
    $report_link = "";
    $include_in_report = "";
    $saved = false;
    // foreach($_POST as $key => $value){
    foreach($todos as $key => $value){

        // comment
        if(strpos($key, "todo_comment") !== false){
            $comments = $value;
            // $comment_key = $key;
        } elseif(strpos($key, "internal_notes") !== false){
            $internal_notes = $value;
        } elseif(strpos($key, "report_link") !== false){
            $report_link = $value;
        } elseif(strpos($key, "include_in_report") !== false){
            $include_in_report = $value;
        }
    }

    /* dd($todo);
    dd($comments);
    dd($internal_notes);
    dd($report_link);
    dd($include_in_report);
    dd($_POST);
    die(); */

    // save the comments in the todo list
    // loop through the todo list
    foreach($todo_list as $key => $todo_item){

        // check if the todo item is the same as the comment key
        if($todo_item["To Do"] == $todo){

            // get array key
            $comment_key = $key;
        }
    }

    if($additional_todo_key){

        // entry
        $entry = GFAPI::get_entry($entry_id);
        // get the copy of the todo list
        $todo_data = rgar($entry, 19);
        // json decode the todo list
        $todo_list = json_decode($todo_data, true);
        // get data from the additional todo key
        // $todo_list = $or_todo_list[$additional_todo_key-1]['data'];

        // update the comments
        $todo_list[$additional_todo_key-1]['data'][$comment_key]["Comments"] = $comments;
    
        // change to completed if save_type == upload
        if($save_type == "upload"){
            $todo_list[$additional_todo_key-1]['data'][$comment_key]["Status"] = "completed";
        }
    
        // INCLUDE IN REPORT
        $todo_list[$additional_todo_key-1]['data'][$comment_key]["Include in Report"] = $include_in_report;
    
        // INTERNAL NOTES
        $todo_list[$additional_todo_key-1]['data'][$comment_key]["Internal Notes"] = $internal_notes;
    
        // REPORT LINK
        $todo_list[$additional_todo_key-1]['data'][$comment_key]["Report Link"] = $report_link;

        // json encode the todo list
        $todo_data = json_encode($todo_list);

        // save the comments in the copy of the todo list
        GFAPI::update_entry_field( $entry_id, 19, $todo_data );
        $saved = true;

        return $todo_list[$additional_todo_key-1]['data'];


    } else {
    
        // update the comments
        $todo_list[$comment_key]["Comments"] = $comments;
    
        // change to completed if save_type == upload
        if($save_type == "upload"){
            $todo_list[$comment_key]["Status"] = "completed";
        }
    
        // INCLUDE IN REPORT
        $todo_list[$comment_key]["Include in Report"] = $include_in_report;
    
        // INTERNAL NOTES
        $todo_list[$comment_key]["Internal Notes"] = $internal_notes;
    
        // REPORT LINK
        $todo_list[$comment_key]["Report Link"] = $report_link;
    
        // update gform entry meta
        gform_update_meta($entry_id, 'todo_list', $todo_list);

        $saved = true;
        // return $todo_list;
    }

    return $saved;

    // update history
    logTodoHistory("Saved a todo comment", $entry_id);
}

// ajax remove todo item
add_action('wp_ajax_removeTodoList', 'removeTodoList');
add_action('wp_ajax_nopriv_removeTodoList', 'removeTodoList');
function removeTodoList(){

    $entry_id = $_REQUEST["entry_id"];
    $customer_id = $_REQUEST["customer_id"];

    // get todos
    $todo_list = get_user_meta($customer_id, "todo_list", true);

    // remove array item by entry id
    foreach($todo_list as $key => $todo_item){
        if($todo_item["entry_id"] == $entry_id){
            unset($todo_list[$key]);
        }
    }

    // update user meta
    update_user_meta($customer_id, "todo_list", $todo_list);

    die();
}

/*
 * Change Status
 * 
 */
 function changeTodoStatus($entry_id, $status, $if_copy = NULL, $todo_data = NULL, $additional_todo_key = NULL){

    //
    $status = $status == "Completed" ? "Ongoing" : "Completed";

    // check if the todo is a copy
    if($if_copy && $todo_data && $additional_todo_key){

        // update todo copy entry
        // $todo_data[$additional_todo_key-1]["Status"] = $status;
        $todo_data[$additional_todo_key-1]["status"] = $status;

        // json encode
        $todo_data = json_encode($todo_data);
        
        // update entry
        $result = GFAPI::update_entry_field( $entry_id, 19, $todo_data );

        // $status = $todo_data;
        
    } else {
    
        // update entry
        $result = GFAPI::update_entry_field( $entry_id, 13, $status );
    }

    // update history
    logTodoHistory("Changed the todo status", $entry_id);

    return $status;
}

/*
 * CHANGE THE TODO DUE DATE
 * 
 */
function changeTodoDueDate($date, $entry_id){

    // new date
    // $new_date = date("F j, Y, g:i a", strtotime($date));
    $new_date = date("F j, Y", strtotime($date));

    // update entry
    $result = GFAPI::update_entry_field( $entry_id, 15, $new_date );

    // update history
    logTodoHistory("Changed the todo due date to ".$new_date, $entry_id);

    return $new_date;


    /* echo "<pre>";
    var_dump($entry_id);
    var_dump($date);
    var_dump($new_date);
    echo "</pre>"; */

    // update history
    // logTodoHistory("Changed the todo due date to ".$new_date, $entry_id);

    // return $date;
}

/*
 * CHANGE THE CLOSED DATE
 * 
 */
function changeTodoClosedDate($status, $entry_id, $if_copy = NULL, $todo_data = NULL, $additional_todo_key = NULL){

    if($status != "Completed"){
        return;
    }

    // new date
    $date_today = date("F j, Y");

    // check if the todo is a copy
    if($if_copy && $todo_data && $additional_todo_key){

        // update todo copy entry
        $todo_data[$additional_todo_key-1]["closed_date"] = $date_today;

        // json encode
        $todo_data = json_encode($todo_data);
        
        // update entry
        $result = GFAPI::update_entry_field( $entry_id, 19, $todo_data );

    } else {


        // update entry
        $result = GFAPI::update_entry_field( $entry_id, 16, $date_today );
    }

    // update history
    logTodoHistory("Closed this todo list on ".$date_today, $entry_id);

    return $date_today;
}

/*
 * SAVE GOOGLE DRIVE LINK
 * 
 */
function saveGoogleDriveLink($entry_id, $gdrive_folder_id){
    
    $link = "https://drive.google.com/drive/folders/".$gdrive_folder_id;

    // update entry
    $result = GFAPI::update_entry_field( $entry_id, 17, $link );

    // update history
    logTodoHistory("Saved a google drive link", $entry_id);

    return $link;
}

function saveSelectedMonth($entry_id, $date){

    // update entry
    GFAPI::update_entry_field( $entry_id, 18, $date );

    return $date;
}

/*
 * Close and copy todo list 
 * - copy over the todo list to a new todo list
 * - updated to be used when the todo list status is changed to completed
 * 
 * @param $entry_id
 * @param $message
 * @param $is_copy
 * 
 */
function closeAndCopyTodoList($entry_id = NULL, $message = '', $is_copy = false, $customer_email = NULL){

    $todo_list = gform_get_meta($entry_id, 'todo_list');
    // $tasdasd = json_encode($todo_list);

    // $message = $message ? $message : 'Closed and copied this todo list to a new list.';

    $todo_services = buildServices($customer_email, $entry_id);

    $todo_data[] = array(
        'date' => date("Y-m-d H:i:s"),
        // 'data' => [],
        // 'data' => $todo_list,
        'data' => $todo_services,
        // 'status' => 'Completed',
        'status' => 'Ongoing',
        'closed_date' => '',
        'due_date' => '',
        'is_copy' => $is_copy,
        'report_sent' => false,
        'report_sent_date' => '',
    );

    // 
    $data = json_encode($todo_data);

    // update entry
    GFAPI::update_entry_field( $entry_id, 19, $data ); // Todo Date

    // update history
    if($message){
        logTodoHistory($message, $entry_id);
    }
}


/*
 * Todo History
 * 
 */
function logTodoHistory($action = NULL, $entry_id = NULL){
    
    /* // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$current_user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$current_user_id = $current_user_id ? $current_user_id : get_current_user_id();
    // GET USER BY ID
    $current_user = get_user_by( 'id', $current_user_id ); */

    // I DIDN'T UPDATE THIS ONE TO FETCH THE CUSTOMER ID IF THE MANAGER IS USING THE USER VIEW FUNCTIONALITY
    // BECAUSE IT WILL BE HARD FOR US TO REALLY KNOW IF THE MANAGER OR THE USER IS DOING THE ACTION
    // GET USER OBJECT
    $current_user = wp_get_current_user(); // supposed to be the manager OR THE USER IN GENERAL

    // get user full name
    $user_full_name = $current_user->user_firstname . " " . $current_user->user_lastname;

    // get user email
    $user_email = $current_user->user_email;

    // date
    $date = date("Y-m-d H:i:s");

    // get entry
    $entry = GFAPI::get_entry($entry_id);

    // get rgar
    $todo_history = rgar($entry, 14);

    // check if todo history is empty if not decode
    $todo_history = $todo_history == "" ? [] : json_decode($todo_history, true);

    $todo_history[] = array(
        "user_full_name" => $user_full_name,
        "user_email" => $user_email,
        "date" => $date,
        "action" => $action
    );

    // json encode
    $json_data = json_encode($todo_history);

    // update entry
    $result = GFAPI::update_entry_field($entry_id, 14, $json_data);
}

/*
 * GENERATE A GOOGLE DRIVE FOLDER
 * 
 * @param array $data
 * 
 * @return array()
 * 
 */
function generateGoogleDriveFolder($data){

    // GET THE DATA
    $date = $data["month"];
    $customer_email = $data["customer_email"];
    $entry_id = $data["entry_id"];
    // initialize class
    $seoi = new NEW_SEOI_GOOGLE();
    // create the google drive folder structure
    $google_directory = $customer_email . "/Reports/" . $date . "/";
    // create the folder or return the folder id if it exists
    $reportfolderid = $seoi->googleDriveCreateFolder($google_directory, "", "reports");
    // save google drive folder id to the database
    saveGoogleDriveLink($entry_id, $reportfolderid);
    // SAVE SELECTED MONTH
    $date = str_replace("_", " ", $date);
    saveSelectedMonth($entry_id, $date);

}


/*
 * FILE UPLOAD TO THE GOOGLE DRIVE FOLDER
 */
add_action('wp_ajax_googleDriveFileUpload', 'googleDriveFileUpload');
add_action('wp_ajax_nopriv_googleDriveFileUpload', 'googleDriveFileUpload');
function googleDriveFileUpload(){

    $file = $_FILES['file'];
    $month = $_POST['month'];
    $customer_email = $_POST['customer_email'];
    $drive_id = $_POST['drive_id'];
    // echo $file['tmp_name'];
    // $entry_id = $_POST["DATA"];

    /* blic function saveDataToCache(array $data = array()){

		// FILE NAME
		$file_name = $data['user_id'].'_'.$data['data_type'].'_property_report.json';
		// FILE PATH
		$file_path = get_stylesheet_directory()."/includes/tmp/".$file_name;
		// OVERWRITE THE FILE
		return $json = file_put_contents($file_path, json_encode($data));
	} */

    // Specify the directory where you want to save the uploaded file
    //   $uploadDirectory = 'uploads/';
    $uploadDirectory = get_stylesheet_directory()."/includes/cache/";

    // Generate a unique filename to avoid overwriting existing files
    $filename = uniqid() . '_' . $file['name'];

    // Move the temporary file to the upload directory
    $destination = $uploadDirectory . $filename;

    if (move_uploaded_file($file['tmp_name'], $destination)) {


        // initialize class
        $seoi = new NEW_SEOI_GOOGLE();
        // ADD _ TO THE MONTH
        $month = str_replace(" ", "_", $month);
    
        // create the google drive folder structure
        $google_directory = $customer_email . "/Reports/" . $month . "/" . $file['name'];
    
        // upload the file to google drive
        $gdrive_upload = $seoi->googleDriveUploadFile($google_directory, $destination, 'document'); 

        // check if gdive upload is empty
        if($gdrive_upload["id"]){
            // build the file link
            echo "https://drive.google.com/file/d/".$gdrive_upload["id"]."/view";
        } else {
            echo false;
        }

        // var_dump($gdrive_upload);

    } else {
        // File upload failed
        // echo 'File upload failed.';
        echo false;
    }

    die();
}


// AJAX REMOVE FILE FROM GOOGLE DRIVE
add_action('wp_ajax_removeFileFromGoogleDrive', 'removeFileFromGoogleDrive');
add_action('wp_ajax_nopriv_removeFileFromGoogleDrive', 'removeFileFromGoogleDrive');
function removeFileFromGoogleDrive(){

    $file_id = $_POST["drive_id"];

    // initialize class
    $seoi = new NEW_SEOI_GOOGLE();

    // remove file from google drive
    $remove_file = $seoi->googleDriveDeleteFile($file_id);

    // check if the file was removed

    // var_dump($remove_file);
    if(!isset($remove_file['error'])){
        echo "success";
    } else {
        echo "error";
    }

    die();
}

// AJAX UPDATE TODO LIST
add_action('wp_ajax_updateTodoList', 'updateTodoList');
add_action('wp_ajax_nopriv_updateTodoList', 'updateTodoList');
function updateTodoList(){

    // JSON HEADER
    header('Content-Type: application/json');

    // 
    $formData = $_REQUEST["formData"];
    $formDataArr = [];

    // loop through the form data
    foreach($formData as $key => $value){

        // 
        $formDataArr[$value['name']] = $value['value'];
    }


    /* $jsonString = '{"formData": "{\\\"report_link\\\":\\\",https:\/\/drive.google.com\/file\/d\/1uh5t8U-D2oCg6-CLXzMOa6hqOhz8j7Jq\/view,https:\/\/drive.google.com\/file\/d\/1uh5t8U-D2oCg6-CLXzMOa6hqOhz8j7Jq\/view,https:\/\/drive.google.com\/file\/d\/1uh5t8U-D2oCg6-CLXzMOa6hqOhz8j7Jq\/view\\\",\\\"todo_comment_0\\\":\\\"\\\",\\\"editor_id\\\":\\\"todo_comment_0\\\",\\\"save_type\\\":\\\"save\\\",\\\"entry_id\\\":\\\"1449\\\",\\\"todo\\\":\\\"Site Speed Optimisation\\\",\\\"todo_info\\\":\\\"Optimise site load speed. We have optimised images by reducing file size and other unnecessary files to improve your site\\'s load speed.\\\",\\\"additional_todo_key\\\":\\\"\\\",\\\"internal_notes_0\\\":\\\"<p>dfgdfgdfg<\/p>\\\",\\\"include_in_report_0\\\":\\\"on\\\"}"}';

// Decode the JSON string
$data = json_decode($jsonString, true);

// Access the formData key and decode its value
$formData = json_decode($data['formData'], true);

// Now you can use $formData as an associative array in your PHP code
print_r($formData); */
    
    // json decode
    // $formData = json_decode(html_entity_decode( stripslashes ($formData ) ) );
    // $formData = json_decode( stripslashes ($formData ) );
    /* $formData = json_decode( $formData, true );
    // Access the formData key and decode its value
    $formData = json_decode($formData['formData'], true); */
    // $formData = stripslashes($formData );
    
    // ob_start();
    
    // 
    // $save_type = $formData['save_type'];

    // dd($formData);
    //
    // $response['tasdasdasd'] = $formDataArr;
    // $response['test'] = $formData->editor_id;

    // 
    $save_type = $formDataArr['save_type'];
    $editor_id = $formDataArr['editor_id'];
    $entry_id = $formDataArr['entry_id'];
    $additional_todo_key = $formDataArr['additional_todo_key'];
    $todo = $formDataArr['todo'];

    // GET THE TODO LIST
    $todo_list = gform_get_meta($entry_id, 'todo_list');

    // $response['asasdasd'] = $save_type;

    
    // SAVE THE TODO COMMENTS
    $response['saved'] = saveTodoComments($entry_id, $todo_list, "save", $additional_todo_key, $todo, $formDataArr);
            


    //
    echo json_encode( $response );

    die();
}