<?php
/*
	seo-manager/seo-strategy/
	-- assigned orders to the account manager
*/
add_shortcode( 'seo-strategy', '_seo_strategy' );
function _seo_strategy() {
	ob_start();

	// get user data
	// $user_id   = get_current_user_id();

    // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
    $user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
    // IF EMPTY, GET THE CURRENT USER ID
    $user_id = $user_id ? $user_id : get_current_user_id();

    // GET THE VIEW AS TO CHECK IF THE USER IS VIEWING AS A CUSTOMER
	$view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';

    // GET USER OBJECT
    $user = get_user_by("ID", $user_id);
    // GET USER EMAIL
    $user_email = $user->user_email;
    // GET USER ROLE
	$user_role = $user->roles[0];

    /* var_dump($user_email);
    var_dump($view_as); */
    
    // the seo strategy form for the account manager
    if($user_role == "account_manager") {

        // get the existing strategies
        $strategies = get_the_author_meta( "seo_strategies", $user_id );
    
        // get the assigne customers of the seo manager
        $assignedCustomers = get_the_author_meta( "_assigned_customers", $user_id );
    
        // data for the seo manager
        if ( isset( $_POST["Customer_ID"] ) ) {
    
            // 
            $customer = get_user_by( "id", $_POST["Customer_ID"] );
            $formData = $strategies[$_POST["Customer_ID"]];
    
            // output customer id in an html
            echo "<div id='seo-strategy-customer-email' data-customer-email='".$customer->user_email."'></div>";
            
            $user_id = $_POST["Customer_ID"];
        }

        // customer email
        $customer_email = "";

        // check if customer id is set
        if(isset($_GET['cid'])){
            
            // get customer id
            $customer_id = $_GET['cid'];

            // check if the customer id exists in the assigned customers
            if(in_array($customer_id, $assignedCustomers)){

                // get user email by id
                $customer_email = get_user_by('id', $customer_id)->user_email;
            }
        }

        // initialize class
        $seoi = new NEW_SEOI_GOOGLE();

        // get auth link
        $auth_url = $seoi->oauth_link();

        // get the access and refresh tokens
        $refresh_token = $seoi->get_tokens("refresh");

        // generate new access token for the api
        $seoi->generate_new_tokens($refresh_token);


        

        // if (isset($_GET['code'])) {
        if ($refresh_token) {

            // generate access token
            $code = isset($_GET['code']) ? $_GET['code'] : '';
            $seoi->generate_tokens($code);
        ?>
                <div class="bg-white p-3 mb-3 border-top-5 border-orange">
                    <div class="text fw-medium">Generate a SEO Strategy</div>
                </div>
            <?php
            echo "<div class='seo-strategy-manager-form m-0'>";
            echo do_shortcode("[gravityform id=18 title=false description=false ajax=true field_values='strategy_customer_email={$customer_email}&seo_strategy_manager_id={$user_id}']");
            echo "</div>";

            /* latest keyword report */
            /* // get user by email
            $customer_data = get_user_by('email', $customer_email);
            // get user id
            $customer_id = $customer_data->ID;
            // get specific user meta by key
            $latest_entry = get_user_meta($customer_id, 'latest_generated_keyword_report', true);
            // check if latest entry is not empty
            if($latest_entry){
                require(__DIR__ . '/reports/generate-keyword-report.php');
            } */

            

            /* repot history todo list */
            // gravityform get all entries with specific meta value
            $customer_id = isset($customer_id) ? $customer_id : '';
            $entries = GFAPI::get_entries(18, array(
                'mode' => 'any',
                array(
                    'key'   => '11',
                    'value' => $customer_id
                ),
            ), array(), array('offset' => 0, 'page_size' => 20 ));

            /* dd($customer_id);
            dd($entries); */

            if($entries){
            ?>
            <table class="table bg-white mt-3">
                <thead>
                    <tr>
                        <th class="text fw-medium" colspan="3">History</th>
                    </tr>
                    <tr>
                        <th class="text fw-medium">Customer Email</th>
                        <th class="text fw-medium">Date</th>
                        <th class="text fw-medium"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    foreach($entries as $key => $entry){
                        // get entry id
                        $entry_id = $entry['id'];

                        // date created
                        $date_created = rgar($entry, 'date_created');

                        // format date 
                        $date_created = date("F j, Y", strtotime($date_created));

                        // get customer email
                        $customer_email = rgar($entry, '12');
                    ?>
                        <tr>
                            <td class="text"><?php echo $customer_email; ?></td>
                            <td class="text"><?php echo $date_created; ?></td>
                            <td class="text"><form action="/seo-manager/todos/list/?eid=<?php echo $entry_id; ?>" method="POST"><input type="hidden" name="entry_id" value="<?php echo $entry_id; ?>"><button type="submit" class="rounded-0 text py-2 px-3 btn-orange-outline lh-1">View Todo #<?php echo $entry_id; ?></button></form></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
            <?php
            }
            // =======================
        } else {
            ?>
                <div class="dashboard-overview no-arrow mt-3">
                    <div class="do-title">
                        <p>Please connect your seo manager google account first.</p>
                        <a href="<?php echo $auth_url; ?>" class="orange-button">Authenticate</a>
                    </div>
                </div>
            <?php
        }
    } else {

        ?>
            <div class="bg-white p-3 mb-3 border-top-5 border-orange">
                <div class="text fw-medium">Generate a SEO Strategy</div>
            </div>
        <?php

        // GET ALL USER ORDERS
        $customer_orders = get_posts( array(
            'numberposts' => 3, // can be any number. I just set 3 for testing purposes
            'meta_key'    => '_customer_user',
            'meta_value'  => $user_id,
            'post_type'   => wc_get_order_types(),
            'post_status' => array_keys( wc_get_order_statuses() ),
        ) );
        // COUNT ORDERS
        $order_count = $customer_orders ? count($customer_orders) : 0;
        
        // NUMBER OF ENTRIES
        $entries = GFAPI::get_entries( 17, array(
            'status'        => 'active',
            'field_filters' => array(
                array(
                    'key'   => '12',
                    'value' => $user_email,
                ),
            )
        ) );
        // COUNT ENTRIES
        $entry_count = $entries ? count($entries) : 0;

        // dd($customer_orders);
        // dd($entries);
        /* dd($order_count);
        dd($entry_count); */

        if($order_count == 0 && $entry_count >= 5) {
        ?>
            <div class="alert alert-warning alert-dismissible fade show rounded-0" role="alert">
                <?php
                    echo "You've hit the limit for generating SEO strategies. Please consider placing an order before continuing.";
                ?>
            </div>
        <?php
        } else {

            echo "<div class='seo-strategy-manager-form m-0'>";
            echo do_shortcode("[gravityform id=17 title=false description=false ajax=true field_values='strategy_customer_email={$user_email}&seo_strategy_user_email={$user_email}']");
            echo "</div>";
        }



        /*  echo "<div class='seo-strategy-manager-form m-0'>";
            echo do_shortcode("[gravityform id=18 title=false description=false ajax=true field_values='strategy_customer_email={$customer_email}&seo_strategy_manager_id={$user_id}']");
            echo "</div>"; */
    }

	return ob_get_clean();
}