<?php
// create a shortcode for the backlink checker
add_shortcode( 'seo-tools-content-readability', 'seoToolsContentReadability' );
function seoToolsContentReadability( $atts ) {
    
    ob_start();

    /* 
        Root Domain = root_domain 
    */
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">Content Readability</div>
    </div>
    <table class="table bg-white">
        <tbody>
            <tr>
                <td>
                    <form action="" method="POST">
                        <div class="text fw-medium">INPUT YOUR URL</div>
                        <input type="text" name="url" value="" class="mt-3 rounded-0 lh-1 w-100" placeholder="https://yourdomain.com/" required>
                        <button type="submit" class="mt-2 rounded-0 btn-orange py-2 px-3 text lh-1 w-100" style="height: 41px;">Submit</button>
                    </form>
                </td>
            </tr>
        </tbody>
    </table>
<?php
    if($_POST["url"]){
        $cr = new Content_Readability();
        $readability_data = $cr->check_readability($_POST["url"]);
?>
    <table class="table bg-white">
        <thead>
            <tr>
                <th class="text fw-medium">Results</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text"><span>URL:</span> <strong><?php echo $_POST["url"]; ?></strong></td>
            </tr>
            <?php if($readability_data){ ?>
                <?php foreach($readability_data as $key => $data){ ?>
                    <tr>    
                        <td class="text"><?php echo ucwords(str_replace("_", " ", $key)); ?><span>:</span> <strong><?php echo number_format($data,2); ?></strong></td>
                    </tr>
                <?php } ?>
            <?php } ?>
        </tbody>
    </table>
<?php
    }
    return ob_get_clean();
}