<?php
// 
add_shortcode( 'seo-tools-conversion-rate-calculator', 'seoToolsConversionRateCalculator' );
function seoToolsConversionRateCalculator( $atts ) {
    ob_start();
    
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">Conversion Rate Calculator</div>
    </div>
    <table class="table bg-white">
        <tbody>
            <tr>
                <td>
                    <form action="" method="POST">
                        <div class="text fw-medium">Number of website visitors:</div>
                        <input type="number" name="visitors" value="" class="mt-2 rounded-0 lh-1 w-100" required>

                        <div class="text fw-medium mt-3">Total orders from website visitors:</div>
                        <input type="number" name="num_orders" value="" class="mt-2 rounded-0 lh-1 w-100" required>

                        <button type="submit" class="mt-3 rounded-0 btn-orange py-2 px-3 text lh-1 w-100" style="height: 41px;">Submit</button>
                    </form>
                </td>
            </tr>
        </tbody>
    </table>
<?php
    if($_POST["visitors"] && $_POST["num_orders"]){

        // Conversion Rate = (Number of Conversions / Total Number of Actions) x 100
        // Conversion Rate = (20 / 100) x 100 = 20%
        $rate = ($_POST["num_orders"] / $_POST["visitors"]) * 100;
?>
    <table class="table bg-white">
        <thead>
            <tr>
                <th class="text fw-medium">Conversion Rate Calculation</th>
            </tr>
        </thead>
        <tbody>
            <?php //if($siteData){ ?>
                <?php //foreach ($siteData["row"] as $key => $data) { ?>
                    <tr>    
                        <td class="text">With <?php echo $_POST["visitors"]; ?> and <?php echo $_POST["num_orders"]; ?>, your conversion rate is <strong><?php echo $rate; ?>%</strong></td>
                    </tr>
                <?php //} ?>
            <?php //} ?>
        </tbody>
    </table>
<?php
    }
    return ob_get_clean();
}