<?php
defined( 'ABSPATH' ) || exit;

// CHANGE TEXT ON CHECKOUT
add_filter( 'gettext', 'wc_billing_field_strings', 20, 3 );
function wc_billing_field_strings( $translated_text, $text, $domain ) {
	switch ( $translated_text ) {
        case 'Billing details' :
		$translated_text = __( 'Account Information', 'woocommerce' );
		break;
        
		case 'Account username' :
		$translated_text = __( 'Username', 'woocommerce' );
		break;

		case 'Create account password' :
		$translated_text = __( 'Password', 'woocommerce' );
		break;
	}
	return $translated_text;
}

// CHECKOUT FIELDS
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
function custom_override_checkout_fields( $fields ) {
    unset($fields['billing']['billing_company']); // remove billing company

    $fields['billing']['billing_email']['priority'] = 20; // re order email field
    $fields['billing']['billing_phone']['priority'] = 21; // re order phone field

    // ACCOUNT FIELDS
    unset($fields['account']['account_username']);
    // $fields['account']['account_password']['priority'] = 22;

    return $fields;
}

// REMOVER ADDITIONAL INFORMATION ON CHECKOUT
add_filter( 'woocommerce_enable_order_notes_field', '__return_false', 9999 );

// WOOCOMMERCE ADD FIRST NAME AND LAST NAME TO ACCOUNT REGISTRATION FORM
// ADD FIELDS
add_action( 'woocommerce_register_form_start', '_addFieldsRegistrationForm' );
function _addFieldsRegistrationForm() {
?>
    <p class="form-row form-row-first">
    <label for="reg_billing_first_name"><?php _e( 'First name', 'woocommerce' ); ?> <span class="required">*</span></label>
    <input type="text" class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
    </p>
  
    <p class="form-row form-row-last">
    <label for="reg_billing_last_name"><?php _e( 'Last name', 'woocommerce' ); ?> <span class="required">*</span></label>
    <input type="text" class="input-text" name="billing_last_name" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
    </p>
  
    <div class="clear"></div>
<?php
}

// VALIDATE FIELDS
add_filter( 'woocommerce_registration_errors', '_validateFieldsRegistrationForm', 10, 3 );
function _validateFieldsRegistrationForm( $errors, $username, $email ) {
    if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
        $errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
    }
    if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
        $errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!.', 'woocommerce' ) );
    }
    return $errors;
}

// SAVE FIELDS
// add_action( 'woocommerce_created_customer', '_saveFieldsRegistrationForm' ); 
function _saveFieldsRegistrationForm( $customer_id ) {
    if ( isset( $_POST['billing_first_name'] ) ) {
        update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
        update_user_meta( $customer_id, 'first_name', sanitize_text_field($_POST['billing_first_name']) );
    }
    if ( isset( $_POST['billing_last_name'] ) ) {
        update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
        update_user_meta( $customer_id, 'last_name', sanitize_text_field($_POST['billing_last_name']) );
    }

    // customer obj
    // $customer = get_user_by( "id", $customer_id );
    $customer = new WC_Customer( $customer_id );

    // db info
    $servername = "localhost";
    $username   = "seoico_wp762";
    $dbpass     = "p24SDRu.5.";
    $dbname     = "seoico_Z4Fne8nm";

    // generated password
    $generatedPassword = "se".$customer->ID."co".date("Ymd")."oi";

    // 
    $userData = array(
        ':name'          => $_POST['billing_first_name'],
        ':email'         => $customer->get_email(),
        ':mobile'        => "",
        ':password'      => md5( $generatedPassword ),
        ':address'       => "",
        ':user_type'     => "Member",
        ':status'        => "1",
        ':add_date'      => date('Y-m-d H:m:s'),
        ':purchase_date' => date('Y-m-d H:m:s'),
        ':last_login_at' => date('Y-m-d H:m:s'),
        ':expired_date'  => date('2050-01-01 00:00:00'),
        ':package_id'    => "1",
        ':paypal_email'  => "",
        ':last_payment_method' => "",
        ':last_login_ip'       => "",
    );

    try {
        // db connection
        $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $dbpass);

        // set the PDO error mode to exception
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // 
        $stmt = $conn->prepare(
            'INSERT INTO users (name, email, mobile, password, address, user_type, status, add_date, purchase_date, last_login_at, expired_date, package_id, paypal_email, last_payment_method, last_login_ip) VALUES (:name, :email, :mobile, :password, :address, :user_type, :status, :add_date, :purchase_date, :last_login_at, :expired_date, :package_id, :paypal_email, :last_payment_method, :last_login_ip)'
        );

        // 
        $stmt->execute($userData);

        // echo "New record created successfully";
    } catch(PDOException $e) {
        echo $e->getMessage();
    }

    $conn = null;
}

// random string generator for the temporary password
function rand_string( $length ) {
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    return substr(str_shuffle($chars),0,$length);
}

// REMOVE MESSAGE BOX ON CHECKOUT
add_filter( 'wc_add_to_cart_message_html', '__return_false' );

// STOP GRAVITY FORMS FROM SNAPPING
add_filter( 'gform_confirmation_anchor', '__return_false' );

// my account page woocommerce
add_action( 'woocommerce_after_customer_login_form', 'action_woocommerce_login_form_end', 10, 0 ); 
function action_woocommerce_login_form_end() { 
    echo do_shortcode( "[gravityform id=4 ajax=true description=false title=false]" );
    // echo do_shortcode( "[nextend_social_login_register_flow]" );
    // echo wp_login_form();
}
add_action( 'woocommerce_login_form_start', 'action_woocommerce_login_form_start', 10, 0 ); 
function action_woocommerce_login_form_start() { 
    echo "<h3>Login</h3><p class='got-account'>Got an account? Welcome back. Login here</p>";
}
add_action( 'woocommerce_before_customer_login_form', 'action_woocommerce_login_form_before', 10, 0 ); 
function action_woocommerce_login_form_before() { 
?>
<div class='login-page-logo'><a href='<?php echo get_site_url(); ?>'><img src='<?php echo get_site_url(); ?>/wp-content/uploads/2020/11/seoi-logo-orange.png' alt='SEOi' /></a></div>
<?php
}
// nextend
add_action( 'woocommerce_login_form_end', '_addcustomLoginForm', 10, 0 ); 
function _addcustomLoginForm() {
    // echo wp_login_form();
    // echo "asd";
    echo do_shortcode( "[google_login]" );
}
/* add_action( 'woocommerce_login_form', 'remove_checkout_login_form', 10, 0 );
function remove_checkout_login_form(){
    return false;
} */


// ADD NEW ORDER STATUS
add_action( 'init', 'register_new_order_status' );
function register_new_order_status() {
    register_post_status( 'wc-on-going', array(
        'label'                     => 'On Going',
        'public'                    => true,
        'show_in_admin_status_list' => true,
        'show_in_admin_all_list'    => true,
        'exclude_from_search'       => false,
        // 'label_count'               => ""
    ) );
}
add_filter( 'wc_order_statuses', 'add_new_status_to_order_statuses' );
function add_new_status_to_order_statuses( $order_statuses ) {
    $new_order_statuses = array();
    foreach ( $order_statuses as $key => $status ) {
        $new_order_statuses[ $key ] = $status;
        if ( 'wc-processing' === $key ) {
            $new_order_statuses['wc-on-going'] = 'On Going';
        }
    }
    return $new_order_statuses;
}

// GIVE ACCESS TO ORDER INFORMATION
add_filter( 'user_has_cap', 'give_permissions', 10, 3 );
function give_permissions( $allcaps, $cap, $args ) {

    /* // Bail out if we're not asking about a post:
	if ( 'edit_post' != $args[0] )
        return $allcaps;

    // Bail out for users who can already edit others posts:
    if ( $allcaps['edit_others_posts'] )
        return $allcaps;

    // Bail out for users who can't publish posts:
    if ( !isset( $allcaps['publish_posts'] ) or !$allcaps['publish_posts'] )
        return $allcaps; */

    // check if is admin
    $user_id = get_current_user_id();
    $user    = get_user_by("ID", $user_id);
    
    // if($user_roles && $user){

        // $user_role = $user->roles[0];
    // $user_role = $user->roles ? $user->roles[0] : "";
    $user_roles = $user ? $user->roles : array();
    $user_roles = count($user_roles) > 0 ? $user_roles : "";
    $user_role = $user_roles ? $user_roles[0] : "";

        // var_dump($user->roles);

    

    if ($user_role == "administrator" || $user_role == "account_manager") {
        // if (in_array("administrator", $user_roles) || in_array("account_manager", $user_roles)) {
            //$user = 123; //user id 
            if ( $cap[0] == 'view_order' ) {
                $allcaps[ $cap[0] ] = true;
            }
        // }
    }

    return $allcaps;
}

// custom admin css
add_action('admin_head', '_custom_admin_css');
function _custom_admin_css() {
?>
  <style>
      .order-status.status-on-going{
        background: #53ab9b;
        color: white;
      }
      .order-status.status-cancelled{
        background: #fb7676;
        color: white;
      }
  </style>
<?php
}

// 
add_action( 'template_redirect', 'custom_shop_page_redirect' );
function custom_shop_page_redirect() {
    if( is_shop() ){
        wp_redirect( get_site_url().'/affordable-seo-company/' );
        exit();
    }
}

// remove related product
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

// AUTO COMPLETE ORDER
add_action( 'woocommerce_order_status_processing', 'custom_autocomplete_order' );
function custom_autocomplete_order( $order_id ) {
    if ( ! $order_id ) {
        return;
    }
    $order = wc_get_order( $order_id );
    $order->update_status( 'completed' );
}



/* CUSTOM PRODUCT META FIELD TO LINK THE PAGES TO THE PRODUCTS */
// Add a custom meta field to the product
function add_custom_product_meta_field() {
    global $post;

    echo '<div class="custom-meta-field"><p class="form-field">';
    echo '<label for="related_page">Related Page (page id)</label>';
    echo '<input type="text" id="related_page" name="related_page" value="' . get_post_meta($post->ID, 'related_page', true) . '" />';
    echo '</p></div>';
}
add_action('woocommerce_product_options_general_product_data', 'add_custom_product_meta_field');

// Save the custom meta field value
function save_custom_product_meta_field($post_id) {
    $related_page_value = isset($_POST['related_page']) ? sanitize_text_field($_POST['related_page']) : '';
    update_post_meta($post_id, 'related_page', $related_page_value);
}
add_action('woocommerce_process_product_meta', 'save_custom_product_meta_field');

/*
 * SAVE THE WEBSITE URL TO THE USER META
 *
 */
add_action('woocommerce_thankyou', 'saveUserWebsiteAfterCheckout', 10, 1);
function saveUserWebsiteAfterCheckout( $order_id ) {
    // GET ORDER
    $order = wc_get_order( $order_id );
    // IF ORDER HAS SUBSCRIPTION
	$validate_subscription = [];

    // LOOP THROUGH ORDER ITEMS
	foreach ( $order->get_items() as $item_id => $item ) {
        // GET WEBSITE URL
		$website = $item->get_meta( 'Website URL', true );
        // CHECK IF WEBSITE URL IS NOT EMPTY
        if($website){
            // SAVE WEBSITE URL TO USER META
            saveUserWebsite($website);
        }

        // DATA
		$product_id = $item->get_product_id();
		$product = $item->get_product();
		$item_type = $product->get_type();
		// CHECK IF ITEM TYPE HAS STRING SUBSCRIPTION
		if (strpos($item_type, 'subscription') !== false) {
			$validate_subscription[] = true;
		}
	} 

    // BUILD DATA FOR GO HIGH LEVEL
	$billing_first_name = $order->get_billing_first_name();
	$billing_last_name = $order->get_billing_last_name();
	$billing_email = $order->get_billing_email();
    $billing_phone = $order->get_billing_phone();

    // CHECK IF ORDER HAS SUBSCRIPTION
    if (in_array(true, $validate_subscription)) {
        // BUILD DATA FOR GO HIGH LEVEL
        $customer_tag = "Managed Customer";
    } else {
        $customer_tag = "Customer";
    }

    // BUILD THE CONTACT DATA
    $contact_data = array(
        'name'  => $billing_first_name . " " . $billing_last_name,
        'email' => $billing_email,
        'phone' => $billing_phone,
        'tags'  => $customer_tag,
    );

    // GO HIGH LEVEL
    addGoHighLevelContact($contact_data);
}

/*  */
/* add_filter( 'woocommerce_new_customer_data', function( $data ) {
	$data['user_login'] = $data['user_email'];

	return $data;
} ); */

/*  */
/* function remove_account_username_validation($posted_data, $errors) {
    if (isset($errors->errors['account_username'])) {
        unset($errors->errors['account_username']);
    }
    return $posted_data;
}
add_filter('woocommerce_after_checkout_validation', 'remove_account_username_validation', 10, 2); */
/* function disable_username_validation($validation_errors, $posted_data) {
    if (isset($validation_errors->errors['account_username'])) {
        unset($validation_errors->errors['account_username']);
    }
    return $validation_errors;
}
add_filter('woocommerce_process_registration_errors', 'disable_username_validation', 10, 2); */
/* function disable_username_validation_checkout($errors, $username, $email) {
    unset($errors->errors['username_exists']);
    return $errors;
}
add_filter('woocommerce_registration_errors', 'disable_username_validation_checkout', 10, 3); */

/* function prevent_username_validation($validation_error, $username, $email) {
    return new WP_Error();
}
add_filter('woocommerce_registration_errors', 'prevent_username_validation', 10, 3);
add_filter('woocommerce_process_registration_errors', 'prevent_username_validation', 10, 3); */


/*
 * FORCE USERNAME TO BE THE EMAIL ADDRESS
 * 
 */
function my_new_customer_username( $username, $email, $new_user_args, $suffix ) {
    return $email;
}
add_filter( 'woocommerce_new_customer_username', 'my_new_customer_username', 10, 4 );


###################################################
//Allow custom characters inside of wordpress usernames
//USAGE: drop this function and filter into your functions.php file
//  https://www.craig-edmonds.com/solved-allow-wordpress-accept-plus-sign-usernames/
###################################################
function create_attendee_sanitize_user($username, $raw_username, $strict) {
	
	$allowed_symbols = "a-z0-9+ _.\-@"; //yes we allow whitespace which will be trimmed further down script
	
	//Strip HTML Tags
	$username = wp_strip_all_tags ($raw_username);

	//Remove Accents
	$username = remove_accents ($username);

	//Kill octets
	$username = preg_replace ('|%([a-fA-F0-9][a-fA-F0-9])|', '', $username);

	//Kill entities
	$username = preg_replace ('/&.+?;/', '', $username);

	//allow + symbol
	$username = preg_replace ('|[^'.$allowed_symbols.']|iu', '', $username);

	//Remove Whitespaces
	$username = trim ($username);

	// Consolidate contiguous Whitespaces
	$username = preg_replace ('|\s+|', ' ', $username);

	//Done
	return $username;
	
}
// add_filter ('sanitize_user', 'create_attendee_sanitize_user', 10, 3);


/*
 * ADD ADD WEBSITE URL FIELD TO TO EDIT ACCOUNT PAGE
 * 
 */
add_action( 'woocommerce_before_edit_account_form', 'action_woocommerce_before_edit_account_form', 10, 0 );
function action_woocommerce_before_edit_account_form(){
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">Edit Account</div>
    </div>
<?php
}
add_action( 'woocommerce_after_edit_account_form', 'action_woocommerce_after_edit_account_form', 10, 0 );
function action_woocommerce_after_edit_account_form() { 

    // get user id
    $user_id = get_current_user_id();



    // get website url
    // $website_url = get_user_meta( $user_id, 'website_url', true );
    $user_websites = get_user_meta( $user_id, '_user_websites', true );

    // dd($user_websites);
?>
    <div class="bg-white border p-3 mt-3">
        <h5 class="font-weight-bold">Add a Website</h5>
        <form action="" class="">
            <input class="w-100 d-block rounded-0" style="height:44px;" type="text" required placeholder="eg. https://yourwebsiteurl.com">
            <a href="" class="add-website btn-orange rounded-0 small-text px-3 text-uppercase mt-2">Add Website</a>
        </form>

        <?php if($user_websites){ ?>
            <h5 class="font-weight-bold mt-4">Your Websites</h5>
            <div>
                <?php foreach($user_websites as $key => $website){ ?>
                    <div><a href="" class="remove-website" data-website="<?php echo $website; ?>">&times;</a> <span><?php echo $website; ?></span></div>
                <?php } ?>
                </div>
        <?php } ?>
    </div>
<?php
}

// ADD WEBSITE AJAX
add_action( 'wp_ajax_add_website', 'add_website' );
add_action( 'wp_ajax_nopriv_add_website', 'add_website' );
function add_website() {

    // json header
    header('Content-Type: application/json');

    // get user id
    $user_id = get_current_user_id();

    // get website url
    $website_url = $_POST['website_url'];

    // get user websites
    $user_websites = get_user_meta( $user_id, '_user_websites', true );

    // check if user websites is empty
    if(!$user_websites){
        // create array
        $user_websites = array();
    }

    // add website url to array
    array_push($user_websites, $website_url);

    // update user meta
    update_user_meta( $user_id, '_user_websites', $user_websites );

    // return response
    echo json_encode(array(
        'status' => 'success',
        'message' => 'Website added successfully',
        'website_url' => $website_url,
    ));

    // end ajax
    die();
}

// REMOVE WEBSITE AJAX
add_action( 'wp_ajax_remove_website', 'remove_website' );
add_action( 'wp_ajax_nopriv_remove_website', 'remove_website' );
function remove_website() {

    // json header
    header('Content-Type: application/json');

    // get user id
    $user_id = get_current_user_id();

    // get website url
    $website_url = $_POST['website_url'];

    // get user websites
    $user_websites = get_user_meta( $user_id, '_user_websites', true );

    // check if user websites is empty
    if(!$user_websites){
        // create array
        $user_websites = array();
    }

    // remove website url from array
    $user_websites = array_diff($user_websites, array($website_url));

    // update user meta
    update_user_meta( $user_id, '_user_websites', $user_websites );

    // return response
    echo json_encode(array(
        'status' => 'success',
        'message' => 'Website removed successfully',
        'website_url' => $website_url,
    ));

    // end ajax
    die();
}

// woocommerce_single_product_summary
// add_action( 'woocommerce_single_product_summary', 'action_woocommerce_single_product_summary', 10, 0 );
function action_woocommerce_single_product_summary(){
    // echo "test";
    // $user_country = get_user_country();
    
    $location = WC_Geolocation::geolocate_ip();
    $country = $location['country'];
    dd($location);
    dd($country);
}

function custom_change_currency_symbol($currency_symbol, $currency) {
    // Use WC_Geolocation to get the user's geolocation
    $geolocation = WC_Geolocation::geolocate_ip();
    
    // Check if the geolocation data includes the user's country
    if (isset($geolocation['country'])) {
        $user_country = $geolocation['country'];
        
        // Define currency symbols based on country
        $currency_symbols = array(
            'US' => '$',       // Example: Dollar sign for the United States
            'GB' => '£',       // Example: Pound sign for the United Kingdom
            // Add more country-based currency symbols as needed
        );
        
        // Check if there is a custom currency symbol for the user's country
        if (isset($currency_symbols[$user_country])) {
            return $currency_symbols[$user_country];
        }
    }
    
    // If no custom symbol is defined for the user's country, return the default symbol
    return $currency_symbol;
}

// add_filter('woocommerce_currency_symbol', 'custom_change_currency_symbol', 10, 2);


// Advanced Product Fields Extended for WooCommerce 

add_filter('wapf/html/pricing_hint', function( $str ) {
    return str_replace('+','', $str);
}, 10, 1);

// add_filter('wapf/html/product_totals', 'sw_wapf_add_summary_html',10,2);
function sw_wapf_add_summary_html($totals_html, $product) {

    // Configurable data
    $product_ids = array(6392);
    $added_html = '<div><span>Frame surface</span><span class="sw-frame-surface">0m²</span></div>';
    // Don't edit below this line.

    dd($totals_html);

    if(!in_array($product->get_id(), $product_ids))
        return $totals_html;

    $to_find = '<div class="wapf--inner">';
    return str_replace($to_find, $to_find . $added_html, $totals_html);

}

// add_action('wp_footer', 'wapf_custom_summary_js');
function wapf_custom_summary_js() {

    $product_ids = array(6392); // Change this to your product ID's

    if(!is_product() || !in_array(get_queried_object_id(), $product_ids)) return;
    ?>
    <script>
    jQuery(function() {
        jQuery('.calc-width input, .calc-height input').on('change', function(e) {
            var surface = (jQuery('.calc-width input').val()/1000) * (jQuery('.calc-height input').val()/1000);
            jQuery('.sw-frame-surface').html(surface.toFixed(2) + 'm²');
        });
    });
    </script>
<?php
}

function custom_geo_location_fee() {
    // Use WC_Geolocation to get the user's geolocation
    $geolocation = WC_Geolocation::geolocate_ip();

    // Check if the geolocation data includes the user's country
    if (isset($geolocation['country'])) {
        $user_country = $geolocation['country'];

        // Define the exchange rate
        $exchange_rate = 1.25; // Replace with your desired exchange rate

        // Check if the user's country is the United States (US)
        if ($user_country === 'US') {
            // Get the cart total
            $cart_total = WC()->cart->get_cart_contents_total();

            // Calculate the exchange rate difference
            $exchange_rate_difference = ($cart_total * $exchange_rate) - $cart_total;

            if ($exchange_rate_difference > 0) {
                // Add the exchange rate difference as a fee
                $fee_amount = $exchange_rate_difference;
                $fee_label = __('Exchange Rate Fee', 'your-text-domain'); // Customize the label

                WC()->cart->add_fee($fee_label, $fee_amount);
            }
        }
    }
}

// add_action('woocommerce_cart_calculate_fees', 'custom_geo_location_fee');


/**
 * Attach PDF file to WooCommerce order confirmation email for Cheque payment method.
 */
function attach_pdf_to_email_for_cheque_payment( $attachments, $email_id, $order, $email ) {
    // Check if the payment method is Cheque
    if ( 'cheque' === $order->get_payment_method() ) {
        // $upload_dir = wp_upload_dir();
        // $pdf_file_path = $upload_dir['basedir'] . "/2020/09/example.pdf";
        $pdf_file_path = get_stylesheet_directory() . '/public/pdf/sample.pdf';

        // Check if the PDF file exists
        if ( file_exists( $pdf_file_path ) ) {
            // Add the PDF file to the attachments array
            $attachments[] = $pdf_file_path;
        }
    }

    return $attachments;
}

add_filter( 'woocommerce_email_attachments', 'attach_pdf_to_email_for_cheque_payment', 10, 4 );



function asdasd(){

    // get order
    $order = wc_get_order( 6584 );
    // get order data
    $order_data = $order->get_data();
    $order_billing_first_name = $order_data['billing']['first_name'];
    $order_billing_last_name = $order_data['billing']['last_name'];
    $order_billing_email = $order_data['billing']['email'];
    $order_billing_phone = $order_data['billing']['phone'];
    $order_billing_address_1 = $order_data['billing']['address_1'];
    $order_billing_address_2 = $order_data['billing']['address_2'];
    $order_billing_city = $order_data['billing']['city'];
    $order_billing_state = $order_data['billing']['state'];
    $order_billing_postcode = $order_data['billing']['postcode'];
    $order_billing_country = $order_data['billing']['country'];

    // build mail body
    $mail_body .= "<p>Order ID: {$order->get_id()}</p>";
    $mail_body .= "<p>Order Date: {$order->get_date_created()->date('Y-m-d H:i:s')}</p>";
    $mail_body .= "<p>Order Status: {$order->get_status()}</p>";
    $mail_body .= "<p>Order Total: {$order->get_formatted_order_total()}</p>";
    $mail_body .= "<p>Order Payment Method: {$order->get_payment_method_title()}</p>";
    $mail_body .= "<p>Customer Name: {$order_billing_first_name} {$order_billing_last_name}</p>";
    $mail_body .= "<p>Customer Email: {$order_billing_email}</p>";
    $mail_body .= "<p>Customer Phone: {$order_billing_phone}</p>";
    $mail_body .= "<p>Customer Address: {$order_billing_address_1} {$order_billing_address_2} {$order_billing_city} {$order_billing_state} {$order_billing_postcode} {$order_billing_country}</p>";
    $mail_body .= "<p>Customer IP: {$order->get_customer_ip_address()}</p>";
    $mail_body .= "<p>Customer User Agent: {$order->get_customer_user_agent()}</p>";

    echo "<pre>";

    echo "</pre>";

    // Send a basic plain email to specific email addresses
    $to = array( 'sean@seoi.co.uk', 'yuki@seoi.co.uk' );
    $subject = 'Invoice was sent to Customer for Order #' . $order_id . '.';
    $message = 'The invoice for order #' . $order_id . ' has been sent.';
    $headers = array(
        'From: SEOi <noreply@seoi.io>',
        'Content-Type: text/html',
    );
    wp_mail( $to, $subject, $mail_body, $headers );


    // Process each failed subscription order
    /* foreach ($failed_subscriptions as $subscription_order) {
        // Trigger the WooCommerce action to send order details
        // do_action('send_order_details', $subscription_order->get_id());
        send_custom_order_details_action($subscription_order->get_id());
    }
 */

    /* // Get the order object
    $order = wc_get_order( 6601 );
    // PDF file path inside the child theme directory
    $pdf_file_path = get_stylesheet_directory() . '/public/pdf/sample.pdf';

     // Get the email instance
     $mailer = WC()->mailer();

     // Get the email classes
     $emails = $mailer->get_emails();

    echo "<pre>";
    var_dump(file_exists( $pdf_file_path ));
    var_dump($order->get_payment_method());
    var_dump($pdf_file_path);
    var_dump($emails);
    echo "</pre>"; */
    ?>
    <!-- <style>#adminmenumain{display: none !important;}</style> -->
    <?php
}
// add_action("admin_init", "asdasd");



/**
 * Action to send custom order details.
 *
 * @param int $order_id The ID of the order.
 */
function send_custom_order_details_action( $order_id ) {
    // Load the order by its ID
    $order = wc_get_order( $order_id );

    // Check if the email has been sent for this month
    $email_sent_this_month = get_transient( 'custom_order_email_sent_' . $order_id );

    if ( ! $email_sent_this_month ) {
        // Trigger the WooCommerce action to send order details
        do_action( 'woocommerce_before_resend_order_emails', $order, 'customer_invoice' );

        // Send the customer invoice email
        WC()->payment_gateways();
        WC()->shipping();
        WC()->mailer()->customer_invoice( $order );

        // Note the event
        $order->add_order_note( __( 'Monthly Invoice Sent to Customer.', 'your-text-domain' ), false, true );

        // GET ORDER CUSTOMER NAME
       /*  $order_data = $order->get_data();
        $order_billing_first_name = $order_data['billing']['first_name'];
        $order_billing_last_name = $order_data['billing']['last_name']; */

        // Send a basic plain email to specific email addresses
        $to = array( 'sean@seoi.co.uk', 'yuki@seoi.co.uk' );
        $subject = 'Invoice was sent to Customer for Order #' . $order_id . '.';
        $message = 'The invoice for order #' . $order_id . ' has been sent.';
        $headers = array(
            'From: SEOi <noreply@seoi.io>',
            'Content-Type: text/plain',
        );
        wp_mail( $to, $subject, $message, $headers );

        // Trigger any additional actions or custom logic as needed

        do_action( 'woocommerce_after_resend_order_email', $order, 'customer_invoice' );

        // Set transient to indicate that the email has been sent for this month
        set_transient( 'custom_order_email_sent_' . $order_id, true, MONTH_IN_SECONDS );
    }
}

// Hook your custom action to the desired trigger point
// add_action( 'send_custom_order_details', 'send_custom_order_details_action', 10, 1 );


/* function triggerSendEmails($order_id){
    // Replace 123 with the actual order ID you want to trigger
    // do_action( 'send_custom_order_details', $order_id );
}
// add_action("admin_init", 'test'); */

/**
 * Schedule daily cron job to check for failed subscription orders.
 */
function custom_schedule_daily_cron_job() {
    if (!wp_next_scheduled('custom_daily_cron_job')) {
        wp_schedule_event(time(), 'daily', 'custom_daily_cron_job');
    }
}
add_action('wp', 'custom_schedule_daily_cron_job');

/**
 * Callback function for the daily cron job.
 */
function custom_daily_cron_job() {
    // Get all subscription orders with 'failed' status
    /*$failed_subscriptions = wc_get_orders(array(
        'status' => 'failed',
        // 'type'   => 'shop_subscription',
    ));*/
    
    global $wpdb;
    $subscription_order_ids = $wpdb->get_col("
        SELECT DISTINCT order_items.order_id
        FROM {$wpdb->prefix}woocommerce_order_items as order_items
        LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta as order_item_meta ON order_items.order_item_id = order_item_meta.order_item_id
        WHERE order_items.order_item_type = 'line_item'
        AND order_item_meta.meta_key = '_product_id'
        AND order_item_meta.meta_value IN (
            SELECT DISTINCT post_id
            FROM {$wpdb->prefix}postmeta
            WHERE meta_key = '_subscription_period'
        )
    ");
    
    
    // Get all subscription orders with 'failed' status
    $failed_subscriptions = wc_get_orders(array(
        'post__in' => $subscription_order_ids,
        // 'post_type' => 'shop_order',
        'post_status' => 'failed', // Adjust the status as needed
        'numberposts' => -1,
    ));

    // Process each failed subscription order
    foreach ($failed_subscriptions as $subscription_order) {
        // Trigger the WooCommerce action to send order details
        // do_action('send_order_details', $subscription_order->get_id());
        send_custom_order_details_action($subscription_order->get_id());
    }
}
add_action('custom_daily_cron_job', 'custom_daily_cron_job');

/**
 * Action to send order details.
 *
 * @param int $order_id The ID of the order.
 */
/* function send_order_details_action($order_id) {
    // Process and send order details as needed
    $order = wc_get_order($order_id);

    // Check if the order is a subscription order
    if ($order && $order->get_type() === 'shop_subscription') {
        triggerSendEmails($order_id);
    }
}
// add_action('send_order_details', 'send_order_details_action', 10, 1); */
