<?php 
/**
 * Template Name: Keyword Report
 * Version: 1.0
 * Description: SEOi Keyword Report PDF Template
 * Author: 
 * Author URI: https://seoi.co.uk/
 * Group: Core
 * License: GPLv2
 * Required PDF Version: 4.0
 * Tags: space, solar system, getting started
 */

/* Prevent direct access to the template (always good to include this) */
if ( ! class_exists( 'GFForms' ) ) {
    return;
}

// return; // don't generate for the meantime. !remove

/**
 * All Gravity PDF v4/v5/v6 templates have access to the following variables:
 *
 * @var array  $form      The current Gravity Forms array
 * @var array  $entry     The raw entry data
 * @var array  $form_data The processed entry data stored in an array
 * @var object $settings  The current PDF configuration
 * @var array  $fields    An array of Gravity Forms fields which can be accessed with their ID number
 * @var array  $config    The initialised template config class – eg. /config/zadani.php
 */

// include file inside the theme folder that contains the class
require_once( get_stylesheet_directory() . '/includes/seo-manager/dashboard.php' );

?>

<!-- Any PDF CSS styles can be placed in the style tag below -->
<link rel="stylesheet" href="<?= __DIR__; ?>/css/keyword_report.css">


<?php

// get server root
// $root = $_SERVER['DOCUMENT_ROOT'];

// echo "<img src='".$root."/api/generatedimage.png'>";


// data
$original_url  = $form_data['field'][9];
$start_date    = $form_data['field'][6];
$end_date      = $form_data['field'][7];
// $keyword_count = $form_data['field'][5];
$keywords      = get_user_meta(1, "keyword_basket", true);

/* echo "<pre>";
var_dump("etest");
var_dump($original_url);
// var_dump($website);
var_dump($start_date);
var_dump($end_date);
// var_dump($siteData);
echo "</pre>";

die(); */

// dates
$start_date      = date("Y-m-d", strtotime($start_date));
$end_date        = date("Y-m-d", strtotime($end_date));
$prev_start_date = date("Y-m-d", strtotime("-1 month", strtotime($start_date)));
$prev_end_date   = date("Y-m-d", strtotime("-1 month", strtotime($end_date)));





// initilize the google class
$google = new NEW_SEOI_GOOGLE();

// do shortcode
/* echo do_shortcode('[gfchart id="5373"]');
echo "<pre>";
var_dump($settings);
var_dump($config);
echo "</pre>"; */

?>

<!-- pdf header and footer -->
<htmlpageheader name="MyCustomHeader">
    <table style="border-bottom: 2px solid #fa7d09; border-spacing: 0; border-collapse: collapse; margin-bottom: 10px;" cellspacing="0" width="100%">
        <tbody>
            <tr>
                <td width="50%" style="vertical-align:bottom; padding-bottom: 15px;" ><img src="<?= __DIR__; ?>/images/seoilogo-4.png" alt="SEOi" width="80px"></td>
                <td width="50%" style="text-align: right; vertical-align: bottom; padding-bottom: 15px; color: #666666; font-size: 11px;">https://seoi.co.uk/</td>
            </tr>
        </tbody>
    </table>
</htmlpageheader>
<htmlpagefooter name="MyCustomFooter">
    <table style="border-top: 2px solid #fa7d09; border-spacing: 0; border-collapse: collapse;" cellspacing="0" width="100%">
        <tbody>
            <tr>
                <td width="50%" style="padding-top: 15px; vertical-align: middle; color: #666666; font-size: 11px;">© Copyright <?php echo date('Y'); ?> SEOi</td>
                <td width="50%" style="padding-top: 15px; vertical-align: middle; text-align: right; color: #666666; font-size: 11px;">{PAGENO} of {nbpg}</td>
            </tr>
        </tbody>
    </table>
</htmlpagefooter>

<?php

// order data
$order_id = $form_data['field'][1];

// check if order id is set and get the website url of that order if the keyword report is generated on the /view-order page
if($order_id){

    // 
    $order       = wc_get_order($order_id);
    $order_items = $order->get_items(); // get all order items

    // loop through order items
    foreach ($order_items as $key => $item) {
        
        // get the clean (without https and slashes) website url
        $original_url = $item->get_meta('Website URL', true);
        
    }
}


$website_url  = parse_url($original_url);
$website_url  = $website_url["host"] ? $website_url["host"] : $website_url["path"];

// validate website url
// google search console api requires the site url specified in the site list
$website = $google->validate_website($website_url);

// get access token
// $access_token = $google->get_tokens('access');


// live keywords
    $rowCount        = 1000;
    $startRow        = 0;
    $prevStartRow    = 0;
    $allKeywords     = array();
    $prevAllKeywords = array();

    $siteData = $google->generate_site_data(
        "", // access token
        $website, 
        $start_date,
        $end_date,
        $rowCount,
        "",
        $startRow
    );

    if(isset($siteData['rows'])){
    
        // get current month keywords
        do{

            // 
            $siteData = $google->generate_site_data(
                "", // access token
                $website, 
                $start_date,
                $end_date,
                $rowCount,
                "",
                $startRow
            );

            // 
            if(isset($siteData["rows"])){
                $allKeywords = array_merge($allKeywords, $siteData["rows"]);
            }
            
            // update start row
            $startRow = count($allKeywords);

        } while (count($allKeywords) < $rowCount && count($siteData["rows"]) >= $rowCount);

        // get previous month keywords
        $prevSiteData = $google->generate_site_data(
            "", // access token
            $website, 
            $prev_start_date,
            $prev_end_date,
            $rowCount,
            "",
            $prevStartRow
        );

        // check if there are any keywords in the previous month
        if($prevSiteData["rows"]){

            // get previous month keywords
            do{

                //
                $prevSiteData = $google->generate_site_data(
                    "", // access token
                    $website, 
                    $prev_start_date,
                    $prev_end_date,
                    $rowCount,
                    "",
                    $prevStartRow
                );

                

                // 
                if($prevSiteData["rows"]){
                    $prevAllKeywords = array_merge($prevAllKeywords, $prevSiteData["rows"]);
                }

                // update start row
                $prevStartRow = count($prevAllKeywords);

            } while (count($prevAllKeywords) < $rowCount && count($prevSiteData["rows"]) >= $rowCount);

        } else {
                
                // declare empty array
                $prevSiteData = array();
        }

    }

    /* echo "<pre>";
var_dump($siteData);
var_dump($website);
var_dump($website_url);
var_dump($start_date);
var_dump($end_date);
echo "</pre>"; */
// die();
    
    
    // check if the website is valid
    if ($website && $allKeywords && $prevAllKeywords) {

        // get the data
        $current_data = $allKeywords;
        $prev_data    = $prevAllKeywords;

        // arrange nested array by key
        // $current_data = $google->array_sort($current_data, "keyword", SORT_ASC);
        // $adasda = array_sort($current_data, $current_data[4], SORT_DESC);
        

        // set the default data to the variables
        $keywords_by_page_rankings      = $current_data;
        $top_moved_keywords             = $current_data;
        // $top_20_keywords_by_clicks      = $current_data;
        // $top_20_keywords_by_impressions = $current_data;
        // $top_20_keywords_by_position    = $current_data;

        // sort the data by page rankings
        usort($keywords_by_page_rankings, fn($a, $b) => $a["position"] <=> $b["position"]);

        /* echo "<pre>";
        var_dump(count($current_data));
        var_dump($keywords_by_page_rankings);
        echo "</pre>"; */


        // sort array by key
        // array_multisort(array_column($top_20_keywords_by_clicks, 1), SORT_DESC, $top_20_keywords_by_clicks); // by clicks
        // array_multisort(array_column($top_20_keywords_by_impressions, 2), SORT_DESC, $top_20_keywords_by_impressions); // by impressions
        // array_multisort(array_column($top_20_keywords_by_position, 4), SORT_ASC, $top_20_keywords_by_position); // by position

        // arrows used for the pdf
        $up_arrow = "data:image/png;base64,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";
		$down_arrow = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAPCAYAAAAyPTUwAAAACXBIWXMAAC4jAAAuIwF4pT92AAAGumlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS42LWMxNDUgNzkuMTYzNDk5LCAyMDE4LzA4LzEzLTE2OjQwOjIyICAgICAgICAiPiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdEV2dD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlRXZlbnQjIiB4bWxuczpwaG90b3Nob3A9Imh0dHA6Ly9ucy5hZG9iZS5jb20vcGhvdG9zaG9wLzEuMC8iIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ0MgMjAxOSAoV2luZG93cykiIHhtcDpDcmVhdGVEYXRlPSIyMDIxLTExLTI0VDIyOjIzOjE1KzA4OjAwIiB4bXA6TWV0YWRhdGFEYXRlPSIyMDIxLTExLTI0VDIyOjIzOjE1KzA4OjAwIiB4bXA6TW9kaWZ5RGF0ZT0iMjAyMS0xMS0yNFQyMjoyMzoxNSswODowMCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpkN2Q3NGVlNy1kYjQzLWRlNGEtOTNlNy0wYTA5YWJiMzQ4N2YiIHhtcE1NOkRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3ODViMGY2MS1hYzg2LTg1NDItODNkYS05YTg4MWZjMTc5YzUiIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDoxNjVhZWZkYi1kNjEwLWQwNDUtYWU0NC1lOTE4ZGE0OGNjOWUiIHBob3Rvc2hvcDpDb2xvck1vZGU9IjMiIHBob3Rvc2hvcDpJQ0NQcm9maWxlPSJzUkdCIElFQzYxOTY2LTIuMSIgZGM6Zm9ybWF0PSJpbWFnZS9wbmciPiA8eG1wTU06SGlzdG9yeT4gPHJkZjpTZXE+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJjcmVhdGVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOjE2NWFlZmRiLWQ2MTAtZDA0NS1hZTQ0LWU5MThkYTQ4Y2M5ZSIgc3RFdnQ6d2hlbj0iMjAyMS0xMS0yNFQyMjoyMzoxNSswODowMCIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTkgKFdpbmRvd3MpIi8+IDxyZGY6bGkgc3RFdnQ6YWN0aW9uPSJzYXZlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDpkN2Q3NGVlNy1kYjQzLWRlNGEtOTNlNy0wYTA5YWJiMzQ4N2YiIHN0RXZ0OndoZW49IjIwMjEtMTEtMjRUMjI6MjM6MTUrMDg6MDAiIHN0RXZ0OnNvZnR3YXJlQWdlbnQ9IkFkb2JlIFBob3Rvc2hvcCBDQyAyMDE5IChXaW5kb3dzKSIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8L3JkZjpTZXE+IDwveG1wTU06SGlzdG9yeT4gPHBob3Rvc2hvcDpUZXh0TGF5ZXJzPiA8cmRmOkJhZz4gPHJkZjpsaSBwaG90b3Nob3A6TGF5ZXJOYW1lPSLihpEiIHBob3Rvc2hvcDpMYXllclRleHQ9IuKGkSIvPiA8cmRmOmxpIHBob3Rvc2hvcDpMYXllck5hbWU9IuKGkyIgcGhvdG9zaG9wOkxheWVyVGV4dD0i4oaTIi8+IDwvcmRmOkJhZz4gPC9waG90b3Nob3A6VGV4dExheWVycz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5XesKsAAAAZklEQVQoz2P4//8/Awgjg//iAQZwNlQehJkYsIMJ2ARxKWYYVUwbxaBYA+IEJL4AEE/AZfIDIC4AKjgApBWA+AJUDFMx48sNH4CUAxALALE8EG8AiqFGO3pCgjrnAbaExIie4vABAC/ZONz1qSeQAAAAAElFTkSuQmCC";
        ?>
            <!--  -->
            <div class="table-wrap">
                <h4 class="table-title">Page 1 Keywords</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Keyword</th>
                            <th>Clicks</th>
                            <th>Impressions</th>
                            <!-- <th>CTR</th> -->
                            <th>Previous Position</th>
                            <th>Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($keywords_by_page_rankings as $key => $value) {

                                // google page 1

                                if($value["position"] <= 10){
                                    $past_position = "-";

                                    if($prev_data){

                                        foreach ($prev_data as $key => $pv) {
                                            if ($value["keys"][0] == $pv["keys"][0]) {
                                                // $past_position = $pv[4];
                                                $past_position = round($pv["position"], 2);
                                            }
                                        }
                                    }
                        ?>
                                    <tr>
                                        <td><?php echo $value["keys"]["0"]; ?></td>
                                        <td><?php echo $value["clicks"]; ?></td>
                                        <td><?php echo $value["impressions"]; ?></td>
                                        <!-- <td><?php
                                            //echo round($value[3], 2);
                                        ?></td> -->
                                        <td><?php echo $past_position; ?></td>
                                        <td><?php 
                                            // echo $value[4];
                                            echo round($value["position"], 2);

                                            if ($past_position != "-" && $value["position"] > $past_position) {
                                                echo "<img src='".$down_arrow."'>";
                                            } elseif ($past_position != "-" && $value["position"] < $past_position) {
                                                echo "<img src='".$up_arrow."'>";
                                            }
                                        ?></td>
                                    </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <div class="table-wrap">
                <h4 class="table-title">Page 2 Keywords</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Keyword</th>
                            <th>Clicks</th>
                            <th>Impressions</th>
                            <!-- <th>CTR</th> -->
                            <th>Previous Position</th>
                            <th>Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($keywords_by_page_rankings as $key => $value) {

                                // google page 2
                                if($value["position"] >= 11 && $value["position"] <= 20){
                                    $past_position = "-";

                                    if($prev_data){

                                        foreach ($prev_data as $key => $pv) {
                                            if ($value["keys"][0] == $pv["keys"][0]) {
                                                // $past_position = $pv["position"];
                                                $past_position = round($pv["position"], 2);
                                            }
                                        }
                                    }
                        ?>
                                    <tr>
                                        <td><?php echo $value["keys"][0]; ?></td>
                                        <td><?php echo $value["clicks"]; ?></td>
                                        <td><?php echo $value["impressions"]; ?></td>
                                        <!-- <td><?php
                                            //echo round($value[3], 2);
                                        ?></td> -->
                                        <td><?php echo $past_position; ?></td>
                                        <td><?php 
                                            // echo $value["position"];
                                            echo round($value["position"], 2);

                                            if ($past_position != "-" && $value["position"] > $past_position) {
                                                echo "<img src='".$down_arrow."'>";
                                            } elseif ($past_position != "-" && $value["position"] < $past_position) {
                                                echo "<img src='".$up_arrow."'>";
                                            }
                                        ?></td>
                                    </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <div class="table-wrap">
                <h4 class="table-title">Page 3 Keywords</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Keyword</th>
                            <th>Clicks</th>
                            <th>Impressions</th>
                            <!-- <th>CTR</th> -->
                            <th>Previous Position</th>
                            <th>Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($keywords_by_page_rankings as $key => $value) {

                                // google page 3
                                if($value["position"] >= 21 && $value["position"] <= 30){
                                    $past_position = "-";

                                    if($prev_data){

                                        foreach ($prev_data as $key => $pv) {
                                            if ($value["keys"][0] == $pv["keys"][0]) {
                                                // $past_position = $pv["position"];
                                                $past_position = round($pv["position"], 2);
                                            }
                                        }
                                    }
                        ?>
                                    <tr>
                                        <td><?php echo $value["keys"][0]; ?></td>
                                        <td><?php echo $value["clicks"]; ?></td>
                                        <td><?php echo $value["impressions"]; ?></td>
                                        <!-- <td><?php
                                            //echo round($value[3], 2);
                                        ?></td> -->
                                        <td><?php echo $past_position; ?></td>
                                        <td><?php 
                                            // echo $value["position"];
                                            echo round($value["position"], 2);

                                            if ($past_position != "-" && $value["position"] > $past_position) {
                                                echo "<img src='".$down_arrow."'>";
                                            } elseif ($past_position != "-" && $value["position"] < $past_position) {
                                                echo "<img src='".$up_arrow."'>";
                                            }
                                        ?></td>
                                    </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>

            <?php
                $top_moved = array();
                foreach ($top_moved_keywords as $key => $value) {

                    $past_position = "-";

                    if($prev_data){
                        foreach ($prev_data as $key => $pv) {

                            if ($value["keys"][0] == $pv["keys"][0]) {

                                // past position
                                $past_position = round($pv["position"], 2);

                                // get the difference
                                $diff = $past_position - $value["position"];
                                $diff = round($diff, 2);

                                // insert value into array by diff
                                if($diff >= 1){
                                    $top_moved[$diff] = $value;
                                }
                            }
                        }
                    }
                }

            if($top_moved){
                // arrange array by key
                krsort($top_moved);
            ?>
            <div class="table-wrap">
                <h4 class="table-title">Top Moved Keywords</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th>Keyword</th>
                            <th>Clicks</th>
                            <th>Impressions</th>
                            <th>Previous Position</th>
                            <th>Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($top_moved as $key => $value) {

                                $past_position = "-";

                                if($prev_data){

                                    foreach ($prev_data as $key => $pv) {
                                        if ($value["keys"][0] == $pv["keys"][0]) {
                                            $past_position = round($pv["position"], 2);
                                        }
                                    }
                                }
                        ?>
                                <tr>
                                    <td><?php echo $value["keys"][0]; ?></td>
                                    <td><?php echo $value["clicks"]; ?></td>
                                    <td><?php echo $value["impressions"]; ?></td>
                                    <td><?php echo $past_position; ?></td>
                                    <td><?php 
                                        echo round($value["position"], 2);

                                        if ($past_position != "-" && $value["position"] > $past_position) {
                                            echo "<img src='".$down_arrow."'>";
                                        } elseif ($past_position != "-" && $value["position"] < $past_position) {
                                            echo "<img src='".$up_arrow."'>";
                                        }
                                    ?></td>
                                </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <?php } ?>
        <?php
    } else {
        echo "<p>No data found</p>";
    }
// }
?>