<?php 
/**
 * Template Name: SEO Strategy
 * Version: 1.0
 * Description: SEOi SEO Strategy PDF Template
 * Author: 
 * Author URI: https://seoi.co.uk/
 * Group: Core
 * License: GPLv2
 * Required PDF Version: 4.0
 * Tags: space, solar system, getting started
 */

 /* Prevent direct access to the template (always good to include this) */
if ( ! class_exists( 'GFForms' ) ) {
    return;
}

// include file inside the theme folder that contains the class
require_once( get_stylesheet_directory() . '/functions.php' );


$entry_id = $form_data['entry_id'];
$strategyData = gform_get_meta($entry_id, 'seo_strategy');

// dd($strategyData);

// ===================================================
if(!$strategyData){
    // BUILD THE DATA FOR THE SEO STRATEGY PDF
    $strategyData = [];
    // INITIALIZE CLASS
    $seo = new SEOI_SEO();
    // KEYWORDS DATA
    $keywords  = [];
    $keyword_1 = $form_data['field'][8] ? $keywords[] = $form_data['field'][8] : "";
    $keyword_2 = $form_data['field'][3] ? $keywords[] = $form_data['field'][3] : "";
    $keyword_3 = $form_data['field'][9] ? $keywords[] = $form_data['field'][9] : "";
    // GET OTHER DATA
    $user_email = $form_data['field'][10];
    $website = $form_data['field'][1];
    // INSERT DATA
    $strategyData['date_created'] = $entry['date_created'];
    $strategyData['user_email']   = $user_email;
    $strategyData['website']      = $website;
    $strategyData['keywords']     = $keywords;
    $strategyData['keyword_data'] = [];
    // CHECK IF KEYWORDS IS NOT EMPTY
    if($keywords){
        // LOOP THROUGH KEYWORDS
        foreach($keywords as $nkey => $keyword){
            //
            $data = [];
            $ownData = [];
            // GET KEYWORD DATA USING SERP API
            $keyword_data = $seo->get_top_sites_by_keywords($keyword);
            // GET OWN WEBSITE DATA
            $own_data = $seo->get_position_by_keyword($keyword, $website);
            // dd($keyword_data);
            // die();
            if(!$keyword_data['error'] && !$own_data['error']){

                // GET ORGANIC RESULTS FOR THE KEYWORD
                $top_sites_by_keyword = $keyword_data['organic_results'];
                
                // CHECK IF TOP SITES BY KEYWORD OR OWN DATA IS NOT EMPTY
                if($top_sites_by_keyword){
                    // TRIM THE TOP SITES BY KEYWORD TO 3
                    $top_sites_by_keyword = array_slice($top_sites_by_keyword, 0, 3);
                    // LOOP THROUGH TOP SITES BY KEYWORD
                    foreach($top_sites_by_keyword as $key => $site_data){
                        // DATA
                        $page_link      = $site_data['link'];
                        $page_metrics   = $seo->moz_url_metrics($page_link);
                        $page_wc        = $seo->page_word_count($page_link);
                        $page_da        = $page_metrics["results"] ? $page_metrics["results"][0]["domain_authority"] : "";
                        $page_backlinks = $page_metrics["results"] ? $page_metrics["results"][0]["external_pages_to_root_domain"] : "";
                        // PAGE FILE CONTENTS
                        $options = array(
                            'http' => array(
                                'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36'
                            )
                        );
                        $context           = stream_context_create($options);
                        $page_content      = file_get_contents($page_link, false, $context);
                        $data[$key]['h1']  = substr_count($page_content, '<h1');
                        $data[$key]['h2']  = substr_count($page_content, '<h2');
                        $data[$key]['h3']  = substr_count($page_content, '<h3');
                        $data[$key]['h4']  = substr_count($page_content, '<h4');
                        $data[$key]['h5']  = substr_count($page_content, '<h5');
                        $data[$key]['h6']  = substr_count($page_content, '<h6');
                        $data[$key]['p']   = substr_count($page_content, '<p');
                        $data[$key]['img'] = substr_count($page_content, '<img');
                        // INSERT
                        $data[$key]['page_link'] = $page_link;
                        $data[$key]['domain_authority'] = $page_da;
                        $data[$key]['word_count'] = $page_wc;
                        $data[$key]['backlinks'] = $page_backlinks;
                    }
                }
                // if($own_data){
                    // DATA
                    $page_link      = $own_data ? $own_data['link'] : $website;
                    $page_metrics   = $seo->moz_url_metrics($page_link);
                    $page_wc        = $seo->page_word_count($page_link);
                    $page_da        = $page_metrics["results"] ? $page_metrics["results"][0]["domain_authority"] : "";
                    $page_backlinks = $page_metrics["results"] ? $page_metrics["results"][0]["external_pages_to_root_domain"] : "";
                    // PAGE FILE CONTENTS
                    $options = array(
                        'http' => array(
                            'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36'
                        )
                    );
                    $context           = stream_context_create($options);
                    $page_content      = file_get_contents($page_link, false, $context);
                    $ownData['h1']  = substr_count($page_content, '<h1');
                    $ownData['h2']  = substr_count($page_content, '<h2');
                    $ownData['h3']  = substr_count($page_content, '<h3');
                    $ownData['h4']  = substr_count($page_content, '<h4');
                    $ownData['h5']  = substr_count($page_content, '<h5');
                    $ownData['h6']  = substr_count($page_content, '<h6');
                    $ownData['p']   = substr_count($page_content, '<p');
                    $ownData['img'] = substr_count($page_content, '<img');
                    // INSERT
                    $ownData['page_link'] = $page_link;
                    $ownData['domain_authority'] = $page_da;
                    $ownData['word_count'] = $page_wc;
                    $ownData['backlinks'] = $page_backlinks;
                    // POSITION
                    // $position = $own_data['position'] ? $own_data['position'] : "Not in top 100";
                    $search_page_offset = $own_data['search_page_offset'];
                    $position = $search_page_offset > 10 ? $own_data['position'] + $search_page_offset : $own_data['position'];
                    $ownData['position'] = $position ? $position : "Not in top 100";
                // }
                // INSERT DATA
                $strategyData['keyword_data'][$nkey]['data'] = $data;
                $strategyData['keyword_data'][$nkey]['own_data'] = $ownData;
                $strategyData['keyword_data'][$nkey]['keyword'] = $keyword;
                // https://docs.gravityforms.com/gform_update_meta/
            }
        }
    }
    // UPDATE THE ENTRY TODO LIST META
    gform_update_meta($entry_id, 'seo_strategy', $strategyData);
}
// ===================================================
// ===================================================


/* // initialize class
$data = new SEOI_SEO();

// keywords
$keywords  = [];
$keyword_1 = $form_data['field'][8] ? $keywords[] = $form_data['field'][8] : "";
$keyword_2 = $form_data['field'][3] ? $keywords[] = $form_data['field'][3] : "";
$keyword_3 = $form_data['field'][9] ? $keywords[] = $form_data['field'][9] : ""; */
?>

<!-- Any PDF CSS styles can be placed in the style tag below -->
<link rel="stylesheet" href="<?= __DIR__; ?>/css/keyword_report.css">

<!-- pdf header and footer -->
<htmlpageheader name="MyCustomHeader">
    <table style="border-bottom: 2px solid #fa7d09; border-spacing: 0; border-collapse: collapse; margin-bottom: 10px;" cellspacing="0" width="100%">
        <tbody>
            <tr>
                <td width="50%" style="vertical-align:bottom; padding-bottom: 15px;" ><img src="<?= __DIR__; ?>/images/seoilogo-4.png" alt="SEOi" width="80px"></td>
                <td width="50%" style="text-align: right; vertical-align: bottom; padding-bottom: 15px; color: #666666; font-size: 11px;">https://seoi.co.uk/</td>
            </tr>
        </tbody>
    </table>
</htmlpageheader>
<htmlpagefooter name="MyCustomFooter">
    <table style="border-top: 2px solid #fa7d09; border-spacing: 0; border-collapse: collapse;" cellspacing="0" width="100%">
        <tbody>
            <tr>
                <td width="50%" style="padding-top: 15px; vertical-align: middle; color: #666666; font-size: 11px;">© Copyright <?php echo date('Y'); ?> SEOi</td>
                <td width="50%" style="padding-top: 15px; vertical-align: middle; text-align: right; color: #666666; font-size: 11px;">{PAGENO} of {nbpg}</td>
            </tr>
        </tbody>
    </table>
</htmlpagefooter>

<!--  -->
<h4 class="title">Generated Data</h4><br>
<table class="metric-table table">
    <thead>
        <tr>
            <th class="mt-title" colspan="2">Form Data</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>User Email</td>
            <td><?php echo $form_data['field'][10]; ?></td>
        </tr>
        <tr>
            <td>Website URL</td>
            <td><?php echo $form_data['field'][1]; ?></td>
        </tr>
        <tr>
            <td>Keyword 1</td>
            <td><?php echo $form_data['field'][8]; ?></td>
        </tr>
        <?php if($form_data['field'][3]){ ?>
            <tr>
                <td>Keyword 2</td>
                <td><?php echo $form_data['field'][3]; ?></td>
            </tr>
        <?php } ?>
        <?php if($form_data['field'][9]){ ?>
            <tr>
                <td>Keyword 3</td>
                <td><?php echo $form_data['field'][9]; ?></td>
            </tr>
        <?php } ?>
        <!-- <tr>
            <td>Add On Page Optimization</td>
            <td><?php //echo is_array($form_data['field']['7_name']) ? "Yes" : "No"; ?></td>
        </tr> -->
    </tbody>
</table>


<!-- loop through the keywords -->
<?php 
if($strategyData['keyword_data']){

    $keywords = $strategyData['keywords'];
    foreach($strategyData['keyword_data'] as $key => $data){
?>
        <br><br>
        <div class="table-wrap">
            <h4 class="table-title">Keyword: "<?php echo $data['keyword']; ?>" Top 3 Competitor Data</h4>
            <?php //if($top_sites_by_keyword){ ?>
                <table class="metric-table table">
                    <thead>
                        <tr>
                            <th>Competitor URL</th>
                            <th>Word Count</th>
                            <th>Headings</th>
                            <th>Paragraphs</th>
                            <th>Images</th>
                            <th>Domain Authority</th>
                            <th>Backlinks</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            // trim array to only the top 3
                            // $top_sites_by_keyword = array_slice($top_sites_by_keyword, 0, 3);

                            // average data
                            $average_data = [];
                            

                            // loop through the sites
                            foreach($data['data'] as $key => $site_data){


                                // reset array
                                $headings = [];
                                $check_empty = [];
                                
                                // site data
                                $page_link      = $site_data['page_link'];
                                // $page_metrics   = $data->moz_url_metrics($page_link);
                                // $page_wc        = $data->page_word_count($page_link);
                                // $page_da        = $page_metrics["results"] ? $page_metrics["results"][0]["domain_authority"] : "";
                                // $page_backlinks = $page_metrics["results"] ? $page_metrics["results"][0]["external_pages_to_root_domain"] : "";
                                $page_wc = $site_data['word_count'];
                                $page_da = $site_data['domain_authority'];
                                $page_backlinks = $site_data['backlinks'];
                                $page_p = $site_data['p'];
                                $page_img = $site_data['img'];
                                // add user agent to file_get_contents
                                /* $options = array(
                                    'http' => array(
                                        'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36'
                                    )
                                );
                                $context = stream_context_create($options);
                                $page_content = file_get_contents($page_link, false, $context);
                                // $page_content   = file_get_contents($page_link);
                                $page_h1  = substr_count($page_content, '<h1');
                                $page_h2  = substr_count($page_content, '<h2');
                                $page_h3  = substr_count($page_content, '<h3');
                                $page_h4  = substr_count($page_content, '<h4');
                                $page_h5  = substr_count($page_content, '<h5');
                                $page_h6  = substr_count($page_content, '<h6');
                                $page_p   = substr_count($page_content, '<p');
                                $page_img = substr_count($page_content, '<img'); */
                                
                                
                                // add to headings array
                                $headings[] += $site_data['h1'];
                                $headings[] += $site_data['h2'];
                                $headings[] += $site_data['h3'];
                                $headings[] += $site_data['h4'];
                                $headings[] += $site_data['h5'];
                                $headings[] += $site_data['h6'];
                                
                                // check if not crawled
                                $check_empty[] += array_sum($headings);
                                $check_empty[] += $page_p;
                                $check_empty[] += $page_img;
                                $check_empty[] += $page_wc;
                                
                                // populate avarage data
                                $average_data['headings'][] += array_sum($headings);
                                $average_data['p'] [] += $page_p;
                                $average_data['img'][]+= $page_img;
                                $average_data['wc'][] += $page_wc;
                                $average_data['da'][] += $page_da;
                                $average_data['bl'][] += $page_backlinks;
                        ?>
                                <tr>
                                    <td><?php echo $page_link; ?></td>
                                    <?php if(array_sum($check_empty) > 0){ ?>
                                        <td><?php echo $page_wc; ?></td>
                                        <td><?php echo array_sum($headings); ?></td>
                                        <td><?php echo $page_p; ?></td>
                                        <td><?php echo $page_img; ?></td>
                                    <?php } else { ?>
                                        <td colspan="4" style="text-align:center;">Page can't be crawled</td>
                                    <?php } ?>
                                    <td><?php echo $page_da; ?></td>
                                    <td><?php echo number_format($page_backlinks, 2); ?></td>
                                </tr>
                        <?php } ?>

                        <!-- average data -->
                        <tr>
                            <td><strong>Average:</strong></td>
                            <td><?php echo getAverageData($average_data, 'wc'); ?></td>
                            <td><?php echo getAverageData($average_data, 'headings'); ?></td>
                            <td><?php echo getAverageData($average_data, 'p'); ?></td>
                            <td><?php echo getAverageData($average_data, 'img'); ?></td>
                            <td><?php echo getAverageData($average_data, 'da'); ?></td>
                            <td><?php echo getAverageData($average_data, 'bl'); ?></td>
                        </tr>
                        <!-- !end average row -->

                        <!--  -->
                        <?php 
                        if($data['own_data']){
                            $own_data = $data['own_data'];
                            $headings[] += $own_data['h1'];
                            $headings[] += $own_data['h2'];
                            $headings[] += $own_data['h3'];
                            $headings[] += $own_data['h4'];
                            $headings[] += $own_data['h5'];
                            $headings[] += $own_data['h6'];
                        ?>
                            <?php //$own_data_content = getLinkData($own_data["link"]); ?>
                            <tr class="orange">
                                <th>Your Url</th>
                                <th>Word Count</th>
                                <th>Headings</th>
                                <th>Paragraphs</th>
                                <th>Images</th>
                                <th>Domain Authority</th>
                                <th>Backlinks</th>
                            </tr>
                            <tr>
                                <td><strong><?php echo $own_data["position"] ?></strong> <?php echo $own_data["page_link"]; ?></td>
                                <td><?php echo $own_data["word_count"]; ?></td>
                                <td><?php echo array_sum($headings); ?></td>
                                <td><?php echo $own_data["p"]; ?></td>
                                <td><?php echo $own_data["img"]; ?></td>
                                <td><?php echo $own_data["domain_authority"]; ?></td>
                                <td><?php echo $own_data["backlinks"]; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            <?php //} ?>
        </div>
    <?php } ?>
<?php } ?>

<?php
/* // GET AVERAGE DATA
function getAverageData($data = NULL, $key = NULL) {
    
    // check if $data is not empty
    if($data && $key){

        // remove empty values
        // $data[$key] = array_filter($data[$key]);

        // get average data
        $average_data = array_sum($data[$key]) / count($data[$key]);

        // decimal count 2
        return number_format($average_data, 2);
    } else {

        // return 0
        return false;
    }
}
 */
// GET WEBSITE DATA (HEADINGS, PARAGRAPHS, IMAGES, WORD COUNT, DA, BACKLINKS)
/* function getLinkData($url){

    // initialize class
    $data = new SEOI_SEO();

    // site data
    $page_link = $url;
    $page_metrics = $data->moz_url_metrics($page_link);
    $word_count = $data->page_word_count($page_link);
    $domain_authority = $page_metrics["results"] ? $page_metrics["results"][0]["domain_authority"] : "";
    $backlinks = $page_metrics["results"] ? $page_metrics["results"][0]["external_pages_to_root_domain"] : "";

    // add user agent to file_get_contents
    $context = stream_context_create(array(
        'http' => array(
            'user_agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.132 Safari/537.36'
        )
    ));
    $page_content = file_get_contents($page_link, false, $context);

    $h1 = substr_count($page_content, '<h1');
    $h2 = substr_count($page_content, '<h2');
    $h3 = substr_count($page_content, '<h3');
    $h4 = substr_count($page_content, '<h4');
    $h5 = substr_count($page_content, '<h5');
    $h6 = substr_count($page_content, '<h6');
    $paragraphs = substr_count($page_content, '<p');
    $images = substr_count($page_content, '<img');

    // add to headings array
    $headings[] += $h1;
    $headings[] += $h2;
    $headings[] += $h3;
    $headings[] += $h4;
    $headings[] += $h5;
    $headings[] += $h6;

    return array(
        "headings"         => array_sum($headings),
        "paragraphs"       => $paragraphs,
        "images"           => $images,
        "domain_authority" => $domain_authority,
        "backlinks"        => number_format($backlinks, 2),
        "word_count"       => $word_count
    );
} */

?>